/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialBizInfoSubmitValidator
extends AbstractValidator {
    private static final String PROP_MASTERID = "masterid";
    public static final String BD_MATERIALPURCHASEINFO = "bd_materialpurchaseinfo";
    public static final String BD_MATERIALSALINFO = "bd_materialsalinfo";

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("isdeliverinspect");
        preparePropertys.add("isreturninspect");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.materialConfigPropChecking(dataEntity);
            this.materialUnitChecking(dataEntity);
            DynamicObject bill = dataEntity.getDataEntity();
            if (!BD_MATERIALSALINFO.equals(bill.getDataEntityType().getName())) continue;
            this.checkInspectCfg(dataEntity);
        }
    }

    private void materialConfigPropChecking(ExtendedDataEntity dataEntity) {
        DynamicObject material = dataEntity.getDataEntity().getDynamicObject(PROP_MASTERID);
        if (material == null) {
            return;
        }
        String materialNumber = material.getString("number");
        String configproperties = material.getString("configproperties");
        if ("3".equals(configproperties)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u5c5e\u6027\u4e3a\u7279\u5f81\u4ef6\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e1a\u52a1\u4fe1\u606f\u3002", (String)"MaterialBizInfoSaveValidator_16", (String)"bd-sbd-opplugin", (Object[])new Object[0]), materialNumber));
        }
    }

    private void materialUnitChecking(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        String dataEntityTypeName = entity.getDataEntityType().getName();
        DynamicObject matDO = entity.getDynamicObject(PROP_MASTERID);
        DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
        Long mid = matDO.getLong("id");
        Long buid = baseunitDO.getLong("id");
        DynamicObject unit = null;
        List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1");
        boolean flag = false;
        if (StringUtils.equals((CharSequence)BD_MATERIALSALINFO, (CharSequence)dataEntityTypeName)) {
            unit = entity.getDynamicObject("salesunit");
            flag = true;
        } else {
            unit = entity.getDynamicObject("purchaseunit");
        }
        if (flag && !fixconunitlist.contains(unit.getLong("id"))) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u5355\u4f4d\u4e0d\u5728\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MaterialBizInfoSubmitValidator_17", (String)"bd-sbd-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!flag && !fixconunitlist.contains(unit.getLong("id"))) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u5355\u4f4d\u4e0d\u5728\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MaterialBizInfoSubmitValidator_18", (String)"bd-sbd-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void checkInspectCfg(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject material = bill.getDynamicObject(PROP_MASTERID);
        if (material == null) {
            return;
        }
        if (!material.getBoolean("enableinspect") && (bill.getBoolean("isdeliverinspect") || bill.getBoolean("isreturninspect"))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f00\u542f\u201c\u53d1\u8d27\u68c0\u9a8c\u201d\u6216\u201c\u9000\u8d27\u68c0\u9a8c\u201d\u65f6\uff0c\u8bf7\u5148\u5f00\u542f\u7269\u6599\u7684\u201c\u53ef\u8d28\u68c0\u201d\u5f00\u5173\u3002", (String)"MaterialBizInfoSubmitValidator_21", (String)"bd-sbd-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

