/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bd.sbd.business.helper.MaterialBizInfoCheckHelper;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bd.sbd.enums.EndDateCalTypeEnum;
import kd.bd.sbd.enums.UnitEnum;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialInvInfoSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(MaterialInvInfoSaveValidator.class);
    public static final String PROP_INVENTORYUNIT = "inventoryunit";
    public static final String PROP_BASEUNIT = "baseunit";
    public static final String PROP_MASTERID = "masterid";
    public static final String ENABLESHELFLIFEMGR = "enableshelflifemgr";
    public static final String SHELFLIFE = "shelflife";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private MaterialBizInfoCheckHelper materialBizInfoCheckHelper = new MaterialBizInfoCheckHelper();

    public MaterialInvInfoSaveValidator() {
        this.setEntityKey("bd_materialinventoryinfo");
    }

    public void validate() {
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialInvInfoSaveValidator", (String)"validate");){
            HashSet<Long> materialIds = new HashSet<Long>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                BigDecimal shelfLife;
                List assistMuListResult;
                Object inventoryunit = dataEntity.getDataEntity().get(PROP_INVENTORYUNIT);
                Long inventoryunitId = 0L;
                if (inventoryunit instanceof DynamicObject) {
                    inventoryunitId = Long.valueOf(((DynamicObject)inventoryunit).getPkValue().toString());
                } else if (inventoryunit instanceof Long) {
                    inventoryunitId = (Long)inventoryunit;
                }
                Object material = dataEntity.getDataEntity().get(PROP_MASTERID);
                Long materialId = 0L;
                Long baseunitId = 0L;
                if (material instanceof DynamicObject) {
                    materialId = Long.valueOf(((DynamicObject)material).getPkValue().toString());
                    Object baseunit = ((DynamicObject)material).get(PROP_BASEUNIT);
                    if (baseunit instanceof DynamicObject) {
                        baseunitId = Long.valueOf(((DynamicObject)baseunit).getPkValue().toString());
                    } else if (baseunit instanceof Long) {
                        baseunitId = (Long)baseunit;
                    }
                    String operateKey = this.getOperateKey();
                    if ("submit".equals(operateKey)) {
                        Boolean enableInspect = ((DynamicObject)material).getBoolean("enableinspect");
                        Boolean invHadTrue = dataEntity.getDataEntity().getBoolean("ispurchaseinspect") || dataEntity.getDataEntity().getBoolean("isinvinspect");
                        if (!enableInspect.booleanValue() && invHadTrue.booleanValue()) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u7269\u6599\u53ef\u8d28\u68c0\u6807\u8bc6\u3002", (String)"MaterialInvInfoSaveValidator_27", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                        }
                    }
                } else if (material instanceof Long) {
                    materialId = (Long)material;
                    DynamicObject mainMaterial = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)PROP_BASEUNIT);
                    Object baseunit = mainMaterial.get(PROP_BASEUNIT);
                    if (baseunit instanceof DynamicObject) {
                        baseunitId = Long.parseLong(((DynamicObject)baseunit).getPkValue().toString());
                    } else if (baseunit instanceof Long) {
                        baseunitId = (Long)baseunit;
                    }
                }
                materialIds.add(materialId);
                if (!(inventoryunitId == 0L || materialId == 0L || (assistMuListResult = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)baseunitId, (String)"1", (Boolean)Boolean.TRUE)) != null && assistMuListResult.contains(inventoryunitId))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u4f4d\u5728\u7269\u6599\u5355\u4f4d\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\u4e14\u5728\u901a\u7528\u6362\u7b97\u5173\u7cfb\u4e2d\u4e0e\u57fa\u672c\u5355\u4f4d\u4e0d\u5b58\u5728\u56fa\u5b9a\u6362\u7b97\u5173\u7cfb\u3002", (String)"MaterialInvInfoSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                }
                logger.info("\u3010------------------begin enableshelflifemgr--------------------\u3011");
                boolean mgrBoolean = dataEntity.getDataEntity().getBoolean(ENABLESHELFLIFEMGR);
                logger.info("[enableshelflifemgr]: {mgrBoolean: " + mgrBoolean + "}");
                if (mgrBoolean && BigDecimal.ZERO.compareTo(shelfLife = dataEntity.getDataEntity().getBigDecimal(SHELFLIFE)) >= 0) {
                    logger.info("[shelfLife]: {shelfLife: " + shelfLife + "}");
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u4fdd\u8d28\u671f\u5fc5\u5f55\u3002", (String)"MaterialShelfLifeValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
                }
                this.checkLifeFieldMustInput(dataEntity);
                this.invQtyIsNotNullSaveValidate(dataEntity);
                this.invQtyRelationSaveValidate(dataEntity);
            }
            Set materialEndIds = this.materialBizInfoCheckHelper.checkMaterialData(materialIds, "enableinv", this.dataEntities);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Object material = dataEntity.getDataEntity().get(PROP_MASTERID);
                Long materialId = 0L;
                String materialNumber = "";
                if (material instanceof DynamicObject) {
                    materialId = Long.valueOf(((DynamicObject)material).getPkValue().toString());
                    materialNumber = ((DynamicObject)material).getString("number");
                } else if (material instanceof Long) {
                    materialId = (Long)material;
                }
                if (materialEndIds.contains(materialId)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7269\u6599\u7f16\u7801%s\u672a\u5f00\u542f\u53ef\u5e93\u5b58\u5c5e\u6027\u3002", (String)"MaterialInvInfoSaveValidator_15", (String)"bd-sbd-opplugin", (Object[])new Object[0]), materialNumber));
            }
        }
    }

    public void shelfLifeMgrFieldChecking(ExtendedDataEntity[] dataEntities) {
        LinkedList<Object> fromDBIds = new LinkedList<Object>();
        int len = dataEntities.length;
        for (int i = 0; i < len; ++i) {
            boolean isFromDB = dataEntities[i].getDataEntity().getDataEntityState().getFromDatabase();
            if (!isFromDB) continue;
            fromDBIds.add(dataEntities[i].getDataEntity().getPkValue());
        }
        if (fromDBIds.isEmpty()) {
            return;
        }
        LinkedList<Object> needCheckingIdList = new LinkedList<Object>();
        Map dataFromDBMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id,enableshelflifemgr,enablelot", (QFilter[])new QFilter[]{new QFilter("id", "in", fromDBIds)});
        if (dataFromDBMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject curData = dataEntity.getDataEntity();
            Object curDataId = curData.getPkValue();
            DynamicObject dataFromDB = (DynamicObject)dataFromDBMap.get(curDataId);
            if (dataFromDB == null) continue;
            boolean oldEnableShelfLifeMgr = dataFromDB.getBoolean(ENABLESHELFLIFEMGR);
            boolean curEnableShelfLifeMgr = curData.getBoolean(ENABLESHELFLIFEMGR);
            boolean oldEnablelot = dataFromDB.getBoolean("enablelot");
            boolean curEnablelot = curData.getBoolean("enablelot");
            if (oldEnableShelfLifeMgr == curEnableShelfLifeMgr && oldEnablelot == curEnablelot) continue;
            needCheckingIdList.add(curDataId);
        }
        if (needCheckingIdList.isEmpty()) {
            return;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.getIgnoreRefEntityIds().add("im_lotintrack");
        checker.getIgnoreRefEntityIds().add("im_warehousesetup");
        checker.getIgnoreRefEntityIds().add("im_invstart");
        Map refrenceResultMap = checker.checkRef((BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType(), needCheckingIdList.toArray());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object id = dataEntity.getDataEntity().getPkValue();
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)refrenceResultMap.get(id);
            if (refrenceResult == null || !refrenceResult.isRefence()) continue;
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                    fieldName = ((IFieldHandle)property).getDisplayName().toString();
                    break;
                }
                if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                fieldName = ((MulBasedataProp)property).getDisplayName().toString();
                break;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u4fee\u6539\u4fdd\u8d28\u671f\u7ba1\u7406\u3001\u542f\u7528\u6279\u53f7\u7ba1\u7406\u5b57\u6bb5\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\u3002", (String)"MaterialInvInfoSaveValidator_16", (String)"bd-sbd-opplugin", (Object[])new Object[0]), billName, fieldName);
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private void checkLifeFieldMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        String leadTimeUnit = bill.getString("leadtimeunit");
        String shelfLifeUnit = bill.getString("shelflifeunit");
        boolean enableShelfLifeMgr = bill.getBoolean(ENABLESHELFLIFEMGR);
        String calDirection = bill.getString("caldirection");
        String calculationForEndDate = bill.getString("calculationforenddate");
        boolean isValidCalDirection = true;
        if (enableShelfLifeMgr) {
            if (UnitEnum.isInvalidVal((String)shelfLifeUnit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u4fdd\u8d28\u671f\u5355\u4f4d\u5fc5\u5f55\u3002", (String)"MaterialInvInfoSaveValidator_23", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (UnitEnum.isInvalidVal((String)leadTimeUnit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u63d0\u524d\u671f\u5355\u4f4d\u5fc5\u5f55\u3002", (String)"MaterialInvInfoSaveValidator_25", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (CalDirectionEnum.isInvalidVal((String)calDirection)) {
                isValidCalDirection = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u8ba1\u7b97\u65b9\u5411\u5fc5\u5f55\u3002", (String)"MaterialInvInfoSaveValidator_22", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)shelfLifeUnit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u95ed\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u4fdd\u8d28\u671f\u5355\u4f4d\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"MaterialInvInfoSaveValidator_24", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)leadTimeUnit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u95ed\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u63d0\u524d\u671f\u5355\u4f4d\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"MaterialInvInfoSaveValidator_26", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)calDirection)) {
                isValidCalDirection = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u95ed\u4fdd\u8d28\u671f\u7ba1\u7406\u65f6\uff0c\u8ba1\u7b97\u65b9\u5411\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"MaterialInvInfoSaveValidator_17", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
        }
        if (!isValidCalDirection) {
            return;
        }
        if (CalDirectionEnum.CALENDDATE.getValue().equals(calDirection) || CalDirectionEnum.CALBOTH.getValue().equals(calDirection)) {
            if (EndDateCalTypeEnum.isInvalidVal((String)calculationForEndDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5b58\u5728\u6216\u9519\u8bef\u3002", (String)"MaterialInvInfoSaveValidator_18", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.isNotBlank((CharSequence)calculationForEndDate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u5411\u4e0d\u7b49\u4e8e\u6309\u751f\u4ea7\u65e5\u8ba1\u7b97\u5230\u671f\u65e5\u6216\u76f8\u4e92\u8ba1\u7b97\uff0c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5141\u8bb8\u5f55\u5165\u503c\u3002", (String)"MaterialInvInfoSaveValidator_19", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }

    private void invQtyIsNotNullSaveValidate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        BigDecimal minInvQty = dataEntity.getBigDecimal("mininvqty");
        BigDecimal reOrderPointQty = dataEntity.getBigDecimal("reorderpointqty");
        BigDecimal saftyInvQty = dataEntity.getBigDecimal("saftyinvqty");
        BigDecimal maxInvQty = dataEntity.getBigDecimal("maxinvqty");
        if (dataEntity.getBoolean("ismininvalert") && minInvQty.compareTo(ZERO) <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u6700\u5c0f\u5e93\u5b58\u9884\u8b66\uff0c\u6700\u5c0f\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialInvInfoSaveValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (dataEntity.getBoolean("ismaxinvalert") && maxInvQty.compareTo(ZERO) <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u6700\u5927\u5e93\u5b58\u9884\u8b66\uff0c\u6700\u5927\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialInvInfoSaveValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (dataEntity.getBoolean("isreorderpointalert") && reOrderPointQty.compareTo(ZERO) <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u518d\u8ba2\u8d27\u70b9\u9884\u8b66\uff0c\u518d\u8ba2\u8d27\u70b9\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialInvInfoSaveValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (dataEntity.getBoolean("issaftyinvalert") && saftyInvQty.compareTo(ZERO) <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u5b89\u5168\u5e93\u5b58\u9884\u8b66\uff0c\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialInvInfoSaveValidator_4", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }

    private void invQtyRelationSaveValidate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        boolean isValid = true;
        BigDecimal minInvQty = dataEntity.getBigDecimal("mininvqty");
        BigDecimal reOrderPointQty = dataEntity.getBigDecimal("reorderpointqty");
        BigDecimal saftyInvQty = dataEntity.getBigDecimal("saftyinvqty");
        BigDecimal maxInvQty = dataEntity.getBigDecimal("maxinvqty");
        Stack<BigDecimal> validateStack = new Stack<BigDecimal>();
        ArrayList<String> fieldList = new ArrayList<String>();
        if (minInvQty != null && minInvQty.compareTo(ZERO) > 0) {
            validateStack.push(minInvQty);
            fieldList.add(ResManager.loadKDString((String)"\u6700\u5c0f\u5e93\u5b58", (String)"MaterialInvInfoSaveValidator_5", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (saftyInvQty != null && saftyInvQty.compareTo(ZERO) > 0) {
            validateStack.push(saftyInvQty);
            fieldList.add(ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58", (String)"MaterialInvInfoSaveValidator_6", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (reOrderPointQty != null && reOrderPointQty.compareTo(ZERO) > 0) {
            validateStack.push(reOrderPointQty);
            fieldList.add(ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"MaterialInvInfoSaveValidator_7", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (maxInvQty != null && maxInvQty.compareTo(ZERO) > 0) {
            validateStack.push(maxInvQty);
            fieldList.add(ResManager.loadKDString((String)"\u6700\u5927\u5e93\u5b58", (String)"MaterialInvInfoSaveValidator_8", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
        if (validateStack.size() <= 1) {
            return;
        }
        while (validateStack.size() > 1) {
            BigDecimal top = (BigDecimal)validateStack.pop();
            if (top.compareTo((BigDecimal)validateStack.peek()) >= 0) continue;
            isValid = false;
            break;
        }
        if (!isValid) {
            String fieldNameStr = String.join((CharSequence)"]\uff0c[", fieldList);
            String fieldRelaStr = String.join((CharSequence)"\u2264", fieldList);
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append('[').append(fieldNameStr).append(']');
            errorMsg.append(ResManager.loadKDString((String)"\u5fc5\u987b\u7b26\u5408\u5927\u5c0f\u5173\u7cfb\uff1a", (String)"MaterialInvInfoSaveValidator_9", (String)"bd-sbd-opplugin", (Object[])new Object[0])).append(fieldRelaStr).append("\u3002");
            this.addErrorMessage(extendedDataEntity, errorMsg.toString());
        }
    }
}

