/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.Set;
import kd.bd.sbd.business.helper.SnMainfileNewHelp;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SnParameteSaveValidator
extends AbstractValidator {
    private static int COUNT = 10000;

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"SnParameteSaveValidator", (String)"isSnRangeCanChange");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.isSnRangeCanChange(dataEntity);
            }
        }
    }

    private void isSnRangeCanChange(ExtendedDataEntity dataEntity) {
        StringBuilder countSql = new StringBuilder();
        StringBuilder snSql = new StringBuilder();
        String tempDataSet = SnMainfileNewHelp.takeUniqueRange((ExtendedDataEntity)dataEntity);
        String mainSnNumber = dataEntity.getDataEntity().getString("number");
        long snDimItemId = dataEntity.getDataEntity().getLong("id");
        if (snDimItemId == 0L) {
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)"bd_sndimension", (Object)snDimItemId);
        if (!exists) {
            return;
        }
        DynamicObject sndimsion = BusinessDataServiceHelper.loadSingle((Object)snDimItemId, (String)"bd_sndimension");
        Set oldsnRange = SnMainfileNewHelp.getSnUnqctrl((String)sndimsion.getString("sncheckrange"));
        Set nowsnRange = SnMainfileNewHelp.getSnUnqctrl((String)dataEntity.getDataEntity().getString("sncheckrange"));
        countSql.append("select count(*) totalSn from t_bd_snmainfile");
        DataSet countDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)countSql.toString());
        long totalSn = 0L;
        while (countDataSet.hasNext()) {
            Row next = countDataSet.next();
            totalSn = next.getLong("totalSn");
        }
        if (totalSn <= (long)COUNT) {
            boolean flag;
            if (mainSnNumber.equals("SNUMBER")) {
                snSql.append("select t.fnumber,count(1) from t_bd_snmainfile t group by t.fnumber").append(tempDataSet).append(" having count(1)>1");
                flag = true;
            } else {
                snSql.append("select te.fsndimnumber,count(1) from t_bd_sndimensionentry te join t_bd_snmainfile t on t.fid = te.fid").append(" where te.fsndimitem = ").append(snDimItemId).append(" group by").append(" te.fsndimnumber").append(tempDataSet).append(" having count(1)>1");
                flag = false;
            }
            DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)snSql.toString());
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String number = flag ? next.getString("fnumber") : next.getString("fsndimnumber");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u201c%1$s\u201d\u5df2\u91cd\u590d\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"SnParameteSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]), number));
            }
        } else {
            if (oldsnRange.equals(nowsnRange)) {
                return;
            }
            if (oldsnRange.containsAll(nowsnRange)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e3b\u6863\u6570\u636e\uff0c\u552f\u4e00\u6027\u6821\u9a8c\u8303\u56f4\u4e0d\u80fd\u6539\u5c0f\uff0c\u8bf7\u5220\u9664\u6570\u636e\u540e\u518d\u4fee\u6539\u3002", (String)"SnParameteSaveValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            } else if (oldsnRange.size() == nowsnRange.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e3b\u6863\u6570\u636e\uff0c\u552f\u4e00\u6027\u6821\u9a8c\u8303\u56f4\u4e0d\u80fd\u66f4\u6539\uff0c\u8bf7\u5220\u9664\u6570\u636e\u540e\u518d\u4fee\u6539\u3002", (String)"SnParameteSaveValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

