/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SnWarehouseValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set props = super.preparePropertys();
        props.add("curinvorg");
        props.add("curwarehous");
        props.add("curlocation");
        return props;
    }

    public void validate() {
        DynamicObject curinvOrg;
        DynamicObject data;
        HashMap<String, DynamicObject> warehouseSetupMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> orgs = new HashSet<Long>(16);
        HashSet<Long> warehouses = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject warehouse;
            data = extendedDataEntity.getDataEntity();
            curinvOrg = data.getDynamicObject("curinvorg");
            if (curinvOrg != null) {
                orgs.add(curinvOrg.getLong("id"));
            }
            if ((warehouse = data.getDynamicObject("curwarehous")) == null) continue;
            warehouses.add(warehouse.getLong("id"));
        }
        warehouseSetupMap.putAll(SnWarehouseValidator.getAllWarehouseSetup(orgs, warehouses));
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject warehouseSetup;
            data = extendedDataEntity.getDataEntity();
            curinvOrg = data.getDynamicObject("curinvorg");
            DynamicObject location = data.getDynamicObject("curlocation");
            DynamicObject warehouse = data.getDynamicObject("curwarehous");
            if (location == null && warehouse == null) continue;
            if (curinvOrg == null && warehouse != null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed3\u5e93\u201c{0}\u201d\u5fc5\u987b\u5173\u8054\u5f53\u524d\u7ec4\u7ec7\uff0c\u8bf7\u8865\u5145\u5f53\u524d\u7ec4\u7ec7\u3002", (String)"SBS-E-618088", (String)"bd-sbd-opplugin", (Object[])new Object[]{warehouse.getString("number")}));
                continue;
            }
            if (warehouse == null && location != null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c{0}\u201d\u5fc5\u987b\u5173\u8054\u4ed3\u5e93\uff0c\u8bf7\u8865\u5145\u4ed3\u5e93\u3002", (String)"SBS-E-831732", (String)"bd-sbd-opplugin", (Object[])new Object[]{location.getString("number")}));
                continue;
            }
            String key = "";
            if (warehouse != null && curinvOrg != null) {
                key = String.valueOf(curinvOrg.getPkValue()) + String.valueOf(warehouse.getPkValue());
            }
            if ((warehouseSetup = (DynamicObject)warehouseSetupMap.get(key)) == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed3\u5e93\u201c{0}\u201d\u4e0d\u96b6\u5c5e\u4e8e\u5f53\u524d\u7ec4\u7ec7\u201c{1}\u201d\u3002", (String)"SBS-W-827416", (String)"bd-sbd-opplugin", (Object[])new Object[]{warehouse.getString("number"), curinvOrg.getString("number")}));
            }
            if (location == null) continue;
            if (!warehouse.getBoolean("isopenlocation")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c{0}\u201d\u4e0d\u96b6\u5c5e\u4e8e\u4ed3\u5e93\u201c{1}\u201d\u3002", (String)"SBS-W-801306", (String)"bd-sbd-opplugin", (Object[])new Object[]{location.getString("number"), warehouse.getString("number")}));
                continue;
            }
            Object locId = location.getPkValue();
            DynamicObjectCollection locationEntrys = warehouse.getDynamicObjectCollection("entryentity");
            boolean isLocationMatch = false;
            for (DynamicObject locationEntry : locationEntrys) {
                DynamicObject loc = locationEntry.getDynamicObject("location");
                if (loc == null || !loc.getPkValue().equals(locId)) continue;
                isLocationMatch = true;
            }
            if (isLocationMatch) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c{0}\u201d\u4e0d\u96b6\u5c5e\u4e8e\u4ed3\u5e93\u201c{1}\u201d\u3002", (String)"SBS-W-801306", (String)"bd-sbd-opplugin", (Object[])new Object[]{location.getString("number"), warehouse.getString("number")}));
        }
    }

    private static Map<String, DynamicObject> getAllWarehouseSetup(Set<Long> orgIds, Set<Long> warehouseIds) {
        HashMap<String, DynamicObject> warehouseSetupMap = new HashMap<String, DynamicObject>(16);
        if (orgIds.isEmpty() || warehouseIds.isEmpty()) {
            return warehouseSetupMap;
        }
        QFilter filter = new QFilter("org", "in", orgIds).and("warehouse", "in", warehouseIds).and("startstatus", "=", (Object)"B").and("enable", "=", (Object)true);
        Map setUps = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])filter.toArray());
        for (DynamicObject setupDym : setUps.values()) {
            DynamicObject org = setupDym.getDynamicObject("org");
            DynamicObject warehouse = setupDym.getDynamicObject("warehouse");
            if (org == null || warehouse == null) continue;
            String key = org.getPkValue().toString() + warehouse.getPkValue().toString();
            warehouseSetupMap.put(key, setupDym);
        }
        return warehouseSetupMap;
    }
}

