/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class WarehouseLocationRefDValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, ExtendedDataEntity> wareLocNumToDataEntity = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        Long userId = UserServiceHelper.getCurrentUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"05", (String)"=9Q86DR2P+Q", (String)"bd_warelocareference", (String)"47156aff000000ac", (boolean)true);
        List hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        HashSet<Object> warehouseSet = new HashSet<Object>();
        HashSet<Object> locationSet = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject warehouse = (DynamicObject)entity.get("warehouse");
            DynamicObject location = (DynamicObject)entity.get("location");
            if (warehouse == null || location == null) continue;
            if (!hasPermOrgIds.contains(warehouse.getLong("createorg.id"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7%s\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u7ec4\u7ec7\u4e0b\u7684\u4ed3\u5e93\u4ed3\u4f4d\u5173\u7cfb\u3002", (String)"WarehouseLocationRefDValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]), warehouse.get("createorg.name")));
                continue;
            }
            warehouseSet.add(warehouse.getPkValue());
            locationSet.add(location.getPkValue());
            wareLocNumToDataEntity.put(warehouse.get("number") + "_" + location.get("number"), dataEntity);
        }
        DataSet invSet = this.getWareLocationInv(warehouseSet, locationSet);
        if (invSet == null) {
            return;
        }
        if (invSet.hasNext()) {
            if (dataEntities.length == 1) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u4ed3\u4f4d\u7684\u5e93\u5b58\u6d88\u8017\u5b8c\u540e\uff0c\u518d\u5220\u9664\u4ed3\u4f4d\u3002", (String)"WarehouseLocationRefDValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[0], msg);
            } else {
                this.showWareLocationInvMsg(invSet, wareLocNumToDataEntity);
            }
        }
    }

    private DataSet getWareLocationInv(Set<Object> warehouseSet, Set<Object> locationSet) {
        QFilter locationFilter = new QFilter("location", "in", locationSet);
        QFilter qtyFilter = new QFilter("baseqty", "!=", (Object)0);
        qtyFilter.or("qty", "!=", (Object)0);
        qtyFilter.or("qty2nd", "!=", (Object)0);
        QFilter filter = new QFilter("warehouse", "in", warehouseSet);
        filter.and(qtyFilter).and(locationFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_inv_realbalance", (String)"location.number,warehouse.number", (QFilter[])filter.toArray(), null);
        return dataSet.distinct();
    }

    private void showWareLocationInvMsg(DataSet invDataSet, Map<String, ExtendedDataEntity> wareLocNumToDataEntity) {
        while (invDataSet.hasNext()) {
            if (this.dataEntities != null && this.dataEntities.length == 1) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u4ed3\u4f4d\u7684\u5e93\u5b58\u6d88\u8017\u5b8c\u540e\uff0c\u518d\u5220\u9664\u4ed3\u4f4d\u3002", (String)"WarehouseLocationRefDValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            Row row = invDataSet.next();
            String locationNum = row.getString("location.number");
            String warehouseNum = row.getString("warehouse.number");
            ExtendedDataEntity extendedDataEntity = wareLocNumToDataEntity.get(warehouseNum + "_" + locationNum);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06%1$s\u4ed3\u5e93\u5bf9\u5e94\u7684%2$s\u4ed3\u4f4d\u5e93\u5b58\u6d88\u8017\u5b8c\u540e\uff0c\u518d\u5173\u95ed\u4ed3\u4f4d\u7ba1\u7406\u3002", (String)"WarehouseLocationRefDValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]), warehouseNum, locationNum));
        }
    }
}

