/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils.pdm.mftbom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.utils.pdm.mftbom.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class BomUtils {
    private static final ThreadLocal<Map<String, String>> ctrlStrategyThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, QFilter>> orgFilterThreadLocal = new ThreadLocal();

    public static String getBomCtrlStrategyCache(String entityKey) {
        String ctrlStrategy;
        Map<String, String> currentThreadLocal = ctrlStrategyThreadLocal.get();
        if (currentThreadLocal == null) {
            currentThreadLocal = new HashMap<String, String>();
            ctrlStrategyThreadLocal.set(currentThreadLocal);
        }
        if (StringUtils.isEmpty((String)(ctrlStrategy = currentThreadLocal.get(entityKey)))) {
            DynamicObject defCtrlStrDO = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)entityKey);
            ctrlStrategy = defCtrlStrDO == null ? "5" : DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)defCtrlStrDO, (String)"defaultctrlstrategy");
            currentThreadLocal.put(entityKey, ctrlStrategy);
        }
        return ctrlStrategy;
    }

    public static QFilter getBomOrgFilterCache(DynamicObject createOrg, String entityKey, String ctrlStrategy) {
        String pks;
        QFilter qFilter;
        Map<String, QFilter> currentThreadLocal = orgFilterThreadLocal.get();
        if (currentThreadLocal == null) {
            currentThreadLocal = new HashMap<String, QFilter>();
            orgFilterThreadLocal.set(currentThreadLocal);
        }
        if ((qFilter = currentThreadLocal.get(pks = createOrg.getPkValue() + "_" + entityKey + "_" + ctrlStrategy)) == null) {
            BaseDataService baseDataService = new BaseDataService();
            baseDataService.clearBaseDataFilterCache(entityKey, (Long)createOrg.getPkValue());
            QFilter baseDataCreaterOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)createOrg.getLong("id"));
            qFilter = new QFilter("createorg", "=", createOrg.getPkValue());
            if ("5".equals(ctrlStrategy)) {
                qFilter = new QFilter("1", "=", (Object)1);
            } else if ("6".equals(ctrlStrategy)) {
                List<Long> orgs = BomUtils.getOrgRanges(entityKey, ctrlStrategy, (Long)createOrg.getPkValue());
                if (orgs.isEmpty() && baseDataCreaterOrgFilter != null) {
                    qFilter = baseDataCreaterOrgFilter;
                } else if (!orgs.isEmpty()) {
                    qFilter = new QFilter("createorg", "in", orgs);
                }
            } else if (baseDataCreaterOrgFilter != null) {
                qFilter = baseDataCreaterOrgFilter;
            }
            currentThreadLocal.put(pks, qFilter);
        }
        return qFilter;
    }

    private static List<Long> getOrgRanges(String entityType, String ctrlStrategy, Long parentOrgID) {
        if ("5".equals(ctrlStrategy)) {
            return Collections.emptyList();
        }
        if ("6".equals(ctrlStrategy)) {
            ArrayList<Long> useorgList = new ArrayList<Long>();
            useorgList.add(parentOrgID);
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityType);
            Long viewId = ctrlView == null ? Long.valueOf(16L) : DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)ctrlView);
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, useorgList, (boolean)true);
        }
        return Collections.emptyList();
    }

    public static void removeBomCtrlStrategyCeche() {
        ctrlStrategyThreadLocal.remove();
    }

    public static void removeBomOrgFilterCeche() {
        orgFilterThreadLocal.remove();
    }
}

