/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class AddressFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IDataModelListener {
    private static final String BTNSAVE = "btnsave";
    private static ThreadLocal<Boolean> currentflag = new ThreadLocal();

    public void registerListener(EventObject e) {
        BasedataEdit customer;
        super.registerListener(e);
        Button savebtn = (Button)this.getView().getControl(BTNSAVE);
        savebtn.addClickListener((ClickListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        String id;
        super.beforeBindData(e);
        if (this.getModel().getDataEntity().getBoolean("issupplieradd") && this.getModel().getDataEntity().getDynamicObject("supplier") != null) {
            DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getDataEntity().getDynamicObject("supplier").getPkValue(), (String)"bd_supplier");
            id = this.getModel().getDataEntity().getPkValue().toString();
            if (supplier != null) {
                DynamicObject billaddress = supplier.getDynamicObject("billaddress");
                if (billaddress != null && id.equals(billaddress.getString("id"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"supplier"});
                } else {
                    DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
                    if (linkmans != null && linkmans.size() > 0) {
                        Iterator iterator = linkmans.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject linkman = (DynamicObject)iterator.next();
                            if (linkman.getDynamicObject("associatedaddress") == null || !id.equals(linkman.getDynamicObject("associatedaddress").getString("id"))) continue;
                            this.getView().setEnable(Boolean.FALSE, new String[]{"supplier"});
                            break;
                        }
                    }
                }
            }
        }
        if (this.getModel().getDataEntity().getBoolean("iscustomeradd") && this.getModel().getDataEntity().getDynamicObject("customer") != null) {
            DynamicObjectCollection linkmans;
            if (this.getModel().getDataEntity().getLong("id") != 0L && this.getModel().getDataEntity().getBoolean("isdeliveryaddress")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
            }
            DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getDataEntity().getDynamicObject("customer").getPkValue(), (String)"bd_customer");
            id = this.getModel().getDataEntity().getPkValue().toString();
            if (customer != null && (linkmans = customer.getDynamicObjectCollection("entry_linkman")) != null && linkmans.size() > 0) {
                for (DynamicObject linkman : linkmans) {
                    if (linkman.getDynamicObject("associatedaddress") == null || !id.equals(linkman.getDynamicObject("associatedaddress").getString("id"))) continue;
                    this.getView().setEnable(Boolean.FALSE, new String[]{"customer"});
                    break;
                }
            }
        }
        Object supplierid = this.getView().getFormShowParameter().getCustomParam("supplierid");
        Object customerid = this.getView().getFormShowParameter().getCustomParam("customerid");
        Object isSupplier = this.getView().getFormShowParameter().getCustomParam("isSupplier");
        Object isCustomer = this.getView().getFormShowParameter().getCustomParam("isCustomer");
        Object creatOrg = this.getView().getFormShowParameter().getCustomParam("createorg");
        if (supplierid != null) {
            this.getModel().setValue("supplierid", supplierid);
            this.getModel().setValue("supplier", supplierid);
            this.getView().setEnable(Boolean.FALSE, new String[]{"supplier"});
        }
        if (customerid != null) {
            this.getModel().setValue("customerid", customerid);
            this.getModel().setValue("customer", customerid);
            this.getView().setEnable(Boolean.FALSE, new String[]{"customer"});
        }
        if (isSupplier instanceof Boolean && Boolean.parseBoolean(isSupplier.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"issupplieradd"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"iscustomeradd"});
            this.getModel().setValue("issupplieradd", (Object)Boolean.TRUE);
            this.getModel().setValue("iscustomeradd", (Object)Boolean.FALSE);
        }
        if (isCustomer instanceof Boolean && Boolean.parseBoolean(isCustomer.toString())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"issupplieradd"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"iscustomeradd"});
            this.getModel().setValue("issupplieradd", (Object)Boolean.FALSE);
            this.getModel().setValue("iscustomeradd", (Object)Boolean.TRUE);
        }
        if (creatOrg != null) {
            this.getModel().setValue("createorg", creatOrg);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (BTNSAVE.equals(source.getKey())) {
            QFilter qf2;
            QFilter qf1;
            QFilter[] qfs;
            DynamicObject address;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("number", this.getModel().getValue("number"));
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name != null) {
                data.put("name", name.getLocaleValue());
            }
            data.put("linkman", this.getModel().getValue("linkman"));
            OrmLocaleValue phone = (OrmLocaleValue)this.getModel().getValue("phone");
            if (phone != null) {
                data.put("phone", phone.getLocaleValue());
            }
            data.put("addemail", this.getModel().getValue("addemail"));
            data.put("timezone", this.getModel().getValue("timezone") == null ? this.getModel().getValue("timezone") : ((DynamicObject)this.getModel().getValue("timezone")).get("name"));
            data.put("invalid", this.getModel().getValue("invalid"));
            data.put("default", this.getModel().getValue("default"));
            data.put("phonecode", "phonecode");
            OrmLocaleValue detailaddress = (OrmLocaleValue)this.getModel().getValue("detailaddress");
            if (detailaddress != null) {
                data.put("detailaddress", detailaddress.getLocaleValue());
            }
            if (!StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("supplierid")))) {
                QFilter qf22;
                QFilter qf12 = new QFilter("supplierid", "=", this.getModel().getValue("supplierid"));
                QFilter[] qfs2 = new QFilter[]{qf12, qf22 = new QFilter("number", "=", this.getModel().getValue("number"))};
                DynamicObject address2 = BusinessDataServiceHelper.loadSingle((String)"bd_address", (String)"id,enable", (QFilter[])qfs2);
                if (address2 != null) {
                    data.put("id", address2.getPkValue());
                    data.put("enable", address2.get("enable"));
                    this.getView().returnDataToParent(data);
                    if (currentflag.get().booleanValue()) {
                        currentflag.remove();
                        this.getView().close();
                    }
                }
            } else if (!StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("customerid"))) && (address = BusinessDataServiceHelper.loadSingle((String)"bd_address", (String)"id,enable", (QFilter[])(qfs = new QFilter[]{qf1 = new QFilter("customerid", "=", this.getModel().getValue("customerid")), qf2 = new QFilter("number", "=", this.getModel().getValue("number"))}))) != null) {
                data.put("id", address.getPkValue());
                data.put("enable", address.get("enable"));
                this.getView().returnDataToParent(data);
                if (currentflag.get().booleanValue()) {
                    currentflag.remove();
                    this.getView().close();
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operate = formOperate.getOperateKey();
        if ("save".equals(operate)) {
            if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                currentflag.set(Boolean.FALSE);
            } else if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                currentflag.set(Boolean.TRUE);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("admindivision".equals(name)) {
            this.getModel().setValue("admindivisiondata", this.getModel().getValue("admindivision"));
        } else if ("admindivisiondata".equals(name)) {
            this.getView().updateView("phonecode");
        }
        if ("customer".equals(name)) {
            this.getModel().setValue("customerid", this.getModel().getDataEntity().getDynamicObject("customer") == null ? Long.valueOf(0L) : this.getModel().getDataEntity().getDynamicObject("customer").getPkValue());
        }
        if ("supplier".equals(name)) {
            this.getModel().setValue("supplierid", this.getModel().getDataEntity().getDynamicObject("supplier") == null ? Long.valueOf(0L) : this.getModel().getDataEntity().getDynamicObject("supplier").getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity == null) {
            return;
        }
        if ("supplier".equals(fieldKey) || "customer".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.setShowApproved(false);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List datas = e.getSourceDataList();
        for (Map data : datas) {
            String orgError;
            DynamicObject org;
            String createOrgNumber;
            Map createOrg;
            String number;
            String isSupplier = (String)data.get("isSupplier");
            if ("1".equals(isSupplier)) {
                Map supplier = (Map)data.get("supplier");
                if (supplier != null && supplier.size() > 0) {
                    number = (String)supplier.get("number");
                    createOrg = (Map)supplier.get("createorg");
                    createOrgNumber = (String)createOrg.get("number");
                    org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createOrgNumber)});
                    if (org == null) {
                        orgError = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AddressFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]), createOrgNumber);
                        throw new KDBizException(orgError);
                    }
                    DynamicObject supplierData = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("createorg", "=", org.getPkValue())});
                    if (supplierData == null) {
                        String supplierError = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u521b\u5efa\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"AddressFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]), number, createOrgNumber);
                        throw new KDBizException(supplierError);
                    }
                    supplier.put("id", supplierData.getPkValue());
                    data.put("supplierid", supplierData.getPkValue());
                }
                data.put("issupplieradd", "1");
                data.put("iscustomeradd", "0");
                continue;
            }
            Map customer = (Map)data.get("customer");
            if (customer != null && customer.size() > 0) {
                number = (String)customer.get("number");
                createOrg = (Map)customer.get("createorg");
                createOrgNumber = (String)createOrg.get("number");
                org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createOrgNumber)});
                if (org == null) {
                    orgError = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AddressFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]), createOrgNumber);
                    throw new KDBizException(orgError);
                }
                DynamicObject customerData = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("createorg", "=", org.getPkValue())});
                if (customerData == null) {
                    String customerError = String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u521b\u5efa\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"AddressFormPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]), number, createOrgNumber);
                    throw new KDBizException(customerError);
                }
                customer.put("id", customerData.getPkValue());
                data.put("customerid", customerData.getPkValue());
            }
            data.put("issupplieradd", "0");
            data.put("iscustomeradd", "1");
        }
    }
}

