/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.AbstractFilterContantParser;
import kd.bos.entity.filter.FilterContantParserArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class CustomerFilterContantParser
extends AbstractFilterContantParser {
    public static final QFilter EMPTY = new QFilter("1", "=", (Object)2);

    protected QFilter getQFilter(FilterContantParserArgs filterContantParserArgs) {
        String filedKey = CustomerFilterContantParser.getCustomerFieldKey(filterContantParserArgs);
        if (StringUtils.isEmpty((String)filedKey)) {
            return EMPTY;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("salerid", "=", (Object)currUserId);
        DynamicObjectCollection allUseOrg = BaseDataServiceHelper.getAllUseOrg((String)"bd_customer");
        ArrayList<Long> orgIds = new ArrayList<Long>(allUseOrg.size());
        for (int i = 0; i < allUseOrg.size(); ++i) {
            DynamicObject org = (DynamicObject)allUseOrg.get(i);
            orgIds.add(org.getLong("id"));
        }
        userFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", orgIds, (boolean)Boolean.FALSE));
        try (DataSet customerDataSet = QueryServiceHelper.queryDataSet((String)CustomerFilterContantParser.class.getName(), (String)"bd_customer", (String)"id", (QFilter[])userFilter.toArray(), null);){
            Iterator iterator;
            ArrayList<Long> masterList = new ArrayList<Long>(16);
            int count = 0;
            for (Row row : customerDataSet) {
                masterList.add(row.getLong("id"));
                ++count;
            }
            if (count == 0) {
                iterator = EMPTY;
                return iterator;
            }
            iterator = new QFilter(filedKey, "in", masterList);
            return iterator;
        }
    }

    private static String getCustomerFieldKey(FilterContantParserArgs filterContantParserArgs) {
        String filedKey = filterContantParserArgs.getFieldName();
        String[] filedKeyList = filterContantParserArgs.getFieldName().split("[.]");
        MainEntityType mainEntityType = filterContantParserArgs.getMainEntityType();
        if (filedKeyList.length > 1) {
            StringBuilder keyBuilder = new StringBuilder();
            for (int i = 0; i < filedKeyList.length; ++i) {
                IDataEntityProperty property = mainEntityType.findProperty(filedKeyList[i]);
                if (property instanceof EntryProp) {
                    keyBuilder.append(property.getName()).append(".");
                }
                if (!(property instanceof BasedataProp)) continue;
                if ("bd_customer".equals(((BasedataProp)property).getBaseEntityId())) {
                    keyBuilder.append(property.getName());
                    break;
                }
                return "";
            }
            filedKey = keyBuilder.append(".id").toString();
        }
        return filedKey;
    }

    protected String getScriptFilter(FilterContantParserArgs filterContantParserArgs) {
        return "";
    }
}

