/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.master.MasterDataBaseFormPlugin;
import kd.bd.master.consts.CustomerStatusConst;
import kd.bd.master.enums.PartnerType;
import kd.bd.master.helper.AddressHelper;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bd.master.helper.FillDataHelper;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;

public class CustomerFormPlugin
extends MasterDataBaseFormPlugin
implements BeforeF7SelectListener {
    private GroupStandardHelper groupStandardHelper = new GroupStandardHelper();
    private static final Log log = LogFactory.getLog(CustomerFormPlugin.class);

    @Override
    public String getType() {
        return "bd_customer";
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"deleteidentity"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"deleteidentity"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bizpartner"});
        if (!BizpartnerHelper.isEnablepartner()) {
            Container ctr = (Container)this.getControl("fieldsetpanelap");
            if (ctr != null) {
                for (Control ct : ctr.getItems()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{ct.getKey()});
                }
            }
        } else {
            ((BasedataEdit)this.getView().getControl("bizpartner")).setMustInput(false);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit associatedaddress;
        BasedataEdit groupid;
        BasedataEdit datas;
        UserEdit userEdit;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry_address");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((userEdit = (UserEdit)this.getControl("salerid")) != null) {
            userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((datas = (BasedataEdit)this.getControl("standardid")) != null) {
            datas.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((groupid = (BasedataEdit)this.getControl("groupid")) != null) {
            groupid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((associatedaddress = (BasedataEdit)this.getView().getControl("associatedaddress")) != null) {
            associatedaddress.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if ("tabpageap".equals(key) && "btn_savestandard".equals(operationKey)) {
            try (TraceSpan span = Tracer.create((String)"CustomerFormPlugin", (String)"setSupGroupStandard");){
                if (!MasterDataHelper.checkMasterDataExit((IDataModel)this.getModel(), (String)this.getType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5ba2\u6237\u3002", (String)"Customer2FormPlugin_15", (String)"bd-master-formplugin", (Object[])new Object[0]));
                    return;
                }
                String result = MasterDataHelper.checkGroupEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (String)this.getType());
                if (result != null) {
                    this.getView().showTipNotification(result);
                    return;
                }
                boolean isGroupNew = new MasterDataHelper().checkGroupNew(this.getModel().getDataEntity(), this.getType(), this.getView());
                if (!isGroupNew) return;
                this.setCusGroupStandard(this.getModel(), this.getView());
                return;
            }
        }
        if (!"tabpageap_address".equals(key)) return;
        try {
            AddressHelper.addressOperate((String)operationKey, (IFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"bd_customer");
            return;
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void setCusGroupStandard(IDataModel model, IFormView view) {
        boolean result = GroupStandardHelper.saveGroupStandard((DynamicObject)model.getDataEntity(), (DynamicObjectCollection)model.getEntryEntity("entry_groupstandard"), (String)this.getType(), (IFormView)view);
        if (result) {
            GroupStandardHelper.setGroupStandard((Object)model.getDataEntity().getPkValue(), (String)MasterDataHelper.getUseOrg((IFormView)view).toString(), null, (IDataModel)model, (IFormView)view, (String)this.getType());
            GroupStandardHelper.setGrouptandard((IDataModel)model, (IFormView)view, (IPageCache)this.getPageCache(), (String)this.getType());
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u6807\u51c6\u4fdd\u5b58\u6210\u529f\u3002", (String)"Customer2FormPlugin_16", (String)"bd-master-formplugin", (Object[])new Object[0]));
            model.setDataChanged(false);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("addnumber".equals(fieldName)) {
            Object addressid = this.getModel().getValue("addid");
            BillShowParameter formShowParameter = null;
            formShowParameter = FormShowParameterUtil.createFormShowParameter((String)"bd_address", (Object)addressid, (String)ResManager.loadKDString((String)"\u5730\u5740", (String)"CustomerAddressFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]), (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.EDIT);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customeraddress"));
            formShowParameter.setCustomParam("isSupplier", (Object)Boolean.FALSE);
            formShowParameter.setCustomParam("isCustomer", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("customerid", (Object)this.getModel().getDataEntity().getPkValue().toString());
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String fieldKey = arg0.getProperty().getName();
        Object customerid = this.getModel().getDataEntity().getPkValue();
        if (customerid == null) {
            return;
        }
        if ("salerid".equals(fieldKey)) {
            FormShowParameter param = arg0.getFormShowParameter();
            param.setCustomParam("isShowPartner", (Object)Boolean.FALSE);
        } else if ("standardid".equals(fieldKey)) {
            GroupStandardHelper.addGroupStandardbeforeF7Select((IDataModel)this.getModel(), (String)"bd_customer", (BeforeF7SelectEvent)arg0);
        } else if ("groupid".equals(fieldKey)) {
            this.groupStandardHelper.addGroupbeforeF7Select(this.getModel(), arg0, this.getType());
        } else if ("associatedaddress".equals(fieldKey)) {
            QFilter qf1 = new QFilter("customerid", "=", (Object)String.valueOf(customerid));
            QFilter qf2 = new QFilter("invalid", "=", (Object)"0");
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.add(qf1);
            qfs.add(qf2);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List datas = e.getSourceDataList();
        for (int row = 0; row < datas.size(); ++row) {
            List linkmans = (List)((Map)datas.get(row)).get("entry_linkman");
            String id = String.valueOf(((Map)datas.get(row)).get("id"));
            String number = String.valueOf(((Map)datas.get(row)).get("number"));
            Map creatOrg = (Map)((Map)datas.get(row)).get("createorg");
            if (linkmans == null || linkmans.size() <= 0) continue;
            for (int i = 0; i < linkmans.size(); ++i) {
                Map lk = (Map)linkmans.get(i);
                Map associatedaddress = (Map)lk.get("associatedaddress");
                if (associatedaddress == null) continue;
                if (!"null".equals(id) && !StringUtils.isEmpty((String)id)) {
                    DynamicObject address = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_address", (QFilter[])new QFilter[]{new QFilter("customerid", "=", (Object)id), new QFilter("number", "=", associatedaddress.get("number"))});
                    if (address == null) {
                        e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5173\u8054\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CustomerFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    associatedaddress.put("id", Long.valueOf(address.getPkValue().toString()));
                    ((Map)linkmans.get(i)).put("associatedaddress", associatedaddress);
                    continue;
                }
                if (!"null".equals(number) && !StringUtils.isEmpty((String)number) && creatOrg != null && creatOrg.size() > 0) {
                    String orgnumber = String.valueOf(creatOrg.get("number"));
                    if ("null".equals(orgnumber) || StringUtils.isEmpty((String)orgnumber)) {
                        e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomerFormPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgnumber)});
                    if (org == null) {
                        e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u5ba2\u6237\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CustomerFormPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("createorg", "=", org.getPkValue())});
                    if (customer == null) {
                        e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u5ba2\u6237\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CustomerFormPlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject address = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_address", (QFilter[])new QFilter[]{new QFilter("customerid", "=", (Object)customer.getPkValue().toString()), new QFilter("number", "=", associatedaddress.get("number"))});
                    if (address == null) {
                        e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5173\u8054\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CustomerFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    associatedaddress.put("id", Long.valueOf(address.getPkValue().toString()));
                    ((Map)linkmans.get(i)).put("associatedaddress", associatedaddress);
                    continue;
                }
                e.addCancelMessage(Integer.valueOf(row), Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u5ba2\u6237\u5185\u7801\u6216\u5ba2\u6237\u521b\u5efa\u7ec4\u7ec7\u4e0e\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"CustomerFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void tabSelected(TabSelectEvent arg0) {
        super.tabSelected(arg0);
        String tabKey = arg0.getTabKey();
        if ("tabpageap_biz".equals(tabKey) || "tabpageap_inv".equals(tabKey)) {
            this.getView().updateView("invoicecustomerid");
            this.getView().updateView("paymentcustomerid");
            this.getView().updateView("delivercustomerid");
        } else if ("tabpageap_linkman".equals(tabKey)) {
            this.addEntryGridFilter("entry_linkman", "deleteidentity");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        ChangeData[] changeSet = arg0.getChangeSet();
        IDataEntityProperty property = arg0.getProperty();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String propertyName = property.getName();
        if ("name".equals(propertyName)) {
            Object oldNameValue = changeSet[0].getOldValue();
            try {
                FillDataHelper.input((IFormView)view, (IDataModel)model, (String)propertyName, (Object)oldNameValue);
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u5ba2\u6237\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
        } else if ("type".equals(propertyName)) {
            this.typeChange(changeSet);
        } else if ("deleteidentity".equals(propertyName)) {
            Boolean newValue = (Boolean)changeSet[0].getNewValue();
            if (newValue.booleanValue()) {
                this.addEntryGridFilter("entry_linkman", "deleteidentity");
            }
        } else if ("chkisinternalcompany".equals(propertyName)) {
            Boolean newValue = (Boolean)changeSet[0].getNewValue();
            if (newValue.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"internal_company"});
            } else {
                this.getModel().setValue("internal_company", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"internal_company"});
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pkValue = (Long)dataEntity.getPkValue();
        boolean chkisinternalcompany = dataEntity.getBoolean("chkisinternalcompany");
        if (pkValue != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"internal_company"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"chkisinternalcompany"});
        } else if (!chkisinternalcompany) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"internal_company"});
        }
        FillDataHelper.checkIsvData((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operation = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operation) || "submit".equals(operation)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"chkisinternalcompany"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"internal_company"});
            }
            this.getView().getPageCache().remove("internal_company");
        } else if ("changeinternal_company".equals(operation) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String typeValue = String.valueOf(this.getModel().getValue("type"));
            if (!PartnerType.PERSON.getValue().equals(typeValue)) {
                this.getModel().setValue("chkisinternalcompany", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.TRUE, new String[]{"chkisinternalcompany"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"internal_company"});
            }
            this.getPageCache().put("internal_company", "true");
        } else if ("deleteentry_linkman".equals(operation) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry_linkman");
            int[] rows = entryGrid.getSelectRows();
            if (rows != null && rows.length > 0) {
                DynamicObject customer = this.getModel().getDataEntity();
                Long id = customer.getLong("id");
                if (id != 0L) {
                    boolean exit = QueryServiceHelper.exists((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    if (exit) {
                        for (int rowIndex : rows) {
                            this.getModel().setValue("deleteidentity", (Object)Boolean.TRUE, rowIndex);
                            this.getModel().setValue("invalid", (Object)Boolean.TRUE, rowIndex);
                            this.getModel().setValue("isdefault_linkman", (Object)Boolean.FALSE, rowIndex);
                        }
                    } else {
                        for (int rowIndex : MasterDataHelper.sort((int[])rows)) {
                            this.getModel().deleteEntryRow("entry_linkman", rowIndex);
                        }
                    }
                } else {
                    for (int rowIndex : MasterDataHelper.sort((int[])rows)) {
                        this.getModel().deleteEntryRow("entry_linkman", rowIndex);
                    }
                }
            }
        } else if ("unaudit".equals(operation)) {
            this.addEntryGridFilter("entry_linkman", "deleteidentity");
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject defaultCusSatus = BusinessDataServiceHelper.loadSingleFromCache((Object)CustomerStatusConst.CUSTOMERSTATUS_NORMAL, (String)"bd_customerstatus");
        entity.set("customerstatus", (Object)defaultCusSatus);
    }

    private void typeChange(ChangeData[] changeSet) {
        String oldTypeValue = String.valueOf(changeSet[0].getOldValue());
        String newTypeValue = String.valueOf(changeSet[0].getNewValue());
        if (PartnerType.PERSON.getValue().equals(newTypeValue)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"chkisinternalcompany"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"internal_company"});
            this.getModel().setValue("chkisinternalcompany", (Object)Boolean.FALSE);
            this.getModel().setValue("internal_company", null);
        }
        if (PartnerType.PERSON.getValue().equals(oldTypeValue)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"chkisinternalcompany"});
        }
    }
}

