/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.master.enums.MaterialInfoEntityTypeEnum;
import kd.bd.master.helper.GenerateMaterialBizInfoHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class MaterialBizInfoDetailPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String TABPAGEAP_PURCHASE = "purchaseinfo";
    public static final String TABPAGEAP_SAL = "salinfo";
    public static final String TABPAGEAP_INVENTORY = "inventoryinfo";
    public static final String TABPAGEAP_MFT = "mftinfo";
    public static final String TABPAGEAP_PLAN = "planinfo";
    public static final String TABPAGEAP_INSPECTINFO = "inspectinfo";
    public static final String TABPAGEAP_CAL = "calinfo";
    public static final String PGCACHE_CURSELTABKEY = "curSelTabKey";
    public static final String ENTRYENTITY_TAG = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!GenerateMaterialBizInfoHelper.isExtistEntity((String)"mpdm_materialplan")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABPAGEAP_PLAN});
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(TABPAGEAP_PURCHASE);
        this.getPageCache().put(PGCACHE_CURSELTABKEY, TABPAGEAP_PURCHASE);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String curSelTabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put(PGCACHE_CURSELTABKEY, curSelTabKey);
        this.loadData();
    }

    private void loadData() {
        Map cols;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkey = customParams.get("masterid");
        if (pkey == null || pkey.equals(0)) {
            return;
        }
        String curTab = this.getPageCache().get(PGCACHE_CURSELTABKEY);
        List<String> prefixAndUnitTagList = this.getInfoTabPrefixAndUnittag(curTab);
        String prefix = prefixAndUnitTagList.get(0);
        String unitProperties = prefixAndUnitTagList.get(1);
        String selectPropertites = "id,createorg,status,enable,ctrlstrategy,creator,createtime";
        if (StringUtils.isNotEmpty((String)unitProperties)) {
            selectPropertites = selectPropertites + "," + unitProperties;
        }
        String entityTypeByCode = "mpdm_materialplan";
        if (!TABPAGEAP_PLAN.equals(curTab)) {
            entityTypeByCode = MaterialInfoEntityTypeEnum.getEntityTypeByCode((String)curTab);
        }
        if ((cols = BusinessDataServiceHelper.loadFromCache((String)entityTypeByCode, (String)selectPropertites, (QFilter[])new QFilter[]{new QFilter("masterid", "=", pkey)})) == null || cols.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(prefix + ENTRYENTITY_TAG);
        entryentity.clear();
        int count = 0;
        for (DynamicObject bizInfo : cols.values()) {
            DynamicObject dynamicObject = new DynamicObject(entryentity.getDynamicObjectType());
            dynamicObject.set(prefix + "createorg", (Object)bizInfo.getDynamicObject("createorg"));
            if (!("plan".equals(prefix) || "inspect".equals(prefix) || "cal".equals(prefix))) {
                dynamicObject.set(prefix + "unit", (Object)bizInfo.getDynamicObject(unitProperties));
            }
            dynamicObject.set(prefix + "status", (Object)bizInfo.getString("status"));
            dynamicObject.set(prefix + "enable", (Object)bizInfo.getString("enable"));
            dynamicObject.set(prefix + "ctrlstrategy", (Object)bizInfo.getString("ctrlstrategy"));
            dynamicObject.set(prefix + "creator", (Object)bizInfo.getDynamicObject("creator"));
            dynamicObject.set(prefix + "createtime", (Object)bizInfo.getDate("createtime"));
            entryentity.add(count, dynamicObject);
            ++count;
        }
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView(prefix + ENTRYENTITY_TAG);
    }

    private List<String> getInfoTabPrefixAndUnittag(String curSelTabKey) {
        ArrayList<String> prefixAndUnitTagList = new ArrayList<String>();
        switch (curSelTabKey) {
            case "purchaseinfo": {
                prefixAndUnitTagList.add("pur");
                prefixAndUnitTagList.add("purchaseunit");
                break;
            }
            case "inventoryinfo": {
                prefixAndUnitTagList.add("inv");
                prefixAndUnitTagList.add("inventoryunit");
                break;
            }
            case "salinfo": {
                prefixAndUnitTagList.add("sal");
                prefixAndUnitTagList.add("salesunit");
                break;
            }
            case "mftinfo": {
                prefixAndUnitTagList.add("mft");
                prefixAndUnitTagList.add("mftunit");
                break;
            }
            case "inspectinfo": {
                prefixAndUnitTagList.add("inspect");
                prefixAndUnitTagList.add("");
                break;
            }
            case "calinfo": {
                prefixAndUnitTagList.add("cal");
                prefixAndUnitTagList.add("");
                break;
            }
            case "planinfo": {
                prefixAndUnitTagList.add("plan");
                prefixAndUnitTagList.add("");
                break;
            }
        }
        return prefixAndUnitTagList;
    }
}

