/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.event;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.master.enums.MaterialInfoPushTargetEntityTypeEnum;
import kd.bd.master.helper.GenerateMaterialBizInfoHelper;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.StringUtils;

public abstract class BaseMaterialAuditAutoPushEvent
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(BaseMaterialAuditAutoPushEvent.class);

    protected abstract String getPushTarget();

    protected abstract String getBotpId();

    public Object handleEvent(KDBizEvent evt) {
        List masteridList = ((EntityEvent)evt).getBusinesskeys().stream().map(Long::parseLong).collect(Collectors.toCollection(ArrayList::new));
        String pushTarget = this.getPushTarget();
        String botpId = this.getBotpId();
        boolean planAppExtistFlg = GenerateMaterialBizInfoHelper.isExtistEntity((String)"mpdm_materialplan");
        if (MaterialInfoPushTargetEntityTypeEnum.PLANINFO.getEntityType().equals(pushTarget) && !planAppExtistFlg) {
            return evt.getEventId();
        }
        StringBuilder errorMessage = new StringBuilder();
        PushArgs args = this.buildTaskArgs(pushTarget, botpId, masteridList);
        String autoPushResult = this.autoPush(args);
        errorMessage.append(autoPushResult);
        if (!errorMessage.toString().trim().isEmpty()) {
            throw new KDBizException(errorMessage.toString());
        }
        return evt.getEventId();
    }

    private String autoPush(PushArgs pushArgs) {
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            String excludeErrInfo = ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u4e0b\u63a8", (String)"BASEDATA-P-758417", (String)"bd-master-formplugin", (Object[])new Object[0]);
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                String reportString = billReport.toString();
                if (!StringUtils.isNotEmpty((String)reportString) || reportString.contains(excludeErrInfo)) continue;
                errMessage.append("\n").append(reportString);
            }
            return errMessage.toString();
        }
        return "";
    }

    private PushArgs buildTaskArgs(String targetEntityType, String botpId, List<Long> masteridList) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("bd_material");
        pushArgs.setTargetEntityNumber(targetEntityType);
        pushArgs.setRuleId(botpId);
        pushArgs.setSelectedRows(BaseMaterialAuditAutoPushEvent.buildTaskSelectedRows(masteridList));
        pushArgs.setHasRight(false);
        pushArgs.setAutoSave(true);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private static List<ListSelectedRow> buildTaskSelectedRows(List<Long> masteridList) {
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(masteridList.size());
        for (Long masterid : masteridList) {
            ListSelectedRow row = new ListSelectedRow((Object)masterid, Boolean.TRUE);
            selectedRowList.add(row);
        }
        return selectedRowList;
    }
}

