/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class GroupTempListPlugin
extends TemplateTreePlugin {
    public static final String TEXTFORMAT_NAME = "{name}";
    public static final String TEXTFORMAT_CODE = "{code}";
    public static final String OP_OPEN = "btn_open";
    public static final String PGCACHE_CREATEORG = "createOrg";
    public static final String PGCACHE_CREATEORGS = "createOrgs";
    public static final String PGCACHE_PARENTCREATEORG = "orgs";

    public void search(SearchEnterEvent evt) {
        List<Object> treeNodes;
        String searchText = evt.getText();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return;
        }
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"StandardTreeListPlugin_6", (String)"bos-form-core", (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    if (indexCache == treeNodes.size()) {
                        indexCache = 0;
                    }
                    this.focusNode(treeView, this.getTreeModel().getRoot(), treeNodes.get(indexCache), entity);
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"StandardTreeListPlugin_7", (String)"bos-form-core", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                treeView.treeNodeClick(treeNodes.get(0).getParentid(), treeNodes.get(0).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode, String entity) {
        this.expandParents(treeView, rootNode, treeNode, entity);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node, String entity) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = this.getTreeNode(parentid, entity);
            if (p != null) {
                this.expandParents(treeView, rootNode, p, entity);
                treeView.expand(parentid);
                treeView.updateNode(node);
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    private TreeNode getTreeNode(String parentid, String entity) {
        String groupNumber = GroupStandardHelper.getGroupNumber((String)entity);
        TreeNode treeNode = new TreeNode();
        if (this.getTreeModel().getRoot().getId().equals(parentid)) {
            return this.getTreeModel().getRoot();
        }
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(parentid), (String)groupNumber, (String)"longnumber,parent,name,number");
        List<TreeNode> nodes = this.getChildrenNodes(parentid, entity, groupNumber);
        treeNode.setId(parentid);
        treeNode.setParentid(group.getDynamicObject("parent") != null ? group.getDynamicObject("parent").getString("id") : this.getTreeModel().getRoot().getId());
        treeNode.setLongNumber(group.getString("longnumber"));
        treeNode = this.getLocaleStringName(group, "", treeNode);
        treeNode.addChildren(nodes);
        return treeNode;
    }

    private List<TreeNode> getChildrenNodes(String parentid, String entity, String groupNumber) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String standard = (String)this.getModel().getValue("cmbstandardlst");
        Set<Long> useOrgs = this.getUseOrgs(param, entity + "group", standard);
        Set<Long> orgs = this.getorgAndParentOrg(entity, useOrgs);
        Set groupOrgs = GroupStandardUtils.getGroupOrgId((String)entity, orgs);
        List<Map<String, String>> childNodes = this.queryUserGroup(parentid, groupOrgs, groupNumber, standard);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(childNodes.size());
        for (Map<String, String> map : childNodes) {
            TreeNode groupNode = new TreeNode();
            String id = map.get("id");
            String name = map.get("name");
            groupNode.setParentid(parentid);
            groupNode.setId(id);
            groupNode.setText(name);
            List<Map<String, String>> newChildNodes = this.queryUserGroup(id, groupOrgs, groupNumber, standard);
            if (null != newChildNodes && newChildNodes.size() > 0) {
                groupNode.addChildren(new ArrayList());
            }
            nodes.add(groupNode);
        }
        return nodes;
    }

    private List<Map<String, String>> queryUserGroup(String parentId, Set<Long> groupOrgs, String groupNumber, String standard) {
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            parentId = "0";
        }
        QFilter[] qfArr = new QFilter[]{new QFilter("parent", "=", (Object)Long.parseLong(parentId)), new QFilter("standard", "=", (Object)Long.valueOf(standard)), new QFilter("createorg", "in", groupOrgs), new QFilter("enable", "in", (Object)"1")};
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)groupNumber, (String)"id,name", (QFilter[])qfArr);
        List groups = loadFromCache.values().stream().sorted((a, b) -> a.getString("number").compareTo(b.getString("number"))).collect(Collectors.toList());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(loadFromCache.size());
        HashSet<Long> ids = new HashSet<Long>(loadFromCache.size());
        for (DynamicObject group : groups) {
            ids.add(group.getLong("id"));
        }
        QFilter[] parentQfilter = new QFilter[]{new QFilter("parent", "in", ids), new QFilter("standard", "in", groupOrgs)};
        Map parents = BusinessDataServiceHelper.loadFromCache((String)groupNumber, (String)"parent", (QFilter[])parentQfilter);
        HashSet<Long> parentIds = new HashSet<Long>(parents.size());
        for (DynamicObject group : parents.values()) {
            if (group.getDynamicObject("parent") == null) continue;
            parentIds.add(group.getDynamicObject("parent").getLong("id"));
        }
        for (DynamicObject group : groups) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", group.getString("id"));
            map.put("name", group.getString("name"));
            if (parentIds.contains(group.getLong("id"))) {
                map.put("isLeaf", "false");
            } else {
                map.put("isLeaf", "true");
            }
            list.add(map);
        }
        return list;
    }

    private List<TreeNode> getSearchGroup(String searchText, String entity) {
        String value = (String)this.getModel().getValue("cmbstandardlst");
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String groupNumber = GroupStandardHelper.getGroupNumber((String)entity);
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.valueOf(value));
        QFilter qFilter2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        Set<Long> useOrgs = this.getUseOrgs(param, entity, value);
        Set<Long> orgs = this.getorgAndParentOrg(entity, useOrgs);
        QFilter qFilter4 = new QFilter("createorg", "in", orgs);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)groupNumber, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4}, (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(datas.size());
        for (DynamicObject group : datas) {
            if (group.getLong("id") == 0L) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString("id"));
            Long parent = group.getLong("parent");
            treeNode.setParentid(parent == 0L ? "8609760E-EF83-4775-A9FF-CCDEC7C0B689" : group.getString("parent"));
            treeNode.setLongNumber(group.getString("longnumber"));
            treeNode = this.getLocaleStringName(group, "", treeNode);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    protected void setComboEdit(List<Map<String, Object>> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl("cmbstandardlst");
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    protected void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    protected Map<String, LocaleString> setComboItems(List<Map<String, Object>> orgModelList) {
        LinkedHashMap<String, LocaleString> comboItems = new LinkedHashMap<String, LocaleString>();
        if (orgModelList != null) {
            for (Map<String, Object> map : orgModelList) {
                String id = (String)map.get("id");
                String fName = (String)map.get("name");
                comboItems.put(id, new LocaleString(fName));
            }
        }
        return comboItems;
    }

    protected void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    protected TreeNode getLocaleStringName(DynamicObject group, String textFormat, TreeNode treeNode) {
        String name = group.getString("name");
        String number = group.getString("number");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = group.getString("name");
        }
        String text = textFormat;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            if (textFormat.contains(TEXTFORMAT_NAME) && StringUtils.isNotBlank((CharSequence)name)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_NAME, (String)name);
            }
            if (textFormat.contains(TEXTFORMAT_CODE) && StringUtils.isNotBlank((CharSequence)number)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_CODE, (String)number);
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            treeNode.setText(name);
        } else {
            treeNode.setText(text);
        }
        return treeNode;
    }

    protected Set<Long> getorgAndParentOrg(String entity, Set<Long> useOrgs) {
        Set orgs = null;
        String orgsStr = this.getPageCache().get(PGCACHE_PARENTCREATEORG);
        if (StringUtils.isNotBlank((CharSequence)orgsStr)) {
            orgs = (Set)SerializationUtils.fromJsonString((String)orgsStr, Set.class);
        }
        if (orgs == null) {
            orgs = GroupStandardUtils.getGroupOrgId((String)entity, useOrgs);
            this.getPageCache().put(PGCACHE_PARENTCREATEORG, SerializationUtils.toJsonString((Object)orgs));
        }
        return orgs;
    }

    protected List<QFilter> addQFilters(List<QFilter> parentQFilters, QFilter ... qFilter) {
        for (QFilter qf : qFilter) {
            parentQFilters.add(qf);
        }
        return parentQFilters;
    }

    protected Set<Long> getUseOrgs(ListShowParameter param, String entity, String standard) {
        Set useOrgs = null;
        String useOrgsStr = this.getPageCache().get(PGCACHE_CREATEORGS);
        if (StringUtils.isNotBlank((CharSequence)useOrgsStr)) {
            useOrgs = (Set)SerializationUtils.fromJsonString((String)useOrgsStr, Set.class);
        }
        if (useOrgs == null) {
            String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
            useOrgs = GroupStandardUtils.getCreateOrgs((ListShowParameter)param, (String)entity, (String)standard, (String)createOrg);
            this.getPageCache().put(PGCACHE_CREATEORGS, SerializationUtils.toJsonString((Object)useOrgs));
        }
        return useOrgs;
    }
}

