/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bd.sbd.enums.EndDateCalTypeEnum;
import kd.bd.sbd.enums.StartDateCalTypeEnum;
import kd.bd.sbd.enums.StatusEnum;
import kd.bd.sbd.utils.pdm.mftbom.DynamicObjDataUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MasterBasedataEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class MaterialInvInfoPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String EVENT_CUSTOM_SHOWWAREHOUSESETUP = "ShowWareHouseSetup";
    public static final String EVENT_CUSTOM_SHOWINTERSYSTEMCALLCONF = "ShowInterSystemCallConf";
    private static Map<String, String> ctrls = new HashMap<String, String>(4);

    public void afterLoadData(EventObject e) {
        BaseShowParameter baseShowParameter;
        long useOrgId;
        super.afterLoadData(e);
        if (this.getView() != null && this.getView().getFormShowParameter() instanceof BaseShowParameter && (useOrgId = (baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter()).getUseOrgId()) != 0L) {
            this.getPageCache().put("createOrg", useOrgId + "");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        Object oldObj = e.getChangeSet()[0].getOldValue();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "masterid": {
                this.change4material(newObj);
                break;
            }
            case "isreserve": {
                this.change4IsReserve(e);
                break;
            }
            case "enableserial": {
                this.checkInUsed(newObj, "enableserial");
                break;
            }
            case "enableshelflifemgr": {
                this.changeShelfLifeMgr(oldObj, newObj);
                break;
            }
            case "ismininvalert": 
            case "issaftyinvalert": 
            case "isreorderpointalert": 
            case "ismaxinvalert": {
                this.openSwitchSetMustInput(key.toLowerCase(), newObj);
                break;
            }
            case "enablewarnlead": {
                this.closeSwitchClearsData(key.toLowerCase(), newObj);
                break;
            }
            case "caldirection": {
                this.setLifeFieldMustInput(this.getModel().getDataEntity().getBoolean("enableshelflifemgr"));
                this.setCalEndDateVal();
                this.setCalStartDateVal();
                break;
            }
            case "calculationforenddate": {
                this.setCalStartDateVal();
                break;
            }
        }
    }

    private void setCalEndDateVal() {
        String calDirection = this.getModel().getDataEntity().getString("caldirection");
        if (CalDirectionEnum.CALENDDATE.getValue().equals(calDirection) || CalDirectionEnum.CALBOTH.getValue().equals(calDirection)) {
            this.getModel().setValue("calculationforenddate", (Object)EndDateCalTypeEnum.STARTDATEADDSHELFLIFE.getValue());
        } else if (CalDirectionEnum.CALNONE.getValue().equals(calDirection) || CalDirectionEnum.CALSTARTDATE.getValue().equals(calDirection)) {
            this.getModel().setValue("calculationforenddate", null);
        }
    }

    private void setCalStartDateVal() {
        DynamicObject data = this.getModel().getDataEntity();
        String calDirection = data.getString("caldirection");
        String calCulForEndDate = data.getString("calculationforenddate");
        if (CalDirectionEnum.CALBOTH.getValue().equals(calDirection) && (EndDateCalTypeEnum.STARTDATEADDSHELFLIFE.getValue().equals(calCulForEndDate) || EndDateCalTypeEnum.STARTDATEADDLASTDAY.getValue().equals(calCulForEndDate))) {
            this.getModel().setValue("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFE.getValue());
        } else if (CalDirectionEnum.CALBOTH.getValue().equals(calDirection) && EndDateCalTypeEnum.STARTDATEADDSHELFLIFEMINUSONE.getValue().equals(calCulForEndDate)) {
            this.getModel().setValue("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFEADDONE.getValue());
        } else if (CalDirectionEnum.CALSTARTDATE.getValue().equals(calDirection) && StringUtils.isBlank((CharSequence)calCulForEndDate)) {
            this.getModel().setValue("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFE.getValue());
        } else if (CalDirectionEnum.CALNONE.getValue().equals(calDirection) || CalDirectionEnum.CALENDDATE.getValue().equals(calDirection)) {
            this.getModel().setValue("startdatecaltype", null);
        }
    }

    private void openSwitchSetMustInput(String lowerCase, Object newObj) {
        Boolean isOpen = Boolean.valueOf(newObj.toString());
        String control = ctrls.get(lowerCase);
        QtyEdit qtyEdit = (QtyEdit)this.getControl(control);
        qtyEdit.setMustInput(isOpen.booleanValue());
    }

    private void closeSwitchClearsData(String lowerCase, Object newObj) {
        Boolean isOpen = false;
        if (StringUtils.isNotBlank((Object)newObj)) {
            isOpen = Boolean.valueOf(newObj.toString());
        }
        if (!isOpen.booleanValue()) {
            String control = ctrls.get(lowerCase);
            this.getModel().setValue(control, null);
        }
    }

    private void changeShelfLifeMgr(Object oldObj, Object newObj) {
        boolean enableShelfLifeMgr = (Boolean)newObj;
        IDataModel model = this.getModel();
        this.setLifeFieldMustInput(enableShelfLifeMgr);
        if (!enableShelfLifeMgr) {
            model.setValue("shelflifeunit", null);
            model.setValue("shelflife", null);
            model.setValue("calculationforenddate", null);
            model.setValue("leadtimeunit", null);
            model.setValue("dateofoverdueforin", null);
            model.setValue("dateofoverdueforout", null);
            model.setValue("warnleadtime", null);
            model.setValue("enablewarnlead", null);
            model.setValue("caldirection", null);
            model.setValue("startdatecaltype", null);
        }
        if (enableShelfLifeMgr && StringUtils.isBlank((Object)model.getValue("caldirection"))) {
            model.setValue("caldirection", (Object)CalDirectionEnum.CALBOTH.getValue());
        }
    }

    private void setLifeFieldMustInput(boolean enableShelfLifeMgr) {
        ComboEdit shelflifeUnit = (ComboEdit)this.getControl("shelflifeunit");
        ComboEdit calculationForEndDate = (ComboEdit)this.getControl("calculationforenddate");
        ComboEdit leadTimeUnit = (ComboEdit)this.getControl("leadtimeunit");
        ComboEdit calDirectionCombo = (ComboEdit)this.getControl("caldirection");
        ComboEdit startDateCalTypeCombo = (ComboEdit)this.getControl("startdatecaltype");
        DynamicObject materialInvInfo = this.getModel().getDataEntity();
        String calDirection = materialInvInfo.getString("caldirection");
        shelflifeUnit.setMustInput(enableShelfLifeMgr);
        boolean isEndDateMustInput = enableShelfLifeMgr && (CalDirectionEnum.CALENDDATE.getValue().equals(calDirection) || CalDirectionEnum.CALBOTH.getValue().equals(calDirection));
        calculationForEndDate.setMustInput(isEndDateMustInput);
        leadTimeUnit.setMustInput(enableShelfLifeMgr);
        calDirectionCombo.setMustInput(enableShelfLifeMgr);
        boolean isStartDateMustInput = enableShelfLifeMgr && (CalDirectionEnum.CALSTARTDATE.getValue().equals(calDirection) || CalDirectionEnum.CALBOTH.getValue().equals(calDirection));
        startDateCalTypeCombo.setMustInput(isStartDateMustInput);
    }

    private void checkInUsed(Object newObj, String type) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        if (org == null) {
            return;
        }
        DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
        if (masterid != null && !Boolean.parseBoolean(newObj.toString())) {
            QFilter filter1 = new QFilter("material", "=", masterid.getPkValue());
            DynamicObject[] objs = null;
            String errorCode = null;
            if ("enablelot".equals(type)) {
                QFilter filter2 = new QFilter("createorg", "=", org.getPkValue());
                objs = BusinessDataServiceHelper.load((String)"bd_lot", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
                errorCode = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u542f\u7528\u6279\u53f7\u7ba1\u7406\u3002", (String)"MaterialInvInfoPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                if (objs != null && objs.length > 0) {
                    this.getView().showErrorNotification(errorCode);
                    this.getModel().setValue("enablelot", (Object)Boolean.TRUE);
                }
            } else if ("enableserial".equals(type)) {
                QFilter filter2 = new QFilter("keeporg", "=", org.getPkValue());
                objs = BusinessDataServiceHelper.load((String)"bd_snmainfile", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
                errorCode = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\u3002", (String)"MaterialInvInfoPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                if (objs != null && objs.length > 0) {
                    this.getView().showErrorNotification(errorCode);
                    this.getModel().setValue("enableserial", (Object)Boolean.TRUE);
                }
            }
        }
        if ("enableserial".equals(type)) {
            this.getModel().setValue("isoutputrequest", newObj);
            this.getView().updateView("isoutputrequest");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
        boolean enableshelflifemgr = (Boolean)this.getModel().getValue("enableshelflifemgr");
        this.setLifeFieldMustInput(enableshelflifemgr);
        if (this.getModel().getValue("masterid") != null) {
            DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
            this.getModel().setValue("material", (Object)((Long)masterid.getPkValue()));
            this.getModel().setDataChanged(false);
        }
    }

    private void setEnable() {
        boolean isReserve = this.getModel().getDataEntity().getBoolean("isreserve");
        this.getView().setEnable(Boolean.valueOf(!isReserve), new String[]{"isallowneginv"});
    }

    private void change4IsReserve(PropertyChangedArgs e) {
        boolean isReserve = this.getModel().getDataEntity().getBoolean("isreserve");
        if (isReserve) {
            this.getModel().setValue("isallowneginv", (Object)Boolean.FALSE);
        }
        this.getView().setEnable(Boolean.valueOf(!isReserve), new String[]{"isallowneginv"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MasterBasedataEdit materialEdit = (MasterBasedataEdit)this.getView().getControl("masterid");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit invUnitEdit = (UnitEdit)this.getView().getControl("inventoryunit");
        invUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("masterid".equals(fieldKey)) {
            QFilter invMaterialFilter = new QFilter("enableinv", "=", (Object)Boolean.TRUE);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter auditFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            ArrayList<String> configpropertiesValues = new ArrayList<String>();
            configpropertiesValues.add("1");
            configpropertiesValues.add("2");
            QFilter configproperties = new QFilter("configproperties", "in", configpropertiesValues);
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(createOrg != null ? Long.parseLong(createOrg.getPkValue().toString()) : 0L));
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(invMaterialFilter, configproperties, enableFilter, auditFilter, orgIdFilter));
        } else if ("inventoryunit".equals(fieldKey)) {
            if (this.checkFieldValueNull("masterid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialInvInfoPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (this.checkFieldValueNull("baseunit")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f53\u524d\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u662f\u5426\u6b63\u786e\u3002", (String)"MaterialInvInfoPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long mid = ((DynamicObject)this.getModel().getValue("masterid")).getLong("id");
            Long buid = ((DynamicObject)this.getModel().getValue("baseunit")).getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1", (Boolean)Boolean.TRUE);
            QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
            showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
        } else {
            return;
        }
    }

    private boolean checkFieldValueNull(String fieldname) {
        Object value = this.getModel().getValue(fieldname);
        if (value != null) {
            if (value instanceof DynamicObject) {
                DynamicObject doValue = (DynamicObject)value;
                return doValue.getLong("id") <= 0L;
            }
            return false;
        }
        return true;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"isallowneginv") && StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)EVENT_CUSTOM_SHOWWAREHOUSESETUP)) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"/ECXMRIR/OVQ", (String)"=9Q86DR2P+Q");
        }
        if (StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)EVENT_CUSTOM_SHOWINTERSYSTEMCALLCONF)) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"1159940683331791872", (String)"05RE3QGF6PC2");
        }
        if ((StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"isreserve") || StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"reservationperiod")) && StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)"ShowScmParamList")) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"1160100948149006336", (String)"05RE3QGF6PC2");
        }
    }

    private void change4material(Object newObj) {
        if (newObj == null) {
            this.getModel().setValue("inventoryunit", null);
            this.getModel().setValue("baseunit", null);
            this.getModel().setValue("material", null);
        } else {
            DynamicObject mate = (DynamicObject)newObj;
            this.getModel().setValue("material", (Object)mate);
            DynamicObject baseunit = mate.getDynamicObject("baseunit");
            if (baseunit != null) {
                this.getModel().setValue("inventoryunit", baseunit.get("id"));
                this.getModel().setValue("baseunit", baseunit.get("id"));
            }
        }
    }

    private boolean getRefMsg(DynamicObject data, String key, boolean newValue) {
        DynamicObject oldData = BusinessDataServiceHelper.loadSingleFromCache((Object)data.getPkValue(), (String)"bd_materialinventoryinfo");
        if ("enablelot".equals(key) && oldData.getBoolean("enablelot") == newValue) {
            return true;
        }
        if ("enableshelflifemgr".equals(key) && oldData.getBoolean("enableshelflifemgr") == newValue) {
            return true;
        }
        boolean haveRefrence = this.checkRealInv(data);
        if (haveRefrence) {
            String resMsg = null;
            String title = null;
            if ("enableshelflifemgr".equals(key)) {
                title = ResManager.loadKDString((String)"\u542f\u7528/\u53cd\u542f\u7528\u4fdd\u8d28\u671f", (String)"MaterialInvInfoPlugin_8", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                resMsg = ResManager.loadKDString((String)"\u5f00\u542f\u6216\u5173\u95ed\u4fdd\u8d28\u671f\u7ba1\u7406\u9700\u8981\u5148\u5904\u7406\u5386\u53f2\u5e93\u5b58\uff0c\u5426\u5219\u65e0\u6cd5\u51fa\u5e93\uff0c\u8bf7\u786e\u4fdd\u5386\u53f2\u5e93\u5b58\u4e3a0\u3002\r\n\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MaterialInvInfoPlugin_9", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(title, resMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("enableshelflifemgr", (IFormPlugin)this));
            } else if ("enablelot".equals(key)) {
                title = ResManager.loadKDString((String)"\u542f\u7528/\u53cd\u542f\u7528\u6279\u53f7", (String)"MaterialInvInfoPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                resMsg = ResManager.loadKDString((String)"\u5f00\u542f\u6216\u5173\u95ed\u542f\u7528\u6279\u53f7\u7ba1\u7406\u9700\u8981\u5148\u5904\u7406\u5386\u53f2\u5e93\u5b58\uff0c\u5426\u5219\u65e0\u6cd5\u51fa\u5e93\uff0c\u8bf7\u786e\u4fdd\u5386\u53f2\u5e93\u5b58\u4e3a0\u3002\r\n\u5f00\u542f/\u5173\u95ed\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u8bf7\u5148\u4e0e\u8d22\u52a1\u4eba\u5458\u786e\u8ba4\u5bf9\u5b58\u8d27\u6210\u672c\u7684\u5f71\u54cd\u3002\r\n\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MaterialInvInfoPlugin_7", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(title, resMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("enablelot", (IFormPlugin)this));
            }
            return false;
        }
        return true;
    }

    private boolean checkRealInv(DynamicObject data) {
        boolean exist = false;
        DynamicObject material = data.getDynamicObject("material");
        boolean exitsTable = DB.exitsTable((DBRoute)new DBRoute("scm"), (String)"t_im_inv_realbalance");
        if (material == null || !exitsTable) {
            return false;
        }
        long masterId = material.getLong("id");
        String ctrlStrategy = data.getString("ctrlstrategy");
        long createOrgId = data.getDynamicObject("createorg").getLong("id");
        QFilter mQ = new QFilter("material", "=", (Object)masterId);
        QFilter qtyQ = new QFilter("qty", "!=", (Object)0);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"im_inv_realbalance", (String)"material,org", (QFilter[])new QFilter[]{mQ, qtyQ}, null);
        HashSet<Long> invOrgSet = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            invOrgSet.add(next.getLong("org"));
        }
        if (invOrgSet.isEmpty()) {
            return false;
        }
        if ("5".equals(ctrlStrategy)) {
            exist = true;
        } else if ("7".equals(ctrlStrategy) && invOrgSet.contains(createOrgId)) {
            exist = true;
        } else if ("6".equals(ctrlStrategy) || "2".equals(ctrlStrategy) || "1".equals(ctrlStrategy)) {
            Set<Object> haveAuthOrgIdSet = new HashSet(16);
            if ("6".equals(ctrlStrategy)) {
                haveAuthOrgIdSet = this.getAuthOrg(createOrgId);
            } else {
                Map responseMap;
                List useOrgIdList;
                ArrayList<Long> dataIds = new ArrayList<Long>(2);
                Long pkId = data.getLong("id");
                dataIds.add(pkId);
                AssignQueryResponse response = BaseDataServiceHelper.assignQueryByData(dataIds, (String)data.getDataEntityType().getName(), (Long)createOrgId, (String)"bd");
                if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)(useOrgIdList = (List)(responseMap = response.getData()).get(pkId)))) {
                    haveAuthOrgIdSet.addAll(useOrgIdList);
                }
            }
            haveAuthOrgIdSet.add(createOrgId);
            invOrgSet.retainAll(haveAuthOrgIdSet);
            if (!invOrgSet.isEmpty()) {
                exist = true;
            }
        }
        return exist;
    }

    private Set<Long> getAuthOrg(long createOrgId) {
        ArrayList<Long> useorgList = new ArrayList<Long>();
        useorgList.add(createOrgId);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)"bd_materialinventoryinfo");
        Long viewId = ctrlView == null ? Long.valueOf(16L) : DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)ctrlView);
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, useorgList, (boolean)true);
        HashSet<Long> haveAuthOrgIdSet = new HashSet<Long>(allSubordinateOrgs);
        return haveAuthOrgIdSet;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
            if ("enablelot".equals(callBackId)) {
                this.getModel().setValue("enablelot", (Object)((Boolean)this.getModel().getValue("enablelot") == false ? 1 : 0));
            } else if ("enableshelflifemgr".equals(callBackId)) {
                this.getModel().setValue("enableshelflifemgr", (Object)((Boolean)this.getModel().getValue("enableshelflifemgr") == false ? 1 : 0));
            }
        }
        this.getView().updateView("enablelot");
        this.getView().updateView("enableshelflifemgr");
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        Control c = (Control)source;
        String key = c.getKey();
        if ("enableshelflifemgr".equals(key) || "enablelot".equals(key)) {
            IDataModel model = this.getModel();
            Object id = model.getValue("id");
            if (id == null || id.equals(0L)) {
                return;
            }
            DynamicObject data = model.getDataEntity(true);
            boolean flag = this.getRefMsg(data, key, (Boolean)e.getValue());
            if (!flag) {
                e.setCancel(true);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (!pkValue.equals(0L)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"masterid"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dym = this.getModel().getDataEntity();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && dym != null && !kd.bd.sbd.utils.StringUtils.isEmpty((String)dym.getString("status")) && "A".equals(dym.getString("status")) || "unaudit".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && dym != null && !kd.bd.sbd.utils.StringUtils.isEmpty((String)dym.getString("status")) && "A".equals(dym.getString("status")) || "unsubmit".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && dym != null && !kd.bd.sbd.utils.StringUtils.isEmpty((String)dym.getString("status")) && "A".equals(dym.getString("status"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"masterid"});
            this.getView().updateView("masterid");
        }
    }

    static {
        ctrls.put("ismininvalert", "mininvqty");
        ctrls.put("issaftyinvalert", "saftyinvqty");
        ctrls.put("isreorderpointalert", "reorderpointqty");
        ctrls.put("ismaxinvalert", "maxinvqty");
        ctrls.put("enablewarnlead", "warnleadtime");
    }
}

