/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.EventObject;
import kd.bd.sbd.utils.CommonUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;

public class RecConditionFromPlugin
extends AbstractBasePlugIn {
    private static final String SM_DELIVER_NOTICE = "sm_delivernotice";
    private static final String IM_SAL_OUT_BILL = "im_saloutbill";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount("entry");
        for (int index = 0; index < rowCount; ++index) {
            String controlSend;
            Boolean isPre = (Boolean)this.getModel().getValue("ispre", index);
            if (!isPre.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"controlsend"});
            }
            if (SM_DELIVER_NOTICE.equals(controlSend = (String)this.getModel().getValue("controlsend", index)) || IM_SAL_OUT_BILL.equals(controlSend)) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"prepayctrlstrategy"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"prepayctrlstrategy"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block10: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            switch (propName) {
                case "ispre": {
                    this.setControlStepEnable((Boolean)newValue, rowIndex);
                    continue block10;
                }
                case "controlsend": {
                    this.setPrePayCtrlStrategyEnable(String.valueOf(newValue), rowIndex);
                    continue block10;
                }
                case "prepayctrlstrategy": {
                    Object controlSend = this.getModel().getValue("controlsend", rowIndex);
                    if (!CommonUtils.isNull((Object)newValue) || CommonUtils.isNull((Object)controlSend)) continue block10;
                    this.getModel().setValue("prepayctrlstrategy", oldValue, rowIndex);
                    continue block10;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length == 0) {
            return;
        }
        for (RowDataEntity rowData : rowDataEntities) {
            int rowIndex = rowData.getRowIndex();
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"controlsend"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"prepayctrlstrategy"});
        }
    }

    private void setControlStepEnable(Boolean isPre, int rowIndex) {
        if (isPre.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"controlsend"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"controlsend"});
            this.getModel().setValue("controlsend", null, rowIndex);
            this.getModel().setValue("prepayctrlstrategy", null, rowIndex);
        }
    }

    private void setPrePayCtrlStrategyEnable(String controlSend, int rowIndex) {
        String fullPerPaymentLimit = "F";
        if (SM_DELIVER_NOTICE.equals(controlSend) || IM_SAL_OUT_BILL.equals(controlSend)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"prepayctrlstrategy"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"prepayctrlstrategy"});
        }
        if (CommonUtils.isNull((Object)controlSend)) {
            this.getModel().setValue("prepayctrlstrategy", null, rowIndex);
        } else {
            this.getModel().setValue("prepayctrlstrategy", (Object)"F", rowIndex);
        }
    }
}

