/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.basedata.biztypeconf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class BizTypeConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SYSTEM_TYPE = "bd-sbd-formplugin";
    private static final String CONVERTSRCBILL = "convertSrcBill";
    private static final String CLEARSRCBILL = "clearSrcBill";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object srcBill = model.getValue("srcbill");
        if (Objects.isNull(srcBill)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtergridap"});
        } else {
            String srcBillName = ((DynamicObject)srcBill).getString("number");
            this.setDefaultCustomFilter(srcBillName);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Object srcBill = model.getValue("srcbill");
        if (!Objects.isNull(srcBill)) {
            String srcBillName = ((DynamicObject)srcBill).getString("number");
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            this.resetFilterColumns(filterGrid, srcBillName);
            this.setFilter();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizType = (BasedataEdit)this.getControl("biztype");
        if (!Objects.isNull(bizType)) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getProperty().getName()) {
            case "biztype": {
                this.bizTypeFilte(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        String proName = e.getProperty().getName();
        for (ChangeData data : changeDatas = e.getChangeSet()) {
            Object newObject = data.getNewValue();
            Object oldObject = data.getOldValue();
            if (!"srcbill".equals(proName)) continue;
            this.srcBillChange(newObject, oldObject);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        Object obj = args.getSource();
        switch (opKey = ((AbstractOperate)obj).getOperateKey()) {
            case "save": {
                this.setCustomFilter(args);
                break;
            }
            case "submit": {
                this.setCustomFilter(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String backId = event.getCallBackId();
        MessageBoxResult reult = event.getResult();
        switch (backId) {
            case "convertSrcBill": {
                this.dealConvertBill(reult);
                break;
            }
            case "clearSrcBill": {
                this.dealClearBill(reult);
                break;
            }
        }
    }

    private void dealClearBill(MessageBoxResult reult) {
        if (reult.equals((Object)MessageBoxResult.Yes)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.clearFilterGrid(filterGrid);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"filtergridap"});
        }
        if (reult.equals((Object)MessageBoxResult.Cancel)) {
            this.setOldSrcBill();
        }
    }

    private void dealConvertBill(MessageBoxResult reult) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (reult.equals((Object)MessageBoxResult.Yes)) {
            String srcBillName = this.getPageCache().get("srcBillName");
            this.clearFilterGrid(filterGrid);
            this.setDefaultCustomFilter(srcBillName);
            this.getView().updateView("filtergridap");
            this.resetFilterColumns(filterGrid, srcBillName);
        }
        if (reult.equals((Object)MessageBoxResult.Cancel)) {
            this.setOldSrcBill();
        }
    }

    private void setOldSrcBill() {
        String oldBillId = this.getPageCache().get("oldSrcBillId");
        this.getModel().beginInit();
        this.getModel().setValue("srcbill", (Object)oldBillId);
        this.getModel().endInit();
        this.getView().updateView("srcbill");
    }

    private void bizTypeFilte(BeforeF7SelectEvent event) {
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter filter = new QFilter("domain", "=", (Object)"8");
        listShowParameter.getListFilterParameter().setFilter(filter);
    }

    private void setCustomFilter(BeforeDoOperationEventArgs args) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        List filterRows = filterCondition.getFilterRow();
        if (filterRows.isEmpty()) {
            this.getModel().getDataEntity().set("filterstring_tag", null);
        } else {
            for (SimpleFilterRow filterRow : filterRows) {
                String compareType = filterRow.getCompareType();
                if (!CompareTypeEnum.NDAYSBEFORE.getId().equals(compareType)) continue;
                List value = filterRow.getValue();
                String valueStr = "";
                if (!value.isEmpty()) {
                    valueStr = ((FilterValue)value.get(0)).getValue().toString();
                }
                if (!"0".equals(valueStr)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u4e2d\u201cN\u5929\u524d\u201d\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"BizTypeConfigPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String filterString = SerializationUtils.toJsonString((Object)filterCondition);
            this.getModel().getDataEntity().set("filterstring_tag", (Object)filterString);
        }
    }

    private void srcBillChange(Object newObject, Object oldObject) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (!Objects.isNull(newObject)) {
            String srcBillName = ((DynamicObject)newObject).getString("number");
            if (Objects.isNull(oldObject)) {
                this.setDefaultCustomFilter(srcBillName);
                this.getView().updateView("filtergridap");
                this.resetFilterColumns(filterGrid, srcBillName);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"filtergridap"});
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONVERTSRCBILL, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6765\u6e90\u5355\u636e\u5c06\u4f1a\u6e05\u7a7a\u8fc7\u6ee4\u6761\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizTypeConfigPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                this.getPageCache().put("oldSrcBillId", ((DynamicObject)oldObject).getString("id"));
                this.getPageCache().put("srcBillName", srcBillName);
            }
        }
        if (Objects.isNull(newObject) && !Objects.isNull(oldObject)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CLEARSRCBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u6765\u6e90\u5355\u636e\u5c06\u4f1a\u6e05\u7a7a\u8fc7\u6ee4\u6761\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizTypeConfigPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            this.getPageCache().put("oldSrcBillId", ((DynamicObject)oldObject).getString("id"));
        }
    }

    private void clearFilterGrid(FilterGrid filterGrid) {
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        List listFilter = condition.getFilterRow();
        listFilter.clear();
        condition.setFilterRow(listFilter);
        filterGrid.SetValue(condition);
    }

    private void setDefaultCustomFilter(String type) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (null != filterGrid) {
            filterGrid.setEntityNumber(type);
        }
    }

    private void resetFilterColumns(FilterGrid filterGrid, String srcBillName) {
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> resetFilterColumns = new ArrayList<Map>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            String fieldName;
            if (!srcBillName.equals(filterColumn.get("entryEntity")) || (fieldName = (String)filterColumn.get("fieldName")).contains(".") && !fieldName.contains(".name") && !fieldName.contains(".number") || !this.judageStr(fieldName)) continue;
            resetFilterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(resetFilterColumns);
        this.getView().updateView("filtergridap");
        if (resetFilterColumns.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728\u8868\u5934\u5b57\u6bb5\u3002", (String)"BizTypeConfigPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void setFilter() {
        String billfilterstr = (String)this.getModel().getDataEntity().get("filterstring_tag");
        if (StringUtils.isNotEmpty((String)billfilterstr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    private boolean judageStr(String tempStr) {
        char[] chars = tempStr.toCharArray();
        int count = 0;
        for (char ch : chars) {
            if ('.' != ch) continue;
            ++count;
        }
        return count < 2;
    }
}

