/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.pdm.mftbom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.sbd.business.pdm.helper.MaterialHelper;
import kd.bd.sbd.business.pdm.helper.PageCacheHelper;
import kd.bd.sbd.business.pdm.service.MFTBomValidateBusiness;
import kd.bd.sbd.utils.BOMVersionUtil;
import kd.bd.sbd.utils.pdm.mftbom.BOMEntryQtyTypeEnum;
import kd.bd.sbd.utils.pdm.mftbom.BOMEntryTypeEnum;
import kd.bd.sbd.utils.pdm.mftbom.BomVersionQueryHelper;
import kd.bd.sbd.utils.pdm.mftbom.ControlUtil;
import kd.bd.sbd.utils.pdm.mftbom.DynamicObjDataUtil;
import kd.bd.sbd.utils.pdm.mftbom.StatusEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMTplEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String KEY_MASTERID = "masterid";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_BASEUNIT = "baseunit";
    private static final String MPDM_REPLACENO = "mpdm_replaceno";

    public void afterAddRow(AfterAddRowEventArgs event) {
        String epName;
        super.afterAddRow(event);
        if (event == null) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryProp ep = event.getEntryProp();
        String string = epName = ep == null ? "" : ep.getName();
        if (DynamicObjDataUtil.isEmptyString((String)epName)) {
            return;
        }
        Object[] rdes = event.getRowDataEntities();
        if (DynamicObjDataUtil.isEmptyArray((Object[])rdes)) {
            return;
        }
        int rdesSize = rdes.length;
        int qtyEntryRowCount = dm.getEntryRowCount("qtyentry");
        BigDecimal maxQtyEntryBatchEndQty = BigDecimal.ZERO;
        for (int qtyRowIndex = 0; qtyRowIndex < qtyEntryRowCount; ++qtyRowIndex) {
            BigDecimal qtyEntryBatchEndQty;
            if (qtyRowIndex >= qtyEntryRowCount - rdesSize || (qtyEntryBatchEndQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qtyentrybatchendqty", (int)qtyRowIndex, (BigDecimal)BigDecimal.ZERO)).compareTo(maxQtyEntryBatchEndQty) <= 0) continue;
            maxQtyEntryBatchEndQty = qtyEntryBatchEndQty;
        }
        for (int index = 0; index < rdesSize; ++index) {
            Object rde = rdes[index];
            if (rde == null) continue;
            DynamicObject rowDO = rde.getDataEntity();
            int rowIndex = rde.getRowIndex();
            if (rowDO == null || rowIndex < 0 || !epName.equalsIgnoreCase("qtyentry")) continue;
            dm.beginInit();
            rowDO.beginInit();
            BigDecimal newQtyEntryBatchStartQty = maxQtyEntryBatchEndQty.add(BigDecimal.ZERO);
            dm.setValue("qtyentrybatchstartqty", (Object)newQtyEntryBatchStartQty, rowIndex);
            BigDecimal newQtyEntryBatchEndQty = newQtyEntryBatchStartQty.add(BigDecimal.ONE);
            dm.setValue("qtyentrybatchendqty", (Object)newQtyEntryBatchEndQty, rowIndex);
            maxQtyEntryBatchEndQty = newQtyEntryBatchEndQty;
            rowDO.endInit();
            dm.endInit();
            fv.updateView("qtyentrybatchstartqty", rowIndex);
            fv.updateView("qtyentrybatchendqty", rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        int entryRowIndex;
        List evInfoList;
        super.afterDoOperation(event);
        if (event == null) {
            return;
        }
        OperationResult or = event.getOperationResult();
        List list = evInfoList = or == null ? null : or.getAllErrorOrValidateInfo();
        if (!DynamicObjDataUtil.isEmptyList((List)evInfoList)) {
            return;
        }
        String opKey = event.getOperateKey();
        if (DynamicObjDataUtil.isEmptyString((String)opKey)) {
            return;
        }
        Tab entryTab = (Tab)this.getControl("tab_entry");
        String tabPageKey = entryTab == null ? null : entryTab.getCurrentTab();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (("tabpage_qtyentry".equalsIgnoreCase(tabPageKey) || "tabpage_setupentry".equalsIgnoreCase(tabPageKey)) && entryRowIndex >= 0) {
            String pageFlex = null;
            if ("tabpage_qtyentry".equalsIgnoreCase(tabPageKey)) {
                pageFlex = "flex_qtyentry";
            } else if ("tabpage_setupentry".equalsIgnoreCase(tabPageKey)) {
                pageFlex = "flex_setupentry";
            }
            if (opKey.equalsIgnoreCase("nextentry") || opKey.equalsIgnoreCase("preventry")) {
                this.updateChildPage(pageFlex, true);
            }
        }
        if (opKey.equalsIgnoreCase("unsubmit") || opKey.equalsIgnoreCase("unaudit") || opKey.equalsIgnoreCase("replace")) {
            this.loadData();
            if (opKey.equalsIgnoreCase("replace")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"replacenonum"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"createorg", "type", "group", KEY_MATERIAL, "version", "yieldrate", "auxproperty", "iscoproduct"});
                this.getPageCache().put("replace", "1");
            }
        } else if (opKey.equalsIgnoreCase("submit")) {
            this.updateVersionField();
        } else if (opKey.equalsIgnoreCase("save")) {
            this.replaceLockFields();
        } else if (opKey.equalsIgnoreCase("delete")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"createorg", "type", "group", KEY_MATERIAL, "version", "yieldrate", "auxproperty", "iscoproduct"});
            this.getPageCache().remove("replace");
            IFormView pView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (pView != null) {
                pView.getPageCache().remove("replace");
            }
        } else if ("newcopentry".equals(opKey) || "deletecopentry".equals(opKey) || "insertentry_cop".equals(opKey)) {
            this.isCopProduct(this.getModel());
        }
        this.insertMainMaterial(true);
    }

    private void updateVersionField() {
        this.getView().updateView("version");
        this.updateVersionField(this.getModel().getEntryEntity("entry"), "entryversion");
        this.updateVersionField(this.getModel().getEntryEntity("copentry"), "copentryversion");
    }

    private void updateVersionField(DynamicObjectCollection coll, String versionField) {
        if (coll != null && !coll.isEmpty()) {
            IFormView view = this.getView();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                view.updateView(versionField, i);
            }
        }
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        if (event == null) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
        this.setOutputpercentControl();
    }

    public void afterCopyData(EventObject event) {
        super.afterCopyData(event);
    }

    public void afterLoadData(EventObject event) {
        super.afterLoadData(event);
        if (event == null) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject bom = this.getModel().getDataEntity();
        DynamicObjectCollection entryCol = bom.getDynamicObjectCollection("entry");
        if (!this.checkViewNotNull()) {
            return;
        }
        this.loadData();
        this.showConfigCode(this.getModel());
        this.setOutputpercentControl();
        this.insertMainMaterial(true);
        if (this.isPercentBill()) {
            this.setMainProductInfo("copentryversion", this.getModel().getValue("version"));
            this.setMainProductInfo("copentryauxproperty", this.getModel().getValue("auxproperty"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BigDecimal headoutputpercent;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)operate.getOperateKey(), (CharSequence)"replace")) {
            String userOrg = (String)this.getView().getFormShowParameter().getCustomParam("useorgId");
            Long useOrgId = userOrg == null ? 0L : Long.parseLong(userOrg);
            if (useOrgId <= 0L) {
                DynamicObject useOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"useorg");
                useOrgId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)useOrg);
            }
            if (useOrgId <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BOMTplEdit_27", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object createOrg = this.getModel().getValue("createorg");
            Long createOrgId = 0L;
            if (createOrg instanceof DynamicObject) {
                createOrgId = Long.parseLong(((DynamicObject)createOrg).getPkValue().toString());
            } else if (createOrg instanceof Long) {
                createOrgId = (Long)createOrg;
            }
            Map map = PageCacheHelper.getParentPageCache((IFormView)this.getView());
            String useOrgListId = "";
            if (map != null) {
                useOrgListId = map.getOrDefault("createOrg", "");
            }
            if (!createOrgId.equals(useOrgId) || !StringUtils.equals((CharSequence)useOrgListId, (CharSequence)createOrgId.toString())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u662f\u5f53\u524d\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884cBOM\u66ff\u4ee3\u3002", (String)"BOMTplEdit_47", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("save".equals(operate.getOperateKey()) || "submit".equals(operate.getOperateKey())) {
            this.isCopProduct(this.getModel());
        } else if (this.isPercentBill() && ("deletecopentry".equalsIgnoreCase(operate.getOperateKey()) || "insertentry_cop".equalsIgnoreCase(operate.getOperateKey()))) {
            int[] selectRows;
            EntryGrid entryGrid = (EntryGrid)this.getControl("copentry");
            for (int index : selectRows = entryGrid.getSelectRows()) {
                String bomtype = (String)this.getModel().getValue("copentrytype", index);
                if (!"10740".equals(bomtype)) continue;
                if ("deletecopentry".equals(operate.getOperateKey())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4ea7\u54c1\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BOMTplEdit_88", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4ea7\u54c1\u524d\u4e0d\u5141\u8bb8\u63d2\u5165\u884c\u3002", (String)"BOMTplEdit_89", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
            }
        }
        if (this.isPercentBill() && ("save".equalsIgnoreCase(operate.getOperateKey()) || "audit".equalsIgnoreCase(operate.getOperateKey()) || "submit".equalsIgnoreCase(operate.getOperateKey())) && (headoutputpercent = (BigDecimal)this.getModel().getValue("headoutputpercent")).compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4ea7\u54c1\u4ea7\u51fa\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BOMTplEdit_87", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void updateOutputpercent() {
        BigDecimal entryvalue = (BigDecimal)this.getModel().getValue("outputpercent", 0);
        if (entryvalue != null) {
            this.getModel().setValue("headoutputpercent", (Object)entryvalue);
        }
    }

    private boolean isPercentBill() {
        try {
            DynamicObject type = (DynamicObject)this.getModel().getValue("type");
            if (type != null && type.getBoolean("ispercent")) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private void insertMainMaterial(boolean isView) {
        if (this.isPercentBill()) {
            this.getView().updateView("copentry");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject matobj = dataEntity.getDynamicObject(KEY_MATERIAL);
            DynamicObjectCollection copentryentry = dataEntity.getDynamicObjectCollection("copentry");
            if (copentryentry != null && copentryentry.size() > 0) {
                DynamicObject copentryitem = (DynamicObject)copentryentry.get(0);
                if (copentryitem != null && !"10740".equals(copentryitem.getString("copentrytype"))) {
                    this.getModel().insertEntryRow("copentry", 0);
                }
            } else {
                this.getModel().insertEntryRow("copentry", 0);
            }
            DynamicObject typeObj = this.getModel().getValue("type") == null ? null : (DynamicObject)this.getModel().getValue("type");
            DynamicObject createOrgObj = this.getModel().getValue("createorg") == null ? null : (DynamicObject)this.getModel().getValue("createorg");
            copentryentry = dataEntity.getDynamicObjectCollection("copentry");
            for (int index = 0; index < copentryentry.size(); ++index) {
                DynamicObject copEntryMaterialDO;
                DynamicObject copEntryDO = (DynamicObject)copentryentry.get(index);
                if (copEntryDO == null || (copEntryMaterialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copEntryDO, (String)"copentrymaterial")) == null) continue;
                boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)copEntryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
                this.setAuxpEnble(this.getView(), this.getModel(), isAuxpEnable, index, "copentryauxproperty");
                boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)copEntryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
                this.setAuxpMustInput(this.getView(), this.getModel(), isAuxpMustInput, index, "copentryauxproperty", false);
            }
            if (matobj != null) {
                LocalDate localDate = LocalDate.of(2000, 1, 1);
                Date dates = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                localDate = LocalDate.of(2999, 12, 31);
                Date datee = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                this.getModel().setValue("copentrytype", (Object)"10740", 0);
                this.getModel().setValue("copentrymaterial", (Object)matobj, 0);
                if (isView) {
                    this.getModel().setValue("outputpercent", (Object)dataEntity.getBigDecimal("headoutputpercent"), 0);
                } else {
                    this.getModel().setValue("outputpercent", (Object)BigDecimal.valueOf(100L), 0);
                }
                this.getModel().setValue("copentryvaliddate", (Object)dates, 0);
                this.getModel().setValue("copentryinvaliddate", (Object)datee, 0);
                this.setMainProductInfo("copentryversion", this.getModel().getValue("version"));
                this.setMainProductInfo("copentryauxproperty", this.getModel().getValue("auxproperty"));
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentrytype"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentrymaterial"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryprocessseq"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryoperationnum"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryversion"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryremark"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryoperation"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryauxproperty"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryvaliddate"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"copentryinvaliddate"});
                if (isView) {
                    this.getModel().setDataChanged(false);
                }
            }
        }
    }

    private void setOutputpercentControl() {
        if (this.isPercentBill()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"outputpercent"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copentryqty"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copentryecnno"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"outputpercent"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"copentryqty"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"copentryecnno"});
        }
    }

    private void loadData() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        DynamicObject typeObj = dm.getValue("type") == null ? null : (DynamicObject)dm.getValue("type");
        DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
        boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)((DynamicObject)dm.getValue(KEY_MATERIAL)), (DynamicObject)typeObj, (DynamicObject)createOrgObj);
        this.setAuxpEnble(fv, dm, isAuxpEnable, -1, "auxproperty");
        boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)((DynamicObject)dm.getValue(KEY_MATERIAL)), (DynamicObject)typeObj, (DynamicObject)createOrgObj);
        this.setAuxpMustInput(fv, dm, isAuxpMustInput, -1, "auxproperty", false);
        String status = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"status", (String)StatusEnum.SAVED.value);
        if (status.equals(StatusEnum.SUBMITED.value) || status.equals(StatusEnum.AUDITED.value)) {
            fv.setVisible(Boolean.FALSE, new String[]{"acptbi_entry_new", "acptbi_entry_delete", "acptbi_copentry_new", "acptbi_copentry_insert", "acptbi_copentry_delete"});
        } else {
            fv.setVisible(Boolean.TRUE, new String[]{"acptbi_entry_new", "acptbi_entry_delete", "acptbi_copentry_new", "acptbi_copentry_insert", "acptbi_copentry_delete"});
            this.replaceLockFields();
        }
        this.setBOMVersionMustInput(DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)KEY_MATERIAL), DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"type"));
        this.isCopProduct(dm);
        TabSelectEvent tseEntry = new TabSelectEvent((Object)this.getControl("tab_entry"), "tabpage_entry");
        this.tabSelected(tseEntry);
        DynamicObjectCollection copEntryDOC = dm.getEntryEntity("copentry");
        int copEntryDOCSize = DynamicObjDataUtil.isEmptyList((List)copEntryDOC) ? 0 : copEntryDOC.size();
        for (int index = 0; index < copEntryDOCSize && !this.isPercentBill(); ++index) {
            DynamicObject copEntryDO = (DynamicObject)copEntryDOC.get(index);
            if (copEntryDO == null) continue;
            DynamicObject copEntryMaterialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copEntryDO, (String)"copentrymaterial");
            isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)copEntryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpEnble(fv, dm, isAuxpEnable, index, "copentryauxproperty");
            isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)copEntryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpMustInput(fv, dm, isAuxpMustInput, index, "copentryauxproperty", false);
        }
        DynamicObjectCollection entryDOC = dm.getEntryEntity("entry");
        int entryDOCSize = DynamicObjDataUtil.isEmptyList((List)entryDOC) ? 0 : entryDOC.size();
        for (int index = 0; index < entryDOCSize; ++index) {
            DynamicObjectCollection setupEntryCol;
            DynamicObject entryDO = (DynamicObject)entryDOC.get(index);
            if (entryDO == null) continue;
            DynamicObject entryMaterialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entrymaterial");
            isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)entryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpEnble(fv, dm, isAuxpEnable, index, "entryauxproperty");
            isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)entryMaterialDO, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpMustInput(fv, dm, isAuxpMustInput, index, "entryauxproperty", false);
            DynamicObjectCollection qtyEntryCol = entryDO.getDynamicObjectCollection("qtyentry");
            if (qtyEntryCol != null) {
                for (int i = 0; i < qtyEntryCol.size(); ++i) {
                    String property;
                    IDataEntityType type;
                    DynamicObject qtyEntry = (DynamicObject)qtyEntryCol.get(i);
                    if (qtyEntry != null && (type = qtyEntry.getDataEntityType()) != null && StringUtils.isNotBlank((CharSequence)(property = type.getProperties().toString())) && !property.contains("qtyentrykey")) continue;
                }
            }
            if ((setupEntryCol = entryDO.getDynamicObjectCollection("setupentry")) == null) continue;
            for (int i = 0; i < setupEntryCol.size(); ++i) {
                IDataEntityType type;
                DynamicObject setupEntry = (DynamicObject)setupEntryCol.get(i);
                if (setupEntry != null && (type = setupEntry.getDataEntityType()) != null) continue;
            }
        }
    }

    private void replaceLockFields() {
        IFormView fv = this.getView();
        Map map = PageCacheHelper.getParentPageCache((IFormView)fv);
        String replaceStr = "0";
        if (map != null) {
            replaceStr = map.getOrDefault("replace", "0");
        }
        String localKey = this.getPageCache().get("replace");
        if ("1".equalsIgnoreCase(replaceStr) || StringUtils.equalsIgnoreCase((CharSequence)localKey, (CharSequence)"1")) {
            fv.setEnable(Boolean.TRUE, new String[]{"replacenonum"});
            fv.setEnable(Boolean.FALSE, new String[]{"createorg", "type", "group", KEY_MATERIAL, "version", "yieldrate", "auxproperty", "iscoproduct"});
            BasedataEdit createorgEdit = (BasedataEdit)this.getControl("createorg");
            if (createorgEdit != null) {
                createorgEdit.setEnable("createorg", Boolean.FALSE.booleanValue(), 0);
            }
        }
    }

    private void isCopProduct(IDataModel dm) {
        String bomid;
        boolean isProduct = false;
        DynamicObjectCollection copEntryCol = dm.getEntryEntity("copentry");
        if (!copEntryCol.isEmpty()) {
            for (int i = 0; i < copEntryCol.size(); ++i) {
                DynamicObject copEntryObj = (DynamicObject)copEntryCol.get(i);
                DynamicObject copEntryMaterial = copEntryObj.getDynamicObject("copentrymaterial");
                String protype = copEntryObj.getString("copentrytype");
                if (copEntryMaterial == null || "10740".equals(protype)) continue;
                isProduct = true;
                break;
            }
        }
        if (!isProduct && this.isEcoBom() && (bomid = (String)dm.getValue("bomid")) != null && !"".equals(bomid)) {
            isProduct = this.isBomProductJoin(bomid);
        }
        dm.setValue("iscoproduct", (Object)isProduct);
    }

    private boolean isEcoBom() {
        return "pdm_ecobom".equalsIgnoreCase(this.getModel().getDataEntityType().getName());
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (DynamicObjDataUtil.isEmptyString((String)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) continue;
            this.propertyChanged(propertyName, changeData);
        }
        if (this.isPercentBill()) {
            int rowIndex;
            if (KEY_MATERIAL.equalsIgnoreCase(propertyName)) {
                this.insertMainMaterial(false);
            } else if ("version".equalsIgnoreCase(propertyName)) {
                this.setMainProductInfo("copentryversion", this.getModel().getValue("version"));
            } else if ("auxproperty".equalsIgnoreCase(propertyName)) {
                this.setMainProductInfo("copentryauxproperty", this.getModel().getValue("auxproperty"));
            } else if ("type".equalsIgnoreCase(propertyName)) {
                this.setOutputpercentControl();
                this.insertMainMaterial(false);
            } else if ("outputpercent".equalsIgnoreCase(propertyName) && changeDatas != null && changeDatas.length > 0 && (rowIndex = changeDatas[0].getRowIndex()) == 0) {
                this.updateOutputpercent();
            }
        }
    }

    private void setMainProductInfo(String propkey, Object propvalue) {
        String copentrytype = (String)this.getModel().getValue("copentrytype", 0);
        if ("10740".equals(copentrytype)) {
            this.getModel().setValue(propkey, propvalue, 0);
        }
    }

    private void proMaterialChanged(IFormView fv, IDataModel dm, Long propertyOldValuePK, Long propertyValuePK, DynamicObject propertyValueDO) {
        DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
        boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)propertyValueDO, (DynamicObject)((DynamicObject)dm.getValue("type")), (DynamicObject)createOrgObj);
        this.setAuxpEnble(fv, dm, isAuxpEnable, -1, "auxproperty");
        boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)propertyValueDO, (DynamicObject)((DynamicObject)dm.getValue("type")), (DynamicObject)createOrgObj);
        this.setAuxpMustInput(fv, dm, isAuxpMustInput, -1, "auxproperty", true);
        boolean isVersion = this.setBOMVersionMustInput(propertyValueDO, DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"type"));
        if (propertyValuePK <= 0L || !isVersion) {
            dm.setValue("version", null);
        } else {
            Object masterid = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)propertyValueDO, (String)KEY_MASTERID);
            DynamicObject initVersion = null;
            if (masterid instanceof DynamicObject) {
                initVersion = BOMVersionUtil.createAndGetBomVersion((DynamicObject)dm.getDataEntity(true), (boolean)false, null);
            }
            dm.beginInit();
            dm.setValue("version", initVersion == null ? Long.valueOf(0L) : initVersion.get("id"));
            dm.endInit();
            fv.updateView("version");
        }
    }

    private void copMaterialChanged(IFormView fv, IDataModel dm, Integer rowIndex, Long propertyOldValuePK, Long propertyValuePK, DynamicObject propertyValueDO) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObject materialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)propertyValueDO, (String)KEY_MASTERID);
        DynamicObject mftUnitDO = materialDO == null ? DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)propertyValueDO, (String)KEY_BASEUNIT) : DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)materialDO, (String)KEY_BASEUNIT);
        String mftUnitIDStr = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)mftUnitDO, (String)"id");
        Long mftUnitID = DynamicObjDataUtil.isEmptyString((String)mftUnitIDStr) ? 0L : Long.parseLong(mftUnitIDStr);
        dm.setValue("copentryunit", (Object)mftUnitID, rowIndex.intValue());
        Object typeObj = dm.getValue("type");
        DynamicObject type = typeObj == null ? null : (DynamicObject)typeObj;
        DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
        boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)propertyValueDO, (DynamicObject)type, (DynamicObject)createOrgObj);
        this.setAuxpEnble(fv, dm, isAuxpEnable, rowIndex, "copentryauxproperty");
        boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)propertyValueDO, (DynamicObject)type, (DynamicObject)createOrgObj);
        this.setAuxpMustInput(fv, dm, isAuxpMustInput, rowIndex, "copentryauxproperty", true);
        if (!propertyValuePK.equals(propertyOldValuePK)) {
            dm.setValue("copentryversion", null, rowIndex.intValue());
        }
    }

    private void copDataChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, Date propertyValueDate, EntryGrid copEntryGrid, DynamicObject propertyValueCDDE, Object propertyOldValueObj) {
        Date copEntryInvalidDate;
        Date copEntryValidDate = propertyName.equalsIgnoreCase("copentryvaliddate") ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)"copentryvaliddate", (int)rowIndex);
        Date date = copEntryInvalidDate = propertyName.equalsIgnoreCase("copentryinvaliddate") ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)"copentryinvaliddate", (int)rowIndex);
        if (copEntryValidDate == null) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\u201c\u751f\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMTplEdit_49", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            copEntryGrid.focusCell(rowIndex.intValue(), propertyName);
            if (propertyOldValueObj != null) {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"copentryvaliddate", (Object)propertyOldValueObj, (int)rowIndex);
            } else {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"copentryvaliddate", (Object)new Date(), (int)rowIndex);
            }
            return;
        }
        if (copEntryInvalidDate == null) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMTplEdit_50", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            copEntryGrid.focusCell(rowIndex.intValue(), propertyName);
            if (propertyOldValueObj != null) {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"copentryinvaliddate", (Object)propertyOldValueObj, (int)rowIndex);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"copentryinvaliddate", (Object)simpleDateFormat.parse("2029-01-01"), (int)rowIndex);
                }
                catch (ParseException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("dateParseException", ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"BOMTplEdit_48", (String)"bd-mpdm-formplugin", (Object[])new Object[0])), new Object[]{""});
                }
            }
            return;
        }
        if (copEntryValidDate.after(copEntryInvalidDate)) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"BOMTplEdit_51", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            copEntryGrid.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
        }
    }

    private void entryMaterialChanged(IFormView fv, IDataModel dm, Integer rowIndex, Long propertyOldValuePK, Long propertyValuePK, DynamicObject propertyValueDO) {
        Long entryMasterId;
        DynamicObject mater;
        Long vMaterId;
        DynamicObject entryversion;
        if (rowIndex < 0) {
            return;
        }
        if (propertyValueDO == null) {
            return;
        }
        DynamicObject entryMFTInfoMasterDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)propertyValueDO, (String)KEY_MASTERID);
        DynamicObject mftUnitDO = entryMFTInfoMasterDO == null ? DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)propertyValueDO, (String)KEY_BASEUNIT) : DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryMFTInfoMasterDO, (String)KEY_BASEUNIT);
        String mftUnitIDStr = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)mftUnitDO, (String)"id");
        Long mftUnitID = DynamicObjDataUtil.isEmptyString((String)mftUnitIDStr) ? 0L : Long.parseLong(mftUnitIDStr);
        String entryTypeObject = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"entrytype", (int)rowIndex);
        String entryType = entryTypeObject == null ? null : entryTypeObject.toString();
        Object typeObj = dm.getValue("type");
        DynamicObject type = typeObj == null ? null : (DynamicObject)typeObj;
        DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
        boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)propertyValueDO, (DynamicObject)type, (DynamicObject)createOrgObj);
        this.setAuxpEnble(fv, dm, isAuxpEnable, rowIndex, "entryauxproperty");
        boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)propertyValueDO, (DynamicObject)type, (DynamicObject)createOrgObj);
        this.setAuxpMustInput(fv, dm, isAuxpMustInput, rowIndex, "entryauxproperty", true);
        if (BOMEntryTypeEnum.STORAGE.value.equalsIgnoreCase(entryType)) {
            dm.setValue("entryunit", (Object)(mftUnitID > 0L ? mftUnitID : null), rowIndex.intValue());
        }
        if (!propertyValuePK.equals(propertyOldValuePK) && (entryversion = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entryversion", (int)rowIndex)) != null && !(vMaterId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)(mater = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)(entryversion = BomVersionQueryHelper.getDataCacheByID((Object)entryversion.getPkValue())), (String)KEY_MATERIAL)))).equals(entryMasterId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)entryMFTInfoMasterDO))) {
            dm.setValue("entryversion", null, rowIndex.intValue());
        }
    }

    private void entryDataChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, Date propertyValueDate, EntryGrid entryGrid, DynamicObject propertyValueCDDE, Object propertyOldValueObj) {
        Date entryInvalidDate;
        Date entryValidDate = propertyName.equalsIgnoreCase("entryvaliddate") ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)"entryvaliddate", (int)rowIndex);
        Date date = entryInvalidDate = propertyName.equalsIgnoreCase("entryinvaliddate") ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)"entryinvaliddate", (int)rowIndex);
        if (entryValidDate == null) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\u201c\u751f\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMTplEdit_52", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            entryGrid.focusCell(rowIndex.intValue(), propertyName);
            if (propertyOldValueObj != null) {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"entryvaliddate", (Object)propertyOldValueObj, (int)rowIndex);
            } else {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"entryvaliddate", (Object)new Date(), (int)rowIndex);
            }
            return;
        }
        if (entryInvalidDate == null) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMTplEdit_53", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            entryGrid.focusCell(rowIndex.intValue(), propertyName);
            if (propertyOldValueObj != null) {
                ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"entryinvaliddate", (Object)propertyOldValueObj, (int)rowIndex);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)"entryinvaliddate", (Object)simpleDateFormat.parse("2029-01-01"), (int)rowIndex);
                }
                catch (ParseException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("dateParseException", ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"BOMTplEdit_48", (String)"bd-mpdm-formplugin", (Object[])new Object[0])), new Object[]{""});
                }
            }
            return;
        }
        if (entryValidDate.after(entryInvalidDate)) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"BOMTplEdit_54", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            entryGrid.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
        }
    }

    private void qtyTypeChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyValueStr) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObject entry = dm.getEntryRowEntity("entry", rowIndex.intValue());
        if (entry == null) {
            return;
        }
        DynamicObjectCollection setupEntryCol = entry.getDynamicObjectCollection("setupentry");
        if (setupEntryCol == null) {
            return;
        }
        DynamicObjectCollection qtyEntryCol = entry.getDynamicObjectCollection("qtyentry");
        if (qtyEntryCol == null) {
            return;
        }
        if (BOMEntryQtyTypeEnum.STEP.value.equalsIgnoreCase(propertyValueStr)) {
            setupEntryCol.clear();
            fv.updateView("setupentry");
        } else {
            qtyEntryCol.clear();
            fv.updateView("qtyentry");
        }
    }

    private void entryQtyChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, BigDecimal propertyValueBigDecimal) {
        BigDecimal entryQtyDenominator;
        if (rowIndex < 0) {
            return;
        }
        BigDecimal entryQtyNumerator = propertyName.equalsIgnoreCase("entryqtynumerator") ? propertyValueBigDecimal : DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqtynumerator", (int)rowIndex, (BigDecimal)BigDecimal.ZERO);
        BigDecimal bigDecimal = entryQtyDenominator = propertyName.equalsIgnoreCase("entryqtydenominator") ? propertyValueBigDecimal : DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqtydenominator", (int)rowIndex, (BigDecimal)BigDecimal.ZERO);
        if (entryQtyNumerator != null && entryQtyDenominator != null && BigDecimal.ZERO.compareTo(entryQtyNumerator) < 0 && BigDecimal.ZERO.compareTo(entryQtyDenominator) < 0) {
            BigDecimal entryQty = entryQtyNumerator.divide(entryQtyDenominator, RoundingMode.UP);
            dm.setValue("entryqty", (Object)entryQty, rowIndex.intValue());
        } else {
            dm.setValue("entryqty", (Object)BigDecimal.ZERO, rowIndex.intValue());
        }
    }

    private void batchQtyChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, BigDecimal propertyValueBigDecimal, EntryGrid qtyEntryEG, DynamicObject propertyValueCDDE, Object propertyOldValueObj) {
        BigDecimal qtyEntryBatchEndQty;
        BigDecimal qtyEntryBatchStartQty = propertyName.equalsIgnoreCase("qtyentrybatchstartqty") ? propertyValueBigDecimal : DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qtyentrybatchstartqty", (BigDecimal)BigDecimal.ZERO);
        BigDecimal bigDecimal = qtyEntryBatchEndQty = propertyName.equalsIgnoreCase("qtyentrybatchendqty") ? propertyValueBigDecimal : DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qtyentrybatchendqty", (BigDecimal)BigDecimal.ZERO);
        if (qtyEntryBatchStartQty == null || BigDecimal.ZERO.compareTo(qtyEntryBatchStartQty) > 0) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u6279\u91cf\u5f00\u59cb\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"BOMTplEdit_55", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            qtyEntryEG.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
            return;
        }
        if (qtyEntryBatchEndQty == null || BigDecimal.ZERO.compareTo(qtyEntryBatchEndQty) >= 0) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u6279\u91cf\u622a\u6b62\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BOMTplEdit_56", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            qtyEntryEG.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
            return;
        }
        if (qtyEntryBatchStartQty.compareTo(qtyEntryBatchEndQty) >= 0) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u6279\u91cf\u622a\u6b62\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6279\u91cf\u5f00\u59cb\u201d\u3002", (String)"BOMTplEdit_57", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            qtyEntryEG.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
            return;
        }
        int qtyEntryRowCount = dm.getEntryRowCount("qtyentry");
        for (int index = 0; index < qtyEntryRowCount; ++index) {
            if (index == rowIndex) continue;
            BigDecimal tmpBatchStartQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qtyentrybatchstartqty", (int)index, (BigDecimal)BigDecimal.ZERO);
            BigDecimal tmpBatchEndQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qtyentrybatchendqty", (int)index, (BigDecimal)BigDecimal.ZERO);
            if (tmpBatchStartQty == null || tmpBatchEndQty == null || qtyEntryBatchStartQty.compareTo(tmpBatchEndQty) >= 0 || qtyEntryBatchEndQty.compareTo(tmpBatchStartQty) <= 0) continue;
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u6279\u91cf\u5f00\u59cb\u201d\u548c\u201c\u6279\u91cf\u622a\u6b62\u201d\u4e0e\u7b2c%2$s\u884c\u91cd\u53e0\u3002", (String)"BOMTplEdit_58", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1, index + 1));
            qtyEntryEG.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
            return;
        }
    }

    private void setupChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, Object propertyValueObj, Object propertyOldValueObj, EntryGrid setupEntryEG, DynamicObject propertyValueCDDE) {
        String curLocaleValue;
        if (rowIndex < 0) {
            return;
        }
        LocaleString olvLS = DynamicObjDataUtil.OrmLocaleValueToLocaleString((Object)propertyValueObj);
        LocaleString ldocLS = DynamicObjDataUtil.LocaleDynamicObjectCollectionToLocaleString((Object)propertyValueObj, (String)propertyName);
        LocaleString ls = olvLS == null ? (ldocLS == null ? new LocaleString() : (ldocLS.size() == 0 ? new LocaleString() : ldocLS)) : (olvLS.size() == 0 ? new LocaleString() : olvLS);
        String string = curLocaleValue = ls.size() == 0 ? null : ls.getLocaleValue();
        if (DynamicObjDataUtil.isEmptyString((String)curLocaleValue)) {
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u5b89\u88c5\u4f4d\u7f6e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMTplEdit_59", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
            setupEntryEG.focusCell(rowIndex.intValue(), propertyName);
            dm.beginInit();
            if (propertyValueCDDE != null) {
                propertyValueCDDE.beginInit();
                LocaleString oldcLS = DynamicObjDataUtil.LocaleDynamicObjectCollectionToLocaleString((Object)propertyOldValueObj, (String)propertyName);
                propertyValueCDDE.set(propertyName, (Object)oldcLS);
                propertyValueCDDE.endInit();
            }
            dm.endInit();
            fv.updateView(propertyName, rowIndex.intValue());
        }
    }

    private void setUpQtyChanged(IFormView fv, IDataModel dm, Integer rowIndex, String propertyName, Object propertyOldValueObj, BigDecimal propertyValueBigDecimal, EntryGrid setupEntryEG, DynamicObject propertyValueCDDE) {
        if (rowIndex < 0) {
            return;
        }
        BigDecimal entryQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqty_set", (BigDecimal)BigDecimal.ZERO);
        int setupEntryRowCount = dm.getEntryRowCount("setupentry");
        BigDecimal setupEntryQtySum = BigDecimal.ZERO;
        for (int index = 0; index < setupEntryRowCount; ++index) {
            if (index == rowIndex) {
                setupEntryQtySum = setupEntryQtySum.add(propertyValueBigDecimal == null || BigDecimal.ZERO.compareTo(propertyValueBigDecimal) >= 0 ? BigDecimal.ZERO : propertyValueBigDecimal);
                continue;
            }
            BigDecimal tmpSetupEntryQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"setupentryqty", (int)index, (BigDecimal)BigDecimal.ZERO);
            setupEntryQtySum = setupEntryQtySum.add(tmpSetupEntryQty);
        }
        if (entryQty.compareTo(setupEntryQtySum) < 0) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u201c\u7ec4\u4ef6\u6570\u91cf\u201d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u201c\u603b\u6570\u91cf\u201d\u3002", (String)"BOMTplEdit_42", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            setupEntryEG.focusCell(rowIndex.intValue(), propertyName);
            ControlUtil.setOldValue((IFormView)fv, (IDataModel)dm, (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)propertyOldValueObj, (int)rowIndex);
        }
    }

    protected void propertyChanged(String propertyName, Object propertyValue) {
        if (DynamicObjDataUtil.isEmptyString((String)propertyName)) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        ChangeData propertyValueCD = propertyValue instanceof ChangeData ? (ChangeData)propertyValue : null;
        int rowIndex = propertyValueCD != null ? propertyValueCD.getRowIndex() : -1;
        DynamicObject propertyValueCDDE = propertyValueCD == null ? null : propertyValueCD.getDataEntity();
        Object propertyOldValueObj = propertyValueCD == null ? null : propertyValueCD.getOldValue();
        DynamicObject propertyOldValueDO = propertyOldValueObj instanceof DynamicObject ? (DynamicObject)propertyOldValueObj : null;
        Object propertyOldValuePKObj = propertyOldValueDO == null ? null : propertyOldValueDO.getPkValue();
        Long propertyOldValuePK = 0L;
        if (propertyOldValuePKObj == null) {
            propertyOldValuePK = -1L;
        } else if (Pattern.matches("^[0-9]*$", propertyOldValuePKObj.toString())) {
            propertyOldValuePK = Long.parseLong(propertyOldValuePKObj.toString());
        }
        Object propertyValueObj = propertyValueCD == null ? propertyValue : propertyValueCD.getNewValue();
        Boolean propertyValueBoolean = propertyValueObj instanceof Boolean ? (Boolean)propertyValueObj : Boolean.FALSE;
        BigDecimal propertyValueBigDecimal = propertyValueObj instanceof BigDecimal ? (BigDecimal)propertyValueObj : BigDecimal.ZERO;
        DynamicObject propertyValueDO = propertyValueObj instanceof DynamicObject ? (DynamicObject)propertyValueObj : null;
        Object propertyValuePKObj = propertyValueDO == null ? null : propertyValueDO.getPkValue();
        Long propertyValuePK = 0L;
        if (propertyValuePKObj == null) {
            propertyValuePK = -1L;
        } else if (Pattern.matches("^[0-9]*$", propertyValuePKObj.toString())) {
            propertyValuePK = Long.parseLong(propertyValuePKObj.toString());
        }
        String propertyValueStr = propertyValueObj == null ? null : propertyValueObj.toString();
        Date propertyValueDate = propertyValueObj instanceof Date ? (Date)propertyValueObj : null;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        EntryGrid copEntryGrid = (EntryGrid)this.getControl("copentry");
        SubEntryGrid qtyEntryEG = (SubEntryGrid)this.getControl("qtyentry");
        SubEntryGrid setupEntryEG = (SubEntryGrid)this.getControl("setupentry");
        if (propertyName.equalsIgnoreCase(KEY_MATERIAL)) {
            this.proMaterialChanged(fv, dm, propertyOldValuePK, propertyValuePK, propertyValueDO);
            dm.setValue("configuredcode", null);
        } else if (propertyName.equalsIgnoreCase("type")) {
            DynamicObject product = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)KEY_MATERIAL);
            DynamicObject typeObj = dm.getValue("type") == null ? null : (DynamicObject)dm.getValue("type");
            DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
            boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)product, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpEnble(fv, dm, isAuxpEnable, -1, "auxproperty");
            boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)product, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpMustInput(fv, dm, isAuxpMustInput, -1, "auxproperty", true);
            this.setEntryColAuxpMustImput(fv, dm, "copentry", typeObj, "copentrymaterial", "copentryauxproperty");
            this.setEntryColAuxpMustImput(fv, dm, "entry", typeObj, "entrymaterial", "entryauxproperty");
            this.setBOMVersionMustInput(product, propertyValueDO);
            this.showConfigCode(dm);
            this.clearReplaceNoInfo();
        } else if (propertyName.equalsIgnoreCase("copentrymaterial")) {
            this.copMaterialChanged(fv, dm, rowIndex, propertyOldValuePK, propertyValuePK, propertyValueDO);
            this.isCopProduct(dm);
        } else if (propertyName.equalsIgnoreCase("copentryvaliddate") || propertyName.equalsIgnoreCase("copentryinvaliddate")) {
            this.copDataChanged(fv, dm, rowIndex, propertyName, propertyValueDate, copEntryGrid, propertyValueCDDE, propertyOldValueObj);
        } else if (propertyName.equalsIgnoreCase("entrymaterial")) {
            this.entryMaterialChanged(fv, dm, rowIndex, propertyOldValuePK, propertyValuePK, propertyValueDO);
            dm.setValue("entryconfiguredcode", null, rowIndex);
        } else if (propertyName.equalsIgnoreCase("entryvaliddate") || propertyName.equalsIgnoreCase("entryinvaliddate")) {
            this.entryDataChanged(fv, dm, rowIndex, propertyName, propertyValueDate, entryGrid, propertyValueCDDE, propertyOldValueObj);
        } else if (propertyName.equalsIgnoreCase("entryqtytype")) {
            this.qtyTypeChanged(fv, dm, rowIndex, propertyValueStr);
        } else if (propertyName.equalsIgnoreCase("entryqtynumerator") || propertyName.equalsIgnoreCase("entryqtydenominator")) {
            this.entryQtyChanged(fv, dm, rowIndex, propertyName, propertyValueBigDecimal);
        } else if (propertyName.equalsIgnoreCase("qtyentrybatchstartqty") || propertyName.equalsIgnoreCase("qtyentrybatchendqty")) {
            this.batchQtyChanged(fv, dm, rowIndex, propertyName, propertyValueBigDecimal, (EntryGrid)qtyEntryEG, propertyValueCDDE, propertyOldValueObj);
        } else if (propertyName.equalsIgnoreCase("setupentrysetuplocation")) {
            this.setupChanged(fv, dm, rowIndex, propertyName, propertyValueObj, propertyOldValueObj, (EntryGrid)setupEntryEG, propertyValueCDDE);
        } else if (propertyName.equalsIgnoreCase("setupentryqty")) {
            this.setUpQtyChanged(fv, dm, rowIndex, propertyName, propertyOldValueObj, propertyValueBigDecimal, (EntryGrid)setupEntryEG, propertyValueCDDE);
        } else if ("replacenonum".equals(propertyName)) {
            if (StringUtils.isBlank((Object)propertyValueObj)) {
                this.clearReplaceNoInfo();
            }
        } else if ("replaceno".equals(propertyName)) {
            if (propertyValueObj == null) {
                this.clearReplaceNoInfo();
            } else {
                this.setReplaceNewData(propertyValueObj);
            }
        }
    }

    private void setReplaceNewData(Object propertyValueObj) {
        DynamicObject replaceNo;
        IDataModel model = this.getModel();
        if (model.getProperty("newreplaceno") == null) {
            return;
        }
        DynamicObject dynamicObject = replaceNo = propertyValueObj instanceof DynamicObject ? (DynamicObject)propertyValueObj : null;
        if (replaceNo == null) {
            return;
        }
        IFormView view = this.getView();
        Long replacePk = replaceNo.getLong("id");
        String replaceNumber = replaceNo.getString("number");
        String replaceName = replaceNo.getString("name");
        model.beginInit();
        model.setValue("replaceentity", (Object)MPDM_REPLACENO);
        model.setValue("newreplaceno", (Object)replacePk);
        model.setValue("replacenonum", (Object)replaceNumber);
        model.setValue("replacenoname", (Object)replaceName);
        model.endInit();
        view.updateView("replaceentity");
        view.updateView("newreplaceno");
        view.updateView("replacenonum");
        view.updateView("replacenoname");
    }

    private void clearReplaceNoInfo() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (model.getProperty("newreplaceno") == null) {
            return;
        }
        model.beginInit();
        model.setValue("replaceentity", (Object)"");
        model.setValue("replacenonum", (Object)"");
        model.setValue("replacenoname", (Object)"");
        model.setValue("newreplaceno", (Object)0L);
        model.setValue("replaceno", null);
        view.updateView("replacenonum");
        view.updateView("replacenoname");
        view.updateView("replaceno");
        view.updateView("newreplaceno");
        model.endInit();
    }

    public void registerListener(EventObject event) {
        BasedataEdit copEntryVersionBE;
        BasedataEdit entryVersionBE;
        BasedataEdit materialBE;
        BasedataEdit entryMaterialBE;
        BasedataEdit copEntryMaterialBE;
        TextEdit replaceNoNum;
        BasedataEdit entryconfiguredcodeBE;
        BasedataEdit configuredcodeBE;
        BasedataEdit typeBE;
        BasedataEdit versionBE;
        super.registerListener(event);
        if (event == null) {
            return;
        }
        Tab tab = (Tab)this.getControl("tab_entry");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((versionBE = (BasedataEdit)this.getControl("version")) != null) {
            versionBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((typeBE = (BasedataEdit)this.getControl("type")) != null) {
            typeBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcodeBE = (BasedataEdit)this.getControl("configuredcode")) != null) {
            configuredcodeBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryconfiguredcodeBE = (BasedataEdit)this.getControl("entryconfiguredcode")) != null) {
            entryconfiguredcodeBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((replaceNoNum = (TextEdit)this.getControl("replacenonum")) != null) {
            replaceNoNum.addClickListener((ClickListener)this);
        }
        if ((copEntryMaterialBE = (BasedataEdit)this.getControl("copentrymaterial")) != null) {
            copEntryMaterialBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryMaterialBE = (BasedataEdit)this.getControl("entrymaterial")) != null) {
            entryMaterialBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialBE = (BasedataEdit)this.getControl(KEY_MATERIAL)) != null) {
            materialBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryVersionBE = (BasedataEdit)this.getControl("entryversion")) != null) {
            entryVersionBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((copEntryVersionBE = (BasedataEdit)this.getControl("copentryversion")) != null) {
            copEntryVersionBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickKey = source.getKey();
        if ("replacenonum".equals(clickKey)) {
            this.showBomReplaceNo();
        }
    }

    private void showBomReplaceNo() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        Long createOrgPk = createOrg != null ? createOrg.getLong("id") : 0L;
        DynamicObject bomType = dataEntity.getDynamicObject("type");
        String entityNum = "";
        String entityName = "";
        if (bomType != null) {
            DynamicObject replaceObj = bomType.getDynamicObject("replaceobj");
            if (replaceObj != null) {
                entityNum = replaceObj.getString("id");
            }
        } else {
            if (model.getProperty("replaceentity") == null) {
                return;
            }
            entityNum = dataEntity.getString("replaceentity");
        }
        DynamicObject entityObject = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"id,number,name,modeltype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entityNum)});
        String modeltype = entityObject != null ? entityObject.getString("modeltype") : "";
        entityName = entityObject != null ? entityObject.getString("name") : "";
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("entity", entityNum);
        params.put("entityname", entityName);
        params.put("createorgid", createOrgPk);
        params.put("modeltype", modeltype);
        this.showPage(params);
    }

    private void showPage(Map<String, Object> customParams) {
        IFormView view = this.getView();
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.setFormId("mpdm_bomreplaceno_f7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"BOM\u66ff\u4ee3\u53f7\u7ef4\u62a4", (String)"BOMTplEdit_62", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mpdmbomreplacenof7"));
        view.showForm(listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("mpdmbomreplacenof7".equals(actionId) && returnData != null) {
            this.setRepalceNoinfo(returnData);
        }
    }

    private void setRepalceNoinfo(Object returnData) {
        IDataModel model = this.getModel();
        if (model.getProperty("newreplaceno") == null) {
            return;
        }
        IFormView view = this.getView();
        JSONArray replaceNoDatas = (JSONArray)returnData;
        JSONObject replaceNoData = replaceNoDatas.getJSONObject(0);
        String entityTypeNum = replaceNoData.getString("entitytypenum");
        Long dataPK = replaceNoData.getLong("dataid");
        model.beginInit();
        model.setValue("replaceentity", (Object)entityTypeNum);
        model.setValue("replacenonum", (Object)replaceNoData.getString("datanumber"));
        model.setValue("replacenoname", (Object)replaceNoData.getString("dataname"));
        model.setValue("newreplaceno", (Object)dataPK);
        if (StringUtils.isNotEmpty((CharSequence)entityTypeNum) && MPDM_REPLACENO.equals(entityTypeNum)) {
            model.setItemValueByID("replaceno", (Object)dataPK);
        } else {
            model.setItemValueByID("replaceno", (Object)0L);
        }
        model.endInit();
        view.updateView("replaceentity");
        view.updateView("replacenonum");
        view.updateView("replacenoname");
        view.updateView("newreplaceno");
        view.updateView("replaceno");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String curUserID;
        String srcDEPName;
        ListFilterParameter lfp;
        if (event == null) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        FormShowParameter fsp = event.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        int rowIndex = event.getRow();
        IDataEntityProperty srcDEP = event.getProperty();
        String string = srcDEPName = srcDEP == null ? null : srcDEP.getName();
        if (DynamicObjDataUtil.isEmptyString((String)srcDEPName)) {
            return;
        }
        RequestContext rc = RequestContext.getOrCreate();
        String string2 = curUserID = RequestContext.getOrCreate() == null ? null : rc.getUserId();
        if (DynamicObjDataUtil.isEmptyString((String)curUserID)) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237ID\u5931\u8d25\u3002", (String)"BOMTplEdit_43", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if ("version".equalsIgnoreCase(srcDEPName)) {
            DynamicObject mftInfoDO = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)KEY_MATERIAL);
            if (mftInfoDO == null) {
                return;
            }
            DynamicObject materialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)mftInfoDO, (String)KEY_MASTERID);
            Object materialIDObj = materialDO == null ? mftInfoDO.getPkValue() : materialDO.getPkValue();
            Long materialID = materialIDObj == null ? 0L : Long.parseLong(materialIDObj.toString());
            qFilterList.add(new QFilter(KEY_MATERIAL, "=", (Object)materialID));
        } else if (("entrymaterial".equalsIgnoreCase(srcDEPName) || KEY_MATERIAL.equalsIgnoreCase(srcDEPName) || "copentrymaterial".equalsIgnoreCase(srcDEPName)) && rowIndex >= 0) {
            DynamicObjectCollection copEntryDOC;
            DynamicObject mftInfoDO = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)KEY_MATERIAL);
            if (mftInfoDO == null) {
                return;
            }
            DynamicObject mftInfoMasterDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)mftInfoDO, (String)KEY_MASTERID);
            String materialIDStr = mftInfoMasterDO == null ? mftInfoDO.getPkValue().toString() : mftInfoMasterDO.getPkValue().toString();
            Long materialID = DynamicObjDataUtil.isEmptyString((String)materialIDStr) ? 0L : Long.parseLong(materialIDStr);
            DynamicObjectCollection entryDOC = dm.getEntryEntity("entry");
            int entryDOCSize = DynamicObjDataUtil.isEmptyList((List)entryDOC) ? 0 : entryDOC.size();
            ArrayList<Long> materialIDList = new ArrayList<Long>();
            if (materialID > 0L && !materialIDList.contains(materialID) && !KEY_MATERIAL.equalsIgnoreCase(srcDEPName)) {
                materialIDList.add(materialID);
            }
            if (!"entrymaterial".equalsIgnoreCase(srcDEPName)) {
                for (int index = 0; index < entryDOCSize; ++index) {
                    DynamicObject entryMFTInfoMasterDO;
                    String entryMaterialIDStr;
                    Long entryMaterialID;
                    DynamicObject entryMFTInfoDO;
                    DynamicObject entryDO = (DynamicObject)entryDOC.get(index);
                    if (entryDO == null || (entryMFTInfoDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entrymaterial")) == null || (entryMaterialID = Long.valueOf(DynamicObjDataUtil.isEmptyString((String)(entryMaterialIDStr = (entryMFTInfoMasterDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryMFTInfoDO, (String)KEY_MASTERID)) == null ? entryMFTInfoDO.getPkValue().toString() : entryMFTInfoMasterDO.getPkValue().toString())) ? 0L : Long.parseLong(entryMaterialIDStr))) <= 0L || materialIDList.contains(entryMaterialID)) continue;
                    materialIDList.add(entryMaterialID);
                }
            }
            int copEntryDOCSize = DynamicObjDataUtil.isEmptyList((List)(copEntryDOC = dm.getEntryEntity("copentry"))) ? 0 : copEntryDOC.size();
            for (int index = 0; index < copEntryDOCSize; ++index) {
                DynamicObject copEntryMFTInfoMasterDO;
                String copEntryMaterialIDStr;
                Long copEntryMaterialID;
                DynamicObject copEntryMFTInfoDO;
                DynamicObject copEntryDO = (DynamicObject)copEntryDOC.get(index);
                if (copEntryDO == null || (copEntryMFTInfoDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copEntryDO, (String)"copentrymaterial")) == null || (copEntryMaterialID = Long.valueOf(DynamicObjDataUtil.isEmptyString((String)(copEntryMaterialIDStr = (copEntryMFTInfoMasterDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copEntryMFTInfoDO, (String)KEY_MASTERID)) == null ? copEntryMFTInfoDO.getPkValue().toString() : copEntryMFTInfoMasterDO.getPkValue().toString())) ? 0L : Long.parseLong(copEntryMaterialIDStr))) <= 0L || materialIDList.contains(copEntryMaterialID)) continue;
                materialIDList.add(copEntryMaterialID);
            }
            if (!DynamicObjDataUtil.isEmptyList(materialIDList)) {
                qFilterList.add(new QFilter(KEY_MASTERID, "not in", materialIDList));
            }
        } else if ("entryversion".equalsIgnoreCase(srcDEPName)) {
            DynamicObject entryMFTInfoDO = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entrymaterial", (int)rowIndex);
            if (entryMFTInfoDO == null) {
                return;
            }
            DynamicObject entryMaterialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryMFTInfoDO, (String)KEY_MASTERID);
            String entryMaterialIDStr = entryMaterialDO == null ? entryMFTInfoDO.getPkValue().toString() : entryMaterialDO.getPkValue().toString();
            Long entryMaterialID = DynamicObjDataUtil.isEmptyString((String)entryMaterialIDStr) ? 0L : Long.parseLong(entryMaterialIDStr);
            qFilterList.add(new QFilter(KEY_MATERIAL, "=", (Object)entryMaterialID));
        } else if ("copentryversion".equalsIgnoreCase(srcDEPName)) {
            DynamicObject copEntryMFTInfoDO = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"copentrymaterial", (int)rowIndex);
            if (copEntryMFTInfoDO == null) {
                return;
            }
            DynamicObject copEntryMaterialDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copEntryMFTInfoDO, (String)KEY_MASTERID);
            String entryMaterialIDStr = copEntryMaterialDO == null ? copEntryMFTInfoDO.getPkValue().toString() : copEntryMaterialDO.getPkValue().toString();
            Long entryMaterialID = DynamicObjDataUtil.isEmptyString((String)entryMaterialIDStr) ? 0L : Long.parseLong(entryMaterialIDStr);
            qFilterList.add(new QFilter(KEY_MATERIAL, "=", (Object)entryMaterialID));
        } else if (!"replaceno".equalsIgnoreCase(srcDEPName)) {
            if ("configuredcode".equalsIgnoreCase(srcDEPName)) {
                DynamicObject matInfo = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)KEY_MATERIAL);
                if (matInfo == null) {
                    return;
                }
                String entityName = matInfo.getDynamicObjectType().getName();
                Long matId = -1L;
                if ("bd_materialmftinfo".equals(entityName)) {
                    DynamicObject matObj = matInfo.getDynamicObject(KEY_MASTERID);
                    matId = matObj.getLong("id");
                } else if ("bd_material".equals(entityName)) {
                    matId = matInfo.getLong("id");
                }
            } else if ("entryconfiguredcode".equalsIgnoreCase(srcDEPName)) {
                DynamicObject entryMatInfo = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entrymaterial");
                if (entryMatInfo == null) {
                    return;
                }
                long entryMatId = -1L;
                String entityName = entryMatInfo.getDynamicObjectType().getName();
                if ("bd_materialmftinfo".equals(entityName)) {
                    DynamicObject entryMatObj = entryMatInfo.getDynamicObject(KEY_MASTERID);
                    entryMatId = entryMatObj.getLong("id");
                } else if ("bd_material".equals(entityName)) {
                    entryMatId = entryMatInfo.getLong("id");
                }
            }
        }
        if (!DynamicObjDataUtil.isEmptyList(qFilterList)) {
            lfp.getQFilters().addAll(qFilterList);
            if (lsp != null) {
                lsp.setListFilterParameter(lfp);
            }
            event.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        int entryRowIndex;
        if (event == null) {
            return;
        }
        if (!this.checkViewNotNull()) {
            return;
        }
        IFormView fv = this.getView();
        String tabPageKey = event.getTabKey();
        if (DynamicObjDataUtil.isEmptyString((String)tabPageKey)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (tabPageKey.equalsIgnoreCase("tabpage_qtyentry") || tabPageKey.equalsIgnoreCase("tabpage_setupentry")) {
            if (entryRowIndex >= 0) {
                fv.setVisible(Boolean.TRUE, new String[]{"flex_qtyentry", "flex_setupentry"});
                String pageFlex = null;
                if (tabPageKey.equalsIgnoreCase("tabpage_qtyentry")) {
                    pageFlex = "flex_qtyentry";
                } else if (tabPageKey.equalsIgnoreCase("tabpage_setupentry")) {
                    if (entryGrid == null) {
                        pageFlex = "flex_setupentry";
                        return;
                    }
                    DynamicObject entryObj = entryGrid.getEntryData().getDataEntitys()[entryRowIndex];
                    if (entryObj == null) {
                        pageFlex = "flex_setupentry";
                        return;
                    }
                    String entryqtytype = entryObj.getString("entryqtytype");
                    if ("C".equals(entryqtytype)) {
                        fv.setVisible(Boolean.FALSE, new String[]{"acpp_setupentry", "acptb_setupentry"});
                    } else {
                        fv.setVisible(Boolean.TRUE, new String[]{"acpp_setupentry", "acptb_setupentry"});
                    }
                    pageFlex = "flex_setupentry";
                }
                this.updateChildPage(pageFlex, true);
            } else {
                fv.setVisible(Boolean.FALSE, new String[]{"flex_qtyentry", "flex_setupentry"});
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u3002", (String)"BOMTplEdit_44", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void updateChildPage(String pageFlex, boolean isUpdateSubEntry) {
        int entryRowIndex;
        if (!this.checkViewNotNull()) {
            return;
        }
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        IPageCache pc = this.getPageCache();
        if (pc == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        AbstractGrid.GridState entryGS = entryGrid == null ? null : entryGrid.getEntryState();
        int n = entryRowIndex = entryGS == null ? -1 : entryGS.getFocusRow();
        if (entryRowIndex < 0) {
            return;
        }
        DynamicObject entryDO = dm.getEntryRowEntity("entry", entryRowIndex);
        if (entryDO == null) {
            return;
        }
        String entryQtyType = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryDO, (String)"entryqtytype");
        if ("flex_qtyentry".equalsIgnoreCase(pageFlex)) {
            if (!BOMEntryQtyTypeEnum.STEP.getValue().equalsIgnoreCase(entryQtyType)) {
                fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u7684\u201c\u7528\u91cf\u7c7b\u578b\u201d\u2260\u9636\u68af\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9636\u68af\u7528\u91cf\u3002", (String)"BOMTplEdit_60", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), entryRowIndex + 1));
                fv.setVisible(Boolean.FALSE, new String[]{"flex_qtyentry"});
                return;
            }
            fv.setVisible(Boolean.TRUE, new String[]{"flex_qtyentry"});
        } else if ("flex_setupentry".equalsIgnoreCase(pageFlex)) {
            if (BOMEntryQtyTypeEnum.STEP.value.equals(entryQtyType)) {
                fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u7684\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e3a\u9636\u68af\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u201c\u5b89\u88c5\u4f4d\u7f6e\u201d\u3002", (String)"BOMTplEdit_61", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), entryRowIndex + 1));
                fv.setVisible(Boolean.FALSE, new String[]{"flex_setupentry"});
                return;
            }
            fv.setVisible(Boolean.TRUE, new String[]{"flex_setupentry"});
        }
        if (pageFlex == null) {
            return;
        }
        String suffix = null;
        if (pageFlex.equalsIgnoreCase("flex_qtyentry")) {
            suffix = "_qty";
        } else if (pageFlex.equalsIgnoreCase("flex_setupentry")) {
            suffix = "_set";
        } else {
            return;
        }
        dm.setValue("entryseq" + suffix, (Object)(entryRowIndex + 1));
        DynamicObject entryMFTInfoDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entrymaterial");
        Object entryMFTInfoPKObj = entryMFTInfoDO == null ? null : entryMFTInfoDO.getPkValue();
        Long entryMFTInfoPK = entryMFTInfoPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTInfoPKObj.toString()));
        dm.setValue("entrymaterial" + suffix, (Object)(entryMFTInfoPK <= 0L ? null : entryMFTInfoPK));
        DynamicObject entryMFTUnitDO = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryDO, (String)"entryunit");
        Object entryMFTUnitPKObj = entryMFTUnitDO == null ? null : entryMFTUnitDO.getPkValue();
        Long entryMFTUnitPK = entryMFTUnitPKObj == null ? Long.valueOf(0L) : Long.valueOf(Long.parseLong(entryMFTUnitPKObj.toString()));
        dm.setValue("entryunit" + suffix, (Object)(entryMFTUnitPK <= 0L ? null : entryMFTUnitPK));
        if (pageFlex.equalsIgnoreCase("flex_setupentry")) {
            BigDecimal entryQtyNumerator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryDO, (String)"entryqtynumerator", (BigDecimal)BigDecimal.ZERO);
            BigDecimal entryQtyDenominator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryDO, (String)"entryqtydenominator", (BigDecimal)BigDecimal.ZERO);
            if (entryQtyNumerator != null && entryQtyDenominator != null && BigDecimal.ZERO.compareTo(entryQtyNumerator) < 0 && BigDecimal.ZERO.compareTo(entryQtyDenominator) < 0) {
                String precisionaccount = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryMFTUnitDO, (String)"precisionaccount", (String)"1");
                Integer precision = DynamicObjDataUtil.getDynamicObjectIntegerData((DynamicObject)entryMFTUnitDO, (String)"precision", (Integer)10);
                RoundingMode roundingMode = RoundingMode.HALF_UP;
                if (precisionaccount.equalsIgnoreCase("2")) {
                    roundingMode = RoundingMode.FLOOR;
                } else if (precisionaccount.equalsIgnoreCase("3")) {
                    roundingMode = RoundingMode.CEILING;
                }
                BigDecimal entryQty = entryQtyNumerator.divide(entryQtyDenominator, (int)precision, roundingMode);
                dm.setValue("entryqty" + suffix, (Object)entryQty);
            } else {
                dm.setValue("entryqty" + suffix, (Object)BigDecimal.ZERO);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.checkViewNotNull()) {
            return;
        }
        IDataModel dm = this.getModel();
        String billStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"status");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }

    private boolean setBOMVersionMustInput(DynamicObject product, DynamicObject bomType) {
        Boolean isVersion;
        if (!this.checkViewNotNull()) {
            return false;
        }
        IFormView fv = this.getView();
        Boolean isenablematerialversion = MaterialHelper.isEnableMaterialVersion((DynamicObject)product);
        if (bomType != null) {
            bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)bomType.getDataEntityType().getName(), (String)"isversion");
        }
        if ((isVersion = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)bomType, (String)"isversion")).booleanValue() || isenablematerialversion.booleanValue()) {
            return true;
        }
        ControlUtil.setControlMustInput((IFormView)fv, (String)"version", (String)"", (boolean)false);
        return false;
    }

    private void setAuxpMustInput(IFormView fv, IDataModel dm, boolean isAuxpMustInput, int rowIndex, String fieldName, boolean isResetVal) {
        if (!isAuxpMustInput) {
            if (rowIndex >= 0) {
                ControlUtil.setControlMustInput((IFormView)fv, (String)fieldName, (String)"", (boolean)false, (int)rowIndex);
                if (isResetVal) {
                    dm.setValue(fieldName, null, rowIndex);
                }
                fv.updateView(fieldName, rowIndex);
            } else {
                ControlUtil.setControlMustInput((IFormView)fv, (String)fieldName, (String)"", (boolean)false);
                if (isResetVal) {
                    dm.setValue(fieldName, null);
                }
            }
        } else if (rowIndex >= 0) {
            ControlUtil.setControlMustInput((IFormView)fv, (String)fieldName, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"BOMTplEdit_29", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (boolean)true, (int)rowIndex);
            if (isResetVal) {
                dm.setValue(fieldName, null, rowIndex);
            }
            fv.updateView(fieldName, rowIndex);
        } else {
            ControlUtil.setControlMustInput((IFormView)fv, (String)fieldName, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"BOMTplEdit_29", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (boolean)true);
            if (isResetVal) {
                dm.setValue(fieldName, null);
            }
        }
    }

    private void setAuxpEnble(IFormView fv, IDataModel dm, boolean isAuxpEnable, int rowIndex, String fieldName) {
        if (!isAuxpEnable) {
            if (rowIndex >= 0) {
                fv.setEnable(Boolean.FALSE, rowIndex, new String[]{fieldName});
                fv.updateView(fieldName, rowIndex);
            } else {
                fv.setEnable(Boolean.FALSE, new String[]{fieldName});
                fv.setVisible(Boolean.FALSE, new String[]{fieldName});
            }
        } else if (rowIndex >= 0) {
            fv.setEnable(Boolean.TRUE, rowIndex, new String[]{fieldName});
            fv.updateView(fieldName, rowIndex);
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{fieldName});
            fv.setVisible(Boolean.TRUE, new String[]{fieldName});
        }
    }

    private void setEntryColAuxpMustImput(IFormView fv, IDataModel dm, String entryName, DynamicObject typeObj, String matfieldName, String fieldName) {
        DynamicObjectCollection entryCol = dm.getEntryEntity(entryName);
        if (entryCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            DynamicObject entryMatObj = entryObj.getDynamicObject(matfieldName);
            DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
            boolean isAuxpEnable = MFTBomValidateBusiness.isAuxpEnable((DynamicObject)entryMatObj, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpEnble(fv, dm, isAuxpEnable, i, fieldName);
            boolean isAuxpMustInput = MFTBomValidateBusiness.isAuxpMustInput((DynamicObject)entryMatObj, (DynamicObject)typeObj, (DynamicObject)createOrgObj);
            this.setAuxpMustInput(fv, dm, isAuxpMustInput, i, fieldName, true);
        }
    }

    private boolean checkViewNotNull() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        return fv != null && dm != null;
    }

    public void showConfigCode(IDataModel dm) {
        BasedataEdit configcodeEdit = (BasedataEdit)this.getControl("configuredcode");
        DynamicObject typeObj = (DynamicObject)dm.getValue("type");
        if (typeObj == null) {
            return;
        }
        String purpose = typeObj.getString("purpose");
        if ("C".equals(purpose)) {
            configcodeEdit.setMustInput(true);
        } else {
            configcodeEdit.setMustInput(false);
            dm.setValue("configuredcode", null);
        }
    }

    private boolean isBomProductJoin(String bomId) {
        DynamicObject bom = QueryServiceHelper.queryOne((String)"pdm_mftbom", (String)"iscoproduct", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bomId))});
        if (bom != null) {
            return bom.getBoolean("iscoproduct");
        }
        return false;
    }
}

