/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.qmc;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bd.sbd.consts.Inspect_cfgConst;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class InspectCfgImportPlugin
extends AbstractBillPlugIn {
    public void beforeImportData(BeforeImportDataEventArgs e) {
        String createOrgNumber;
        DynamicObject orgObj;
        Map sourceData = e.getSourceData();
        Object entryEntity = sourceData.get("entryentity");
        Object entryEntryObject = sourceData.get("entryqcp");
        if (entryEntity != null) {
            this.isEntryLegal(entryEntity, entryEntryObject, e);
        }
        if (null == (orgObj = InspectCfgImportPlugin.getOrgObj(createOrgNumber = ((Map)sourceData.get("createorg")).get("number").toString()))) {
            return;
        }
        Map masterid = (Map)sourceData.get("masterid");
        boolean legal = InspectCfgImportPlugin.isMaterialLegal(masterid, orgObj, "bd_material");
        if (!legal) {
            String cancelMessage = String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u53ef\u8d28\u68c0\u6216\u8005\u7269\u6599\u914d\u7f6e\u5c5e\u6027\u4e3a\u7279\u5f81\u4ef6\u3002", (String)"InspectCfgImportPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage);
            e.setCancel(true);
            return;
        }
        if (entryEntryObject != null) {
            List entryArray = (List)entryEntryObject;
            for (Object o : entryArray) {
                Map entry = (Map)o;
                InspectCfgImportPlugin.addKeyId((Map)entry.get("supplier"), orgObj, "bd_supplier");
            }
        }
    }

    public static boolean isMaterialLegal(Map baseObj, DynamicObject orgObj, String entity) {
        Optional<DynamicObject> first;
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgObj.getLong("id"));
        baseFilter.and("number", "=", baseObj.get("number")).and("enable", "=", (Object)"1");
        Map entityMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,enableinspect,configproperties", (QFilter[])baseFilter.toArray());
        if (!CollectionUtils.isEmpty((Map)entityMap) && (first = entityMap.values().stream().filter(x -> x.getBoolean("enableinspect") && !"3".equals(x.get("configproperties"))).findFirst()).isPresent()) {
            baseObj.put("id", first.get().get("id"));
            return true;
        }
        return false;
    }

    public static void addKeyId(Map baseObj, DynamicObject orgObj, String entity) {
        QFilter baseFilter = InspectCfgImportPlugin.getBaseFilter(baseObj, orgObj, entity);
        Map entityMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id", (QFilter[])baseFilter.toArray());
        if (!CollectionUtils.isEmpty((Map)entityMap)) {
            baseObj.put("id", ((DynamicObject)entityMap.values().stream().findFirst().get()).get("id"));
        }
    }

    private static DynamicObject getOrgObj(String createOrgNumber) {
        if (StringUtils.isEmpty((String)createOrgNumber)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createOrgNumber)});
    }

    private static QFilter getBaseFilter(Map baseObj, DynamicObject orgObj, String entity) {
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgObj.getLong("id"));
        baseFilter.and("number", "=", baseObj.get("number")).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        return baseFilter;
    }

    private void isEntryLegal(Object entryEntity, Object entryEntryObject, BeforeImportDataEventArgs e) {
        List entryArray = (List)entryEntity;
        List entryObjArray = (List)entryEntryObject;
        boolean flag = false;
        HashSet<String> bizTypeSet = new HashSet<String>(16);
        for (Object obj : entryArray) {
            String cancelMessage;
            Map objectMap = (Map)obj;
            JSONObject inspecttype = (JSONObject)objectMap.get("inspecttype");
            Boolean nocheckflag = (Boolean)objectMap.get("nocheckflag");
            if (inspecttype == null) {
                if (!nocheckflag.booleanValue()) continue;
                String cancelMessage2 = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u514d\u68c0\u8bbe\u7f6e\u3002", (String)"InspectCfgImportPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage2);
                e.setCancel(true);
                continue;
            }
            String number = inspecttype.getString("number");
            if (!Inspect_cfgConst.noCheckInspectSet.contains(number) && nocheckflag != null && nocheckflag.booleanValue()) {
                cancelMessage = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b%s\uff1a\u4e0d\u652f\u6301\u514d\u68c0\u8bbe\u7f6e\u3002", (String)"InspectCfgImportPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), number);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage);
                e.setCancel(true);
            } else if (Inspect_cfgConst.noCheckInspectSet.contains(number) && nocheckflag != null && nocheckflag.booleanValue()) {
                flag = true;
            }
            if (bizTypeSet.contains(number)) {
                cancelMessage = String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u91cd\u590d\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"InspectCfgImportPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]), number);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage);
                e.setCancel(true);
            }
            bizTypeSet.add(number);
        }
        if (entryObjArray != null && !flag && !entryObjArray.isEmpty()) {
            String cancelMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u652f\u6301\u514d\u68c0\u6216\u514d\u68c0\u8bbe\u7f6e\u672a\u5f00\u542f\uff0c\u4e0d\u80fd\u5f15\u5165\u4f9b\u5e94\u5546\u3002", (String)"InspectCfgImportPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage);
            e.setCancel(true);
        }
    }
}

