/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.scmcbom;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bd.sbd.enums.BillStatusEnum;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.utils.CommonUtils;
import kd.bd.sbd.utils.DateUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SCMCBomTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log LOG = LogFactory.getLog(SCMCBomTplPlugin.class);
    private static final String BLANK = " ";
    private static final String STOP = "stopChange";

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit entryMaterialEdit;
        BasedataEdit versionEdit;
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((versionEdit = (BasedataEdit)this.getView().getControl("version")) != null) {
            versionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryMaterialEdit = (BasedataEdit)this.getView().getControl("entrymaterial")) != null) {
            entryMaterialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)"afterCreateNewData");
        Throwable throwable = null;
        if (span != null) {
            if (throwable != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                span.close();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)"afterBindData");){
            Object bomType = this.getModel().getValue("type");
            if (bomType != null) {
                this.setBOMVersionMustInput((DynamicObject)bomType);
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)"entryGridBindData");
        Throwable throwable = null;
        if (span != null) {
            if (throwable != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                span.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        try (TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (key) {
                case "version": {
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material");
                    if (material == null) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3002", (String)"SCMCBomTplPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter materialFilter = new QFilter("material.id", "=", (Object)((Long)material.getPkValue()));
                    Date nowTime = new Date();
                    QFilter dateFilter = new QFilter("effectdate", "<=", (Object)nowTime).and(new QFilter("invaliddate", ">=", (Object)nowTime));
                    showParameter.getListFilterParameter().getQFilters().add(materialFilter.and(dateFilter));
                    return;
                }
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        try (TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)("afterDoOperation: " + afterDoOperationEventArgs.getOperateKey()));){
            Object bomType;
            if (("unaudit".equals(afterDoOperationEventArgs.getOperateKey()) || "unsubmit".equals(afterDoOperationEventArgs.getOperateKey())) && (bomType = this.getModel().getValue("type")) != null) {
                this.setBOMVersionMustInput((DynamicObject)bomType);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isStopPropertyChange(this.getPageCache())) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            ChangeData[] valueSet = e.getChangeSet();
            String propName = e.getProperty().getName();
            Object newValue = valueSet[0].getNewValue();
            switch (propName) {
                case "type": {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) return;
                    this.setBOMVersionMustInput((DynamicObject)newValue);
                    return;
                }
                case "material": {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) return;
                    this.getModel().setValue("version", null);
                    return;
                }
                case "entrymaterial": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            this.changeEntryMaterial((DynamicObject)valueSet[i].getNewValue(), (DynamicObject)valueSet[i].getOldValue(), rowIndex);
                        }
                        ++i;
                    }
                    return;
                }
                case "entryvaliddate": 
                case "entryinvaliddate": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            this.changeEntryDate(propName, (Date)valueSet[i].getNewValue(), (Date)valueSet[i].getOldValue(), rowIndex);
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"SCMCBomTplPlugin", (String)"afterImportData");){
            Boolean isVersion;
            IDataModel model = this.getModel();
            DynamicObject bill = model.getDataEntity(true);
            DynamicObject bomType = bill.getDynamicObject("type");
            DynamicObject version = bill.getDynamicObject("version");
            if (bomType != null && (isVersion = Boolean.valueOf(bomType.getBoolean("isversion"))).booleanValue() && version == null) {
                String msg = ResManager.loadKDString((String)"\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SCMCBomTplPlugin_5", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), msg);
            }
            String status = bill.getString("status");
            String enable = bill.getString("enable");
            if (status == null || StringUtils.isEmpty((CharSequence)status)) {
                status = BillStatusEnum.SAVE.getValue();
                bill.set("status", (Object)status);
            }
            if (enable == null || StringUtils.isEmpty((CharSequence)enable)) {
                enable = EnableStatusEnum.ENABLE.getValue();
                bill.set("enable", (Object)enable);
            }
            DynamicObject material = bill.getDynamicObject("material");
            if (version != null) {
                DynamicObject versionMaterial;
                Boolean isCancel = Boolean.FALSE;
                if (version.containsProperty("enable")) {
                    String versionEnable = version.getString("enable");
                    if (EnableStatusEnum.DISABLE.getValue().equals(versionEnable)) {
                        isCancel = Boolean.TRUE;
                    }
                }
                if (material != null && material.getPkValue() != null && version.containsProperty("material") && (versionMaterial = version.getDynamicObject("material")) != null && versionMaterial.getPkValue() != null && ((Long)versionMaterial.getPkValue()).longValue() != ((Long)material.getPkValue()).longValue()) {
                    isCancel = Boolean.TRUE;
                }
                if (version.containsProperty("effectdate") && version.containsProperty("invaliddate")) {
                    Date versionEffectDate = version.getDate("effectdate");
                    Date versionInvalidDate = version.getDate("invaliddate");
                    Date nowTime = new Date();
                    if (versionEffectDate != null && versionInvalidDate != null && (versionEffectDate.after(nowTime) || versionInvalidDate.before(nowTime))) {
                        isCancel = Boolean.TRUE;
                    }
                }
                if (isCancel.booleanValue()) {
                    String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u7248\u672c\u53f7\u5fc5\u987b\u4e3a\u53ef\u7528\u3001\u5df2\u5ba1\u6838\u3001\u6709\u6548\u72b6\u6001\u3002", (String)"SCMCBomTplPlugin_7", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), msg);
                }
            }
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("entry");
            if (material != null && material.getPkValue() != null && billEntrys != null && !billEntrys.isEmpty()) {
                for (int i = 0; i < billEntrys.size(); ++i) {
                    DynamicObject billEntry = (DynamicObject)billEntrys.get(i);
                    DynamicObject entryMaterial = billEntry.getDynamicObject("entrymaterial");
                    if (entryMaterial != null && entryMaterial.getPkValue() != null && ((Long)entryMaterial.getPkValue()).longValue() == ((Long)material.getPkValue()).longValue()) {
                        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c\u7ec4\u4ef6\u7f16\u7801\u201d\u4e0e\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u4e0d\u5141\u8bb8\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SCMCBomTplPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), msg);
                        continue;
                    }
                    if (billEntry.getDynamicObject("entryunit") == null && entryMaterial != null && entryMaterial.containsProperty("baseunit")) {
                        billEntry.set("entryunit", (Object)entryMaterial.getDynamicObject("baseunit"));
                    }
                    Date validDate = billEntry.getDate("entryvaliddate");
                    Date invalidDate = billEntry.getDate("entryinvaliddate");
                    if (validDate != null && invalidDate != null && invalidDate.before(validDate)) {
                        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"SCMCBomTplPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), msg);
                        continue;
                    }
                    billEntry.set("entryvaliddate", (Object)DateUtils.getStartOfDay((Date)billEntry.getDate("entryvaliddate")));
                    billEntry.set("entryinvaliddate", (Object)DateUtils.getEndOfDay((Date)billEntry.getDate("entryinvaliddate")));
                }
            }
            long end1 = System.currentTimeMillis();
            LOG.info("afterImportData cost time:" + (end1 - start));
        }
    }

    private void changeEntryMaterial(DynamicObject material, DynamicObject oldMaterial, int rowIndex) {
        if (this.isStopPropertyChange(this.getPageCache())) {
            return;
        }
        this.stopPropertyChange(this.getPageCache());
        this.getModel().setValue("entryqtynumerator", null, rowIndex);
        this.getModel().setValue("entryqtydenominator", null, rowIndex);
        if (material != null) {
            this.getModel().setValue("entryunit", (Object)material.getDynamicObject("baseunit"), rowIndex);
        } else {
            this.getModel().setValue("entryunit", null, rowIndex);
        }
        this.getModel().setValue("entryqtynumerator", (Object)new BigDecimal(1), rowIndex);
        this.getModel().setValue("entryqtydenominator", (Object)new BigDecimal(1), rowIndex);
        this.releasePropertyChange(this.getPageCache());
    }

    private void changeEntryDate(String propName, Date newDate, Date oldDate, int rowIndex) {
        if (newDate == null) {
            if ("entryvaliddate".equals(propName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u751f\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SCMCBomTplPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), rowIndex + 1));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SCMCBomTplPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), rowIndex + 1));
            }
            this.stopPropertyChange(this.getPageCache());
            this.getModel().setValue(propName, (Object)oldDate, rowIndex);
            this.releasePropertyChange(this.getPageCache());
        } else {
            Date invalidDate;
            Date validDate = "entryvaliddate".equals(propName) ? newDate : this.getModel().getValue("entryvaliddate", rowIndex);
            Date date = invalidDate = "entryinvaliddate".equals(propName) ? newDate : this.getModel().getValue("entryinvaliddate", rowIndex);
            if (validDate != null && invalidDate != null && invalidDate.before(validDate)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"SCMCBomTplPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]), rowIndex + 1));
                this.stopPropertyChange(this.getPageCache());
                this.getModel().setValue(propName, (Object)oldDate, rowIndex);
                this.releasePropertyChange(this.getPageCache());
            }
        }
    }

    private void setBOMVersionMustInput(DynamicObject bomType) {
        if (this.getView() == null || this.getModel() == null || bomType == null || !bomType.containsProperty("isversion")) {
            return;
        }
        FieldEdit versionEdit = (FieldEdit)this.getView().getControl("version");
        if (versionEdit == null) {
            return;
        }
        Boolean isVersion = bomType.getBoolean("isversion");
        if (isVersion.booleanValue()) {
            versionEdit.setMustInput(true);
        } else {
            versionEdit.setMustInput(false);
        }
    }

    private void stopPropertyChange(IPageCache pageCache) {
        pageCache.put(STOP, "true");
    }

    private void releasePropertyChange(IPageCache pageCache) {
        pageCache.put(STOP, "false");
    }

    private boolean isStopPropertyChange(IPageCache pageCache) {
        return "true".equals(pageCache.get(STOP));
    }
}

