/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.helper.MasterDataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class BizInfoHelper {
    private static final Log log = LogFactory.getLog(BizInfoHelper.class);
    private static final List<String> BIZ_INFO_FIELD_LIST = Arrays.asList("country", "societycreditcode", "tx_register_no", "artificialperson", "regcapital", "businessterm", "businessscope", "establishdate", "linkman", "bizpartner_phone", "bizpartner_fax", "postal_code", "url", "admindivision", "bizpartner_address", "idno", "chkisinternalcompany", "internal_company", "duns", "curegcapital", "name");

    @SdkDeprecated
    public static boolean isEnableSyncBizInfo() {
        Map<String, Object> sysParamMap = MasterDataHelper.loadAppParameterFromCache("15");
        Object enableSyncBizInfo = sysParamMap.get("enablesyncbizinfo");
        log.info("isEnableSyncBizInfo=" + enableSyncBizInfo);
        return enableSyncBizInfo instanceof Boolean && (Boolean)enableSyncBizInfo != false;
    }

    @SdkDeprecated
    public static void updateBizInfoByNameAndType(DynamicObject[] currDataEntities, OperationResult operationResult) {
        try (TraceSpan span = Tracer.create((String)"MasterDataHelper", (String)"updateBizInfoByNameAndType");){
            String key;
            log.info("call updateBizInfoByNameAndType, currDataEntities.length=" + currDataEntities.length);
            Map<String, DynamicObject> needRemoveObj = BizInfoHelper.getRemoveSameNamePersonalData(currDataEntities);
            HashMap<String, DynamicObject> partnerIdTypeMap = new HashMap<String, DynamicObject>(currDataEntities.length);
            HashSet<String> bizPartnerIdSet = new HashSet<String>(currDataEntities.length);
            HashSet<String> bizPartnerTypeSet = new HashSet<String>(currDataEntities.length);
            for (DynamicObject dynObj : currDataEntities) {
                key = BizInfoHelper.getPartnerIdTypeKey(dynObj);
                if (StringUtils.isBlank((CharSequence)key)) continue;
                partnerIdTypeMap.put(key, dynObj);
                bizPartnerIdSet.add(key.split("_")[0]);
                bizPartnerTypeSet.add(key.split("_")[1]);
            }
            for (DynamicObject dynObj : currDataEntities) {
                DynamicObject src;
                key = BizInfoHelper.getPartnerIdTypeKey(dynObj);
                if (StringUtils.isBlank((CharSequence)key) || (src = (DynamicObject)partnerIdTypeMap.get(key)) == null || needRemoveObj.get(dynObj.getString("id")) != null) continue;
                BizInfoHelper.setVal4BizInfo(src, dynObj);
            }
            log.info("call updateBizInfoByNameAndType, bizPartnerIdSet=" + bizPartnerIdSet + ", bizPartnerTypeSet=" + bizPartnerTypeSet);
            if (bizPartnerIdSet.size() == 0 || bizPartnerTypeSet.size() == 0) {
                return;
            }
            String queryField = "id,bizpartner,type," + BIZ_INFO_FIELD_LIST.toString().replace("[", "").replace("]", "");
            log.info("call updateBizInfoByNameAndType, queryField=" + queryField);
            Set bizPartnerId = bizPartnerIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            Object[] queryCustomers = BusinessDataServiceHelper.load((String)"bd_customer", (String)queryField, (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizPartnerId), new QFilter("type", "in", bizPartnerTypeSet)});
            Object[] querySuppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)queryField, (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizPartnerId), new QFilter("type", "in", bizPartnerTypeSet)});
            log.info("call updateBizInfoByNameAndType, queryCustomers.length=" + queryCustomers.length + ", querySuppliers.length=" + querySuppliers.length);
            LinkedList<Object> needUpdCustomerBizInfoList = new LinkedList<Object>();
            DynamicObject[] data4CustomerChecking = (DynamicObject[])ArrayUtils.addAll((Object[])currDataEntities, (Object[])queryCustomers);
            Map<String, DynamicObject> needRemoveCustomer = BizInfoHelper.getRemoveSameNamePersonalData(data4CustomerChecking);
            for (Object object : queryCustomers) {
                DynamicObject srcCustomer;
                String key2 = BizInfoHelper.getPartnerIdTypeKey((DynamicObject)object);
                if (StringUtils.isBlank((CharSequence)key2) || (srcCustomer = (DynamicObject)partnerIdTypeMap.get(key2)) == null || needRemoveCustomer.get(object.getString("id")) != null) continue;
                BizInfoHelper.setVal4BizInfo(srcCustomer, (DynamicObject)object);
                needUpdCustomerBizInfoList.add(object);
            }
            LinkedList<Object> needUpdSupplierBizInfoList = new LinkedList<Object>();
            DynamicObject[] data4SupplierChecking = (DynamicObject[])ArrayUtils.addAll((Object[])currDataEntities, (Object[])querySuppliers);
            Map<String, DynamicObject> needRemoveSupplier = BizInfoHelper.getRemoveSameNamePersonalData(data4SupplierChecking);
            for (Object targetSupplier : querySuppliers) {
                DynamicObject srcSupplier;
                String key3 = BizInfoHelper.getPartnerIdTypeKey((DynamicObject)targetSupplier);
                if (StringUtils.isBlank((CharSequence)key3) || (srcSupplier = (DynamicObject)partnerIdTypeMap.get(key3)) == null || needRemoveSupplier.get(targetSupplier.getString("id")) != null) continue;
                BizInfoHelper.setVal4BizInfo(srcSupplier, (DynamicObject)targetSupplier);
                needUpdSupplierBizInfoList.add(targetSupplier);
            }
            log.info("call updateBizInfoByNameAndType, needUpdCustomerBizInfoList.size=" + needUpdCustomerBizInfoList.size() + ", needUpdSupplierBizInfoList.size=" + needUpdSupplierBizInfoList.size());
            try (TraceSpan traceSpan = Tracer.create((String)"MasterDataHelper", (String)"SaveServiceHelper.update");){
                if (needUpdCustomerBizInfoList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])needUpdCustomerBizInfoList.toArray(new DynamicObject[needUpdCustomerBizInfoList.size()]));
                }
                if (needUpdSupplierBizInfoList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])needUpdSupplierBizInfoList.toArray(new DynamicObject[needUpdSupplierBizInfoList.size()]));
                }
            }
            HashMap hashMap = new HashMap(16);
            HashMap<String, DynamicObject> needRemoveDatas = new HashMap<String, DynamicObject>(16);
            needRemoveDatas.putAll(needRemoveCustomer);
            needRemoveDatas.putAll(needRemoveSupplier);
            for (DynamicObject needRemoveData : needRemoveDatas.values()) {
                String name = needRemoveData.getLocaleString("name").getLocaleValue();
                String number = needRemoveData.getString("number");
                if (hashMap.get(name) == null) {
                    LinkedList<String> errNumbers = new LinkedList<String>();
                    errNumbers.add(number);
                    hashMap.put(name, errNumbers);
                    continue;
                }
                ((List)hashMap.get(name)).add(number);
            }
            if (!hashMap.isEmpty()) {
                StringBuilder err = new StringBuilder();
                for (Map.Entry entry : hashMap.entrySet()) {
                    err.append(((List)entry.getValue()).toString()).append("\uff1aalready open sync bizinfo\uff0cexist multiple names as").append((String)entry.getKey()).append("and the partner type is personal, sync failed ");
                }
                log.info(err.toString());
            }
        }
    }

    private static String getPartnerIdTypeKey(DynamicObject dynObj) {
        String result = "";
        if (dynObj == null) {
            return result;
        }
        DynamicObject bizPartner = dynObj.getDynamicObject("bizpartner");
        String bizPartnerId = bizPartner != null ? bizPartner.getString("id") : dynObj.getString("bizpartner_Id");
        String bizPartnerType = dynObj.getString("type");
        if (StringUtils.isBlank((CharSequence)bizPartnerId) || StringUtils.isBlank((CharSequence)bizPartnerType)) {
            return result;
        }
        result = bizPartnerId + "_" + bizPartnerType;
        return result;
    }

    private static void setVal4BizInfo(DynamicObject src, DynamicObject target) {
        if (src == null || target == null) {
            log.info("call setVal4BizInfo, src=" + src + ", target=" + target);
            return;
        }
        for (String bizInfoField : BIZ_INFO_FIELD_LIST) {
            target.set(bizInfoField, src.get(bizInfoField));
        }
    }

    private static Map<String, DynamicObject> getRemoveSameNamePersonalData(DynamicObject[] currDataEntities) {
        HashMap<String, DynamicObject> identityNameMap = new HashMap<String, DynamicObject>(currDataEntities.length);
        HashMap<String, DynamicObject> needRemoveObj = new HashMap<String, DynamicObject>(currDataEntities.length);
        for (DynamicObject dynObj : currDataEntities) {
            String identity = dynObj.getDataEntityType().getName();
            String name = dynObj.getLocaleString("name").getLocaleValue();
            String partnerType = dynObj.getString("type");
            if (!"4".equals(partnerType)) continue;
            String key = identity + "_" + name;
            DynamicObject previousElement = (DynamicObject)identityNameMap.get(key);
            if (previousElement != null) {
                needRemoveObj.put(previousElement.getString("id"), previousElement);
                needRemoveObj.put(dynObj.getString("id"), dynObj);
            }
            identityNameMap.put(key, dynObj);
        }
        return needRemoveObj;
    }
}

