/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.bizrule.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;

public class BizRuleEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit libEdit = (BasedataEdit)this.getView().getControl("bizrulelibrary");
        libEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entity");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldVal();
        this.getModel().setValue("applyoperationshow", this.getModel().getValue("applyoperation"));
        this.setShowFieldNoChanged("applyoperationshow");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entity")) {
            this.getModel().setValue("bizrulelibrary", null);
            this.initFieldVal();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"bizrulelibrary")) {
            Object bizrulelibrary = this.getModel().getValue("bizrulelibrary");
            if (Objects.isNull(bizrulelibrary)) {
                this.getModel().setValue("field", null);
                return;
            }
            this.getModel().setValue("field", ((DynamicObject)bizrulelibrary).get("field"));
        }
    }

    private void initFieldVal() {
        this.setMustInputOfOperation();
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        if (entity == null) {
            return;
        }
        ComboEdit operationEdit = (ComboEdit)this.getControl("applyoperationshow");
        operationEdit.setComboItems(this.initComboFieldVal(entity.getString("number")));
        if (this.getModel().getValue("bizrulelibrary") != null) {
            this.getModel().setValue("field", (Object)((DynamicObject)this.getModel().getValue("bizrulelibrary")).getString("field"));
        }
    }

    private List<ComboItem> initComboFieldVal(String entityNumber) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        List operateList = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (operateList == null || operateList.size() == 0) {
            return comboItemList;
        }
        operateList.stream().forEach(map -> {
            String operateKey = (String)map.get("key");
            String opTypeId = (String)map.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opTypeId) || operateKey.endsWith("andnew")) {
                return;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(new StringBuffer((String)((LinkedHashMap)map.get("name")).get(Lang.get().toString())).append("(").append(operateKey).append(")").toString()));
            comboItem.setValue(operateKey);
            comboItemList.add(comboItem);
        });
        return comboItemList;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("bizrulelibrary".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            showParameter.getListFilterParameter().setFilter(new QFilter("entity.number", "=", (Object)(entity == null ? "" : entity.getString("number"))));
        } else if ("entity".equals(key)) {
            DataSet dataSet = DB.queryDataSet((String)"InterQueryMeta", (DBRoute)DBRoute.of((String)"sys.meta"), (String)"select fnumber from t_meta_entitydesign where fmasterid != ' '");
            ArrayList<String> numberList = new ArrayList<String>(10);
            while (dataSet.hasNext()) {
                numberList.add(dataSet.next().getString("fnumber"));
            }
            if (numberList.size() > 0) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("number", "not in", numberList));
            }
        }
    }

    private void setMustInputOfOperation() {
        ComboEdit keyFieldEdit = (ComboEdit)this.getControl("applyoperationshow");
        keyFieldEdit.setMustInput(true);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setShowFieldNoChanged("applyoperation");
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            ITreeListView treeListView = ((ListView)parentView).getTreeListView();
            TreeNode root = treeListView.getTreeModel().getRoot();
            treeListView.getTreeModel().refreshNode((Object)root.getId());
            treeListView.refreshTreeNode(root.getId());
        }
    }

    private void setShowFieldNoChanged(String field) {
        DataEntityState entityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
        entityState.setBizChanged(((IDataEntityProperty)props.get((Object)field)).getOrdinal(), Boolean.FALSE.booleanValue());
        entityState.setBizChanged(((IDataEntityProperty)props.get((Object)"field")).getOrdinal(), Boolean.FALSE.booleanValue());
    }
}

