/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.gbs.core.flow.common.Enum.FlowCardJumpTypeEnum;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class FlowAppMenuFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String CACHEKEY_APPMENUMAP = "appmenumap";
    private static final String CACHEKEY_APPIDS = "appids";
    private static final String CACHEKEY_ROOTNODE = "rootnode";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENUENTRYENTITY = "menuentryentity";
    private static final String BTNOK = "btnok";
    private static final String FIELD_APPID = "appid";
    private static final String FIELD_MENUID = "menuid";
    private static final String FIELD_MENUNAME = "menuname";

    public void registerListener(EventObject e) {
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(this.getView());
        JSONArray userHasPerAppWithCache = portalUsableFuncUtil.getAllAppsInSystem();
        HashSet<String> appIds = new HashSet<String>(16);
        TreeNode treeNode = FlowAppMenuFormPlugin.buildMenuNode(userHasPerAppWithCache, appIds);
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        treeView.addNode(treeNode);
        treeView.focusNode(treeNode);
        this.getPageCache().put(CACHEKEY_APPIDS, SerializationUtils.toJsonString(appIds));
        this.getPageCache().put(CACHEKEY_ROOTNODE, SerializationUtils.toJsonString((Object)treeNode));
    }

    public void beforeClick(BeforeClickEvent e) {
        String key;
        super.beforeClick(e);
        Object source = e.getSource();
        String string = key = source instanceof Control ? ((Control)source).getKey() : "";
        if (BTNOK.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(MENUENTRYENTITY);
            int[] selectRow = entryGrid.getSelectRows();
            if (selectRow.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5e94\u7528\u83dc\u5355", (String)"FlowAppMenuFormPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                return;
            }
            String appId = (String)this.getModel().getValue(FIELD_APPID, selectRow[0]);
            String menuId = (String)this.getModel().getValue(FIELD_MENUID, selectRow[0]);
            String menuName = (String)this.getModel().getValue(FIELD_MENUNAME, selectRow[0]);
            JSONObject jsonObject = new JSONObject().fluentPut("appId", (Object)appId).fluentPut("formId", (Object)menuId).fluentPut("formName", (Object)menuName).fluentPut("jumpType", (Object)FlowCardJumpTypeEnum.APP.getJumpType());
            this.getView().returnDataToParent((Object)jsonObject);
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String parentId = evt.getParentNodeId().toString();
        if ("0".equals(nodeId) || "0".contains(parentId)) {
            this.getModel().deleteEntryData(MENUENTRYENTITY);
            return;
        }
        this.treeNodeClick(nodeId, parentId, true);
    }

    private void treeNodeClick(String nodeId, String parentId, boolean isInitAppMenu) {
        Map<String, List<String>> appMenuMap = this.getAppMenuMap();
        if (isInitAppMenu) {
            Set appIdSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_APPIDS), HashSet.class);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_ROOTNODE), TreeNode.class);
            if (!appIdSet.isEmpty() && appIdSet.contains(nodeId)) {
                TreeNode appNode = this.findNodeById(nodeId, rootNode);
                this.addAppNode(appNode, appMenuMap);
            }
            this.getPageCache().put(CACHEKEY_APPMENUMAP, SerializationUtils.toJsonString(appMenuMap));
        }
        this.getModel().deleteEntryData(MENUENTRYENTITY);
        String bizAppId = this.getNodeAppId(nodeId, parentId, appMenuMap);
        if (StringUtils.isEmpty((CharSequence)bizAppId)) {
            return;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.showMenuList(nodeId, appMeta, bizAppId);
    }

    private void addAppNode(TreeNode appNode, Map<String, List<String>> appMenuMap) {
        if (appNode == null || appNode.getChildren() != null && !appNode.getChildren().isEmpty()) {
            return;
        }
        String nodeId = appNode.getId();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)nodeId, (boolean)false);
        if (metadata != null) {
            ArrayList<String> menuIdList = new ArrayList<String>(16);
            List<TreeNode> nodeList = FlowAppMenuFormPlugin.getMenuNodeList(metadata, menuIdList);
            TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
            appNode = appNode == null ? new TreeNode() : appNode;
            appNode.addChildren(nodeList);
            treeView.updateNode(appNode);
            appMenuMap.put(nodeId, menuIdList);
        }
    }

    private String getNodeAppId(String nodeId, String parentId, Map<String, List<String>> appMenuMap) {
        if (appMenuMap.containsKey(nodeId)) {
            return nodeId;
        }
        for (Map.Entry<String, List<String>> entry : appMenuMap.entrySet()) {
            String appId = entry.getKey();
            List<String> menuIds = entry.getValue();
            if (menuIds.contains(nodeId) || parentId.equals(appId)) {
                return appId;
            }
            if (!menuIds.contains(parentId) || !menuIds.contains(nodeId)) continue;
            return appId;
        }
        return null;
    }

    public void showMenuList(String selectNodeId, AppMetadata appMeta, String bizAppId) {
        List menuElements = appMeta.getAppMenus();
        LinkedHashSet<Map<String, Object>> selectedMenuInfos = new LinkedHashSet<Map<String, Object>>();
        if (selectNodeId.equals(bizAppId)) {
            this.recursionMenuInfo(menuElements, selectedMenuInfos, selectNodeId, bizAppId);
        }
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            if (!selectNodeId.equals(menuId)) continue;
            if (!StringUtils.isEmpty((CharSequence)menuElement.getFormNumber())) {
                HashMap<String, String> menuInfo = new HashMap<String, String>(16);
                menuInfo.put("formname", menuElement.getFormName());
                menuInfo.put("formnumber", menuElement.getFormNumber());
                menuInfo.put(FIELD_MENUNAME, menuElement.getName().getLocaleValue());
                menuInfo.put(FIELD_MENUID, menuId);
                menuInfo.put(FIELD_APPID, bizAppId);
                selectedMenuInfos.add(menuInfo);
            }
            this.recursionMenuInfo(menuElements, selectedMenuInfos, menuId, bizAppId);
        }
        if (selectedMenuInfos.size() < 1) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(MENUENTRYENTITY, selectedMenuInfos.size());
        Iterator menuInfo = selectedMenuInfos.iterator();
        int i = 0;
        while (menuInfo.hasNext()) {
            Map menuJsonObject = (Map)menuInfo.next();
            this.getModel().setValue(FIELD_MENUNAME, menuJsonObject.get(FIELD_MENUNAME), i);
            this.getModel().setValue("formname", menuJsonObject.get("formname"), i);
            this.getModel().setValue("formnumber", menuJsonObject.get("formnumber"), i);
            this.getModel().setValue(FIELD_MENUID, menuJsonObject.get(FIELD_MENUID), i);
            this.getModel().setValue(FIELD_APPID, menuJsonObject.get(FIELD_APPID), i);
            ++i;
        }
    }

    private Set<Map<String, Object>> recursionMenuInfo(List<AppMenuElement> menuElements, Set<Map<String, Object>> menuList, String filterMenuId, String bizAppId) {
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            if (!filterMenuId.equals(parentMenuId)) continue;
            if (!StringUtils.isEmpty((CharSequence)menuElement.getFormNumber())) {
                HashMap<String, String> menuInfo = new HashMap<String, String>(10);
                menuInfo.put("formname", menuElement.getFormName());
                menuInfo.put("formnumber", menuElement.getFormNumber());
                menuInfo.put(FIELD_MENUNAME, menuElement.getName().getLocaleValue());
                menuInfo.put(FIELD_MENUID, menuId);
                menuInfo.put(FIELD_APPID, bizAppId);
                menuList.add(menuInfo);
            }
            this.recursionMenuInfo(menuElements, menuList, menuId, bizAppId);
        }
        return menuList;
    }

    public static TreeNode buildMenuNode(JSONArray cloudAndAppJsonArray, Set<String> appIds) {
        TreeNode RootNode = new TreeNode();
        RootNode.setId("0");
        RootNode.setParentid("");
        RootNode.setText(ResManager.loadKDString((String)"\u5e94\u7528\u83dc\u5355", (String)"FlowAppMenuFormPlugin_2", (String)"bd-gbs-plugin", (Object[])new Object[0]));
        RootNode.setIsOpened(true);
        for (Object value : cloudAndAppJsonArray) {
            JSONArray cloudNext = (JSONArray)value;
            TreeNode cloundNode = new TreeNode();
            ArrayList<TreeNode> appNodeList = new ArrayList<TreeNode>(16);
            for (Object o : cloudNext) {
                JSONObject next = (JSONObject)o;
                if (next == null) continue;
                Map localNameMap = (Map)JSONObject.toJavaObject((JSON)next.getJSONObject("name"), Map.class);
                String nodeName = LocaleString.fromMap((Map)localNameMap).getLocaleValue();
                if (Boolean.TRUE.equals(next.getBoolean("iscloud"))) {
                    cloundNode.setId(next.getString("id"));
                    cloundNode.setText(nodeName);
                    cloundNode.setParentid("0");
                    continue;
                }
                String appId = next.getString("id");
                appIds.add(appId);
                TreeNode appNode = new TreeNode();
                appNode.setId(appId);
                appNode.setText(nodeName);
                appNode.setParentid(next.getString("cloudid"));
                appNodeList.add(appNode);
            }
            if (!appNodeList.isEmpty()) {
                cloundNode.addChildren(appNodeList);
            }
            RootNode.addChild(cloundNode);
        }
        return RootNode;
    }

    private static List<TreeNode> getMenuNodeList(AppMetadata appMeta, List<String> menuIdList) {
        String bizAppId = appMeta.getBizappId();
        JSONArray appIds = DevportalUtil.getBizAppIds((String)bizAppId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> menuIds = new ArrayList<String>(menuElements.size());
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            menuIds.add(menuId);
            menuIdList.add(menuId);
        }
        ArrayList<String> firMenuIds = new ArrayList<String>();
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = menuElement.getName().getLocaleValue();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            firMenuIds.add(menuId);
            TreeNode treeNode = new TreeNode(bizAppId, menuId, menuName);
            firMenuList.add(treeNode);
            menuIdList.add(menuId);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>();
        FlowAppMenuFormPlugin.getMenuTreeNode(menuElements, firMenuIds, firMenuList, nodeLevel, 2);
        return firMenuList;
    }

    private static void getMenuTreeNode(List<AppMenuElement> menuElements, List<String> parentMenuIds, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel, Integer level) {
        ArrayList<String> menuIds = new ArrayList<String>();
        ArrayList<TreeNode> menuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            String menuId = menuElement.getId();
            String menuName = menuElement.getName().getLocaleValue();
            if (!parentMenuIds.contains(parentMenuId)) continue;
            nodeLevel.put(menuId, level);
            menuIds.add(menuId);
            TreeNode treeNode = new TreeNode(parentMenuId, menuId, menuName, false);
            menuList.add(treeNode);
        }
        if (!menuList.isEmpty()) {
            for (int i = 0; i < parentMenuList.size(); ++i) {
                TreeNode pNode = parentMenuList.get(i);
                DevportalUtil.buildNode((TreeNode)pNode, menuList);
            }
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            FlowAppMenuFormPlugin.getMenuTreeNode(menuElements, menuIds, menuList, nodeLevel, level);
        }
    }

    public void search(SearchEnterEvent evt) {
        TreeView treeView = (TreeView)this.getControl(MENU_TREE);
        String searchText = evt.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String searchTextTimeString = this.getPageCache().get("searchText_time");
        int searchTextTime = 1;
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_ROOTNODE), TreeNode.class);
        if (!searchText.equals(searchTextFormCache)) {
            Object resultObj = BizAppServiceHelp.searchAppAndMenu((String)searchText);
            Map<String, List<String>> appMenuMap = this.getAppMenuMap();
            HashSet appIdSet = new HashSet(16);
            if (resultObj instanceof JSONObject) {
                Object existAppNums;
                JSONObject searchData = (JSONObject)resultObj;
                if (searchData.getJSONArray("apps") != null && searchData.getJSONArray("apps").size() > 0) {
                    for (Iterator obj : searchData.getJSONArray("apps")) {
                        JSONObject appJsonObj = (JSONObject)obj;
                        String appId = appJsonObj.getString("id");
                        appIdSet.add(appId);
                    }
                } else if (searchData.getJSONArray("menus") != null) {
                    existAppNums = new HashSet(16);
                    for (Object obj : searchData.getJSONArray("menus")) {
                        JSONObject appJsonObj = (JSONObject)obj;
                        String appNum = appJsonObj.getString("appId");
                        if (existAppNums.contains(appNum)) continue;
                        String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
                        appIdSet.add(appId);
                        existAppNums.add(appNum);
                    }
                }
                if (!appIdSet.isEmpty()) {
                    existAppNums = appIdSet.iterator();
                    while (existAppNums.hasNext()) {
                        String appId = (String)existAppNums.next();
                        TreeNode appNode = this.findNodeById(appId, rootNode);
                        this.addAppNode(appNode, appMenuMap);
                    }
                    this.getPageCache().put(CACHEKEY_APPMENUMAP, SerializationUtils.toJsonString(appMenuMap));
                }
            }
        }
        List cloudNode = rootNode.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList<TreeNode> allNode = new ArrayList<TreeNode>();
        this.getAllNode(allNode, rootNode);
        if (searchText.equals(searchTextFormCache)) {
            String searchDataString = this.getPageCache().get("searchData");
            Object listFormCache = null;
            if (searchDataString != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
                TreeNode focusNode;
                if (listFormCache.size() > searchTextTime) {
                    focusNode = (TreeNode)listFormCache.get(searchTextTime);
                    treeView.focusNode(focusNode);
                    this.treeNodeClick(focusNode.getId(), focusNode.getParentid(), false);
                    treeView.expand(focusNode.getParentid());
                    this.getPageCache().put("searchText_time", String.valueOf(searchTextTime + 1));
                } else {
                    focusNode = (TreeNode)listFormCache.get(0);
                    treeView.focusNode(focusNode);
                    this.treeNodeClick(focusNode.getId(), focusNode.getParentid(), false);
                    treeView.expand(focusNode.getParentid());
                    this.getPageCache().put("searchText_time", "1");
                }
            }
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode node : allNode) {
                if (!node.getText().contains(searchText)) continue;
                list.add(node);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"FlowAppMenuFormPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId(), focusNode.getParentid(), false);
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put("searchText_time", "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    private TreeNode findNodeById(String serchNodeId, TreeNode rootNode) {
        List childNodes = rootNode.getChildren();
        if (childNodes == null || childNodes.isEmpty()) {
            return null;
        }
        for (TreeNode childNode : childNodes) {
            if (childNode.getId().equals(serchNodeId)) {
                return childNode;
            }
            TreeNode findNode = this.findNodeById(serchNodeId, childNode);
            if (findNode == null) continue;
            return findNode;
        }
        return null;
    }

    private Map<String, List<String>> getAppMenuMap() {
        String appMenuMapObj = this.getPageCache().get(CACHEKEY_APPMENUMAP);
        return appMenuMapObj == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)appMenuMapObj, HashMap.class);
    }

    private void getAllNode(List<TreeNode> allNode, TreeNode rootNode) {
        List childNodes = rootNode.getChildren();
        if (childNodes == null || childNodes.isEmpty()) {
            return;
        }
        for (TreeNode childNode : childNodes) {
            allNode.add(childNode);
            this.getAllNode(allNode, childNode);
        }
    }
}

