/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.gbs.core.flow.business.BusinessFlowCardServiceHelper;
import kd.bd.gbs.core.flow.common.Enum.FlowCardJumpTypeEnum;
import kd.bd.gbs.core.flow.common.Enum.FlowCardMethodTypeEnum;
import kd.bd.gbs.core.flow.common.Enum.FlowCardOpenTypeEnum;
import kd.bd.gbs.core.flow.common.util.FlowCardFormUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;

public class FlowCardEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_FLOWID_CACHE = "flowidcache";
    private static final String KEY_ISCONFIRMCLOSE = "isconfirmclose";
    private static final String KEY_SELECTFORM_BACK = "selectformback";
    private static final String KEY_SELECTMENU_BACK = "selectmenuback";
    private static final String KEY_SELECTICON_BACK = "selecticonback";
    private static final String KEY_CANCEL_BACK = "cancelcallback";
    private static final String KEY_CURRENT_NODEID = "crtnodeid";
    private static final String KEY_GLOBALID = "globalid";
    private static final String IS_LOCKED = "isLocked";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String globalId = this.getPageCache().get(KEY_GLOBALID);
        if (StringUtils.isEmpty((CharSequence)globalId)) {
            globalId = String.valueOf(System.currentTimeMillis());
            this.getPageCache().put(KEY_GLOBALID, globalId);
        }
        this.initFlowCardConfig();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isConfirmClose = this.getPageCache().get(KEY_ISCONFIRMCLOSE);
        if (isConfirmClose == null) {
            JSONObject mainData = new JSONObject();
            FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.CANCELEDIT, (JSONObject)mainData, null, (boolean)true, null);
            e.setCancel(true);
            return;
        }
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        Object flowIdObj = customParamMap.get("flowid");
        if (flowIdObj != null) {
            String idStr = String.valueOf((Long)flowIdObj);
            MutexHelper.release((String)"gbs_flowscheme", (String)"modify", (String)idStr);
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().getPageCache().remove(idStr + UserServiceHelper.getCurrentUserId() + IS_LOCKED);
            }
        }
        this.getPageCache().put(KEY_ISCONFIRMCLOSE, null);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getKey();
        if ("cusflow".equals(key)) {
            String nodeId;
            String eventName = e.getEventName();
            String eventArgs = e.getEventArgs();
            JSONObject argsJson = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)eventArgs)) {
                argsJson = (JSONObject)SerializationUtils.fromJsonString((String)eventArgs, JSONObject.class);
            }
            if (!StringUtils.isEmpty((CharSequence)(nodeId = argsJson.getString("nodeId")))) {
                this.getPageCache().put(KEY_CURRENT_NODEID, nodeId);
            }
            switch (eventName) {
                case "openF7": {
                    this.showFormF7(argsJson.getString("jumpType"));
                    break;
                }
                case "openF7Icon": {
                    this.showIconF7();
                    break;
                }
                case "saveGraph": {
                    boolean isExsit;
                    Long flowId = null;
                    if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(KEY_FLOWID_CACHE))) {
                        String flowIdStr = (String)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_FLOWID_CACHE), String.class);
                        flowId = Long.parseLong(flowIdStr);
                    }
                    if (isExsit = FlowCardFormUtil.isExsitScheme(flowId, (JSONObject)argsJson)) {
                        String errMsg = ResManager.loadKDString((String)"\u6d41\u7a0b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FlowCardEditPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(errMsg);
                        return;
                    }
                    Long saveId = this.confirmSaveFlow(flowId, argsJson);
                    if (saveId == null) break;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FlowCardEditPlugin_4", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                    this.getPageCache().put(KEY_FLOWID_CACHE, String.valueOf(saveId));
                    JSONObject mainData = new JSONObject().fluentPut("id", (Object)saveId);
                    FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.SAVEGRAPH, (JSONObject)mainData, null, (boolean)true, null);
                    break;
                }
                case "cancelEdit": {
                    boolean isChange = argsJson.getJSONObject("data").getJSONObject("graphData").getBoolean("isChange");
                    if (isChange) {
                        ConfirmCallBackListener confirm = new ConfirmCallBackListener(KEY_CANCEL_BACK, (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u672a\u4fdd\u5b58\uff0c\u786e\u8ba4\u9000\u51fa\uff1f", (String)"FlowCardEditPlugin_5", (String)"bd-gbs-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
                        break;
                    }
                    this.getPageCache().put(KEY_ISCONFIRMCLOSE, "true");
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (KEY_CANCEL_BACK.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.toString().equals(e.getResultValue())) {
            this.getPageCache().put(KEY_ISCONFIRMCLOSE, "true");
            this.getView().close();
        }
    }

    private Long confirmSaveFlow(Long flowId, JSONObject argsJson) {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("crtappid");
        return BusinessFlowCardServiceHelper.saveFlowConfig((Long)flowId, (String)appId, (JSONObject)argsJson.getJSONObject("data").getJSONObject("graphData"));
    }

    private void showFormF7(String formType) {
        if (StringUtils.isBlank((CharSequence)formType)) {
            return;
        }
        if (formType.equals(FlowCardJumpTypeEnum.APP.getJumpType())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gbs_appmenulist");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SELECTMENU_BACK));
            this.getView().showForm(showParameter);
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_formmeta", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"FlowCardEditPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
        listShowParameter.setFormId("bos_devp_formtreelistf7");
        listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
        listShowParameter.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (formType.equals(FlowCardJumpTypeEnum.OTHER.getJumpType())) {
            List modelTypes = FlowCardFormUtil.getOthereJumpType();
            qFilters.add(new QFilter("modeltype", "in", (Object)modelTypes));
        } else {
            String modelType = FlowCardFormUtil.getJumpModelType((String)formType);
            qFilters.add(new QFilter("modeltype", "=", (Object)modelType));
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SELECTFORM_BACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showIconF7() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_vectorlist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SELECTICON_BACK));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_SELECTFORM_BACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                JSONObject mainData = new JSONObject().fluentPut("nodeId", (Object)this.getPageCache().get(KEY_CURRENT_NODEID)).fluentPut("formId", (Object)listSelectedRow.getNumber()).fluentPut("formName", (Object)listSelectedRow.getName());
                FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.OPENF7, (JSONObject)mainData, null, (boolean)true, null);
            }
        } else if (KEY_SELECTMENU_BACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject mainData = (JSONObject)returnData;
                mainData = mainData.fluentPut("nodeId", (Object)this.getPageCache().get(KEY_CURRENT_NODEID));
                FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.OPENF7, (JSONObject)mainData, null, (boolean)true, null);
            }
        } else if (KEY_SELECTICON_BACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Map paraMap = (Map)returnData;
            String picValue = (String)paraMap.get("value");
            JSONObject mainData = new JSONObject();
            mainData = mainData.fluentPut("nodeId", (Object)this.getPageCache().get(KEY_CURRENT_NODEID));
            mainData = mainData.fluentPut("icon", (Object)picValue);
            FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.OPENF7ICON, (JSONObject)mainData, null, (boolean)true, null);
        }
    }

    private void initFlowCardConfig() {
        boolean isPreSet;
        JSONObject flowCardConfig = new JSONObject();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        Object flowIdObj = customParamMap.get("flowid");
        Object isCopyObj = customParamMap.get("iscopy");
        Object isPreSetObj = customParamMap.get("ispreset");
        boolean isCopy = isCopyObj != null && (Boolean)isCopyObj != false;
        boolean bl = isPreSet = isPreSetObj != null && (Boolean)isPreSetObj != false;
        if (flowIdObj == null) {
            JSONObject mainData = new JSONObject().fluentPut("openType", (Object)FlowCardOpenTypeEnum.NEW.getOpenType());
            FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.INITGRAPH, (JSONObject)mainData, null, (boolean)true, null);
            return;
        }
        Long flowId = (Long)flowIdObj;
        if (!isCopy) {
            this.getPageCache().put(KEY_FLOWID_CACHE, SerializationUtils.toJsonString((Object)flowId));
        }
        flowCardConfig = BusinessFlowCardServiceHelper.getFlowConfig((long)flowId);
        JSONObject mainData = new JSONObject();
        if (isPreSet && !isCopy) {
            JSONArray jsonArr = new JSONArray(1);
            jsonArr.add((Object)flowCardConfig);
            mainData.fluentPut("openType", (Object)FlowCardOpenTypeEnum.VIEW.getOpenType());
            mainData.fluentPut("graphData", (Object)jsonArr);
        } else {
            if (isCopy) {
                flowCardConfig.remove((Object)"name");
                flowCardConfig.fluentPut("name", (Object)"");
            }
            mainData.fluentPut("openType", (Object)FlowCardOpenTypeEnum.EDIT.getOpenType());
            mainData.fluentPut("graphData", (Object)flowCardConfig);
        }
        FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.INITGRAPH, (JSONObject)mainData, null, (boolean)true, null);
    }

    private String getGlobalId() {
        return this.getPageCache().get(KEY_GLOBALID);
    }
}

