/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bd.gbs.core.flow.business.BusinessFlowCardServiceHelper;
import kd.bd.gbs.core.flow.common.Enum.FlowCardJumpTypeEnum;
import kd.bd.gbs.core.flow.common.Enum.FlowCardMethodTypeEnum;
import kd.bd.gbs.core.flow.common.Enum.FlowCardOpenTypeEnum;
import kd.bd.gbs.core.flow.common.util.FlowCardFormUtil;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.portal.service.factory.MenuModeFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class FlowCardViewPlugin
extends GridCardPlugin {
    private static final String BAR_EDIT = "editbar";
    private static final String BAR_SORT = "sortbar";
    private static final String BAR_ADDFLOW = "addflowbar";
    private static final String BAR_REFRESH = "refreshbar";
    private static final String PANEL_EDIT = "editpanel";
    private static final String PANEL_SORT = "sortpanel";
    private static final String PANEL_ADDFLOW = "addpanel";
    private static final String PANEL_REFRESH = "refreshpanel";
    private static final String BAR_FIRSTADDFLOW = "firstaddflowbar";
    private static final String IS_LOCKED = "isLocked";
    private static final String PANE_ADDFLOW = "addflowpanel";
    private static final String PANE_CUSTOMPANEL = "custompanel";
    private static final String KEY_FLOWIDS = "flowids";
    private static final String KEY_EDIT_BACK = "editback";
    private static final String KEY_SELECTFLOW_BACK = "selectflowback";
    private static final String KEY_SORTFLOW_BACK = "sortflowback";
    private static final String KEY_CRTFLOWID = "crtflowid";
    private static final String KEY_GLOBALID = "globalid";
    private static final String KEY_JUMPPAGE = "jumppagekey";
    private static final String KEY_ISADMIN = "isadmin";
    private static final String ID_APPHOME = "/8T+06O/GOEH";
    private static final Log logger = LogFactory.getLog(FlowCardViewPlugin.class);

    public void initialize() {
        String globalId;
        String isAdmin = this.getPageCache().get(KEY_ISADMIN);
        if (isAdmin == null) {
            this.getPageCache().put(KEY_ISADMIN, String.valueOf(PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())));
        }
        if (StringUtils.isEmpty((CharSequence)(globalId = this.getPageCache().get(KEY_GLOBALID)))) {
            globalId = String.valueOf(System.currentTimeMillis());
            this.getPageCache().put(KEY_GLOBALID, globalId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_EDIT, BAR_SORT, BAR_ADDFLOW, BAR_FIRSTADDFLOW, BAR_REFRESH});
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        String flowIdStr = allConfigMap.get(KEY_FLOWIDS);
        this.updateControlVisible(flowIdStr);
        if (StringUtils.isEmpty((CharSequence)flowIdStr)) {
            return;
        }
        ArrayList<Long> flowIdList = new ArrayList<Long>(16);
        for (String flowId : flowIdStr.split(",")) {
            flowIdList.add(Long.parseLong(flowId));
        }
        JSONArray configArray = BusinessFlowCardServiceHelper.getFlowConfigArray(flowIdList);
        if (configArray != null && configArray.size() > 0) {
            String crtFlowId;
            JSONObject configData = new JSONObject().fluentPut("graphData", (Object)configArray).fluentPut("openType", (Object)FlowCardOpenTypeEnum.VIEW.getOpenType());
            String appId = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isEmpty((CharSequence)appId)) {
                appId = "home";
            }
            if (!StringUtils.isEmpty((CharSequence)(crtFlowId = this.getView().getMainView().getPageCache().get(appId + "_" + KEY_CRTFLOWID)))) {
                configData.fluentPut("activeId", (Object)crtFlowId);
            }
            FlowCardFormUtil.setDataToCustomCtl((IFormView)this.getView(), (String)this.getGlobalId(), (FlowCardMethodTypeEnum)FlowCardMethodTypeEnum.INITGRAPH, (JSONObject)configData, null, (boolean)true, null);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getKey();
        if ("cusflow".equals(key)) {
            String eventName = e.getEventName();
            String eventArgs = e.getEventArgs();
            JSONObject argsJson = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)eventArgs)) {
                argsJson = (JSONObject)SerializationUtils.fromJsonString((String)eventArgs, JSONObject.class);
            }
            if (eventName.equals("changeLabel")) {
                String flowId = argsJson.getString("id");
                String appId = this.getView().getFormShowParameter().getAppId();
                if (StringUtils.isEmpty((CharSequence)appId)) {
                    appId = "home";
                }
                this.getView().getMainView().getPageCache().put(appId + "_" + KEY_CRTFLOWID, flowId);
            } else if (eventName.equals("clickNode")) {
                this.doJumpForm(argsJson);
            }
        }
    }

    public void click(EventObject e) {
        String key;
        Object source = e.getSource();
        String string = key = source instanceof Control ? ((Control)source).getKey() : "";
        if (BAR_EDIT.equals(key)) {
            this.showEditForm();
        } else if (BAR_FIRSTADDFLOW.equals(key) || BAR_ADDFLOW.equals(key)) {
            this.showFlowSchemeList();
        } else if (BAR_SORT.equals(key)) {
            String flowIdStr = (String)this.getAllConfigMap().get(KEY_FLOWIDS);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gbs_flowsort");
            showParameter.getCustomParams().put(KEY_FLOWIDS, flowIdStr);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SORTFLOW_BACK));
            this.getView().showForm(showParameter);
        } else if (BAR_REFRESH.equals(key)) {
            this.refreshCard(this.getAllConfigMap());
        }
    }

    private void showFlowSchemeList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"gbs_flowscheme", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u6d41\u7a0b\u5bfc\u822a\u5e93", (String)"FlowCardViewPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
        listShowParameter.setFormId("gbs_addflow_f7");
        listShowParameter.setMultiSelect(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParam("nolink", (Object)true);
        listShowParameter.setCustomParam(KEY_ISADMIN, (Object)this.getPageCache().get(KEY_ISADMIN));
        Map cardConfigMap = this.getAllConfigMap();
        String flowIdStr = (String)cardConfigMap.get(KEY_FLOWIDS);
        if (StringUtils.isNotEmpty((CharSequence)flowIdStr)) {
            String[] flowStrArr = flowIdStr.split(",");
            Object[] flowIdArr = new Long[flowStrArr.length];
            for (int i = 0; i < flowStrArr.length; ++i) {
                flowIdArr[i] = Long.parseLong(flowStrArr[i]);
            }
            listShowParameter.setSelectedRows(flowIdArr);
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SELECTFLOW_BACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_SELECTFLOW_BACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows.isEmpty()) {
                    return;
                }
                if (selectedRows.size() == 1) {
                    Label title = (Label)this.getControl("title");
                    title.setText(selectedRows.get(0).getName());
                    Iterator flowDym = BusinessDataServiceHelper.loadSingle((String)"gbs_flowscheme", (String)"name", (QFilter[])new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue()).toArray());
                    if (flowDym == null) {
                        return;
                    }
                    OrmLocaleValue nameValue = (OrmLocaleValue)flowDym.get("name");
                    String cardTitleLocaleStr = nameValue.entrySet().toString();
                    Map cardInfo = this.getAllConfigMap();
                    cardInfo.put("cardtitle", cardTitleLocaleStr);
                    this.getPageCache().put("cardTitleMapEntry", cardTitleLocaleStr);
                    this.updateAllConfigMap(cardInfo);
                }
                StringBuilder flowIdSb = new StringBuilder();
                for (ListSelectedRow listSelectedRow : selectedRows) {
                    String newFlowId = String.valueOf(listSelectedRow.getPrimaryKeyValue());
                    if (flowIdSb.length() < 1) {
                        flowIdSb.append(newFlowId);
                        continue;
                    }
                    flowIdSb.append(',');
                    flowIdSb.append(newFlowId);
                }
                Map cardConfigMap = this.getAllConfigMap();
                cardConfigMap.put(KEY_FLOWIDS, flowIdSb.toString());
                this.updateAllConfigMap(cardConfigMap);
                this.refreshCard(cardConfigMap);
            }
        } else if (KEY_SORTFLOW_BACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String flowIdStr = (String)returnData;
            Map cardConfigMap = this.getAllConfigMap();
            cardConfigMap.put(KEY_FLOWIDS, flowIdStr);
            this.updateAllConfigMap(cardConfigMap);
            this.refreshCard(cardConfigMap);
        } else if (KEY_EDIT_BACK.equals(actionId)) {
            this.refreshCard(this.getAllConfigMap());
        }
    }

    private void updateControlVisible(String flowIdStr) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_SORT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_ADDFLOW});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_EDIT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_REFRESH});
        if (StringUtils.isEmpty((CharSequence)flowIdStr)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PANE_ADDFLOW});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PANE_CUSTOMPANEL});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PANE_CUSTOMPANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PANE_ADDFLOW});
        }
        if (this.isDesignMode()) {
            if (!StringUtils.isEmpty((CharSequence)flowIdStr)) {
                String[] flowIdArr;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_ADDFLOW});
                if (Boolean.parseBoolean(this.getPageCache().get(KEY_ISADMIN))) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_EDIT});
                }
                if ((flowIdArr = flowIdStr.split(",")).length > 1) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_SORT});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_REFRESH});
            if (StringUtils.isEmpty((CharSequence)flowIdStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{PANE_ADDFLOW});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{PANE_CUSTOMPANEL});
            }
        }
    }

    private void showEditForm() {
        String crtFlowId;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = "home";
        }
        if (StringUtils.isEmpty((CharSequence)(crtFlowId = this.getView().getMainView().getPageCache().get(appId + "_" + KEY_CRTFLOWID)))) {
            String[] flowIdArr = ((String)this.getAllConfigMap().get(KEY_FLOWIDS)).split(",");
            crtFlowId = flowIdArr[0];
        }
        DynamicObject schemeDym = QueryServiceHelper.queryOne((String)"gbs_flowscheme", (String)"id,ispreset,number", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(crtFlowId)).toArray());
        boolean isPreSet = schemeDym.getBoolean("ispreset");
        String flowNum = schemeDym.getString("number");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String lockKey = crtFlowId + currentUserId + IS_LOCKED;
        String isLocked = this.getView().getPageCache().get(lockKey);
        if (!"1".equals(isLocked) && !isPreSet) {
            MutexLockInfo metexLockInfo = new MutexLockInfo(crtFlowId, flowNum, "default_netctrl", "gbs_flowscheme", "modify", true, "default");
            try (DataMutex dataMutex = DataMutex.create();){
                boolean isMutexLocked = dataMutex.require(metexLockInfo);
                if (isMutexLocked) {
                    this.getView().getPageCache().put(lockKey, "1");
                } else {
                    Map lockInfo = dataMutex.getLockInfo(crtFlowId, "default_netctrl", "gbs_flowscheme");
                    if (lockInfo != null && !lockInfo.isEmpty()) {
                        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                        long userId = Long.parseLong((String)lockInfo.get("userid"));
                        Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                        DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                        String personName = "";
                        if (userObj != null) {
                            personName = userObj.getString("name");
                        }
                        String errMsg = ResManager.loadKDString((String)"%1$s\uff1a%2$s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FlowSchemeListPlugin_4", (String)"bd-gbs-plugin", (Object[])new Object[]{flowNum, personName});
                        this.getView().showErrorNotification(errMsg);
                        return;
                    }
                }
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519:%1$s", (String)"FlowSchemeListPlugin_5", (String)"bd-gbs-plugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gbs_flowedit");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("flowid", (Object)Long.parseLong(crtFlowId));
        fsp.setCustomParam("ispreset", (Object)isPreSet);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_EDIT_BACK));
        this.getView().showForm(fsp);
    }

    private void doJumpForm(JSONObject argsJson) {
        String jumpType = argsJson.getString("jumpType");
        String formId = argsJson.getString("formId");
        String cusParam = argsJson.getString("cusParam");
        if (jumpType.equals(FlowCardJumpTypeEnum.APP.getJumpType())) {
            String appId = argsJson.getString("appId");
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            if (app == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u201d%s\u201c\u4e0d\u5b58\u5728\u3002", (String)"FlowCardViewPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]), appId));
            }
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)formId, (String)appId);
        } else if (jumpType.equals(FlowCardJumpTypeEnum.LINK.getJumpType())) {
            this.getView().openUrl(formId);
        } else {
            ShowType showType;
            logger.info("\u5904\u7406\u975e\u83dc\u5355\u8282\u70b9\u8df3\u8f6c\u5f00\u59cb...");
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            String appNum = AppMetadataCache.getAppInfo((String)formConfig.getBizAppNumber()).getAppId();
            boolean tileMenuModeEnable = MenuModeFactory.tileMenuModeEnable();
            String targetKey = !tileMenuModeEnable ? "_submaintab_" : "tabap";
            ShowType showType2 = showType = !tileMenuModeEnable ? ShowType.MainNewTabPage : ShowType.NewTabPage;
            if (!tileMenuModeEnable) {
                logger.info("\u5904\u7406\u6253\u5f00\u5e94\u7528\uff0c\u5e94\u7528id\uff1a" + appNum);
                OpenPageUtils.openApp((String)appNum, null, null, (IFormView)this.getView());
            }
            logger.info("\u5904\u7406\u6253\u5f00\u8868\u5355\uff0c\u8868\u5355\u7c7b\u578b\uff1a" + jumpType + "\u8868\u5355id" + formId);
            if (jumpType.equals(FlowCardJumpTypeEnum.REPORT.getJumpType())) {
                ReportShowParameter rsp = new ReportShowParameter();
                rsp.setFormId(formId);
                rsp.setAppId(appNum);
                rsp.getOpenStyle().setShowType(showType);
                rsp.getOpenStyle().setTargetKey(targetKey);
                this.getView().showForm((FormShowParameter)rsp);
            } else if (jumpType.equals(FlowCardJumpTypeEnum.OTHER.getJumpType())) {
                QFilter appQ = new QFilter("number", "=", (Object)formId);
                appQ.and("parentid", "=", (Object)ID_APPHOME);
                boolean isAppHome = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])appQ.toArray());
                if (!isAppHome) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId(formId);
                    fsp.setAppId(appNum);
                    fsp.getOpenStyle().setShowType(showType);
                    fsp.getOpenStyle().setTargetKey(targetKey);
                    if (!StringUtils.isEmpty((CharSequence)cusParam)) {
                        HashMap<String, String> paramMap = new HashMap<String, String>(16);
                        paramMap.put("flow_cusparam", cusParam);
                        fsp.setCustomParams(paramMap);
                    }
                    this.getView().showForm(fsp);
                }
            } else {
                String jumpPageKey = this.getPageCache().get(KEY_JUMPPAGE);
                if (StringUtils.isEmpty((CharSequence)jumpPageKey)) {
                    jumpPageKey = String.valueOf(System.currentTimeMillis());
                    this.getPageCache().put(KEY_JUMPPAGE, jumpPageKey);
                }
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId(formId);
                listShowParameter.setPageId(jumpPageKey + "_" + formId);
                listShowParameter.setAppId(appNum);
                listShowParameter.getOpenStyle().setShowType(showType);
                if (!StringUtils.isEmpty((CharSequence)cusParam)) {
                    HashMap<String, String> paramMap = new HashMap<String, String>(16);
                    paramMap.put("flow_cusparam", cusParam);
                    listShowParameter.setCustomParams(paramMap);
                }
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private String getGlobalId() {
        return this.getPageCache().get(KEY_GLOBALID);
    }
}

