/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bd.gbs.core.flow.common.util.FlowSchemeExportUtil;
import kd.bd.gbs.core.flow.common.util.ZipTools;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class FlowSchemeListPlugin
extends AbstractListPlugin {
    private static final String KEY_FLOWEDIT_BACK = "floweditback";
    private static final String CACHE_APPID = "appid";
    private static final String KEY_IMPORT_BACK = "importcallback";
    private static final String KEY_PAGE = "pagekey";
    private static final String KEY_ISADMIN = "isadmin";
    private static final String BAR_NEW = "tblnew";
    private static final String BAR_DEL = "tbldel";
    private static final String BAR_IMPORT = "import";
    private static final String BAR_EXPORT = "export";
    private static final String IS_LOCKED = "isLocked";
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_EXPORT});
        this.addClickListeners(new String[]{BAR_IMPORT});
    }

    public void initialize() {
        boolean isAdmin = false;
        String isAdminCache = this.getPageCache().get(KEY_ISADMIN);
        if (StringUtils.isEmpty((CharSequence)isAdminCache)) {
            isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
            this.getPageCache().put(KEY_ISADMIN, String.valueOf(isAdmin));
        } else {
            isAdmin = Boolean.parseBoolean(isAdminCache);
        }
        if (!isAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_NEW, BAR_DEL, BAR_IMPORT, BAR_EXPORT});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Object isLink = this.getView().getFormShowParameter().getCustomParam("nolink");
        if (isLink != null && ((Boolean)isLink).booleanValue()) {
            args.getListColumn("number").setHyperlink(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if ("newscheme".equals(key)) {
            String appId = this.getPageCache().get(CACHE_APPID);
            if (StringUtils.isEmpty((CharSequence)appId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u540e\u518d\u65b0\u589e\u6d41\u7a0b\u3002", (String)"FlowSchemeListPlugin_6", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                return;
            }
            this.showFLowEditView(null, null, appId, false);
        } else if ("copyscheme".equals(key)) {
            if (this.getSelectedRows().size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FlowSchemeListPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject flowDym = QueryServiceHelper.queryOne((String)"gbs_flowscheme", (String)"id,number,bizapp", (QFilter[])new QFilter("id", "=", this.getFocusRowPkId()).toArray());
            if (flowDym == null) {
                return;
            }
            this.showFLowEditView(flowDym.getLong("id"), flowDym.getString("number"), flowDym.getString("bizapp"), true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        if ("delete".equals(arg.getOperateKey()) && arg.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "import": {
                String formNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("gbs_flowimport");
                parameter.setCustomParam("formnumber", (Object)formNumber);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, KEY_IMPORT_BACK);
                parameter.setCloseCallBack(callBack);
                this.getView().showForm(parameter);
                break;
            }
            case "export": {
                ListSelectedRowCollection rows = this.getSelectedRows();
                Object[] rowPKKeyArr = rows.getPrimaryKeyValues();
                if (rowPKKeyArr.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FlowSchemeListPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> infoIdList = new ArrayList<Long>(rows.size());
                HashMap<Long, String> idNumMap = new HashMap<Long, String>(rows.size());
                for (ListSelectedRow listSelectedRow : rows) {
                    Long id = (Long)listSelectedRow.getPrimaryKeyValue();
                    String number = listSelectedRow.getNumber();
                    infoIdList.add(id);
                    idNumMap.put(id, number);
                }
                this.executeExport(infoIdList, idNumMap);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeExport(List<Long> infoIdList, Map<Long, String> idNumMap) {
        IFormView formView = this.getView();
        HashMap<Long, ArrayList<String>> nodeMap = new HashMap<Long, ArrayList<String>>(16);
        try (DataSet nodeDataSet = null;){
            nodeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gbs_flownode", (String)"id,flowscheme", (QFilter[])new QFilter("flowscheme.id", "in", (Object)infoIdList.toArray()).toArray(), null);
            for (Row row : nodeDataSet) {
                Long flowId = row.getLong("flowscheme");
                String nodeId = row.getString("id");
                ArrayList<String> nodeIdList = (ArrayList<String>)nodeMap.get(flowId);
                if (nodeIdList == null) {
                    nodeIdList = new ArrayList<String>(16);
                }
                nodeIdList.add(nodeId);
                nodeMap.put(row.getLong("flowscheme"), nodeIdList);
            }
        }
        boolean isSingle = infoIdList.size() <= 1;
        String firstName = idNumMap.get(infoIdList.get(0));
        String zipName = FlowSchemeExportUtil.getZipName((String)firstName, (boolean)isSingle);
        File zipFile = new File(zipName);
        try {
            Map resultSqlMap = FlowSchemeExportUtil.expSql(infoIdList, nodeMap);
            if (resultSqlMap == null) {
                return;
            }
            ArrayList<ZipTools.ZipParam> lstParam = new ArrayList<ZipTools.ZipParam>(infoIdList.size());
            for (Long flowId : infoIdList) {
                String flowNum = idNumMap.get(flowId);
                String fileName = "";
                Map sqlValueMap = (Map)resultSqlMap.get(String.valueOf(flowId));
                for (Map.Entry entry : sqlValueMap.entrySet()) {
                    if ("sql".equals(entry.getKey())) {
                        fileName = flowNum + "_pre_ins.SQL";
                        String sqlValue = (String)entry.getValue();
                        ByteArrayInputStream sqlInput = new ByteArrayInputStream(sqlValue.getBytes(StandardCharsets.UTF_8));
                        ZipTools.ZipParam param = new ZipTools.ZipParam();
                        param.isfile = true;
                        param.name = fileName;
                        param.stream = sqlInput;
                        lstParam.add(param);
                        continue;
                    }
                    if (!"xml".equals(entry.getKey()) || entry.getValue() == null) continue;
                    fileName = flowNum + "_pre_ins.XML";
                    Object xmlValue = entry.getValue();
                    HashMap tagFileMap = (HashMap)xmlValue;
                    byte[] barray = null;
                    for (Map.Entry tagFile : tagFileMap.entrySet()) {
                        StringWriter sw = (StringWriter)tagFile.getValue();
                        barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                    }
                    ByteArrayInputStream xmlImput = new ByteArrayInputStream(barray);
                    ZipTools.ZipParam param = new ZipTools.ZipParam();
                    param.isfile = true;
                    param.name = fileName;
                    param.stream = xmlImput;
                    lstParam.add(param);
                }
            }
            ZipTools.zipStreams(lstParam, (File)zipFile);
        }
        catch (Exception e) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%1$s", (String)"FlowSchemeListPlugin_2", (String)"bd-gbs-plugin", (Object[])new Object[0]), e.getMessage()));
            return;
        }
        try (FileInputStream zipFileInputStream = new FileInputStream(zipFile);){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(FlowSchemeExportUtil.getZipName((String)firstName, (boolean)isSingle), (InputStream)zipFileInputStream, 5000);
            zipFileInputStream.close();
            formView.download(urls);
        }
        catch (Exception e) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%1$s", (String)"FlowSchemeListPlugin_2", (String)"bd-gbs-plugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            zipFile.delete();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("number".equals(fieldName)) {
            DynamicObject flowDym = QueryServiceHelper.queryOne((String)"gbs_flowscheme", (String)"id,number,bizapp", (QFilter[])new QFilter("id", "=", this.getFocusRowPkId()).toArray());
            if (flowDym == null) {
                return;
            }
            this.showFLowEditView(flowDym.getLong("id"), flowDym.getString("number"), flowDym.getString("bizapp"), false);
        }
    }

    private void showFLowEditView(Long flowId, String flowNum, String appId, boolean isCopy) {
        boolean isPreSet = false;
        if (flowId != null) {
            DynamicObject schemeDym = QueryServiceHelper.queryOne((String)"gbs_flowscheme", (String)"id,ispreset", (QFilter[])new QFilter("id", "=", (Object)flowId).toArray());
            isPreSet = schemeDym.getBoolean("ispreset");
            long currentUserId = UserServiceHelper.getCurrentUserId();
            String lockKey = String.valueOf(flowId) + currentUserId + IS_LOCKED;
            String isLocked = this.getView().getPageCache().get(lockKey);
            if (!"1".equals(isLocked) && !isPreSet) {
                MutexLockInfo metexLockInfo = new MutexLockInfo(String.valueOf(flowId), flowNum, "default_netctrl", "gbs_flowscheme", "modify", true, "default");
                try (DataMutex dataMutex = DataMutex.create();){
                    boolean isMutexLocked = dataMutex.require(metexLockInfo);
                    if (isMutexLocked) {
                        this.getView().getPageCache().put(lockKey, "1");
                    } else {
                        Map lockInfo = dataMutex.getLockInfo(String.valueOf(flowId), "default_netctrl", "gbs_flowscheme");
                        if (lockInfo != null && !lockInfo.isEmpty()) {
                            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                            long userId = Long.parseLong((String)lockInfo.get("userid"));
                            Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                            DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                            String personName = "";
                            if (userObj != null) {
                                personName = userObj.getString("name");
                            }
                            String errMsg = ResManager.loadKDString((String)"%1$s\uff1a%2$s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FlowSchemeListPlugin_4", (String)"bd-gbs-plugin", (Object[])new Object[]{flowNum, personName});
                            this.getView().showErrorNotification(errMsg);
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519:%1$s", (String)"FlowSchemeListPlugin_5", (String)"bd-gbs-plugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gbs_flowedit");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (flowId != null) {
            fsp.setCustomParam("flowid", (Object)flowId);
            fsp.setCustomParam("iscopy", (Object)isCopy);
            fsp.setCustomParam("ispreset", (Object)isPreSet);
        }
        fsp.setCustomParam("crtappid", (Object)appId);
        String pageKey = this.getPageCache().get(KEY_PAGE);
        if (pageKey == null) {
            pageKey = String.valueOf(System.currentTimeMillis());
            this.getPageCache().put(KEY_PAGE, pageKey);
        }
        fsp.setPageId(String.valueOf(flowId) + pageKey);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FLOWEDIT_BACK));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject message;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_FLOWEDIT_BACK.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (KEY_IMPORT_BACK.equals(actionId) && (message = (JSONObject)closedCallBackEvent.getReturnData()) != null) {
            String errorMessage = message.getString(ERROR);
            String successMessage = message.getString(SUCCESS);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%1$s", (String)"FlowSchemeListPlugin_3", (String)"bd-gbs-plugin", (Object[])new Object[0]), errorMessage));
            } else if (StringUtils.isNotBlank((CharSequence)successMessage)) {
                this.getView().showSuccessNotification(successMessage);
                this.getView().updateView();
            }
        }
    }
}

