/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.portal.util.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowSchemeTreeListPlugin
extends StandardTreeListPlugin {
    protected static final String BTN_NEW = "btnnew";
    protected static final String BTN_EDIT = "btnedit";
    protected static final String BTN_DELETE = "btndel";
    private static final String FILTER_KEYFIELD = "bizapp";
    private static final String CACHE_APPID = "appid";
    private static final String CACHE_APPMAP = "appmapcache";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void initializeTree(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.createRootNode();
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        root.setIsOpened(true);
        root.setChildren(this.buildMenuNode());
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String curNodeId = e.getNodeId().toString();
        if (StringUtils.equals((CharSequence)rootNode.getId(), (CharSequence)curNodeId)) {
            e.setChildNodes(this.buildMenuNode());
            TreeNode parent = rootNode.getTreeNode(curNodeId, 20);
            if (parent != null) {
                this.getTreeListView().getTreeView().expand(curNodeId);
            }
            return;
        }
        super.refreshNode(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        this.getPageCache().put(CACHE_APPID, null);
        if (node == null) {
            return null;
        }
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                Map cloudAppMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_APPMAP), Map.class);
                List appIds = (List)cloudAppMap.get(nodeId);
                if (appIds == null || appIds.isEmpty()) {
                    return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
                }
                return new QFilter(FILTER_KEYFIELD, "in", (Object)appIds);
            }
            case "app": {
                this.getPageCache().put(CACHE_APPID, nodeId);
                return new QFilter(FILTER_KEYFIELD, "in", (Object)nodeId);
            }
        }
        return null;
    }

    private List<TreeNode> buildMenuNode() {
        PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(this.getView());
        JSONArray cloudAndAppJsonArray = portalUsableFuncUtil.getAllAppsInSystem();
        ArrayList<TreeNode> cloundNodeList = new ArrayList<TreeNode>(16);
        HashMap cloudAppMap = new HashMap(16);
        for (Object value : cloudAndAppJsonArray) {
            JSONArray cloudNext = (JSONArray)value;
            TreeNode cloundNode = new TreeNode();
            ArrayList<TreeNode> appNodeList = new ArrayList<TreeNode>(16);
            ArrayList<String> appIds = new ArrayList<String>(16);
            for (Object o : cloudNext) {
                JSONObject next = (JSONObject)o;
                if (next == null) continue;
                Map localNameMap = (Map)JSONObject.toJavaObject((JSON)next.getJSONObject("name"), Map.class);
                String nodeName = LocaleString.fromMap((Map)localNameMap).getLocaleValue();
                if (Boolean.TRUE.equals(next.getBoolean("iscloud"))) {
                    cloundNode.setData((Object)"cloud");
                    cloundNode.setId(next.getString("id"));
                    cloundNode.setText(nodeName);
                    cloundNode.setParentid("0");
                    continue;
                }
                String appId = next.getString("id");
                TreeNode appNode = new TreeNode();
                appNode.setData((Object)"app");
                appNode.setId(appId);
                appNode.setText(nodeName);
                appNode.setParentid(next.getString("cloudid"));
                appIds.add(appId);
                appNodeList.add(appNode);
            }
            if (!appNodeList.isEmpty()) {
                cloundNode.addChildren(appNodeList);
            }
            cloundNodeList.add(cloundNode);
            cloudAppMap.put(cloundNode.getId(), appIds);
        }
        this.getPageCache().put(CACHE_APPMAP, SerializationUtils.toJsonString(cloudAppMap));
        return cloundNodeList;
    }

    protected boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }
}

