/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.pojo.LotCodeRuleEntryInfo;
import kd.bd.sbd.business.pojo.LotCodeRuleInfo;
import kd.bd.sbd.enums.LotCodeFormatEnum;
import kd.bd.sbd.enums.LotCodeItemTypeEnum;
import kd.bd.sbd.enums.UseModeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class LotCodeRuleProcessor {
    private static final String COL_ENTRYFIELD = "entryfield";
    private static final String COL_SUBENTRYFIELD = "subentryfield";
    private static final String COL_MATERIAL = "material";
    private static final String COL_LOTMAP = "lotmap";
    private static final String BLANK = " ";
    private String entryEntityKey = "";
    private String materialKey = "";
    private String lotKey = "";
    private boolean isSubEntry = false;
    private static Map<String, String> formIdToOrgFieldMap = new HashMap<String, String>(4);
    private static Log logger = LogFactory.getLog(LotCodeRuleProcessor.class);

    @SdkDeprecated
    public Map<Integer, String> getLotCode(DynamicObject dataEntity, Map<String, String> params) {
        this.entryEntityKey = params.get(COL_ENTRYFIELD);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(this.entryEntityKey);
        return this.getLotCode(dataEntity, entry, params);
    }

    /*
     * WARNING - void declaration
     */
    @SdkDeprecated
    public Map<Integer, String> getLotCode(DynamicObject dataEntity, DynamicObjectCollection entry, Map<String, String> params) {
        Map<Object, DynamicObject> ruleMaps;
        this.entryEntityKey = params.get(COL_ENTRYFIELD);
        this.materialKey = params.get(COL_MATERIAL);
        this.lotKey = params.get(COL_LOTMAP);
        this.isSubEntry = dataEntity.getDataEntityType().getProperties().get((Object)this.entryEntityKey) == null;
        HashMap<Integer, LotCodeRuleInfo> lotCodeRuleMap = new HashMap<Integer, LotCodeRuleInfo>();
        HashMap<String, List<Integer>> propSeqMap = new HashMap<String, List<Integer>>();
        HashMap<Integer, DynamicObject> lotMap = new HashMap<Integer, DynamicObject>();
        HashMap<Integer, DynamicObject> materialNumMap = new HashMap<Integer, DynamicObject>();
        HashMap<Integer, String> msgMap = new HashMap<Integer, String>();
        long time1 = System.currentTimeMillis();
        String formId = dataEntity.getDataEntityType().getName();
        if (formIdToOrgFieldMap.containsKey(formId)) {
            String orgKey = formIdToOrgFieldMap.get(formId);
            Map<Object, Map<Object, DynamicObject>> orgToMaterialInvInfoMap = this.getInvOrgToInvMaterialInfo(entry, orgKey);
            ruleMaps = this.getCodeRules(entry, orgToMaterialInvInfoMap, orgKey);
            this.dealWithLotRule(entry, materialNumMap, lotMap, msgMap, ruleMaps, orgToMaterialInvInfoMap, orgKey);
        } else {
            ruleMaps = this.getAllCodeRules(entry);
            for (DynamicObject row : entry) {
                void var17_18;
                DynamicObject material = row.getDynamicObject(this.materialKey);
                if (material == null || StringUtils.isNotEmpty((String)row.getString(this.lotKey))) continue;
                Object lotCodeRule = null;
                String string = "";
                try {
                    lotCodeRule = this.getLotCodeRule(material, ruleMaps, row.getInt("seq"));
                    if (lotCodeRule == null) {
                        continue;
                    }
                }
                catch (KDBizException e) {
                    String string2 = e.getMessage();
                }
                materialNumMap.put(row.getInt("seq"), material);
                if (StringUtils.isEmpty((String)var17_18)) {
                    lotMap.put(row.getInt("seq"), (DynamicObject)lotCodeRule);
                    continue;
                }
                msgMap.put(row.getInt("seq"), "ERROR" + (String)var17_18);
            }
        }
        int seq = 0;
        if (this.isSubEntry) {
            seq = Integer.parseInt(params.get("seq"));
        }
        long time2 = System.currentTimeMillis();
        logger.info("\u5c01\u88c5" + entry.size() + "\u4e2a\u7269\u6599\u5bf9\u5e94\u7684\u6279\u53f7\u7f16\u7801\u89c4\u5219\u7528\u65f6\uff1a" + (time2 - time1) + "ms");
        if (lotMap.size() == 0) {
            return msgMap;
        }
        for (Map.Entry entry2 : lotMap.entrySet()) {
            DynamicObject lotCodeRule = (DynamicObject)entry2.getValue();
            HashMap<String, DynamicObject> ruleEntryMap = new HashMap<String, DynamicObject>();
            DynamicObjectCollection lotCodeRuleEntry = lotCodeRule.getDynamicObjectCollection("entryentity");
            ArrayList<Object> lotItemIds = new ArrayList<Object>();
            boolean enableLotAttr = true;
            ILocaleString lotAttrName = null;
            for (DynamicObject row : lotCodeRuleEntry) {
                enableLotAttr = row.getBoolean("lotprop.enable");
                if (!enableLotAttr) {
                    lotAttrName = row.getLocaleString("lotprop.name");
                    lotItemIds.clear();
                    ruleEntryMap.clear();
                    break;
                }
                lotItemIds.add(row.get("lotprop.id"));
                ruleEntryMap.put(row.getString("lotprop.id"), row);
            }
            if (!this.isSubEntry) {
                seq = (Integer)entry2.getKey();
            }
            if (enableLotAttr) {
                LotCodeRuleInfo codeInfo = this.buildCodeInfo(seq, (Integer)entry2.getKey(), lotItemIds, ruleEntryMap, dataEntity, entry, (DynamicObject)materialNumMap.get(entry2.getKey()), lotCodeRule);
                codeInfo.setRuleId(lotCodeRule.get("id"));
                codeInfo.setMatNumOnly(lotCodeRule.getBoolean("matnumonly"));
                codeInfo.setMaterialId(((DynamicObject)materialNumMap.get(entry2.getKey())).get("id"));
                lotCodeRuleMap.put((Integer)entry2.getKey(), codeInfo);
                if (!codeInfo.isRight() || !codeInfo.isHaveSerial()) continue;
                this.setSerialSize(propSeqMap, codeInfo);
                continue;
            }
            msgMap.put((Integer)entry2.getKey(), "ERROR" + String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4f9b\u5e94\u94fe\u7f16\u7801\u89c4\u5219\u7684\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027\u672a\u542f\u7528\u3002", (String)"LotCodeRuleProcessor_6", (String)"bd-sbd-business", (Object[])new Object[0]), entry2.getKey(), lotAttrName));
        }
        Map<Integer, String> result = this.getLotCodeNum(lotCodeRuleMap, propSeqMap);
        result.putAll(msgMap);
        return result;
    }

    private Map<Object, Map<Object, DynamicObject>> getInvOrgToInvMaterialInfo(DynamicObjectCollection entry, String orgKey) {
        HashMap<Object, Set> orgToMasterIds = new HashMap<Object, Set>(entry.size());
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject org = row.getDynamicObject(orgKey);
            DynamicObject material = row.getDynamicObject(this.materialKey);
            if (org == null || material == null) continue;
            Object orgid = org.get("id");
            Object masterId = material.get("masterid.id");
            Set set = orgToMasterIds.computeIfAbsent(orgid, k -> new HashSet());
            set.add(masterId);
        }
        HashMap<Object, Map<Object, DynamicObject>> orgToMaterialInvInfoMap = new HashMap<Object, Map<Object, DynamicObject>>(orgToMasterIds.size());
        for (Map.Entry mapping : orgToMasterIds.entrySet()) {
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)mapping.getKey()));
            qFilter.and("masterid.id", "in", mapping.getValue());
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
            Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
            for (Map.Entry dynamicObjectEntry : materialDymLoad.entrySet()) {
                DynamicObject invInfo = (DynamicObject)dynamicObjectEntry.getValue();
                if (invInfo == null) continue;
                Object masterid = invInfo.get("masterid.id");
                map.put(masterid, invInfo);
            }
            orgToMaterialInvInfoMap.put(mapping.getKey(), map);
        }
        return orgToMaterialInvInfoMap;
    }

    private void dealWithLotRule(DynamicObjectCollection entry, Map<Integer, DynamicObject> materialNumMap, Map<Integer, DynamicObject> lotMap, Map<Integer, String> msgMap, Map<Object, DynamicObject> ruleMaps, Map<Object, Map<Object, DynamicObject>> orgToMaterialInvInfoMap, String orgKey) {
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject org = row.getDynamicObject(orgKey);
            if (org == null) continue;
            Map<Object, DynamicObject> masterIdToInvInfoMapping = orgToMaterialInvInfoMap.get(org.getPkValue());
            DynamicObject material = row.getDynamicObject(COL_MATERIAL);
            if (material == null || StringUtils.isNotEmpty((String)row.getString(this.lotKey)) || (material = masterIdToInvInfoMapping.get(material.get("masterid.id"))) == null) continue;
            DynamicObject lotCodeRule = null;
            String msg = "";
            try {
                lotCodeRule = this.getLotCodeRule(material, ruleMaps, row.getInt("seq"));
                if (lotCodeRule == null) {
                    continue;
                }
            }
            catch (KDBizException e) {
                msg = e.getMessage();
            }
            materialNumMap.put(row.getInt("seq"), material);
            if (StringUtils.isEmpty((String)msg)) {
                lotMap.put(row.getInt("seq"), lotCodeRule);
                continue;
            }
            msgMap.put(row.getInt("seq"), "ERROR" + msg);
        }
    }

    public List<String> getSnCodeNum(DynamicObject dataEntity, Map<String, Object> returnParam) {
        ArrayList<Integer> seqs;
        String subEntryEntityKey;
        this.entryEntityKey = (String)returnParam.get(COL_ENTRYFIELD);
        int seq = (Integer)returnParam.get("seq");
        int afterentitySeq = 0;
        if (returnParam.get("afterentitySeq") != null) {
            afterentitySeq = (Integer)returnParam.get("afterentitySeq");
        }
        boolean hasSubEntry = false;
        if (returnParam.containsKey(COL_SUBENTRYFIELD)) {
            hasSubEntry = true;
            subEntryEntityKey = (String)returnParam.get(COL_SUBENTRYFIELD);
        } else {
            subEntryEntityKey = "";
        }
        DynamicObject snRule = (DynamicObject)returnParam.get("snrule");
        DynamicObject material = (DynamicObject)returnParam.get(COL_MATERIAL);
        int size = (Integer)returnParam.get("size");
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((Object)snRule.getPkValue(), (String)"bd_lotcoderule");
        HashMap<String, DynamicObject> ruleEntryMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection lotCodeRuleEntry = codeRule.getDynamicObjectCollection("entryentity");
        ArrayList<Object> lotItemIds = new ArrayList<Object>();
        for (Object row : lotCodeRuleEntry) {
            lotItemIds.add(row.get("lotprop.id"));
            ruleEntryMap.put(row.getString("lotprop.id"), (DynamicObject)row);
        }
        if (hasSubEntry) {
            Map<Object, DynamicObject> items = this.getLotCodeItems(lotItemIds.toArray());
            for (Map.Entry entry : items.entrySet()) {
                long count = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("entryentity").stream().filter(i -> i.getString("entryentityid").equals(subEntryEntityKey)).count();
                if (count <= 0L) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7269\u6599\u5e8f\u5217\u53f7\u7f16\u7801\u89c4\u5219\u5305\u542b\u5b50\u5206\u5f55\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u4e0d\u5305\u542b\u5b50\u5206\u5f55\u5b57\u6bb5\u7684\u5e8f\u5217\u53f7\u7f16\u7801\u89c4\u5219\u3002", (String)"LotCodeRuleProcessor_8", (String)"bd-sbd-business", (Object[])new Object[0]));
            }
        }
        LotCodeRuleInfo codeInfo = this.buildCodeInfo(seq, afterentitySeq, lotItemIds, ruleEntryMap, dataEntity, lotCodeRuleEntry, material, codeRule);
        codeInfo.setRuleId(codeRule.get("id"));
        codeInfo.setMatNumOnly(codeRule.getBoolean("matnumonly"));
        codeInfo.setMaterialId(material.get("id"));
        HashMap<Integer, LotCodeRuleInfo> codeRuleMap = new HashMap<Integer, LotCodeRuleInfo>();
        codeRuleMap.put(0, codeInfo);
        HashMap hashMap = new HashMap();
        if (codeInfo.isRight() && codeInfo.isHaveSerial()) {
            seqs = new ArrayList<Integer>(size);
            for (int i2 = 0; i2 < size; ++i2) {
                seqs.add(i2);
            }
        } else {
            if (!codeInfo.isHaveSerial()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u672a\u914d\u7f6e\u6d41\u6c34\u53f7\uff0c\u65e0\u6cd5\u751f\u6210\u5e8f\u5217\u53f7\u3002", (String)"LotCodeRuleProcessor_9", (String)"bd-sbd-business", (Object[])new Object[0]));
            }
            throw new KDBizException(codeInfo.getMsg());
        }
        hashMap.put(codeRule.getString("id"), seqs);
        Integer serialNum = 0;
        long begin = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"bd/sbd/sncoderule");){
            lock.lock();
            long end = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u9501\u7684\u65f6\u95f4\uff1a" + (end - begin) + "ms");
            try {
                serialNum = this.setMaxSerialNum(codeRuleMap, (List)hashMap.values().iterator().next());
                long end1 = System.currentTimeMillis();
                logger.info("\u8bbe\u7f6e\u6700\u5927\u6d41\u6c34\u53f7\u7684\u65f6\u95f4\uff1a" + (end1 - end) + "ms");
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        ArrayList<String> snNums = new ArrayList<String>(size);
        StringBuilder numsb = new StringBuilder();
        for (int i3 = 0; i3 < size; ++i3) {
            numsb.setLength(0);
            for (LotCodeRuleEntryInfo row : codeInfo.getEntry()) {
                if (StringUtils.isEmpty((String)row.getPropValue())) continue;
                if (numsb.length() > 0) {
                    numsb.append(row.getSplitsign());
                }
                if (row.getPropType() == LotCodeItemTypeEnum.SERIALNUM) {
                    serialNum = serialNum + codeInfo.getStep();
                    String seNum = serialNum.toString();
                    int max = codeInfo.getLenth() - seNum.length();
                    for (int j = 0; j < max; ++j) {
                        numsb.append('0');
                    }
                    numsb.append(seNum);
                    continue;
                }
                numsb.append(row.getPropValue());
            }
            snNums.add(numsb.toString());
        }
        return snNums;
    }

    public List<String> getSnCodeNum(DynamicObject dataEntity, DynamicObjectCollection entry, Map<String, Object> returnParam) {
        ArrayList<Integer> seqs;
        this.entryEntityKey = (String)returnParam.get(COL_ENTRYFIELD);
        int seq = (Integer)returnParam.get("seq");
        int afterentitySeq = 0;
        if (returnParam.get("afterentitySeq") != null) {
            afterentitySeq = (Integer)returnParam.get("afterentitySeq");
        }
        DynamicObject snRule = (DynamicObject)returnParam.get("snrule");
        DynamicObject material = (DynamicObject)returnParam.get(COL_MATERIAL);
        int size = (Integer)returnParam.get("size");
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((Object)snRule.getPkValue(), (String)"bd_lotcoderule");
        HashMap<String, DynamicObject> ruleEntryMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection lotCodeRuleEntry = codeRule.getDynamicObjectCollection("entryentity");
        ArrayList<Object> lotItemIds = new ArrayList<Object>();
        for (DynamicObject row : lotCodeRuleEntry) {
            lotItemIds.add(row.get("lotprop.id"));
            ruleEntryMap.put(row.getString("lotprop.id"), row);
        }
        LotCodeRuleInfo codeInfo = this.buildCodeInfo(seq, afterentitySeq, lotItemIds, ruleEntryMap, dataEntity, lotCodeRuleEntry, material, codeRule);
        codeInfo.setRuleId(codeRule.get("id"));
        codeInfo.setMatNumOnly(codeRule.getBoolean("matnumonly"));
        codeInfo.setMaterialId(material.get("id"));
        HashMap<Integer, LotCodeRuleInfo> codeRuleMap = new HashMap<Integer, LotCodeRuleInfo>();
        codeRuleMap.put(0, codeInfo);
        HashMap propSeqMap = new HashMap();
        if (codeInfo.isRight() && codeInfo.isHaveSerial()) {
            seqs = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                seqs.add(i);
            }
        } else {
            throw new KDBizException(codeInfo.getMsg());
        }
        propSeqMap.put(codeRule.getString("id"), seqs);
        Integer serialNum = 0;
        long begin = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"bd/sbd/sncoderule");){
            lock.lock();
            long end = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u9501\u7684\u65f6\u95f4\uff1a" + (end - begin) + "ms");
            try {
                serialNum = this.setMaxSerialNum(codeRuleMap, (List)propSeqMap.values().iterator().next());
                long end1 = System.currentTimeMillis();
                logger.info("\u8bbe\u7f6e\u6700\u5927\u6d41\u6c34\u53f7\u7684\u65f6\u95f4\uff1a" + (end1 - end) + "ms");
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        ArrayList<String> snNums = new ArrayList<String>(size);
        StringBuilder numsb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            numsb.setLength(0);
            for (LotCodeRuleEntryInfo row : codeInfo.getEntry()) {
                if (StringUtils.isEmpty((String)row.getPropValue())) continue;
                if (numsb.length() > 0) {
                    numsb.append(row.getSplitsign());
                }
                if (row.getPropType() == LotCodeItemTypeEnum.SERIALNUM) {
                    serialNum = serialNum + codeInfo.getStep();
                    String seNum = serialNum.toString();
                    int max = codeInfo.getLenth() - seNum.length();
                    for (int j = 0; j < max; ++j) {
                        numsb.append('0');
                    }
                    numsb.append(seNum);
                    continue;
                }
                numsb.append(row.getPropValue());
            }
            snNums.add(numsb.toString());
        }
        return snNums;
    }

    private DynamicObject getLotCodeRule(DynamicObject material, Map<Object, DynamicObject> ruleMaps, int seq) {
        DynamicObject rule = null;
        if (material.getBoolean("enablelot")) {
            Long pk = this.getRuleIdByMaterial(material);
            if (pk == null || pk == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u8bbe\u7f6e\u6279\u53f7\u7f16\u7801\u89c4\u5219\u3002", (String)"LotCodeRuleProcessor_0", (String)"bd-sbd-business", (Object[])new Object[0]), seq));
            }
            rule = ruleMaps.get(pk);
            boolean enable = rule.getBoolean("enable");
            if (!enable) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u7684\u4f9b\u5e94\u94fe\u7f16\u7801\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"LotCodeRuleProcessor_7", (String)"bd-sbd-business", (Object[])new Object[0]), seq));
            }
        }
        return rule;
    }

    private Map<Object, DynamicObject> getAllCodeRules(DynamicObjectCollection entry) {
        ArrayList<Long> pks = new ArrayList<Long>();
        for (DynamicObject row : entry) {
            DynamicObject material = row.getDynamicObject(this.materialKey);
            if (material == null || StringUtils.isNotEmpty((String)row.getString(this.lotKey)) || !material.getBoolean("enablelot")) continue;
            pks.add(this.getRuleIdByMaterial(material));
        }
        pks.remove(0L);
        if (pks.size() < 1) {
            return new HashMap<Object, DynamicObject>();
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"bd_lotcoderule");
    }

    private Map<Object, DynamicObject> getCodeRules(DynamicObjectCollection entry, Map<Object, Map<Object, DynamicObject>> orgToMaterialInvInfoMap, String orgKey) {
        ArrayList<Long> pks = new ArrayList<Long>();
        for (DynamicObject row : entry) {
            Map<Object, DynamicObject> masterToMaterialInvMap;
            DynamicObject material = row.getDynamicObject(COL_MATERIAL);
            DynamicObject org = row.getDynamicObject(orgKey);
            if (material == null || StringUtils.isNotEmpty((String)row.getString(this.lotKey)) || org == null || (material = (masterToMaterialInvMap = orgToMaterialInvInfoMap.get(org.getPkValue())).get(material.get("masterid.id"))) == null || !material.getBoolean("enablelot")) continue;
            pks.add(this.getRuleIdByMaterial(material));
        }
        pks.remove(0L);
        if (pks.size() < 1) {
            return new HashMap<Object, DynamicObject>();
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"bd_lotcoderule");
    }

    private void setSerialSize(Map<String, List<Integer>> propSeqMap, LotCodeRuleInfo codeInfo) {
        String firstKey = codeInfo.isMatNumOnly() ? codeInfo.getMaterialId().toString() : "";
        String key = firstKey + codeInfo.getPropCol() + codeInfo.getRuleId();
        List<Integer> seqs = propSeqMap.get(key);
        if (seqs == null) {
            seqs = new ArrayList<Integer>();
            seqs.add(codeInfo.getSeq());
            propSeqMap.put(key, seqs);
        } else {
            seqs.add(codeInfo.getSeq());
        }
    }

    private Map<Integer, String> getLotCodeNum(Map<Integer, LotCodeRuleInfo> lotCodeRuleMap, Map<String, List<Integer>> propSeqMap) {
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        long begin = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"bd/sbd/lotcoderule");){
            lock.lock();
            long end = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u9501\u7684\u65f6\u95f4\uff1a" + (end - begin) + "ms");
            try {
                begin = System.currentTimeMillis();
                for (List<Integer> seqs : propSeqMap.values()) {
                    Integer serialNum = this.setMaxSerialNum(lotCodeRuleMap, seqs);
                    this.setSerialNum(lotCodeRuleMap, seqs, serialNum);
                }
                end = System.currentTimeMillis();
                logger.info("\u8bbe\u7f6e\u6700\u5927\u6d41\u6c34\u53f7\u7684\u65f6\u95f4\uff1a" + (end - begin) + "ms");
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        for (Map.Entry<Integer, LotCodeRuleInfo> lotCodeRuleMapEntry : lotCodeRuleMap.entrySet()) {
            Integer seq = lotCodeRuleMapEntry.getKey();
            LotCodeRuleInfo info = lotCodeRuleMapEntry.getValue();
            if (info.isRight()) {
                resultMap.put(seq, this.buildLotCodeNum(info.getEntry()));
                continue;
            }
            resultMap.put(seq, "ERROR" + info.getMsg());
        }
        return resultMap;
    }

    private void setSerialNum(Map<Integer, LotCodeRuleInfo> lotCodeRuleMap, List<Integer> seqs, Integer serialNum) {
        LotCodeRuleInfo info = lotCodeRuleMap.get(seqs.get(0));
        StringBuilder sbnum = new StringBuilder();
        block0: for (int seq : seqs) {
            info = lotCodeRuleMap.get(seq);
            serialNum = serialNum + info.getStep();
            String seNum = serialNum.toString();
            sbnum.setLength(0);
            for (int i = 0; i < info.getLenth() - seNum.length(); ++i) {
                sbnum.append('0');
            }
            sbnum.append(seNum);
            for (LotCodeRuleEntryInfo entry : info.getEntry()) {
                if (entry.getPropType() != LotCodeItemTypeEnum.SERIALNUM) continue;
                entry.setPropValue(sbnum.toString());
                continue block0;
            }
        }
    }

    private Integer setMaxSerialNum(Map<Integer, LotCodeRuleInfo> lotCodeRuleMap, List<Integer> seqs) {
        LotCodeRuleInfo info = lotCodeRuleMap.get(seqs.get(0));
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("lotcoderule", "=", info.getRuleId()));
        if (info.isMatNumOnly()) {
            qfilters.add(new QFilter(COL_MATERIAL, "=", info.getMaterialId()));
        }
        if (StringUtils.isNotEmpty((String)info.getPropCol())) {
            qfilters.add(new QFilter("accordprop", "=", (Object)info.getPropCol()));
        }
        DynamicObject maxSerialEntity = BusinessDataServiceHelper.loadSingle((String)"bd_lotcoderule_maxserial", (String)"id,maxserial", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        Integer serialNum = 0;
        int maxSerialNum = 0;
        if (maxSerialEntity == null) {
            maxSerialEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_lotcoderule_maxserial"));
            serialNum = Integer.parseInt(info.getSettingValue().trim()) - info.getStep();
            maxSerialEntity.set("lotcoderule", info.getRuleId());
            maxSerialEntity.set(COL_MATERIAL, info.getMaterialId());
            maxSerialEntity.set("accordprop", (Object)info.getPropCol());
        } else {
            serialNum = maxSerialEntity.getInt("maxserial");
        }
        maxSerialNum = serialNum + info.getStep() * seqs.size();
        maxSerialEntity.set("maxserial", (Object)maxSerialNum);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{maxSerialEntity});
        return serialNum;
    }

    private String buildLotCodeNum(List<LotCodeRuleEntryInfo> entry) {
        StringBuilder sb = new StringBuilder();
        for (LotCodeRuleEntryInfo row : entry) {
            if (StringUtils.isEmpty((String)row.getPropValue())) continue;
            if (sb.length() > 0) {
                sb.append(row.getSplitsign());
            }
            sb.append(row.getPropValue());
        }
        return sb.toString();
    }

    private LotCodeRuleInfo buildCodeInfo(int seq, int afterentitySeq, List<Object> lotItemIds, Map<String, DynamicObject> ruleEntryMap, DynamicObject dataEntity, DynamicObjectCollection entrys, DynamicObject material, DynamicObject lotCodeRule) {
        LotCodeRuleInfo codeInfo = new LotCodeRuleInfo();
        String entityType = dataEntity.getDataEntityType().getName();
        Map<Object, DynamicObject> items = this.getLotCodeItems(lotItemIds.toArray());
        block8: for (Object id : lotItemIds) {
            DynamicObject item = items.get(id);
            String type = item.getString("type");
            Object pvalue = "";
            String endValue = "";
            DynamicObject ruleRow = ruleEntryMap.get(id.toString());
            LotCodeItemTypeEnum iEnum = LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)type);
            switch (iEnum) {
                case TXT: 
                case DATE: {
                    boolean matchCurrentBill = false;
                    DynamicObjectCollection itemEntry = item.getDynamicObjectCollection("entryentity");
                    for (DynamicObject irow : itemEntry) {
                        matchCurrentBill = irow.getString("appbill.id").equals(entityType);
                        if (!matchCurrentBill) continue;
                        String prop = irow.getString("billfieldid");
                        try {
                            pvalue = this.getLotPropValue(dataEntity, entrys, seq, afterentitySeq, prop, irow);
                        }
                        catch (KDBizException e) {
                            codeInfo.setRight(false);
                            codeInfo.appendMsg(e.getMessage());
                        }
                        break;
                    }
                    if (pvalue == null || StringUtils.isEmpty((String)pvalue.toString().trim())) {
                        if (item.getBoolean("isnullgenlot")) {
                            endValue = "";
                            break;
                        }
                        if (!matchCurrentBill) break;
                        codeInfo.setRight(false);
                        codeInfo.appendMsg(ResManager.loadKDString((String)"\u7269\u6599\u201c{0}\u201d\u7684\u4f9b\u5e94\u94fe\u7f16\u7801\u89c4\u5219\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u201c{1}\u201d\u5c5e\u6027\u3002", (String)"LotCodeRuleProcessor_1", (String)"bd-sbd-business", (Object[])new Object[]{this.getMatName(material), item.getString("name")}));
                        continue block8;
                    }
                    if (iEnum == LotCodeItemTypeEnum.DATE) {
                        String format = ruleEntryMap.get(id.toString()).getString("format");
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        endValue = sdf.format(pvalue);
                        break;
                    }
                    endValue = this.delUseMode(pvalue.toString(), ruleRow);
                    break;
                }
                case SEQ: {
                    endValue = this.delUseMode(String.valueOf(seq), ruleRow);
                    break;
                }
                case SERIALNUM: {
                    codeInfo.setHaveSerial(true);
                    codeInfo.setSettingValue(ruleRow.getString("settingvalue"));
                    codeInfo.setLenth(ruleRow.getInt("length"));
                    codeInfo.setStep(ruleRow.getInt("step"));
                }
                case CONST: {
                    endValue = ruleRow.getString("settingvalue");
                }
            }
            endValue = this.delString2LowUp(endValue, iEnum, ruleRow.getString("formatvalue"));
            LotCodeRuleEntryInfo entryInfo = new LotCodeRuleEntryInfo(seq, ruleRow.getString("entrysplitsign"), iEnum, endValue, ruleRow.getBoolean("isnumaccord"));
            codeInfo.getEntry().add(entryInfo);
            codeInfo.setSeq(this.isSubEntry ? afterentitySeq : seq);
        }
        if (codeInfo.isRight()) {
            StringBuilder sb = new StringBuilder();
            for (LotCodeRuleEntryInfo entry : codeInfo.getEntry()) {
                if (!entry.isNumAccord()) continue;
                sb.append(entry.getPropValue());
            }
            codeInfo.setPropCol(sb.toString());
        }
        return codeInfo;
    }

    private Object getLotPropValue(DynamicObject dataEntity, DynamicObjectCollection entrys, int seq, int afterentitySeq, String prop, DynamicObject irow) {
        int row;
        String key = irow.getString("entryentityid");
        MainEntityType mainEntityType = (MainEntityType)dataEntity.getDataEntityType();
        int n = row = this.isSubEntry ? afterentitySeq : seq;
        if (StringUtils.isNotEmpty((String)key)) {
            if (key.equalsIgnoreCase(this.entryEntityKey)) {
                String[] props;
                IDataEntityProperty baseProp;
                EntryProp entryProp = (EntryProp)mainEntityType.findProperty(this.entryEntityKey);
                EntryType entryType = (EntryType)entryProp.getItemType();
                if (prop.indexOf(46) > 0 && prop.indexOf(this.materialKey) == 0 && (baseProp = entryType.findProperty((props = prop.split("\\."))[0])) instanceof MaterielProp && props.length == 2 && ("name".equals(props[1]) || "number".equals(props[1]))) {
                    prop = props[0] + ".masterid." + props[1];
                }
                if (mainEntityType.getProperties().get((Object)key) != null) {
                    entrys = dataEntity.getDynamicObjectCollection(key);
                }
                try {
                    return ((DynamicObject)entrys.get(row - 1)).get(prop);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"LotCodeRuleProcessor_4", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
                }
            }
            if (this.isSubEntry) {
                MainEntityType dataEntityType = mainEntityType;
                if (dataEntityType.findProperty(key) == null) {
                    return "";
                }
                entrys = dataEntity.getDynamicObjectCollection(key);
            }
            if (entrys.size() > 0) {
                try {
                    return ((DynamicObject)entrys.get(row - 1)).get(prop);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"LotCodeRuleProcessor_4", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
                }
            }
            return "";
        }
        try {
            return dataEntity.get(prop);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f9b\u5e94\u94fe\u7f16\u7801\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"LotCodeRuleProcessor_4", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
        }
    }

    private String delString2LowUp(String endValue, LotCodeItemTypeEnum iEnum, String formatvalue) {
        if (StringUtils.isNotEmpty((String)formatvalue)) {
            block0 : switch (iEnum) {
                case DATE: {
                    break;
                }
                default: {
                    LotCodeFormatEnum key = LotCodeFormatEnum.getLotCodeFormatEnumByValue((String)formatvalue);
                    if (key == null) break;
                    switch (key) {
                        case NORMAL: {
                            break block0;
                        }
                        case LOW: {
                            endValue = endValue.toLowerCase();
                            break block0;
                        }
                        case UP: {
                            endValue = endValue.toUpperCase();
                        }
                    }
                }
            }
        }
        return endValue;
    }

    private String delUseMode(String value, DynamicObject ruleRow) {
        String result = "";
        int ruleLength = ruleRow.getInt("length");
        switch (UseModeEnum.getUseModeEnumEnumByValue((String)ruleRow.getString("attusingmode"))) {
            case CUT: {
                if (value.length() == ruleLength) {
                    return value;
                }
                if (value.length() > ruleRow.getInt("length")) {
                    if (ruleRow.getBoolean("cutstyle")) {
                        result = value.substring(0, ruleLength);
                        break;
                    }
                    result = value.substring(value.length() - ruleLength, value.length());
                    break;
                }
                StringBuilder endString = new StringBuilder();
                String settingvalue = ruleRow.getString("addchar");
                for (int i = 0; i < ruleLength - value.length(); ++i) {
                    endString.append(settingvalue);
                }
                if (ruleRow.getBoolean("addstyle")) {
                    result = value + endString;
                    break;
                }
                result = endString + value;
                break;
            }
            case TOTAL: {
                result = value;
                break;
            }
        }
        return result;
    }

    private String getMatName(DynamicObject material) {
        if (material.getDynamicObjectType().getName().equals("bd_materialinventoryinfo")) {
            return material.getString("masterid.name");
        }
        return material.getString("name");
    }

    private String getMatNumber(DynamicObject material) {
        if (material.getDynamicObjectType().getName().equals("bd_materialinventoryinfo")) {
            return material.getString("masterid.number");
        }
        return material.getString("number");
    }

    private Long getRuleIdByMaterial(DynamicObject material) {
        return material.getLong("lotcoderule_id");
    }

    private Map<Object, DynamicObject> getLotCodeItems(Object[] ids) {
        return BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bd_lotcodeitem");
    }

    @Deprecated
    @SdkDeprecated
    public String buildExampleData(DynamicObjectCollection doc) {
        StringBuilder sb = new StringBuilder();
        int step = 0;
        for (DynamicObject row : doc) {
            if (null == row.getDynamicObject("lotprop")) continue;
            if (step++ != 0) {
                sb.append(row.getString("entrysplitsign"));
            }
            String type = row.getDynamicObject("lotprop").getString("type");
            block0 : switch (LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)type)) {
                case DATE: {
                    String format = row.getString("format");
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    sb.append(sdf.format(new Date()));
                    break;
                }
                case CONST: {
                    String value = row.getString("formatvalue");
                    LotCodeFormatEnum fEnum = LotCodeFormatEnum.getLotCodeFormatEnumByValue((String)value);
                    if (fEnum == null) break;
                    switch (fEnum) {
                        case UP: {
                            sb.append(row.getString("settingvalue").toUpperCase());
                            break block0;
                        }
                        case NORMAL: {
                            sb.append(row.getString("settingvalue"));
                            break block0;
                        }
                        case LOW: {
                            sb.append(row.getString("settingvalue").toLowerCase());
                        }
                    }
                    break;
                }
                case SERIALNUM: {
                    int length = row.getInt("length");
                    String svalue = row.getString("settingvalue");
                    StringBuilder sbnum = new StringBuilder();
                    for (int i = 0; i < length - svalue.length(); ++i) {
                        sbnum.append('0');
                    }
                    sbnum.append(svalue);
                    sb.append((CharSequence)sbnum);
                    break;
                }
                default: {
                    sb.append(row.getDynamicObject("lotprop").getString("name"));
                }
            }
        }
        return sb.toString();
    }

    @SdkDeprecated
    public Map<String, String> buildExampleDataForGL(DynamicObjectCollection doc) {
        StringBuilder sb_cn = new StringBuilder();
        StringBuilder sb_en = new StringBuilder();
        StringBuilder sb_tw = new StringBuilder();
        int step = 0;
        for (DynamicObject row : doc) {
            if (null == row.getDynamicObject("lotprop")) continue;
            if (step++ != 0) {
                sb_cn.append(row.getString("entrysplitsign"));
                sb_en.append(row.getString("entrysplitsign"));
                sb_tw.append(row.getString("entrysplitsign"));
            }
            String type = row.getDynamicObject("lotprop").getString("type");
            block0 : switch (LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)type)) {
                case DATE: {
                    String format = row.getString("format");
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    sb_cn.append(sdf.format(new Date()));
                    sb_en.append(sdf.format(new Date()));
                    sb_tw.append(sdf.format(new Date()));
                    break;
                }
                case CONST: {
                    String value = row.getString("formatvalue");
                    LotCodeFormatEnum fEnum = LotCodeFormatEnum.getLotCodeFormatEnumByValue((String)value);
                    if (fEnum == null) break;
                    switch (fEnum) {
                        case UP: {
                            sb_cn.append(row.getString("settingvalue").toUpperCase());
                            sb_en.append(row.getString("settingvalue").toUpperCase());
                            sb_tw.append(row.getString("settingvalue").toUpperCase());
                            break block0;
                        }
                        case NORMAL: {
                            sb_cn.append(row.getString("settingvalue"));
                            sb_en.append(row.getString("settingvalue"));
                            sb_tw.append(row.getString("settingvalue"));
                            break block0;
                        }
                        case LOW: {
                            sb_cn.append(row.getString("settingvalue").toLowerCase());
                            sb_en.append(row.getString("settingvalue").toLowerCase());
                            sb_tw.append(row.getString("settingvalue").toLowerCase());
                        }
                    }
                    break;
                }
                case SERIALNUM: {
                    int length = row.getInt("length");
                    String svalue = row.getString("settingvalue");
                    StringBuilder sbnum = new StringBuilder();
                    for (int i = 0; i < length - svalue.length(); ++i) {
                        sbnum.append('0');
                    }
                    sbnum.append(svalue);
                    sb_cn.append((CharSequence)sbnum);
                    sb_en.append((CharSequence)sbnum);
                    sb_tw.append((CharSequence)sbnum);
                    break;
                }
                default: {
                    ILocaleString localeString = (ILocaleString)row.getDynamicObject("lotprop").get("name");
                    sb_cn.append(localeString.getLocaleValue_zh_CN() == null ? "" : localeString.getLocaleValue_zh_CN());
                    sb_en.append(localeString.getLocaleValue_en() == null ? "" : localeString.getLocaleValue_en());
                    sb_tw.append(localeString.getLocaleValue_zh_TW() == null ? "" : localeString.getLocaleValue_zh_TW());
                }
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("zh_CN", sb_cn.length() == 0 ? null : sb_cn.toString());
        hashMap.put("en", sb_en.length() == 0 ? null : sb_en.toString());
        hashMap.put("zh_TW", sb_tw.length() == 0 ? null : sb_tw.toString());
        return hashMap;
    }

    static {
        formIdToOrgFieldMap.put("pom_mftorder", "inwardept");
        formIdToOrgFieldMap.put("pom_xmftorder", "inwardept");
        formIdToOrgFieldMap.put("om_mftorder", "inwardept");
        formIdToOrgFieldMap.put("om_xmftorder", "inwardept");
        formIdToOrgFieldMap.put("pm_om_purorderbill", "entryrecorg");
        formIdToOrgFieldMap.put("pm_om_wxpurorderbill", "entryrecorg");
        formIdToOrgFieldMap.put("prop_mftorder", "inwardept");
        formIdToOrgFieldMap.put("prop_xmftorder", "inwardept");
    }
}

