/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PbdSupplierUserPhoneAndEmailValidator
extends AbstractValidator {
    public void validate() {
        Set<String> blackPersonExistPhoneValueSet = this.getBlackExistValueSet("srm_blackperson", "phone");
        Set<String> blackPersonExistEmailValueSet = this.getBlackExistValueSet("srm_blackperson", "email");
        String entityKey = this.getEntityKey();
        HashSet<String> phoneSet = new HashSet<String>(16);
        HashSet<String> emailSet = new HashSet<String>(16);
        HashMap<Long, Integer> user_countMap = new HashMap<Long, Integer>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            long userId;
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            String entityName = dataEntity.getDataEntityType().getName();
            String phone = dataEntity.getString("phone");
            Object email = dataEntity.getString("email");
            if (!this.getOperateKey().equals("save") && ("pur_supuser".equals(entityName) || "scp_supuser".equals(entityName))) {
                phone = dataEntity.getString("user.phone");
                email = dataEntity.getString("user.email");
            }
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                phoneSet.add(phone);
            }
            if (StringUtils.isNotEmpty((CharSequence)email)) {
                emailSet.add((String)email);
            }
            if (0L == (userId = dataEntity.getLong("user.id"))) continue;
            int count = 0;
            if (null != user_countMap.get(userId)) {
                count = (Integer)user_countMap.get(userId);
            }
            user_countMap.put(userId, ++count);
        }
        HashSet<String> bosUserPhoneSet = new HashSet<String>(16);
        HashSet<String> bosUserEmailSet = new HashSet<String>(16);
        QFilter typeQFilter = new QFilter("category", "=", (Object)"1");
        typeQFilter.or(new QFilter("category", "=", (Object)"2"));
        DynamicObjectCollection usertype = QueryServiceHelper.query((String)"bos_usertype", (String)"id,category,number", (QFilter[])typeQFilter.toArray());
        HashSet<Long> userTypeIds = new HashSet<Long>(16);
        long supplierTypeId = 0L;
        for (DynamicObject row : usertype) {
            if ("1".equals(row.getString("category"))) {
                userTypeIds.add(row.getLong("id"));
            }
            if (!"2".equals(row.getString("category")) || !"PT03".equals(row.getString("number"))) continue;
            supplierTypeId = row.getLong("id");
        }
        int count = this.getSupplierCount();
        this.dealBosUser(bosUserPhoneSet, bosUserEmailSet, userTypeIds, phoneSet, emailSet);
        Set<String> bosUserEmailAndPhoneSet = this.getbizPartnerSet(phoneSet, emailSet, supplierTypeId);
        Set<String> regAccountSet = this.getRegAccountSet(phoneSet, emailSet);
        boolean enableSupplieSrmVersion = this.isEnableSupplieSrmVersion();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String msg;
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            String entityName = dataEntity.getDataEntityType().getName();
            String phone = dataEntity.getString("phone");
            String email = dataEntity.getString("email");
            if (!this.getOperateKey().equals("save") && ("pur_supuser".equals(entityName) || "scp_supuser".equals(entityName))) {
                phone = dataEntity.getString("user.phone");
                email = dataEntity.getString("user.email");
            }
            if (StringUtils.isNotBlank((CharSequence)phone) && blackPersonExistPhoneValueSet.contains(phone)) {
                if ("pur_supuser".equals(entityKey)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u201c{0}\u201d\u5df2\u5217\u5165\u4eba\u5458\u9ed1\u540d\u5355\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_0", (String)"bd-pbd-opplugin", (Object[])new Object[]{phone}));
                    continue;
                }
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u201c{0}\u201d\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_1", (String)"bd-pbd-opplugin", (Object[])new Object[]{phone}));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)email) && blackPersonExistEmailValueSet.contains(email)) {
                if ("pur_supuser".equals(entityKey)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u201c{0}\u201d\u5df2\u5217\u5165\u4eba\u5458\u9ed1\u540d\u5355\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_2", (String)"bd-pbd-opplugin", (Object[])new Object[]{email}));
                    continue;
                }
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u201c{0}\u201d\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_3", (String)"bd-pbd-opplugin", (Object[])new Object[]{email}));
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)phone) && bosUserPhoneSet.contains(phone) && enableSupplieSrmVersion) {
                msg = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u201c{0}\u201d\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_4", (String)"bd-pbd-opplugin", (Object[])new Object[]{phone});
                this.addErrorMessage(rowDataEntity, msg);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)email) && bosUserEmailSet.contains(email) && enableSupplieSrmVersion) {
                msg = ResManager.loadKDString((String)"\u90ae\u7bb1\u201c{0}\u201d\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_5", (String)"bd-pbd-opplugin", (Object[])new Object[]{email});
                this.addErrorMessage(rowDataEntity, msg);
            }
            int accountCount = 0;
            for (String phoneAndEmail : bosUserEmailAndPhoneSet) {
                long id = rowDataEntity.getDataEntity().getLong("id");
                if (id != 0L && phoneAndEmail.contains(rowDataEntity.getDataEntity().getString("id"))) continue;
                if (StringUtils.isNotEmpty((CharSequence)phone) && phoneAndEmail.contains(phone)) {
                    ++accountCount;
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)email) || !phoneAndEmail.contains(email)) continue;
                ++accountCount;
            }
            long userId = dataEntity.getLong("user.id");
            if (0L != userId) {
                int userCount = 0;
                if (null != user_countMap.get(userId)) {
                    userCount = (Integer)user_countMap.get(userId);
                }
                accountCount += userCount;
            }
            if (count > 0 && accountCount > count && enableSupplieSrmVersion) {
                String msg2;
                String operateKey = this.getOperateKey();
                if ("enable".equals(operateKey)) {
                    msg2 = ResManager.loadKDString((String)"\u8d85\u8fc7\u540c\u4e00\u8d26\u53f7\u5141\u8bb8\u6ce8\u518c\u7684\u4f9b\u5e94\u5546\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[]{phone});
                    this.addErrorMessage(rowDataEntity, msg2);
                    continue;
                }
                msg2 = ResManager.loadKDString((String)"\u8d85\u8fc7\u540c\u4e00\u8d26\u53f7\u5141\u8bb8\u6ce8\u518c\u7684\u4f9b\u5e94\u5546\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[]{phone});
                this.addErrorMessage(rowDataEntity, msg2);
                continue;
            }
            if (regAccountSet.size() <= 0 || !enableSupplieSrmVersion) continue;
            if (StringUtils.isNotEmpty((CharSequence)phone) && regAccountSet.contains(phone)) {
                String msg3 = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u201c{0}\u201d\u5b58\u5728\u5f85\u5904\u7406\u7684\u6ce8\u518c\u8d44\u6599\u7533\u8bf7\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[]{phone});
                this.addErrorMessage(rowDataEntity, msg3);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)email) || !regAccountSet.contains(email)) continue;
            String msg4 = ResManager.loadKDString((String)"\u90ae\u7bb1\u201c{0}\u201d\u5b58\u5728\u5f85\u5904\u7406\u7684\u6ce8\u518c\u8d44\u6599\u7533\u8bf7\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PbdSupplierUserPhoneAndEmailValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[]{email});
            this.addErrorMessage(rowDataEntity, msg4);
        }
    }

    private void dealBosUser(Set<String> bosUserPhoneSet, Set<String> bosUserEmailSet, Set<Long> userTypeIds, Set<String> phoneSet, Set<String> emailSet) {
        QFilter bosUserQf = new QFilter("enable", "=", (Object)"1");
        QFilter userqFilter = new QFilter("phone", "in", phoneSet);
        userqFilter.or(new QFilter("email", "in", emailSet));
        bosUserQf.and(userqFilter);
        DynamicObjectCollection bosUsers = QueryServiceHelper.query((String)"bos_user", (String)"id,phone,email,usertypes.fbasedataid.id", (QFilter[])bosUserQf.toArray());
        for (DynamicObject row : bosUsers) {
            long userTypeId = row.getLong("usertypes.fbasedataid.id");
            if (!userTypeIds.contains(userTypeId)) continue;
            if (StringUtils.isNotEmpty((CharSequence)row.getString("phone"))) {
                bosUserPhoneSet.add(row.getString("phone"));
            }
            if (!StringUtils.isNotEmpty((CharSequence)row.getString("email"))) continue;
            bosUserEmailSet.add(row.getString("email"));
        }
    }

    private int getSupplierCount() {
        String srmAPPId = "XV1IC150UR4";
        String suppliercout = this.getSysCtrlParam(srmAPPId, "suppliercount");
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)suppliercout)) {
            count = Integer.parseInt(suppliercout);
        }
        return count;
    }

    private boolean isEnableSupplieSrmVersion() {
        QFilter qFilter = new QFilter("paramkey", "=", (Object)"enablenewsrmversion");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])qFilter.toArray());
        return dyn != null && "Y".equals(dyn.getString("paramvalue"));
    }

    private Set<String> getbizPartnerSet(Set<String> phoneSet, Set<String> emailSet, long supplierTypeId) {
        HashSet<String> bosUserEmailAndPhoneSet = new HashSet<String>(16);
        QFilter bizPartnerQf = new QFilter("enable", "=", (Object)"1");
        QFilter bizPartnerAccountQf = new QFilter("user.phone", "in", phoneSet);
        bizPartnerAccountQf.or(new QFilter("user.email", "in", emailSet));
        bizPartnerQf.and(bizPartnerAccountQf);
        DynamicObjectCollection supUsers = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user.phone,user.email,user.usertypes.fbasedataid.id usertypes", (QFilter[])bizPartnerQf.toArray());
        for (DynamicObject row : supUsers) {
            long typeId = row.getLong("usertypes");
            if (0L == supplierTypeId || typeId != supplierTypeId || !StringUtils.isNotEmpty((CharSequence)row.getString("user.phone")) && !StringUtils.isNotEmpty((CharSequence)row.getString("user.email"))) continue;
            bosUserEmailAndPhoneSet.add(row.getString("id") + "_" + row.getString("user.phone") + "_" + row.getString("user.email"));
        }
        return bosUserEmailAndPhoneSet;
    }

    private Set<String> getRegAccountSet(Set<String> phoneSet, Set<String> emailSet) {
        QFilter userQf = new QFilter("email", "in", emailSet);
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"phone", (QFilter[])userQf.toArray());
        for (DynamicObject row : users) {
            if (!StringUtils.isNotEmpty((CharSequence)row.getString("phone"))) continue;
            phoneSet.add(row.getString("phone"));
        }
        IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)"srm_supplierreg").findProperty("newphone");
        String selectors = "id,phone";
        QFilter qFilter = new QFilter("phone", "in", phoneSet);
        qFilter.or(new QFilter("phone", "in", emailSet));
        if (null != property) {
            qFilter.or(new QFilter("newemail", "in", emailSet));
            selectors = selectors + ",newphone,newemail";
        }
        ArrayList<String> regauditstatusList = new ArrayList<String>(16);
        regauditstatusList.add("A");
        regauditstatusList.add("B");
        qFilter.and(new QFilter("auditstatus", "in", regauditstatusList));
        DynamicObjectCollection supplierregs = QueryServiceHelper.query((String)"srm_supplierreg", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<String> regAccountSet = new HashSet<String>(16);
        if (supplierregs.size() > 1) {
            for (DynamicObject row : supplierregs) {
                regAccountSet.add(row.getString("phone"));
                if (null == property) continue;
                regAccountSet.add(row.getString("newphone"));
                regAccountSet.add(row.getString("newemail"));
            }
        }
        return regAccountSet;
    }

    private String getSysCtrlParam(String srmAPPId, String suppliercount) {
        Object val;
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId(srmAPPId);
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        String paramVal = "";
        if (null != systemMap && null != (val = systemMap.get(suppliercount))) {
            paramVal = val.toString();
        }
        return paramVal;
    }

    private Set<String> getBlackExistValueSet(String entityId, String fieldname) {
        HashSet<String> valueSet = new HashSet<String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityId, (String)fieldname, (QFilter[])new QFilter[]{new QFilter("blacktype", "=", (Object)"1").and(new QFilter("auditstatus", "=", (Object)"B").or("auditstatus", "=", (Object)"C"))});
        for (DynamicObject row : query) {
            String value = row.getString(fieldname);
            if ("phone".equals(fieldname) && StringUtils.isNotBlank((CharSequence)value) && value.contains("+86-")) {
                value = value.split("-")[1];
            }
            valueSet.add(value);
        }
        return valueSet;
    }
}

