/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.opplugin.er.daily;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.er.util.ErReimburseSettingUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ErReimburseSettingImportDataOp
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(ErReimburseSettingImportDataOp.class);
    private Map<String, Object> levelMap = new HashMap<String, Object>(8);
    private Map<String, Object> orgMap = new HashMap<String, Object>(8);

    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        Iterator iterator = overrideFieldsConfig.iterator();
        while (iterator.hasNext()) {
            ComboItem comboItem = (ComboItem)iterator.next();
            if (!"reimburselevel".equals(comboItem.getValue())) continue;
            iterator.remove();
            break;
        }
        return overrideFieldsConfig;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            boolean beforeImportData = this.beforeImportData(data, this.ctx.getOption(), logger);
            if (beforeImportData) continue;
            iterator.remove();
        }
    }

    private boolean beforeImportData(ImportBillData importData, Map<String, Object> option, ImportLogger importlogs) {
        JSONObject data = importData.getData();
        String importType = (String)option.get("importtype");
        if (importType != null && "new".equals(importType)) {
            this.log.info(String.format("\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u652f\u6301\u65b0\u589e\u64cd\u4f5c:%s", data));
            importlogs.log(Integer.valueOf(importData.getStartIndex()), ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u201c\u65b0\u589e\u201d\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u201c\u8986\u76d6\u201d\u6216\u201c\u8986\u76d6\u65b0\u589e\u201d\u3002", (String)"ErReimburseSettingImportDataOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0])).fail();
            return false;
        }
        JSONArray reimburseentry = (JSONArray)data.get((Object)"reimlevelentry");
        if (this.orgMap.size() != 0) {
            this.orgMap.clear();
        }
        for (int i = 0; i < reimburseentry.size(); ++i) {
            Map reimburseLevel = (Map)reimburseentry.getJSONObject(i).get((Object)"entryreimburselevel");
            if (reimburseLevel == null) continue;
            String reimburseLevelNumber = (String)reimburseLevel.get("number");
            String companyNumber = reimburseentry.getJSONObject(i).getJSONObject("company").getString("number");
            DynamicObject company = (DynamicObject)this.getOrgByNum(companyNumber);
            Object level = this.levelMap.get(companyNumber + "#" + reimburseLevelNumber);
            if (level != null) continue;
            if (company == null) {
                importlogs.log(Integer.valueOf(importData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErReimburseSettingImportDataOp_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]), companyNumber)).fail();
                return false;
            }
            QFilter er_reimburselevelFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)((Long)company.getPkValue()));
            DynamicObject remburseLevel = BusinessDataServiceHelper.loadSingle((String)"er_reimburselevel", (String)"number", (QFilter[])new QFilter[]{er_reimburselevelFilter, QFilter.of((String)"number=? and enable='1'", (Object[])new Object[]{reimburseLevelNumber})});
            if (remburseLevel == null) {
                this.log.info(String.format("\u62a5\u9500\u7ea7\u522b %s \u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6b63\u5bf9\u5e94\u7684\u62a5\u9500\u7ea7\u522b", reimburseLevelNumber));
                importlogs.log(Integer.valueOf(importData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u62a5\u9500\u7ea7\u522b\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ErReimburseSettingImportDataOp_1", (String)"bd-assistant-opplugin", (Object[])new Object[0]), reimburseLevelNumber)).fail();
                return false;
            }
            this.levelMap.put(companyNumber + "#" + reimburseLevelNumber, remburseLevel);
        }
        Object number = data.get((Object)"number");
        if (!data.containsKey((Object)"number")) {
            this.log.info(data + "\uff0c\u8fd9\u6761\u8bb0\u5f55excel\u6ca1\u6709\u5305\u542bnumber, number\u662f\u5fc5\u5f55\u7684\uff01\uff01\uff01");
            return false;
        }
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,entryentity,entryentity.dpt", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{number})});
        if (users == null || users.length < 1) {
            importlogs.log(Integer.valueOf(importData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5458\u5de5\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErReimburseSettingImportDataOp_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number)).fail();
            return false;
        }
        if (users.length == 1) {
            String auditstatus;
            data.put("id", users[0].getPkValue());
            DynamicObject reimburseLevelSetting = BusinessDataServiceHelper.loadSingleFromCache((Object)users[0].getPkValue(), (String)"er_reimbursesetting", (String)"auditstatus");
            if (reimburseLevelSetting != null && (auditstatus = reimburseLevelSetting.getString("auditstatus")) != null && StringUtils.equals((String)"C", (String)auditstatus)) {
                importlogs.log(Integer.valueOf(importData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u4eba\u5458\uff08%s\uff09\u7684\u62a5\u9500\u7ea7\u522b\u8bbe\u7f6e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"ErReimburseSettingImportDataOp_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number)).fail();
                return false;
            }
            Set dptOfUser = users[0].getDynamicObjectCollection("entryentity").stream().map(e -> e.getDynamicObject("dpt").getPkValue()).collect(Collectors.toSet()).stream().map(e -> OrgUnitServiceHelper.getCompanyfromOrg((Object)e).getOrDefault("id", 0L)).collect(Collectors.toSet());
            Set importDptOfUser = this.orgMap.values().stream().map(e -> ((DynamicObject)e).getPkValue()).collect(Collectors.toSet());
            importDptOfUser.removeIf(dptOfUser::contains);
            if (importDptOfUser.size() != 0) {
                importlogs.log(Integer.valueOf(importData.getStartIndex()), String.format(ResManager.loadKDString((String)"\u5458\u5de5\u5c97\u4f4d\u4e0d\u5b58\u5728\u8be5\u516c\u53f8\uff08%s\uff09\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"ErReimburseSettingImportDataOp_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number)).fail();
                return false;
            }
            return true;
        }
        this.log.info(String.format("t_sec_user\u8868\u4e2d\u67e5\u8be2\u5230number=%s\u7684\u7528\u6237\u5927\u4e8e\u4e00\u6761\uff0c\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u7406\u8bba\u4e00\u4e2a\u5de5\u53f7\u53ea\u5c5e\u4e8e\u4e00\u4e2a\u7528\u6237", number));
        return false;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (result.getSuccess()) {
            for (ImportBillData importBillData : rowdatas) {
                JSONObject data = importBillData.getData();
                Long userId = (Long)data.get((Object)"id");
                DynamicObjectCollection reimlevelentry = this.getDynamicObjects(data, userId);
                ErReimburseSettingUtil.updateRelation((Long)userId, (DynamicObjectCollection)reimlevelentry);
            }
        }
        return result;
    }

    private DynamicObjectCollection getDynamicObjects(JSONObject data, Long userId) {
        JSONObject entryJSON;
        Object orgByNum;
        JSONArray reimlevelentryJSON = (JSONArray)data.get((Object)"reimlevelentry");
        DynamicObject reimbursesetting = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"er_reimbursesetting", (String)"reimlevelentry.company,reimlevelentry.entryreimburselevel");
        DynamicObjectCollection reimlevelentry = reimbursesetting.getDynamicObjectCollection("reimlevelentry");
        DynamicObjectType type = reimlevelentry.getDynamicObjectType();
        for (int i = 0; i < reimlevelentryJSON.size() && (orgByNum = this.getOrgByNum((entryJSON = reimlevelentryJSON.getJSONObject(i)).getJSONObject("company").getString("number"))) != null; ++i) {
            DynamicObject entry = (DynamicObject)type.createInstance();
            entry.set("company", orgByNum);
            JSONObject entryReimburseLevel = entryJSON.getJSONObject("entryreimburselevel");
            if (entryReimburseLevel == null) continue;
            String reimburseLevelNumber = entryReimburseLevel.getString("number");
            entry.set("entryreimburselevel", this.levelMap.get(((DynamicObject)orgByNum).get("number") + "#" + reimburseLevelNumber));
            reimlevelentry.add((Object)entry);
        }
        return reimlevelentry;
    }

    private Object getOrgByNum(String orgnum) {
        Object org = this.orgMap.get(orgnum);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgnum), new QFilter("enable", "=", (Object)true)});
            this.orgMap.put(orgnum, org);
        }
        return org;
    }
}

