/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.assistant.helper.BizLogHelper;
import kd.bd.assistant.plugin.basedata.FinOrgResInValidator;
import kd.bd.assistant.plugin.helper.BankCateHelper;
import kd.bd.assistant.plugin.helper.FinOperateServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinOrgResInOp
extends AbstractOperationServicePlugIn {
    public static final String BOS_BD_OPPLUGIN = "bos-bd-opplugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("name_eng");
        fieldKeys.add("country");
        fieldKeys.add("province");
        fieldKeys.add("city");
        fieldKeys.add("address");
        fieldKeys.add("telephone");
        fieldKeys.add("fax");
        fieldKeys.add("union_number");
        fieldKeys.add("swift_code");
        fieldKeys.add("routingnum");
        fieldKeys.add("other_code");
        fieldKeys.add("address_eng");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinOrgResInValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Date currTime = new Date();
        String userId = RequestContext.get().getUserId();
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
        DynamicObject[] eDataEntities = e.getDataEntities();
        Map<Long, List<DynamicObject>> finOrgInfoMap = this.getFinOrgInfo(eDataEntities);
        for (DynamicObject data : eDataEntities) {
            List finOrgInfos = finOrgInfoMap.getOrDefault(data.getLong("id"), new ArrayList(2));
            if (finOrgInfos.isEmpty()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_finorginfo");
                finOrgInfos.add(new DynamicObject((DynamicObjectType)entityType));
            }
            for (DynamicObject finOrgInfo : finOrgInfos) {
                String unionNumber = data.getString("union_number");
                String name = data.getString("name");
                DynamicObject bankCate = BankCateHelper.findBankCate((String)name, (String)unionNumber);
                if (bankCate != null) {
                    finOrgInfo.set("bank_cate", (Object)bankCate);
                    finOrgInfo.set("logo", (Object)bankCate.getString("logo"));
                }
                QFilter bankFinOrgTypeFilter = new QFilter("type", "=", (Object)"0");
                DynamicObject bankType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id,type", (QFilter[])new QFilter[]{bankFinOrgTypeFilter});
                finOrgInfo.set("finorgtype", (Object)bankType);
                finOrgInfo.set("name", (Object)data.getLocaleString("name").getLocaleValue());
                finOrgInfo.set("name_eng", (Object)data.getString("name_eng"));
                finOrgInfo.set("address", (Object)data.getString("address"));
                finOrgInfo.set("telephone", (Object)data.getString("telephone"));
                finOrgInfo.set("fax", (Object)data.getString("fax"));
                finOrgInfo.set("union_number", (Object)data.getString("union_number"));
                finOrgInfo.set("swift_code", (Object)data.getString("swift_code"));
                finOrgInfo.set("routingnum", (Object)data.getString("routingnum"));
                finOrgInfo.set("address_eng", (Object)data.getString("address_eng"));
                finOrgInfo.set("other_code", (Object)data.getString("other_code"));
                finOrgInfo.set("country", (Object)data.getDynamicObject("country"));
                finOrgInfo.set("province", (Object)data.getDynamicObject("province"));
                finOrgInfo.set("city", (Object)data.getDynamicObject("city"));
                finOrgInfo.set("bebank", (Object)data);
                finOrgInfo.set("creator", finOrgInfo.get("creator") == null ? userId : finOrgInfo.get("creator"));
                finOrgInfo.set("createtime", finOrgInfo.get("createtime") == null ? currTime : finOrgInfo.get("createtime"));
                finOrgInfo.set("modifier", (Object)userId);
                finOrgInfo.set("modifytime", (Object)currTime);
                finOrgInfo.set("enable", (Object)"1");
                finOrgInfo.set("enable_time", finOrgInfo.get("enable_time") == null ? currTime : finOrgInfo.get("enable_time"));
                finOrgInfo.set("status", (Object)"C");
                finOrgInfo.set("parent", null);
                saveList.add(finOrgInfo);
            }
        }
        OperationResult opRes = FinOperateServiceHelper.execOperate((String)"save", (String)"bd_finorginfo", (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        String logMsg = String.format(ResManager.loadKDString((String)"\u5171%d\u6761\u8d44\u6e90\u5f15\u5165\u6210\u529f\u3002", (String)"FinOrgResInOp_0", (String)BOS_BD_OPPLUGIN, (Object[])new Object[0]), opRes.getSuccessPkIds().size());
        BizLogHelper.addLog(null, (String)"bd_finorginfo", (String)ResManager.loadKDString((String)"\u8d44\u6e90\u5f15\u5165", (String)"FinOrgResInOp_1", (String)BOS_BD_OPPLUGIN, (Object[])new Object[0]), (String)logMsg, (Long)RequestContext.get().getOrgId());
    }

    private Map<Long, List<DynamicObject>> getFinOrgInfo(DynamicObject[] eDataEntities) {
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(eDataEntities.length);
        Map finOrgInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("bebank", "in", Stream.of(eDataEntities).map(b -> b.getLong("id")).collect(Collectors.toSet())).and("finorgtype.type", "=", (Object)"0")});
        if (finOrgInfoMap != null && !finOrgInfoMap.isEmpty()) {
            for (DynamicObject finOrg : finOrgInfoMap.values()) {
                long beBankId = finOrg.getDynamicObject("bebank").getLong("id");
                List finOrgList = resultMap.getOrDefault(beBankId, new ArrayList(2));
                finOrgList.add(finOrg);
                resultMap.put(beBankId, finOrgList);
            }
        }
        return resultMap;
    }
}

