/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata.bebank;

import kd.bd.assistant.plugin.helper.CountryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class BebankSaveValidator
extends AbstractValidator {
    public static final String BD_ASSISTANT_OPPLUGIN = "bd-assistant-opplugin";
    public static final String COUNTRY = "country";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject country = data.getDynamicObject(COUNTRY);
            String provinceTxt = data.getString("provincetxt");
            String cityTxt = data.getString("citytxt");
            boolean isChinaMainland = CountryHelper.isChina((DynamicObject)country);
            if (isChinaMainland) {
                if (BebankSaveValidator.isEmpty(provinceTxt)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7701\u4efd\uff08\u94f6\u4f01\uff09\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BebankSaveValidator_1", (String)BD_ASSISTANT_OPPLUGIN, (Object[])new Object[0]));
                }
                if (!BebankSaveValidator.isEmpty(cityTxt)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BebankSaveValidator_2", (String)BD_ASSISTANT_OPPLUGIN, (Object[])new Object[0]));
                continue;
            }
            if (!BebankSaveValidator.isEmpty(cityTxt) || !CountryHelper.isHkOrMoOrTwn((DynamicObject)country)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BebankSaveValidator_2", (String)BD_ASSISTANT_OPPLUGIN, (Object[])new Object[0]));
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

