/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata.descasstacttype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.flex.FlexFormMetaUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;

public class DescAsstactTypeSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DescAsstactTypeSaveOp.class);
    private static final String[] inBaseData = new String[]{"filterdesc", "filtercondition"};
    private static final String[] inAssistantBaseData = new String[]{"assistanttype"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"asstacttype")) {
                    Stream.of(this.dataEntities).filter(v -> !v.getDataEntity().getString("ctrlstrategy").equals("5")).forEach(v -> this.addErrorMessage((ExtendedDataEntity)v, ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u6a21\u5f0f\u4e0d\u652f\u6301\u8be5\u63a7\u5236\u7b56\u7565\u3002", (String)"DescAsstactTypeSaveOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                }
                Arrays.stream(this.dataEntities).filter(extEntity -> {
                    DynamicObject entity = extEntity.getDataEntity();
                    if ("1".equals(entity.getString("valuetype"))) {
                        if (null == entity.getDynamicObject("valuesource")) {
                            return false;
                        }
                        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)entity.getDynamicObject("valuesource").getPkValue().toString());
                        return sourceEntityType instanceof BillEntityType && 12 == sourceEntityType.getPrimaryKey().getDbType();
                    }
                    return false;
                }).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u4e3b\u952e\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c\u6765\u6e90\u3002", (String)"DescAsstactTypeSaveOp_1", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                this.businessValidate();
            }

            private void businessValidate() {
                List<String> shareCtrls = Arrays.asList("5", "6");
                Map<Object, DynamicObject> modifyAssistDys = Arrays.stream(this.dataEntities).filter(x -> x.getDataEntity().getDataEntityState().getFromDatabase()).collect(Collectors.toMap(x -> x.getDataEntity().getPkValue(), y -> y.getDataEntity()));
                HashMap<Object, BaseDataCheckRefrenceResult> checkRefrenced = new HashMap(8);
                Map<Object, Object> dbAssistInfoMap = new HashMap(8);
                if (!CollectionUtils.isEmpty(modifyAssistDys)) {
                    Set<Object> modifyPks = modifyAssistDys.keySet();
                    checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)"bd_desc_asstacttype", (Object[])modifyPks.toArray(), null, null, null);
                    DynamicObject[] dbAssistDys = BusinessDataServiceHelper.load((String)"bd_desc_asstacttype", (String)"id,number,valuetype,valuesource,createorg.id,ctrlstrategy,assistanttype", (QFilter[])new QFilter("id", "in", modifyPks).toArray());
                    dbAssistInfoMap = Arrays.stream(dbAssistDys).collect(Collectors.toMap(x -> x.getPkValue(), y -> y));
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject asst = dataEntity.getDataEntity();
                    String ctrlStrategy = asst.getString("ctrlstrategy");
                    if (!shareCtrls.contains(ctrlStrategy)) continue;
                    Boolean fromDatabase = asst.getDataEntityState().getFromDatabase();
                    String number = asst.getString("number");
                    Optional<String> checkMasterIdProp = this.checkValueSource(asst);
                    if (checkMasterIdProp.isPresent()) {
                        this.addErrorMessage(dataEntity, checkMasterIdProp.get());
                        continue;
                    }
                    Object pkValue = asst.getPkValue();
                    if (fromDatabase.booleanValue()) {
                        DynamicObject dbAssist = (DynamicObject)dbAssistInfoMap.get(pkValue);
                        Optional<String> checkReferenced = this.checkReferenced(checkRefrenced, asst, dbAssist);
                        if (checkReferenced.isPresent()) {
                            this.addErrorMessage(dataEntity, checkReferenced.get());
                            continue;
                        }
                        if (Objects.nonNull(dbAssist) && !number.equals(dbAssist.getString("number"))) {
                            fromDatabase = false;
                        }
                    }
                    String regex = "^[a-z0-9A-Z]+$";
                    if (!fromDatabase.booleanValue() && !Pattern.matches(regex, number)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf4\u660e\u6027\u7ef4\u5ea6\u7684\u7f16\u7801\uff08%s\uff09\u4e0d\u5141\u8bb8\u6709\u4efb\u4f55\u7b26\u53f7\u548c\u4e2d\u6587\uff0c\u53ea\u80fd\u662f\u82f1\u6587\u5927\u5c0f\u5199\u548c\u6570\u5b57\u3002", (String)"DescAsstactTypeSaveOp_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number));
                        continue;
                    }
                    String asstName = asst.getString("name");
                    long createorgId = asst.getLong("createorg_id");
                    String existField = "";
                    if (asst.getDataEntityState().getFromDatabase()) {
                        Optional<String> checkRes;
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_desc_asstacttype", (String)"createorg,name,ctrlstrategy", (QFilter[])new QFilter("id", "=", (Object)asst.getLong("id")).toArray());
                        if (!(asstName.equals(dynamicObject.getString("name")) && ctrlStrategy.equals(dynamicObject.getString("ctrlStrategy")) && createorgId == dynamicObject.getLong("createorg") || !(checkRes = this.checkUniqueNameOrName(true, dataEntity, ctrlStrategy, asstName)).isPresent())) {
                            existField = checkRes.get();
                        }
                    } else {
                        Optional<String> checkRes = this.checkUniqueNameOrName(false, dataEntity, ctrlStrategy, asstName);
                        if (checkRes.isPresent()) {
                            existField = checkRes.get();
                        }
                    }
                    if (existField.equals("number")) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DescAsstactTypeSaveOp_10", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number));
                        return;
                    }
                    if (!existField.equals("name")) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DescAsstactTypeSaveOp_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]), asstName));
                    return;
                }
            }

            private Optional<String> checkValueSource(DynamicObject asst) {
                String valueType = asst.getString("valuetype");
                DynamicObject valueSource = asst.getDynamicObject("valuesource");
                if ("1".equals(valueType) && !Objects.isNull(valueSource)) {
                    String formId = valueSource.getPkValue().toString();
                    return this.checkEntityProp(formId);
                }
                return Optional.empty();
            }

            private Optional<String> checkEntityProp(String formId) {
                MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
                BasedataEntityType basedataEntityType = (BasedataEntityType)sourceEntityType;
                if (StringUtils.isBlank((CharSequence)basedataEntityType.getNumberProperty())) {
                    return Optional.of(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u672a\u5b9a\u4e49\u7f16\u7801\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u503c\u6765\u6e90\u3002", (String)"DescAsstactTypeSaveOp_14", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)basedataEntityType.getNameProperty())) {
                    return Optional.of(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u672a\u5b9a\u4e49\u540d\u79f0\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u503c\u6765\u6e90\u3002", (String)"DescAsstactTypeSaveOp_15", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                return Optional.empty();
            }

            private Optional<String> checkReferenced(Map<Object, BaseDataCheckRefrenceResult> checkRefrenced, DynamicObject asst, DynamicObject dbAssist) {
                Object pkValue = asst.getPkValue();
                BaseDataCheckRefrenceResult refrenceResult = checkRefrenced.get(pkValue);
                if (refrenceResult == null || !refrenceResult.isRefence()) {
                    return Optional.empty();
                }
                if (refrenceResult.isRefence()) {
                    Optional<String> checkResult = this.checkPropertyChange(asst, dbAssist);
                    if (!checkResult.isPresent()) {
                        return Optional.empty();
                    }
                    MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                    String billName = refMainType.getDisplayName().getLocaleValue();
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u5f15\u7528\u4e86%2$s\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4fee\u6539%3$s\u3002", (String)"DescAsstactTypeSaveOp_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), billName, asst.getString("name"), checkResult.get());
                    return Optional.of(msg);
                }
                return Optional.empty();
            }

            private Optional<String> checkPropertyChange(DynamicObject asst, DynamicObject dbAssist) {
                String dbValuetype = dbAssist.getString("valuetype");
                String dbCtrlStrategy = dbAssist.getString("ctrlStrategy");
                String dbValuesource = dbAssist.getString("valuesource");
                long dbCreateorg = dbAssist.getLong("createorg.id");
                String dbAssistanttype = dbAssist.getString("assistanttype");
                String valuetype = asst.getString("valuetype");
                String ctrlStrategy = asst.getString("ctrlStrategy");
                String valuesource = asst.getString("valuesource");
                long createorg = asst.getLong("createorg.id");
                String assistanttype = asst.getString("assistanttype");
                if (!Objects.equals(dbValuetype, valuetype)) {
                    return Optional.of(ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"DescAsstactTypeSaveOp_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                if (!Objects.equals(dbCtrlStrategy, ctrlStrategy)) {
                    return Optional.of(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"DescAsstactTypeSaveOp_6", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                if (!Objects.equals(dbValuesource, valuesource)) {
                    return Optional.of(ResManager.loadKDString((String)"\u503c\u6765\u6e90", (String)"DescAsstactTypeSaveOp_11", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                if (!Objects.equals(dbCreateorg, createorg)) {
                    return Optional.of(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"DescAsstactTypeSaveOp_8", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                if (!Objects.equals(dbAssistanttype, assistanttype)) {
                    return Optional.of(ResManager.loadKDString((String)"\u8f85\u52a9\u503c\u6765\u6e90", (String)"DescAsstactTypeSaveOp_9", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
                return Optional.empty();
            }

            private Optional<String> checkUniqueNameOrName(boolean fromDB, ExtendedDataEntity dataEntity, String ctrlStrategy, String asstName) {
                if ("5".equals(ctrlStrategy)) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
                    QFilter flexFilter = new QFilter("flexid", "=", (Object)101);
                    filters.add(flexFilter);
                    QFilter nameFilter = new QFilter("name", "=", (Object)asstName);
                    filters.add(nameFilter);
                    if (fromDB) {
                        filters.add(new QFilter("id", "!=", (Object)dataEntity.getDataEntity().getLong("id")));
                    }
                    if (QueryServiceHelper.exists((String)"bd_desc_asstacttype", (QFilter[])filters.toArray(new QFilter[0]))) {
                        return Optional.of("name");
                    }
                    filters.clear();
                    filters.add(flexFilter);
                    if (fromDB) {
                        filters.add(new QFilter("id", "!=", (Object)dataEntity.getDataEntity().getLong("id")));
                    }
                    filters.add(new QFilter("number", "=", (Object)dataEntity.getDataEntity().getString("number")));
                    if (QueryServiceHelper.exists((String)"bd_desc_asstacttype", (QFilter[])filters.toArray(new QFilter[0]))) {
                        return Optional.of("number");
                    }
                }
                return Optional.empty();
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String baseData = "1";
        String assistantBaseData = "2";
        String other = "3";
        block10: for (DynamicObject entity : e.getDataEntities()) {
            String type;
            switch (type = (String)entity.get("valuetype")) {
                case "1": {
                    this.repairInvalidData(entity, inAssistantBaseData);
                    continue block10;
                }
                case "2": {
                    this.repairInvalidData(entity, inBaseData);
                    continue block10;
                }
                case "3": {
                    this.repairInvalidData(entity, (String[])ArrayUtils.addAll((Object[])inBaseData, (Object[])inAssistantBaseData));
                }
            }
        }
    }

    private void repairInvalidData(DynamicObject entity, String[] array) {
        for (String key : array) {
            Object object = entity.get(key);
            if (object == null) continue;
            if (object instanceof String && !"".equals(object.toString())) {
                entity.set(key, (Object)"");
                continue;
            }
            entity.set(key, null);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getOperationKey().equals("save")) {
            FlexEntityMetaUtils.clearFlexEntityMeta();
            FlexFormMetaUtils.clearFlexFormMeta();
        }
    }
}

