/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.cal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bd.assistant.cal.CalBalanceValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MaterialCalInfoUnAuditValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_dbparam", (QFilter[])new QFilter("key", "=", (Object)"calinfo_unaudit_check").and("value", "=", (Object)"false").toArray());
        if (dynamicObject != null) {
            return;
        }
        HashSet<Long> pubMaterialIds = new HashSet<Long>(16);
        HashMap<Long, Set> privateOrg2MaterialIds = new HashMap<Long, Set>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String ctrlstrategy = info.getString("ctrlstrategy");
            Long masterid = info.getLong("masterid_id");
            Long createorgid = info.getLong("createorg_id");
            if ("7".equals(ctrlstrategy)) {
                Set materialids = privateOrg2MaterialIds.computeIfAbsent(createorgid, k -> new HashSet(4));
                materialids.add(masterid);
                continue;
            }
            if (!"5".equals(ctrlstrategy)) continue;
            pubMaterialIds.add(masterid);
        }
        Set materialIdOrgIds = CalBalanceValidator.getNotZeroBalMaterial(pubMaterialIds, privateOrg2MaterialIds);
        String errmsg = ResManager.loadKDString((String)"%1$s\uff1a\u7269\u6599\u6709\u671f\u521d\u6570\u636e\u6216\u8005\u5f53\u671f\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MaterialCalInfoUnAuditValidator_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String ctrlstrategy = info.getString("ctrlstrategy");
            Long masterid = info.getLong("masterid_id");
            DynamicObject material = info.getDynamicObject("masterid");
            String matNum = material.getString("number");
            Long createorgid = info.getLong("createorg_id");
            if ("7".equals(ctrlstrategy) && materialIdOrgIds.contains(createorgid + "#" + masterid)) {
                this.addFatalErrorMessage(dataEntity, String.format(errmsg, matNum));
                continue;
            }
            if (!"5".equals(ctrlstrategy) || !materialIdOrgIds.contains(masterid)) continue;
            this.addFatalErrorMessage(dataEntity, String.format(errmsg, matNum));
        }
    }
}

