/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bankaccount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.bankaccount.CusOrSupAccountListPlugin;
import kd.bd.assistant.plugin.bankaccount.InternalBankAccountListPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BdFreeChoiceEdit
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BD_FREE_CHOICE_LIST = "bd_freechoice_list";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showBankInfo();
        this.showEntryBank();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    private void showBankInfo() {
        String filterType;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setBillFormId("bd_accountbanks");
        listShowParameter.setFormId(BD_FREE_CHOICE_LIST);
        listShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        listShowParameter.getOpenStyle().setTargetKey("accountbanktab");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.addCustPlugin(InternalBankAccountListPlugin.class.getName());
        ArrayList<Object> filters = new ArrayList<Object>(10);
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        ArrayList customFilters = new ArrayList(10);
        List bankAccountFilters = (List)customParams.get("bankAccountFilters");
        if (CollectionUtils.isNotEmpty((Collection)bankAccountFilters)) {
            customFilters.addAll(bankAccountFilters.stream().map(f -> QFilter.fromSerializedString((String)f.toString())).collect(Collectors.toList()));
        }
        if (StringUtils.equals((CharSequence)(filterType = customParams.getOrDefault("filterType", "0").toString()), (CharSequence)"1")) {
            filters.clear();
        }
        filters.addAll(customFilters);
        listShowParameter.getListFilterParameter().getQFilters().addAll(filters);
        Object useOrgId = customParams.get("useOrgId");
        if (useOrgId != null) {
            listShowParameter.setUseOrgId(Long.parseLong(useOrgId.toString()));
        }
        listShowParameter.setCustomParam("comeFrom", (Object)"bd_freechoice");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showEntryBank() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        String payeeType = customParams.getOrDefault("payeeType", "");
        Long payeeId = customParams.getOrDefault("payeeId", 0L);
        if (payeeId == null || Long.parseLong(((Object)payeeId).toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"BdFreeChoiceEdit_01", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)payeeType) && !StringUtils.equals((CharSequence)"bd_customer", (CharSequence)payeeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u5fc5\u987b\u4e3a\u5ba2\u6237\u6216\u8005\u4f9b\u5e94\u5546\u3002", (String)"BdFreeChoiceEdit_02", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(payeeType);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setFormId(BD_FREE_CHOICE_LIST);
        listShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        listShowParameter.getOpenStyle().setTargetKey("entrybanktab");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.addCustPlugin(CusOrSupAccountListPlugin.class.getName());
        ArrayList<Object> filters = new ArrayList<Object>(10);
        filters.add(new QFilter("id", "=", (Object)payeeId));
        ArrayList customFilters = new ArrayList(10);
        List cusOrSupFilters = (List)customParams.get("cusOrSupFilters");
        if (CollectionUtils.isNotEmpty((Collection)cusOrSupFilters)) {
            customFilters.addAll(cusOrSupFilters.stream().map(f -> QFilter.fromSerializedString((String)f.toString())).collect(Collectors.toList()));
        }
        filters.addAll(customFilters);
        listShowParameter.getListFilterParameter().getQFilters().addAll(filters);
        listShowParameter.setCustomParam("comeFrom", (Object)"bd_freechoice");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private String getEntityName() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String activeTab = tab.getCurrentTab();
        String realEntity = null;
        switch (activeTab) {
            case "accountbanktab": {
                realEntity = "bd_accountbanks";
                break;
            }
            case "entrybanktab": {
                FormShowParameter fsp = this.getView().getFormShowParameter();
                realEntity = (String)fsp.getCustomParam("payeeType");
                break;
            }
        }
        return realEntity;
    }

    private void btnOk() {
        String realEntity = this.getEntityName();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String activeTab = tab.getCurrentTab();
        IPageCache cache = this.getPageCache();
        String selectedData = cache.get("selected-" + activeTab);
        if (StringUtils.isBlank((CharSequence)selectedData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BdFreeChoiceEdit_03", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        Map selectedDataMap = (Map)SerializationUtils.fromJsonString((String)selectedData, Map.class);
        String id = selectedDataMap.getOrDefault("selectdataid", "");
        String entity = selectedDataMap.getOrDefault("entity", "");
        if (StringUtils.isBlank((CharSequence)id) || !StringUtils.equals((CharSequence)entity, (CharSequence)realEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BdFreeChoiceEdit_03", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(8);
        returnData.put("entity", entity);
        returnData.put("id", Long.parseLong(id));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

