/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bankaccount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.helper.BankInfoDynamicListExtHelper;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CusOrSupAccountListPlugin
extends AbstractListPlugin
implements CreateListColumnsListener,
RowClickEventListener {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("entry_bank.id", "!=", (Object)0L));
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        String payeeType = customParams.getOrDefault("payeeType", "");
        String systemName = customParams.getOrDefault("systemName", "");
        List customShowFields = (List)customParams.get("showFields");
        List<Object> showFields = new ArrayList<String>(16);
        if (StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)payeeType)) {
            showFields.add("bank.name");
            showFields.add("bankaccount");
            showFields.add("accountname");
            showFields.add("currency.name");
            showFields.add("isdefault_bank");
            showFields.add("agentbank");
            showFields.add("agentbankaccount");
        } else {
            showFields.add("bank.name");
            showFields.add("bankaccount");
            showFields.add("accountname");
            showFields.add("currency.name");
            showFields.add("isdefault_bank");
        }
        if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
            BankInfoDynamicListExtHelper.setShowFieldsForSupplierBankInfo((String)systemName, showFields);
        } else {
            BankInfoDynamicListExtHelper.setShowFieldsForCustomerBankInfo((String)systemName, showFields);
        }
        if (CollectionUtils.isNotEmpty((Collection)customShowFields)) {
            customShowFields.removeIf(showFields::contains);
            showFields.addAll(customShowFields.stream().map(Object::toString).collect(Collectors.toList()));
        }
        showFields = showFields.stream().map(f -> "entry_bank." + f).collect(Collectors.toList());
        showFields.add("id");
        showFields.add("entry_bank.id");
        String comeFrom = (String)fsp.getCustomParam("comeFrom");
        this.getPageCache().put("comeFrom", comeFrom);
        this.getPageCache().put("showFields", String.join((CharSequence)",", showFields));
        this.getPageCache().put("payeeType", payeeType);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        String fields = this.getPageCache().get("showFields");
        List showFields = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        String payeeType = this.getPageCache().get("payeeType");
        List listColumns = args.getListColumns();
        listColumns.clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)payeeType);
        Map allFields = entityType.getAllFields();
        int index = 0;
        for (String fieldKey : showFields) {
            IDataEntityProperty property;
            String[] split = fieldKey.replaceAll("entry_bank\\.", "").split("\\.");
            if (!allFields.containsKey(split[0]) || (property = (IDataEntityProperty)allFields.get(split[0])) == null) continue;
            String columnDisplayName = property.getDisplayName().getLocaleValue();
            listColumns.add(this.createListColumn(fieldKey, columnDisplayName, index++));
        }
        listColumns.add(this.createListColumn("id", "id", index++));
        listColumns.add(this.createListColumn("entry_bank.id", "entry_bank.id", index++));
        args.setListColumns(listColumns);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BankListDataProvider());
    }

    public void listRowClick(ListRowClickEvent evt) {
        String comeFrom = this.getPageCache().get("comeFrom");
        if (StringUtils.equals((CharSequence)comeFrom, (CharSequence)"bd_freechoice")) {
            this.returnListSelectData();
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        String comeFrom = this.getPageCache().get("comeFrom");
        if (StringUtils.equals((CharSequence)comeFrom, (CharSequence)"bd_freechoice")) {
            this.returnListSelectData();
            evt.setCancel(true);
        }
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        boolean isEntry = key.contains("entry_bank");
        String fieldName = key;
        String string = key = isEntry && !StringUtils.equals((CharSequence)key, (CharSequence)"entry_bank.id") ? key.replaceAll("entry_bank\\.", "") : key;
        if (isEntry) {
            col.setEntityName("entry_bank");
        }
        col.setFieldName(fieldName);
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setSeq(colIndex);
        if (StringUtils.equals((CharSequence)"id", (CharSequence)key) || StringUtils.equals((CharSequence)"entry_bank.id", (CharSequence)key)) {
            col.setVisible(0);
        } else {
            col.setVisible(11);
        }
        return col;
    }

    private void returnListSelectData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        long selectDataId = selectedRows.size() == 0 ? 0L : Long.parseLong(selectedRows.get(0).getPrimaryKeyValue().toString());
        String entity = selectedRows.size() == 0 ? null : this.getPageCache().get("payeeType");
        IPageCache parentCache = this.getView().getParentView().getPageCache();
        HashMap<String, String> cacheData = new HashMap<String, String>(8);
        cacheData.put("selectdataid", selectDataId + "");
        cacheData.put("entity", entity);
        parentCache.put("selected-entrybanktab", SerializationUtils.toJsonString(cacheData));
    }

    static class BankListDataProvider
    extends ListDataProvider {
        BankListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.forEach(row -> row.set("id", row.get("entry_bank.id")));
            return rows;
        }
    }
}

