/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bankaccount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.helper.BankInfoDynamicListExtHelper;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class InternalBankAccountListPlugin
extends AbstractListPlugin
implements CreateListColumnsListener,
RowClickEventListener {
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        String comeFrom = this.getPageCache().get("comeFrom");
        if (StringUtils.equals((CharSequence)comeFrom, (CharSequence)"bd_freechoice")) {
            this.returnListSelectData();
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        String comeFrom = this.getPageCache().get("comeFrom");
        if (StringUtils.equals((CharSequence)comeFrom, (CharSequence)"bd_freechoice")) {
            this.returnListSelectData();
            evt.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        String systemName = customParams.getOrDefault("systemName", "");
        ArrayList<String> showFields = new ArrayList<String>(16);
        showFields.add("bankaccountnumber");
        showFields.add("name");
        showFields.add("company.name");
        showFields.add("openorg.name");
        showFields.add("bank.name");
        showFields.add("currency.name");
        showFields.add("acctproperty.name");
        showFields.add("acctstatus");
        showFields.add("acctstyle");
        showFields.add("accttype");
        showFields.add("opendate");
        showFields.add("iselecpayment");
        showFields.add("modifier.name");
        showFields.add("modifytime");
        BankInfoDynamicListExtHelper.setShowFieldsForAccountBank((String)systemName, showFields);
        showFields.add("id");
        String comeFrom = (String)fsp.getCustomParam("comeFrom");
        this.getPageCache().put("comeFrom", comeFrom);
        this.getPageCache().put("showFields", String.join((CharSequence)",", showFields));
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        String fields = this.getPageCache().get("showFields");
        List showFields = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        List listColumns = args.getListColumns();
        listColumns.clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        Map allFields = entityType.getAllFields();
        int index = 0;
        for (String fieldKey : showFields) {
            IDataEntityProperty property;
            String[] split = fieldKey.split("\\.");
            if (!allFields.containsKey(split[0]) || (property = (IDataEntityProperty)allFields.get(split[0])) == null) continue;
            String columnDisplayName = property.getDisplayName().getLocaleValue();
            listColumns.add(this.createListColumn(fieldKey, columnDisplayName, index++));
        }
        listColumns.add(this.createListColumn("id", "id", index++));
        args.setListColumns(listColumns);
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setFieldName(key);
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setSeq(colIndex);
        if (StringUtils.equals((CharSequence)"id", (CharSequence)key)) {
            col.setVisible(0);
        } else {
            col.setVisible(11);
        }
        return col;
    }

    private void returnListSelectData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        long selectDataId = selectedRows.size() == 0 ? 0L : Long.parseLong(selectedRows.get(0).getPrimaryKeyValue().toString());
        String entity = selectedRows.size() == 0 ? null : "bd_accountbanks";
        IPageCache parentCache = this.getView().getParentView().getPageCache();
        HashMap<String, String> cacheData = new HashMap<String, String>(8);
        cacheData.put("selectdataid", selectDataId + "");
        cacheData.put("entity", entity);
        parentCache.put("selected-accountbanktab", SerializationUtils.toJsonString(cacheData));
    }
}

