/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata.descassttacttype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class DescAsstactTypeListPlugin
extends AbstractListPlugin {
    private static final String DEFORG = "deforg";
    private static final String PERM_ITEM = "4I3MSOXM6MXC";
    private static final String FI_BD_APP = "fibd";
    private static final String BD_DESC_ASSTACTTYPE = "bd_desc_asstacttype";
    private static final String VIEW_TYPE = "10";

    public void filterContainerInit(FilterContainerInitArgs args) {
        Long deforgId = 0L;
        String deforg = this.getPageCache().get(DEFORG);
        if (deforg == null) {
            deforg = DescAsstactTypeListPlugin.getDefaultUseOrg(this.getAllUseOrg(BD_DESC_ASSTACTTYPE));
            if (deforg != null) {
                this.getPageCache().put(DEFORG, deforg);
                deforgId = Long.valueOf(deforg);
            }
        } else {
            deforgId = Long.valueOf(deforg);
        }
        this.getPageCache().put("org", deforgId.toString());
    }

    public static String getDefaultUseOrg(List<List<Object>> col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(col.get(0).get(0));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (List<Object> obj : col) {
            if (longinOrg != Long.parseLong(String.valueOf(obj.get(0)))) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public List<List<Object>> getAllUseOrg(String entityType) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = FI_BD_APP;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityType, (String)"47150e89000000ac");
        ArrayList<List<Object>> viewOrgIds = new ArrayList<List<Object>>();
        if (result == null) {
            return viewOrgIds;
        }
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        String orgFuncPro = "org.fisaccounting";
        QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)"1");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        String view = null;
        view = null == ctrlview ? VIEW_TYPE : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)"1");
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, orgFuncFilter} : new QFilter[]{idsFilter, f2, f3, orgFuncFilter};
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getAllUseOrg", (String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])qfilters, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                ArrayList<Object> par = new ArrayList<Object>(2);
                par.add(row.getLong("org.id"));
                par.add(row.getString("org.name"));
                viewOrgIds.add(par);
            }
        }
        return viewOrgIds;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Boolean isCustom = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCustom");
        if (isCustom != null && isCustom.booleanValue()) {
            return;
        }
        List<Long> useOrgIds = new ArrayList<Long>(10);
        long useOrgId = 0L;
        Optional<String> orgIdRes = this.getOrg();
        if (orgIdRes.isPresent()) {
            useOrgId = Long.parseLong(orgIdRes.get());
        }
        if (useOrgId != 0L) {
            useOrgIds.add(useOrgId);
        } else {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            Long orgId = parameter.getUseOrgId();
            if (orgId != 0L) {
                useOrgIds.add(orgId);
            } else {
                useOrgIds = parameter.getUseOrgIds();
            }
        }
        if (useOrgIds == null || useOrgIds.isEmpty()) {
            String orgId = this.getPageCache().get("org");
            if (StringUtils.isBlank((CharSequence)orgId)) {
                return;
            }
            if (useOrgIds == null) {
                useOrgIds = new ArrayList(1);
            }
            useOrgIds.add(Long.parseLong(orgId));
        }
        List filters = e.getQFilters();
        filters.add(new QFilter("flexid", "=", (Object)101));
        e.setMainOrgQFilter(null);
        List<Long> orgIds = this.getAllSuperiorOrgIdsOrderByLevel(useOrgIds);
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (orgIds != null && !orgIds.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", orgIds).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        }
    }

    private List<Long> getAllSuperiorOrgIdsOrderByLevel(List<Long> orgIds) {
        Object longNumber;
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgIds == null || orgIds.isEmpty()) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)VIEW_TYPE);
        QFilter f3 = new QFilter("org", "in", orgIds);
        HashSet<String> orgNumbers = new HashSet<String>(10);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AsstactTypeListPlugin_query_longnumber", (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            longNumber = "";
            for (Row row : ds) {
                String[] numbers;
                longNumber = row.getString("longnumber");
                if (!StringUtils.isNotBlank((CharSequence)longNumber) || ((String)longNumber).indexOf(33) == 0) continue;
                for (String number : numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!")) {
                    orgNumbers.add(number);
                }
            }
        }
        if (orgNumbers.isEmpty()) {
            return ids;
        }
        QFilter numberFilter = new QFilter("org.number", "in", orgNumbers);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"AsstactTypeListPlugin_query_orgid", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");
        longNumber = null;
        try {
            for (Row row : ds) {
                ids.add(row.getLong("org"));
            }
        }
        catch (Throwable throwable) {
            longNumber = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (longNumber != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)longNumber).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (int i = 0; i < orgIds.size(); ++i) {
            Long orgId = Long.valueOf(String.valueOf(orgIds.get(i)));
            if (ids.contains(orgId)) continue;
            ids.add(orgId);
        }
        return ids;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Optional<String> orgIdRes;
        super.beforeShowBill(e);
        BillShowParameter billParam = e.getParameter();
        String orgId = this.getPageCache().get("org");
        if (orgId == null || orgId.equals("0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7", (String)"DescAsstactTypeListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        if ((orgIdRes = this.getOrg()).isPresent()) {
            orgId = orgIdRes.get();
        }
        billParam.setCustomParam("createOrg", (Object)orgId);
    }

    private Optional<String> getOrg() {
        ControlFilter controlFilter;
        ControlFilters controlFilters = this.getControlFilters();
        if (controlFilters != null && Objects.nonNull(controlFilter = controlFilters.getCurrentControlFilter())) {
            String field = controlFilter.getFieldName();
            List values = controlFilter.getValue();
            if (field.equals("createorg.id") && !CollectionUtils.isEmpty((Collection)values)) {
                return Optional.of(values.get(0).toString());
            }
        }
        return Optional.empty();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String orgId = this.getPageCache().get("org");
        switch (operateKey) {
            case "delete": 
            case "delete2": {
                Optional<String> orgIdRes = this.getOrg();
                if (orgIdRes.isPresent()) {
                    orgId = orgIdRes.get();
                }
                operate.getOption().setVariableValue("deleteOrg", orgId);
                break;
            }
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        super.beforeQueryOfExport(e);
        e.setSelectFields(e.getSelectFields() + ",disprops");
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        for (DynamicObject queryValue : e.getQueryValues()) {
            IDataEntityProperty dp = (IDataEntityProperty)queryValue.getDynamicObjectType().getProperties().get((Object)"displayproperty");
            if (dp == null) continue;
            FlexProperty flexProperty = new FlexProperty();
            flexProperty.getClass();
            FlexProperty.DisplayStyle style = new FlexProperty.DisplayStyle(flexProperty, queryValue.get("disprops").toString());
            queryValue.set("displayproperty", (Object)style.getDisplayProperty().getValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (operateKey.equals("associate_account") && eventArgs.getOperationResult().isSuccess()) {
            Optional<String> orgIdRes = this.getOrg();
            if (!orgIdRes.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7", (String)"DescAsstactTypeListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            long orgId = Long.parseLong(orgIdRes.get());
            if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)FI_BD_APP, (String)BD_DESC_ASSTACTTYPE, (String)PERM_ITEM) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bf4\u660e\u6027\u7ef4\u5ea6\u201d\u7684\u201c\u5173\u8054\u79d1\u76ee\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DescAsstactTypeListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter par = new ListShowParameter();
            par.setBillFormId("bd_associated_account");
            par.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            par.setCustomParam("useorg", (Object)orgId);
            par.setCustomParam("fromDescAsstactTypeList", (Object)true);
            this.getView().showForm((FormShowParameter)par);
        }
    }

    private long getFirstPermOrg(long orgId) {
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "getHasAssociatedAccountPermOrgs_" + this.getPageCache().getPageId() + currUserId;
        return (Long)ThreadCache.get((Object)key, () -> {
            long resOrgId = 0L;
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)VIEW_TYPE, (String)FI_BD_APP, (String)BD_DESC_ASSTACTTYPE, (String)PERM_ITEM);
            if (hasPermOrgResult.hasAllOrgPerm()) {
                resOrgId = orgId;
            }
            List allPermOrgIds = hasPermOrgResult.getHasPermOrgs();
            if (resOrgId == 0L && !CollectionUtils.isEmpty((Collection)allPermOrgIds)) {
                resOrgId = (Long)allPermOrgIds.get(0);
            }
            return resOrgId;
        }, (boolean)true);
    }
}

