/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.invoicecloud.kingdee;

import java.util.EventObject;
import kd.bd.assistant.plugin.er.invoicecloud.cache.utils.KingdeeInvoiceCloudConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCloudCfgPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_gtcfg".equals(evt.getItemKey())) {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            String taxRegNum = (String)model.getValue("taxregnum");
            if (org == null || StringUtils.isEmpty((CharSequence)taxRegNum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u548c\u7a0e\u53f7", (String)"InvoiceCloudCfgPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            String clientId = KingdeeInvoiceCloudConfig.getClientId((String)taxRegNum);
            String clientSecret = KingdeeInvoiceCloudConfig.getClientSecret((String)taxRegNum);
            String encryptKey = KingdeeInvoiceCloudConfig.getEncryptKey((String)taxRegNum);
            model.setValue("client_id", (Object)clientId);
            model.setValue("client_secret", (Object)clientSecret);
            model.setValue("encrypt_key", (Object)encryptKey);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject org;
        IDataModel model = this.getModel();
        if ("org".equals(e.getProperty().getName()) && (org = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String taxregnum = org.getString("ftaxregnum");
            String companyName = org.getString("ffirmname");
            model.setValue("taxregnum", (Object)StringUtils.defaultIfEmpty((CharSequence)taxregnum, (CharSequence)""));
            model.setValue("firmname", (Object)companyName);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String reg;
        String taxNum;
        super.beforeDoOperation(args);
        FormOperate foper = (FormOperate)args.getSource();
        String key = foper.getOperateKey();
        if (StringUtils.contains((CharSequence)"save", (CharSequence)key) && !(taxNum = (String)this.getModel().getValue("taxregnum")).matches(reg = "^\\w{10}$|^\\w{15}$|^\\w{17}$|^\\w{18}$|^\\w{20}$")) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u957f\u5ea6\u5e94\u4e3a10\u300115\u300117\u300118\u300120\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"InvoiceCloudCfgPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
    }
}

