/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.invoicecloud.kingdee;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.constant.CompareTypeEnum;
import kd.bd.assistant.plugin.er.invoicecloud.mergerule.ShowUserDefineFilterCustomParaBO;
import kd.bd.assistant.plugin.er.invoicecloud.mergerule.UserDefineFilterReturnBO;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class UserDefineRulePlugin
extends AbstractFormPlugin {
    public static final String USER_DEFINE_FILTER = "userdefinefilter";
    public static final List<String> BASEDATAFIELDS = Arrays.asList("invoicecurrencyid.", "costcompanyid.");
    public static final String FIELDNAME = "fieldName";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(USER_DEFINE_FILTER);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParam = formShowParameter.getCustomParams();
        if (!customParam.containsKey("showUserDefineFilterCustomParaBO")) {
            return;
        }
        ShowUserDefineFilterCustomParaBO defineParam = (ShowUserDefineFilterCustomParaBO)JSON.parseObject((String)customParam.get("showUserDefineFilterCustomParaBO").toString(), ShowUserDefineFilterCustomParaBO.class);
        filterGrid.setEntityNumber(defineParam.getEntityName());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)defineParam.getEntityName());
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)mainEntityType);
        getFilterFieldsParameter.setNeedBasedataIdField(true);
        List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
        filterColumns.removeIf(entry -> {
            if (entry.containsKey(FIELDNAME)) {
                String val = entry.get(FIELDNAME).toString();
                return BASEDATAFIELDS.stream().anyMatch(prefix -> val.startsWith((String)prefix) && !val.equals(prefix + "id"));
            }
            return false;
        });
        filterGrid.setFilterColumns(filterColumns);
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(USER_DEFINE_FILTER);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParam = formShowParameter.getCustomParams();
        if (!customParam.containsKey("showUserDefineFilterCustomParaBO")) {
            return;
        }
        ShowUserDefineFilterCustomParaBO defineParam = (ShowUserDefineFilterCustomParaBO)JSON.parseObject((String)customParam.get("showUserDefineFilterCustomParaBO").toString(), ShowUserDefineFilterCustomParaBO.class);
        if (StringUtils.isNotBlank((CharSequence)defineParam.getFilterValue())) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)defineParam.getFilterValue(), FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        Control ctl;
        String key;
        Object source = evt.getSource();
        if (source instanceof Control && StringUtils.equals((CharSequence)(key = (ctl = (Control)source).getKey()), (CharSequence)"btnok")) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(USER_DEFINE_FILTER);
            String entityNumber = filterGrid.getEntityNumber();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            StringBuilder descriptionSB = new StringBuilder();
            for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
                IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(filterRow.getFieldName());
                String displayName = "";
                if (property == null && filterRow.getFieldName().contains(".")) {
                    property = (IDataEntityProperty)dataEntityType.getAllFields().get(filterRow.getFieldName().split("\\.")[0]);
                }
                if (property != null) {
                    displayName = property.getDisplayName().getLocaleValue();
                }
                descriptionSB.append(filterRow.getLeftBracket());
                descriptionSB.append(displayName).append(" ");
                CompareTypeEnum compareType = CompareTypeEnum.of((String)filterRow.getCompareType());
                if (compareType == null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u652f\u6301\u7684\u6bd4\u8f83\u7b26\u7c7b\u578b,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"UserDefineRulePlugin_NotSuppportType", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                    return;
                }
                descriptionSB.append(compareType.getShowName());
                String value = "";
                String valueStr = null;
                if (filterRow.getValue().size() == 1) {
                    value = " " + ((FilterValue)filterRow.getValue().get(0)).getValue();
                } else if (filterRow.getValue().size() > 1) {
                    String values = filterRow.getValue().stream().map(fv -> fv.getValue().toString()).collect(Collectors.joining(","));
                    value = " (" + values + ")";
                }
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    List comboItems = comboProp.getComboItems();
                    for (ValueMapItem item : comboItems) {
                        if (!value.trim().equals(item.getValue())) continue;
                        valueStr = item.getName().getLocaleValue();
                    }
                }
                if (valueStr != null) {
                    descriptionSB.append(valueStr);
                } else {
                    descriptionSB.append(value);
                }
                descriptionSB.append(filterRow.getRightBracket());
                descriptionSB.append("0".equals(filterRow.getLogic()) ? ResManager.loadKDString((String)" \u5e76\u4e14 ", (String)"UserDefineRulePlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)" \u6216\u8005 ", (String)"UserDefineRulePlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
            String desc = "";
            if (!filterCondition.getFilterRow().isEmpty()) {
                desc = descriptionSB.substring(0, descriptionSB.length() - 3);
            }
            UserDefineFilterReturnBO userDefineFilterReturnBO = new UserDefineFilterReturnBO();
            userDefineFilterReturnBO.setDesc(desc);
            userDefineFilterReturnBO.setFilterConJson(SerializationUtils.toJsonString((Object)filterCondition));
            this.getView().returnDataToParent((Object)JSON.toJSONString((Object)userDefineFilterReturnBO));
            this.getView().close();
        }
    }
}

