/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.util.LogUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang.StringUtils;

public class ExpitemRelDeptEdit
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeCheckListener {
    private static final Log log = LogFactory.getLog(ExpitemRelDeptEdit.class);
    private static final String ALGO = ExpitemRelDeptEdit.class.getName();
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)ExpitemRelDeptEdit.class.getName(), (int)5);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"btn_add", "btn_del", "btn_delall"});
        TreeView orgTree = (TreeView)this.getControl("tree_allorg");
        orgTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        orgTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        StringBuilder sb = new StringBuilder();
        long time1 = System.currentTimeMillis();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        ArrayList expItems = (ArrayList)showParameter.getCustomParam("expitems");
        if (expItems == null) {
            expItems = new ArrayList();
        }
        this.getPageCache().put("expitems", SerializationUtils.serializeToBase64(expItems));
        this.getModel().setValue("expitems", (Object)expItems.toArray());
        String org = (String)showParameter.getCustomParam("org");
        if (org == null) {
            long orgId = RequestContext.get().getOrgId();
            org = orgId + "";
        }
        long time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 1: ").append(time2 - time1).append("\n");
        time1 = time2;
        List<Long> orgList = this.initAllDeptData(org);
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 2: ").append(time2 - time1).append("\n");
        time1 = time2;
        Set<Long> subOrgIdAppended = this.appendSubOrgs(org);
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 3: ").append(time2 - time1).append("\n");
        time1 = time2;
        HashSet<Long> relDeptIds = new HashSet<Long>(20000);
        SqlBuilder sqlb = new SqlBuilder();
        sqlb.append("select frelorgid from t_bd_expitemreldept where ", new Object[0]).appendIn("fexpitemid", expItems.toArray());
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlb, rh -> {
            while (rh.next()) {
                Long orgId = rh.getLong("frelorgid");
                relDeptIds.add(orgId);
            }
            return null;
        });
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 4: ").append(time2 - time1).append("\n");
        time1 = time2;
        HashSet<Long> resSet = new HashSet<Long>();
        resSet.addAll(subOrgIdAppended);
        resSet.retainAll(relDeptIds);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(resSet.size());
        for (Long relorgId : resSet) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(relorgId + "");
            checkNodes.add(treeNode);
        }
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 5: ").append(time2 - time1).append("\n");
        time1 = time2;
        TreeView orgTree = (TreeView)this.getControl("tree_allorg");
        String reldeptnew = (String)showParameter.getCustomParam("reldeptnew");
        if (!"true".equals(reldeptnew)) {
            orgTree.checkNodesWithoutChild(checkNodes);
        }
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 6: ").append(time2 - time1).append("\n");
        time1 = time2;
        orgTree.expand(org);
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 7: ").append(time2 - time1).append("\n");
        time1 = time2;
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 8: ").append(time2 - time1).append("\n");
        time1 = time2;
        if (!"true".equals(reldeptnew)) {
            List<Object[]> orgInfoLst = this.queryOrgInfo(relDeptIds);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int rowIndex = 0;
            for (Object[] orgObj : orgInfoLst) {
                vs.set("orgid", orgObj[0], rowIndex);
                vs.set("orgnumber", orgObj[1], rowIndex);
                vs.set("orgname", orgObj[2], rowIndex);
                ++rowIndex;
            }
            model.batchCreateNewEntryRow("orgrelate", vs);
            model.endInit();
            this.getView().updateView("orgrelate");
        }
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 9: ").append(time2 - time1).append("\n");
        time1 = time2;
        relDeptIds.removeAll(resSet);
        this.getPageCache().put("orgIdSelectedButNotAppendToTree", SerializationUtils.serializeToBase64(relDeptIds));
        time2 = System.currentTimeMillis();
        sb.append("afterCreateNewData - 10: ").append(time2 - time1).append("\n");
        time1 = time2;
        log.info(sb.toString());
    }

    private List<Object[]> queryOrgInfo(Set<Long> relDeptIds) {
        ArrayList<Object[]> orgInfoLst = new ArrayList<Object[]>(20000);
        if (!relDeptIds.isEmpty()) {
            SqlBuilder sqlb = new SqlBuilder();
            sqlb.append("select t1.fid fid,fnumber,t2.fname fname from t_org_org t1 inner join t_org_org_L t2 on t1.fid=t2.fid where ", new Object[0]);
            sqlb.append("t2.flocaleid = ?", new Object[]{RequestContext.get().getLang()});
            sqlb.appendIn("and t1.fid", relDeptIds.toArray());
            DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlb, rh -> {
                while (rh.next()) {
                    orgInfoLst.add(new Object[]{rh.getObject(1), rh.getObject(2), rh.getObject(3)});
                }
                return null;
            });
        }
        return orgInfoLst;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_add": {
                this.addToRel();
                break;
            }
            case "btn_del": {
                this.deleteFromRel();
                break;
            }
            case "btn_delall": {
                this.deleteAllFromRel();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveExpItemRelDept();
                break;
            }
            case "bar_cancel": {
                this.getView().close();
                break;
            }
            case "bar_refresh": {
                this.getView().updateView();
                break;
            }
        }
    }

    private List<Long> initAllDeptData(String orgid) {
        TreeView orgTree = (TreeView)this.getControl("tree_allorg");
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(Long.parseLong(orgid));
        List rootOrgs = OrgUnitServiceHelper.getAdminOrgRelation(orgList, (boolean)true);
        rootOrgs.add(Long.parseLong(orgid));
        Map rootOrgDyms = BusinessDataServiceHelper.loadFromCache((Object[])rootOrgs.toArray(), (String)"bos_org");
        rootOrgDyms.forEach((id, rootOrgDym) -> {
            TreeNode node = new TreeNode();
            node.setId(id.toString());
            node.setText(rootOrgDym.getLocaleString("name").getLocaleValue());
            orgTree.addNode(node);
        });
        List orgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, (List)rootOrgs, (boolean)true);
        this.getPageCache().put("orgs", SerializationUtils.serializeToBase64((Object)orgs));
        this.getPageCache().put("rootOrgs", SerializationUtils.serializeToBase64((Object)rootOrgs));
        return orgs;
    }

    private Set<Long> appendSubOrgs(Object parentOrgId) {
        String orgid_string = parentOrgId.toString();
        long orgid_long = Long.parseLong(orgid_string);
        long queryStart = System.currentTimeMillis();
        String selectFields = "org,org.name name,parent,longnumber,isleaf,isctrlunit,view.treetype treetype";
        QFilter parentFilter = new QFilter("parent", "=", (Object)orgid_long);
        QFilter orgStructCommonFilter = this.getOrgStructCommonFilter();
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        String sortFields = OrgUnitServiceHelper.getOrgStructureSortFields();
        DynamicObjectCollection orgDyms = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{viewFilter, orgStructCommonFilter, parentFilter}, (String)sortFields);
        Set parentOrgIds = orgDyms.stream().filter(v -> !v.getBoolean("isLeaf")).map(v -> v.getLong("org")).collect(Collectors.toSet());
        parentFilter = new QFilter("parent", "in", parentOrgIds);
        DynamicObjectCollection parentOrgDyms = QueryServiceHelper.query((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{viewFilter, orgStructCommonFilter, parentFilter});
        parentOrgIds = parentOrgDyms.stream().map(v -> v.getLong("parent")).collect(Collectors.toSet());
        long buildStart = System.currentTimeMillis();
        log.info("ExpitemRelDeptEdit >>> \u67e5\u8be2\u7528\u65f6" + (buildStart - queryStart));
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        HashSet<Long> orgIds = new HashSet<Long>();
        for (DynamicObject orgDym : orgDyms) {
            long id = orgDym.getLong("org");
            String idString = id + "";
            String orgName = orgDym.getString("name");
            String parentId = orgDym.getString("parent");
            TreeNode node = new TreeNode(parentId, idString, orgName);
            if (parentOrgIds.contains(id)) {
                node.setChildren(Collections.EMPTY_LIST);
            }
            nodes.add(node);
            orgIds.add(id);
        }
        TreeView orgTree = (TreeView)this.getControl("tree_allorg");
        orgTree.addNodes(nodes);
        long buildEnd = System.currentTimeMillis();
        log.info("\u6784\u9020\u6811\u6240\u7528\u65f6\u95f4  >>> " + (buildEnd - buildStart));
        return orgIds;
    }

    private QFilter getOrgStructCommonFilter() {
        String rootOrgsString = this.getPageCache().get("rootOrgs");
        List rootOrgs = (List)SerializationUtils.deSerializeFromBase64((String)rootOrgsString);
        String orgString = this.getPageCache().get("orgs");
        List orgs = (List)SerializationUtils.deSerializeFromBase64((String)orgString);
        log.info("ExpitemRelDeptEdit>>>" + orgs);
        QFilter orgFilter = new QFilter("org", "in", (Object)orgs);
        orgFilter.and(new QFilter("org", "not in", (Object)rootOrgs));
        QFilter orgEnableFilter = new QFilter("org.enable", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        return orgEnableFilter.and(freezeFilter).and(orgFilter);
    }

    private SqlBuilder getOrgStructCommonSqlBuilder(Set<Long> orgSelected) {
        String rootOrgsString = this.getPageCache().get("rootOrgs");
        List rootOrgs = (List)SerializationUtils.deSerializeFromBase64((String)rootOrgsString);
        String orgString = this.getPageCache().get("orgs");
        List orgs = (List)SerializationUtils.deSerializeFromBase64((String)orgString);
        SqlBuilder sqlb = new SqlBuilder();
        orgs.removeAll(rootOrgs);
        orgs.removeAll(orgSelected);
        if (!orgs.isEmpty()) {
            sqlb.appendIn("and t1.forgid", orgs.toArray());
        }
        sqlb.append(" and t2.fenable = '1'", new Object[0]);
        sqlb.append(" and t1.fisfreeze = '0'", new Object[0]);
        return sqlb;
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        Control source = (Control)arg0.getSource();
        if (StringUtils.equals((String)source.getKey(), (String)"tree_allorg")) {
            String nodeId = (String)arg0.getNodeId();
            Set<Long> subOrgIdAppended = this.appendSubOrgs(nodeId);
            Set orgIdSelectedButNotAppendToTree = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("orgIdSelectedButNotAppendToTree"));
            HashSet<Long> resSet = new HashSet<Long>();
            resSet.addAll(subOrgIdAppended);
            resSet.retainAll(orgIdSelectedButNotAppendToTree);
            ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(resSet.size());
            for (Long relorgId : resSet) {
                TreeNode treeNode = new TreeNode();
                treeNode.setId(relorgId + "");
                checkNodes.add(treeNode);
            }
            TreeView orgTree = (TreeView)this.getControl("tree_allorg");
            orgTree.checkNodesWithoutChild(checkNodes);
            orgIdSelectedButNotAppendToTree.removeAll(resSet);
            this.getPageCache().put("orgIdSelectedButNotAppendToTree", SerializationUtils.serializeToBase64((Object)orgIdSelectedButNotAppendToTree));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
        Control source = (Control)arg0.getSource();
        if (StringUtils.equals((String)source.getKey(), (String)"tree_allorg")) {
            if (arg0.getChecked().booleanValue()) {
                return;
            }
            String nodeId = (String)arg0.getNodeId();
            QFilter viewFilter = new QFilter("view", "=", (Object)1L);
            Map structMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{viewFilter, new QFilter("org", "=", (Object)Long.parseLong(nodeId))});
            DynamicObject org = (DynamicObject)structMap.values().iterator().next();
            if (org.getBoolean("isleaf")) {
                return;
            }
            String longNumber = org.getString("longnumber");
            structMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{viewFilter, new QFilter("longnumber", "like", (Object)(longNumber + "!%"))});
            Set subOrgIds = structMap.values().stream().map(v -> v.getLong("org_id")).collect(Collectors.toSet());
            Set orgIdSelectedButNotAppendToTree = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("orgIdSelectedButNotAppendToTree"));
            orgIdSelectedButNotAppendToTree.removeAll(subOrgIds);
            this.getPageCache().put("orgIdSelectedButNotAppendToTree", SerializationUtils.serializeToBase64((Object)orgIdSelectedButNotAppendToTree));
        }
    }

    private void addToRel() {
        DynamicObjectCollection authedOrgs;
        TreeView allorg = (TreeView)this.getControl("tree_allorg");
        List selectedNodes = allorg.getTreeState().getSelectedNodes();
        HashSet<Long> orgids = new HashSet<Long>();
        selectedNodes.forEach(node -> orgids.add(Long.parseLong(node.get("id").toString())));
        long time1 = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        HashSet<Long> orgIds_hasChildren = new HashSet<Long>();
        HashSet<String> orgIds_parentToExclude = new HashSet<String>();
        for (Map node2 : selectedNodes) {
            if (!((Boolean)node2.get("isParent")).booleanValue()) continue;
            String id_string = node2.get("id").toString();
            if (!orgIds_parentToExclude.contains(node2.get("parentid").toString())) {
                orgIds_hasChildren.add(Long.parseLong(id_string));
            }
            orgIds_parentToExclude.add(id_string);
        }
        long time2 = System.currentTimeMillis();
        sb.append("addToRel-1: ").append(time2 - time1).append("\n");
        time1 = time2;
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        Map structMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{viewFilter, new QFilter("org", "in", orgIds_hasChildren)});
        time2 = System.currentTimeMillis();
        sb.append("addToRel-2: ").append(time2 - time1).append("\n");
        time1 = time2;
        SqlBuilder sqlb = new SqlBuilder();
        sqlb.append("select t1.forgid forgid from t_org_structure t1 inner join t_org_org t2 on t1.forgid=t2.fid where ", new Object[0]);
        sqlb.append(" FViewID = ? ", new Object[]{1L});
        sqlb.append(" and (", new Object[0]);
        boolean notFirst = false;
        for (DynamicObject struct : structMap.values()) {
            if (!notFirst) {
                sqlb.append(" flongnumber like ? ", new Object[]{struct.getString("longnumber") + "!%"});
                notFirst = true;
                continue;
            }
            sqlb.append(" or flongnumber like ? ", new Object[]{struct.getString("longnumber") + "!%"});
        }
        sqlb.append(")", new Object[0]);
        if (!structMap.isEmpty()) {
            authedOrgs = this.getModel().getEntryEntity("orgrelate");
            Set<Long> orgSelected = authedOrgs.stream().map(v -> v.getLong("orgid")).collect(Collectors.toSet());
            sqlb.appendSqlBuilder(this.getOrgStructCommonSqlBuilder(orgSelected));
            DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlb, rh -> {
                while (rh.next()) {
                    orgids.add(rh.getLong(1));
                }
                return null;
            });
        }
        time2 = System.currentTimeMillis();
        sb.append("addToRel-4: ").append(time2 - time1).append("\n");
        time1 = time2;
        time2 = System.currentTimeMillis();
        sb.append("addToRel-5: ").append(time2 - time1).append("\n");
        time1 = time2;
        authedOrgs = this.getModel().getEntryEntity("orgrelate");
        authedOrgs.forEach(authedOrg -> orgids.remove(authedOrg.getLong("orgid")));
        this.fillAuthOrgEntry(orgids);
        time2 = System.currentTimeMillis();
        sb.append("addToRel-7: ").append(time2 - time1).append("\n");
        time1 = time2;
        log.info(sb.toString());
    }

    private void deleteFromRel() {
        IDataModel model = this.getModel();
        EntryGrid grid = (EntryGrid)this.getControl("orgrelate");
        model.deleteEntryRows("orgrelate", grid.getSelectRows());
        grid.clearEntryState();
    }

    private void deleteAllFromRel() {
        IDataModel model = this.getModel();
        model.deleteEntryData("orgrelate");
    }

    private void saveExpItemRelDept() {
        StringBuilder sb = new StringBuilder();
        String expItemString = this.getPageCache().get("expitems");
        List expItems = (List)SerializationUtils.deSerializeFromBase64((String)expItemString);
        HashSet relExpItems = new HashSet();
        relExpItems.addAll(expItems);
        long time1 = System.currentTimeMillis();
        HashSet levelExpItems = new HashSet();
        levelExpItems.addAll(relExpItems);
        while (!levelExpItems.isEmpty()) {
            QFilter[] filters = new QFilter("parent", "in", levelExpItems).toArray();
            DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"er_expenseitemedit", (String)"id", (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                levelExpItems.clear();
                for (Row row : ds) {
                    levelExpItems.add(row.getLong("id"));
                }
                relExpItems.addAll(levelExpItems);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        long time2 = System.currentTimeMillis();
        sb.append(String.format("saveExpItemRelDept-1: %sms\n", time2 - time1));
        time1 = time2;
        HashMap oldDataMap = new HashMap();
        HashSet orgIds_old = new HashSet();
        SqlBuilder sqlb = new SqlBuilder();
        sqlb.append("select fexpitemid,frelorgid from t_bd_expitemreldept where ", new Object[0]).appendIn("fexpitemid", relExpItems.toArray()).append("order by fexpitemid asc", new Object[0]);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlb, rh -> {
            Long _expId = 0L;
            HashSet<Long> _orgIds = null;
            while (rh.next()) {
                Long expId = rh.getLong(1);
                Long orgId = rh.getLong(2);
                if (_expId - expId != 0L) {
                    _orgIds = new HashSet<Long>();
                    oldDataMap.put(expId, _orgIds);
                    _expId = expId;
                }
                _orgIds.add(orgId);
                orgIds_old.add(orgId);
            }
            return null;
        });
        time2 = System.currentTimeMillis();
        sb.append(String.format("saveExpItemRelDept-2: %sms\n", time2 - time1));
        time1 = time2;
        IDataModel model = this.getModel();
        Set orgIds = model.getEntryEntity("orgrelate").stream().map(v -> v.getLong("orgid")).collect(Collectors.toSet());
        orgIds_old.removeAll(orgIds);
        time2 = System.currentTimeMillis();
        sb.append(String.format("saveExpItemRelDept-3: %sms\n", time2 - time1));
        time1 = time2;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String reldeptnew = (String)showParameter.getCustomParam("reldeptnew");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                boolean isDelete = false;
                if (!"true".equals(reldeptnew)) {
                    sb.append("orgToDelete count = ").append(orgIds_old.size()).append("\n");
                    if (!orgIds_old.isEmpty()) {
                        QFilter qFilter = new QFilter("expenseitem", "in", relExpItems);
                        qFilter.and("relorg", "in", orgIds_old);
                        DeleteServiceHelper.delete((String)"bd_expitemreldept", (QFilter[])new QFilter[]{qFilter});
                        isDelete = true;
                    }
                }
                time2 = System.currentTimeMillis();
                sb.append(String.format("saveExpItemRelDept-4: %sms\n", time2 - time1));
                time1 = time2;
                int totalSize = 0;
                HashMap newDataMap = new HashMap(relExpItems.size());
                for (Object expItemId : relExpItems) {
                    if (expItemId == null || StringUtils.isEmpty((String)expItemId.toString())) continue;
                    long newExpItemId = Long.parseLong(expItemId.toString());
                    HashSet newOrgIds = new HashSet(orgIds);
                    Set _orgIds = (Set)oldDataMap.get(newExpItemId);
                    if (_orgIds != null) {
                        newOrgIds.removeAll(_orgIds);
                    }
                    newDataMap.put(newExpItemId, newOrgIds);
                    if ((totalSize += newOrgIds.size()) <= 1000000) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4fdd\u5b58\u64cd\u4f5c\u4f1a\u751f\u6210\u8d85\u8fc7100\u4e07\u6761\u5173\u8054\u90e8\u95e8\u6570\u636e\uff0c\u8bf7\u51cf\u5c11\u90e8\u95e8\u6570\u636e\u91cf\u518d\u8bd5\u3002", (String)"EM-E-772423", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                }
                sb.append("totalSize = ").append(totalSize).append("\n");
                if (totalSize > 0) {
                    DynamicObject[] items;
                    RequestContext requestContext = RequestContext.get();
                    long currUserId = requestContext.getCurrUserId();
                    Date now = new Date();
                    long[] idArr = DB.genLongIds((String)"t_bd_expitemreldept", (int)totalSize);
                    int idArrIndex = 0;
                    ArrayList<Object[]> params = new ArrayList<Object[]>(totalSize);
                    Object[] paramArray = new Object[5];
                    paramArray[3] = currUserId;
                    paramArray[4] = now;
                    for (Map.Entry mapEntry : newDataMap.entrySet()) {
                        Set newOrgIds = (Set)mapEntry.getValue();
                        paramArray[1] = mapEntry.getKey();
                        for (Long orgId : newOrgIds) {
                            paramArray[0] = idArr[idArrIndex++];
                            paramArray[2] = orgId;
                            params.add((Object[])paramArray.clone());
                        }
                    }
                    int threshold = 5000;
                    if (totalSize <= threshold) {
                        new SaveTask(params).exec();
                    } else {
                        ArrayList<Future> futureLst = new ArrayList<Future>(8);
                        int begin = 0;
                        while (begin < totalSize) {
                            int end = begin + threshold;
                            if (end > totalSize) {
                                end = totalSize;
                            }
                            futureLst.add(THREAD_POOL.submit((Callable)new SaveTask(params.subList(begin, end)), requestContext));
                            begin = end;
                        }
                        try {
                            for (Future future : futureLst) {
                                future.get();
                            }
                        }
                        catch (Exception e) {
                            throw new KDException(e.getMessage());
                        }
                    }
                    time2 = System.currentTimeMillis();
                    sb.append(String.format("saveExpItemRelDept-5: %sms\n", time2 - time1));
                    time1 = time2;
                    for (DynamicObject item : items = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"haverelorg,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)relExpItems.toArray())})) {
                        item.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        item.set("modifytime", (Object)new Date());
                        item.set("haverelorg", (Object)true);
                    }
                    SaveServiceHelper.save((DynamicObject[])items);
                } else if (isDelete && orgIds.isEmpty()) {
                    DynamicObject[] items;
                    for (DynamicObject item : items = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"haverelorg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)relExpItems.toArray())})) {
                        item.set("haverelorg", (Object)false);
                    }
                    SaveServiceHelper.save((DynamicObject[])items);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExpitemRelDeptEdit_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ER-E-410678", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
        }
        String msg = "true".equals(reldeptnew) ? String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u6dfb\u52a0\u5173\u8054\u90e8\u95e8", (String)"ExpitemRelDeptEdit_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]) : String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u5173\u8054\u90e8\u95e8\u8986\u76d6", (String)"ExpitemRelDeptEdit_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
        String opName = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ExpitemRelDeptEdit_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
        AppLogInfo logInfo = LogUtils.recordLogInfo((String)msg, (Long)RequestContext.get().getOrgId(), (String)opName, (IFormView)this.getView());
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog(logInfo);
        time2 = System.currentTimeMillis();
        sb.append(String.format("saveExpItemRelDept-6: %sms\n", time2 - time1));
        log.info(sb.toString());
    }

    private void fillAuthOrgEntry(Set<Long> orgids) {
        List<Object[]> orgLst = this.queryOrgInfo(orgids);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        model.beginInit();
        for (Object[] orgObj : orgLst) {
            vs.set("orgid", orgObj[0], rowIndex);
            vs.set("orgnumber", orgObj[1], rowIndex);
            vs.set("orgname", orgObj[2], rowIndex);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow("orgrelate", vs);
        model.endInit();
        this.getView().updateView("orgrelate");
    }

    public static class SaveTask
    implements Callable<int[]> {
        private List<Object[]> params;

        public SaveTask(List<Object[]> params) {
            this.params = params;
        }

        @Override
        public int[] call() throws Exception {
            return this.exec();
        }

        public int[] exec() {
            String sql = "INSERT INTO t_bd_expitemreldept(FId,fexpitemid,frelorgid,fcreatorid,fcreatetime) VALUES (?,?,?,?,?)";
            return DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, this.params);
        }
    }
}

