/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CostCenterSourceMapSavePlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(CostCenterSourceMapSavePlugin.class);
    private static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String ENTITY_COSTCENTERSOURCE_MAP = "bos_costcentersourcemap";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length == 0) {
                    return;
                }
                for (ExtendedDataEntity data : dataEntities) {
                    this.checkRepeatData(data);
                    this.checkSourceTypeData(data);
                    this.checkEffectDate(data);
                }
            }

            private void checkRepeatData(ExtendedDataEntity data) {
                DynamicObject dataEntity = data.getDataEntity();
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
                if (entryEntity == null) {
                    return;
                }
                HashMap<String, List> entryMapIndex = new HashMap<String, List>(16);
                int indexRow = 1;
                for (DynamicObject entry : entryEntity) {
                    String entryKey = entry.getString("sourcetype") + "@" + entry.getLong("sourcedata.id");
                    entryMapIndex.computeIfAbsent(entryKey, s -> new ArrayList()).add(String.valueOf(indexRow));
                    ++indexRow;
                }
                StringBuffer sb = new StringBuffer();
                if (entryMapIndex.size() > 0) {
                    for (List indexList : entryMapIndex.values()) {
                        if (indexList.size() <= 1) continue;
                        indexList.forEach(s -> sb.append((String)s).append("\uff0c"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c %s \u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostCenterSourceMapSavePlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
                }
            }

            private void checkSourceTypeData(ExtendedDataEntity data) {
                DynamicObject dataEntity = data.getDataEntity();
                DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                if (costCenter == null) {
                    return;
                }
                long costCenterId = costCenter.getLong("id");
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
                HashSet sourceDataIds = new HashSet(16);
                entryEntity.forEach(p -> sourceDataIds.add(p.getLong("sourcedata.id")));
                if (sourceDataIds.size() == 0) {
                    return;
                }
                QFilter qfCostCenter = new QFilter("costcenter", "!=", (Object)costCenterId);
                QFilter qfDataId = new QFilter("entryentity.sourcedata", "in", (Object)sourceDataIds.toArray());
                Date effectDate = dataEntity.getDate("effectdate");
                if (effectDate == null) {
                    effectDate = new Date();
                }
                qfCostCenter.and("effectdate", "<=", (Object)effectDate);
                qfCostCenter.and("expdate", ">", (Object)effectDate);
                DynamicObjectCollection centerSource = QueryServiceHelper.query((String)CostCenterSourceMapSavePlugin.ENTITY_COSTCENTERSOURCE_MAP, (String)"costcenter.name,entryentity.sourcetype sourcetype,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{qfCostCenter, qfDataId});
                if (centerSource == null || centerSource.size() == 0) {
                    return;
                }
                StringBuilder sg = new StringBuilder();
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject curRow = (DynamicObject)entryEntity.get(i);
                    if (centerSource.stream().filter(p -> p.getString("sourcetype").equals(curRow.getString("sourcetype")) && p.getLong("sourcedata") == curRow.getLong("sourcedata.id")).count() == 0L) continue;
                    centerSource.stream().filter(p -> p.getString("sourcetype").equals(curRow.getString("sourcetype")) && p.getLong("sourcedata") == curRow.getLong("sourcedata.id")).forEach(p -> sg.append(p.getString("costcenter.name")).append('\u3001'));
                    String sourceTypeName = CostCenterSourceMapSavePlugin.this.getSourceTypeName(curRow.getString("sourcetype"));
                    String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%1$s\u884c%2$s\u6240\u9009\u7684\u6765\u6e90\u6570\u636e\u5df2\u7ecf\u88ab\u6210\u672c\u4e2d\u5fc3\u201c%3$s\u201d \u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostCenterSourceMapSavePlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]), i + 1, sourceTypeName, sg.substring(0, sg.length() - 1));
                    this.addErrorMessage(data, tip);
                    break;
                }
            }

            private void checkEffectDate(ExtendedDataEntity data) {
                DynamicObject dataEntity = data.getDataEntity();
                DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                if (costCenter == null) {
                    return;
                }
                Date effectDate = dataEntity.getDate("effectdate");
                if (effectDate == null) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"CostCenterSourceMapSavePlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                QFilter qFilter = new QFilter("costcenter", "=", (Object)costCenter.getLong("id"));
                qFilter.and("id", "!=", (Object)dataEntity.getLong("id"));
                boolean exists = QueryServiceHelper.exists((String)CostCenterSourceMapSavePlugin.ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])qFilter.toArray());
                if (exists && effectDate.getTime() < CostCenterSourceMapSavePlugin.this.getDayStartTime(new Date()).getTime()) {
                    long costCenterId = costCenter.getLong("id");
                    DynamicObject maxExpDateBill = CostCenterSourceMapSavePlugin.this.getMaxExpDateBill(dataEntity.getLong("id"), costCenterId);
                    if (maxExpDateBill != null && maxExpDateBill.getDate("effectdate").getTime() >= effectDate.getTime()) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u53d8\u66f4\u5355\u636e\u7684\u751f\u6548\u65e5\u671f\u5c0f\u4e8e\u4e0a\u4e00\u5f20\u5355\u201c%s\u201d\u7684\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u8c03\u6574\u751f\u6548\u65e5\u671f\u3002", (String)"CostCenterSourceMapSavePlugin_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]), maxExpDateBill.getString("number")));
                        return;
                    }
                    QFilter bookDateQFilter = new QFilter("bookdate", ">=", (Object)effectDate);
                    QFilter bizDateQFilter = new QFilter("bizdate", ">=", (Object)effectDate);
                    QFilter costCenterQFilter = new QFilter("costcenter", "=", (Object)costCenterId);
                    boolean isExistCostObject = QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                    boolean isExistPlan = QueryServiceHelper.exists((String)"cad_plannedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter, bizDateQFilter});
                    boolean isExistFact = QueryServiceHelper.exists((String)"cad_factnedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                    boolean isExistResource = QueryServiceHelper.exists((String)"sca_resourceuse", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                    boolean isExistMat = QueryServiceHelper.exists((String)"aca_matusecollect", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                    if (isExistCostObject || isExistPlan || isExistFact || isExistResource || isExistMat) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53d8\u66f4\u5355\u636e\u7684\u6210\u672c\u4e2d\u5fc3\u5728\u5f53\u524d\u751f\u6548\u65f6\u95f4\u6bb5\u5df2\u7ecf\u53d1\u751f\u4e1a\u52a1\uff0c\u8bf7\u8c03\u6574\u751f\u6548\u65e5\u671f\u3002", (String)"CostCenterSourceMapSavePlugin_8", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    private Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private String getSourceTypeName(String sourceType) {
        if (StringUtils.isEmpty((CharSequence)sourceType)) {
            return "";
        }
        String sourceTypeName = "";
        switch (sourceType) {
            case "bos_adminorg": {
                sourceTypeName = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"CostCenterSourceMapSavePlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                break;
            }
            case "bos_org": {
                sourceTypeName = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"CostCenterSourceMapSavePlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                break;
            }
            case "fmm_workcentre": {
                sourceTypeName = ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"CostCenterSourceMapSavePlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return sourceTypeName;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            HashSet<DynamicObject> nullRow = new HashSet<DynamicObject>(2);
            for (DynamicObject entry : entryEntity) {
                if (entry.get("sourcetype") != null && entry.get("sourcedata") != null) continue;
                nullRow.add(entry);
            }
            if (nullRow.size() <= 0) continue;
            entryEntity.removeAll(nullRow);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
            this.changeSourceBillDate(dataEntity, costCenter);
            dataEntity.set("longnumber", (Object)costCenter.getString("longnumber"));
            dataEntity.set("parent", costCenter.get("parent"));
            dataEntity.set("expdate", (Object)CostCenterSourceMapSavePlugin.getDeFaultExpDate());
            this.clearCacheData(dataEntity);
        }
        SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
    }

    private void clearCacheData(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (entryEntity == null) {
            return;
        }
        String cacheKey = "";
        for (DynamicObject entry : entryEntity) {
            try {
                Long sourceDataId = (Long)entry.get("sourcedata.id");
                String sourceType = (String)entry.get("sourcetype");
                cacheKey = sourceDataId + "@" + sourceType;
                AppCache.get((String)"macc").remove("costcenter:" + cacheKey);
            }
            catch (Exception ex) {
                logger.error("cacheKey\uff1a{} \u6e05\u7a7a\u7f13\u5b58\u5931\u8d25\uff1a{}\uff0c", (Object)cacheKey, (Object)ex.getMessage());
            }
        }
    }

    private void changeSourceBillDate(DynamicObject dataEntity, DynamicObject costCenter) {
        boolean isEffected;
        DynamicObject maxExpDateBill = this.getMaxExpDateBill(dataEntity.getLong("id"), costCenter.getLong("id"));
        if (maxExpDateBill == null) {
            return;
        }
        if (maxExpDateBill.get("changer") != null && !(isEffected = this.isEffectDate(maxExpDateBill.getDate("effectdate")))) {
            QFilter idFilter = new QFilter("id", "=", (Object)maxExpDateBill.getLong("id"));
            this.clearCacheData(maxExpDateBill);
            DeleteServiceHelper.delete((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])idFilter.toArray());
            maxExpDateBill = this.getMaxExpDateBill(dataEntity.getLong("id"), costCenter.getLong("id"));
        }
        Date effectDate = dataEntity.getDate("effectdate");
        if (maxExpDateBill == null) {
            return;
        }
        Date expDate = maxExpDateBill.getDate("expdate");
        if (expDate.compareTo(effectDate) != 0) {
            maxExpDateBill.set("expdate", (Object)effectDate);
            SaveServiceHelper.update((DynamicObject)maxExpDateBill);
        }
        this.clearCacheData(maxExpDateBill);
    }

    private boolean isEffectDate(Date effectDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        String date = sdf.format(TimeServiceHelper.now());
        Date nowDate = CostCenterSourceMapSavePlugin.parseDate(date);
        if (effectDate == null || nowDate == null) {
            return false;
        }
        boolean result = effectDate.compareTo(nowDate) < 0;
        return result;
    }

    private DynamicObject getMaxExpDateBill(long id, long costCenterId) {
        QFilter qFilter = new QFilter("costcenter", "=", (Object)costCenterId);
        qFilter.and("id", "!=", (Object)id);
        DynamicObject[] sourceDataArr = BusinessDataServiceHelper.load((String)ENTITY_COSTCENTERSOURCE_MAP, (String)"id,number,effectdate,expdate,changer,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])qFilter.toArray());
        DynamicObject maxExpDateBill = null;
        for (DynamicObject source : sourceDataArr) {
            Date expDate = source.getDate("expdate");
            if (expDate == null) continue;
            if (maxExpDateBill == null) {
                maxExpDateBill = source;
                continue;
            }
            Date maxExpDate = maxExpDateBill.getDate("expdate");
            if (expDate.compareTo(maxExpDate) <= 0) continue;
            maxExpDateBill = source;
        }
        return maxExpDateBill;
    }

    private static Date getDeFaultExpDate() {
        return CostCenterSourceMapSavePlugin.parseDate("2999-12-31 23:59:59");
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date;
    }
}

