/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostCenterTreeUtils {
    public static final String CACHE_KEY_LONGNUMBER = "_longNumberCacheKey";
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey";
    private static Log logger = LogFactory.getLog(CostCenterTreeUtils.class);

    public static void searchTreeNode(IFormView formView, TreeView treeView, String viewId, String searchText) {
        Map<String, String> longNumMap = new HashMap<String, String>();
        List<Object> treeNodes = new ArrayList<TreeNode>();
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String longNumberCacheKey = formView.getPageId() + CACHE_KEY_LONGNUMBER + viewId;
        String searchNodesCacheKey = formView.getPageId() + CACHE_KEY_SEARCH_NODES + viewId;
        String oldSearchTextCacheKey = formView.getPageId() + CACHE_KEY_OLD_SEARCH_TEXT + viewId;
        String parentIdCacheKey = formView.getPageId() + CACHE_KEY_PARENTID + viewId;
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        boolean showDisableCenter = (Boolean)formView.getModel().getValue("showdisablecenter");
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                String longNumCache = pageCache.get(longNumberCacheKey);
                longNumMap = StringUtils.isBlank((CharSequence)longNumCache) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)longNumCache, Map.class);
            }
            if (Utils.isListEmpty(treeNodes)) {
                pageCache.put(searchNodesCacheKey, "");
                pageCache.remove(oldSearchTextCacheKey);
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c55\u793a\u5168\u90e8\u641c\u7d22\u7ed3\u679c\uff0c\u5c06\u91cd\u65b0\u5f00\u59cb\u5faa\u73af\u641c\u7d22\u3002", (String)"CostCenterTreeUtils_0", (String)"bos-org-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else {
            CostCenterTreeUtils.searchTreeNode(searchText, treeNodes, longNumMap, showDisableCenter);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(longNumberCacheKey, SerializationUtils.toJsonString(longNumMap));
        }
        if (Utils.isListNotEmpty(treeNodes)) {
            TreeNode node;
            String parentId;
            String parentIdCache = pageCache.get(parentIdCacheKey);
            ArrayList<String> parentIds = null;
            if (StringUtils.isNotBlank((CharSequence)parentIdCache)) {
                parentIds = (ArrayList<String>)SerializationUtils.fromJsonString((String)parentIdCache, List.class);
            }
            if (parentIds == null) {
                parentIds = new ArrayList<String>();
            }
            if (parentIds.contains(parentId = (node = (TreeNode)treeNodes.get(0)).getParentid())) {
                String nodeId = node.getId();
                TreeNode checkNode = new TreeNode(parentId, nodeId, node.getText());
                treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
                treeView.queryTreeNodeChildren(parentId, nodeId);
                treeView.expand(nodeId);
                treeView.checkNode(checkNode);
                treeView.focusNode(checkNode);
            } else {
                CostCenterTreeUtils.queryTreeNodeWithParent(treeView, longNumMap, node, parentIds, showDisableCenter);
                pageCache.put(parentIdCacheKey, SerializationUtils.toJsonString(parentIds));
            }
            treeNodes.remove(0);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static void searchTreeNode(String searchText, List<TreeNode> treeNodes, Map<String, String> longNumMap, boolean showDisableCenter) {
        String selectFields = "id,name,parent,longnumber";
        QFilter nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        nameFilter.or(new QFilter("number", "like", (Object)("%" + searchText + "%")));
        QFilter enableFilter = showDisableCenter ? null : new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{nameFilter, enableFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_costcenter", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String orgId = org.getString("id");
            TreeNode treeNode = new TreeNode(org.getString("parent"), orgId, org.getString("name"));
            treeNode.setExpend(true);
            treeNodes.add(treeNode);
            longNumMap.put(orgId, org.getString("longnumber"));
        }
    }

    public static String getLongNumberDML() {
        String longNumberDLM = ".";
        MainEntityType costCenterEntityType = EntityMetadataCache.getDataEntityType((String)"bos_costcenter");
        if (costCenterEntityType != null && costCenterEntityType.getProperties() != null) {
            for (IDataEntityProperty dymProperty : costCenterEntityType.getProperties()) {
                if (!(dymProperty instanceof ParentBasedataProp)) continue;
                longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
                break;
            }
        }
        return longNumberDLM;
    }

    private static void queryTreeNodeWithParent(TreeView treeView, Map<String, String> longNumMap, TreeNode node, List<String> parentIds, boolean showDisableCenter) {
        String nodeId = node.getId();
        String longNumber = longNumMap.get(nodeId);
        ArrayList<String> longNumList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumList.add(longNumber);
        }
        CostCenterTreeUtils.getParentLongNumber(longNumber, longNumList, CostCenterTreeUtils.getLongNumberDML());
        String selectFields = "id,name,parent,longnumber";
        QFilter longNumberFilter = new QFilter("longnumber", "in", longNumList);
        QFilter enableFilter = showDisableCenter ? null : new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{longNumberFilter, enableFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_costcenter", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String parentId = org.getString("parent");
            String orgId = org.getString("id");
            if (parentIds.contains(orgId)) continue;
            parentIds.add(parentId);
            TreeNode checkNode = new TreeNode(parentId, orgId, org.getString("name"));
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.queryTreeNodeChildren(parentId, orgId);
            treeView.expand(orgId);
            treeView.checkNode(checkNode);
            treeView.focusNode(checkNode);
        }
    }

    private static void getParentLongNumber(String longNumber, List<String> longNumList, String longNumberDML) {
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf(longNumberDML) == -1) {
            return;
        }
        String parentLongNumber = StringUtils.substringBeforeLast((String)longNumber, (String)longNumberDML);
        longNumList.add(parentLongNumber);
        CostCenterTreeUtils.getParentLongNumber(parentLongNumber, longNumList, longNumberDML);
    }

    public static String getCadBgParamForString(String paramEnum, String defaultVal) {
        QFilter filter = new QFilter("key", "=", (Object)paramEnum);
        DynamicObject param = null;
        try {
            param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        }
        catch (Exception e) {
            logger.error("getCadBgParamForString Error", (Throwable)e);
        }
        if (param == null) {
            return defaultVal;
        }
        return param.getString("value");
    }
}

