/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ManuStrategyGroupUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String selSql = "select  fid from T_BD_MANUSTRATEGYGROUP";
        DBRoute sysRoute = new DBRoute("sys");
        HashSet<Long> ids = new HashSet<Long>(16);
        try (DataSet manustrategyDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)selSql);){
            while (manustrategyDataSet.hasNext()) {
                Row row = manustrategyDataSet.next();
                ids.add(row.getLong("fid"));
            }
        }
        String allManustrategyLSql = "select fid,fname,flocaleid from t_bd_manustrategy_L";
        HashMap<Long, Map> manustrategyNameMap = new HashMap<Long, Map>(16);
        try (DataSet manustrategyDataLSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)allManustrategyLSql);){
            while (manustrategyDataLSet.hasNext()) {
                Row row = manustrategyDataLSet.next();
                Map map = manustrategyNameMap.computeIfAbsent(row.getLong("fid"), k -> new HashMap(16));
                map.put(row.getString("flocaleid"), row.getString("fname"));
            }
        }
        ArrayList<Object[]> newmanustrategyParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> newmanustrategyLParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> newmanustrategyEntryParams = new ArrayList<Object[]>(16);
        String allManustrategySql = "select fid,fnumber from t_bd_manustrategy";
        String insertManustrategyGroupSql = "INSERT INTO T_BD_MANUSTRATEGYGROUP (FID,FMASTERID,FNUMBER ,FSTATUS,FCREATETIME,FMODIFIERID,FENABLE,FMODIFYTIME,FCREATORID) VALUES (?,?,?,'C',{ts'2018-08-08  18:08:08'},1,'1',{ts'2018-08-08  18:08:08'},1)";
        String insertManustrategyGroupLSql = "INSERT INTO T_BD_MANUSTRATEGYGROUP_L (FPKID, FID, FLOCALEID, FNAME) VALUES (?, ?, ?, ?)";
        String insertManustrategyGroupEntrySql = "INSERT INTO T_BD_STRATEGYGROUPENTRY (FENTRYID, FID, FMANUSTRATEGY, FPRIORITY) VALUES (?, ?, ?, 0)";
        try (DataSet manustrategyDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)allManustrategySql);){
            while (manustrategyDataSet.hasNext()) {
                Row row = manustrategyDataSet.next();
                Long manustrategyId = row.getLong("fid");
                if (ids.contains(manustrategyId)) continue;
                String fnumber = row.getString("fnumber");
                Object[] newmanustrategyParam = new Object[3];
                Object[] newmanustrategyEntryParam = new Object[3];
                newmanustrategyParam[0] = manustrategyId;
                newmanustrategyParam[1] = manustrategyId;
                newmanustrategyParam[2] = fnumber;
                Map map = (Map)manustrategyNameMap.get(manustrategyId);
                if (map == null || map.isEmpty()) continue;
                long[] lIds = DB.genLongIds((String)"T_BD_MANUSTRATEGYGROUP_L", (int)map.size());
                int count = 0;
                for (Map.Entry l : map.entrySet()) {
                    Object[] newmanustrategyLParam = new Object[4];
                    String key = (String)l.getKey();
                    String value = (String)l.getValue();
                    newmanustrategyLParam[0] = lIds[count];
                    newmanustrategyLParam[1] = manustrategyId;
                    newmanustrategyLParam[2] = key;
                    newmanustrategyLParam[3] = value;
                    newmanustrategyLParams.add(newmanustrategyLParam);
                    ++count;
                }
                newmanustrategyEntryParam[0] = manustrategyId;
                newmanustrategyEntryParam[1] = manustrategyId;
                newmanustrategyEntryParam[2] = manustrategyId;
                newmanustrategyParams.add(newmanustrategyParam);
                newmanustrategyEntryParams.add(newmanustrategyEntryParam);
            }
        }
        var19_27 = null;
        try (TXHandle handle = TX.requiresNew();){
            if (!newmanustrategyParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertManustrategyGroupSql, newmanustrategyParams);
            }
            if (!newmanustrategyLParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertManustrategyGroupLSql, newmanustrategyLParams);
            }
            if (!newmanustrategyEntryParams.isEmpty()) {
                DB.executeBatch((DBRoute)sysRoute, (String)insertManustrategyGroupEntrySql, newmanustrategyEntryParams);
            }
        }
        catch (Throwable throwable) {
            var19_27 = throwable;
            throw throwable;
        }
        result.setSuccess(true);
        result.setLog("ManuStrategyGroup hisData update success");
        return result;
    }
}

