/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.costtype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CostTypeEditPlugin
extends AbstractBasePlugIn {
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_ELEMENTTYPE = "elementtype";
    private static final String TABLE_CAD_ELEMENTTYPE = "cad_elementtype";
    private static final String TABLE_CAD_ELEMENT = "cad_element";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SAVEANDNEW = "bar_saveandnew";
    private static final String COLUMN_NUMBER = "number";
    private static final String COLUMN_ISUPDATE = "isupdate";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_UNAUDIT = "bar_unaudit";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.defualtCurreny();
        this.setEnableByUsed();
        this.setEnableBySysData();
        this.resetComBoEditValByAppNum();
        this.setVisibleByAppNum();
        String type = (String)this.getModel().getValue(COLUMN_TYPE);
        if ("1".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"default"});
        }
        this.getModel().setDataChanged(false);
        this.bindCostTypeEntryInfo();
    }

    private void setVisibleByAppNum() {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"default"});
        }
    }

    private void resetComBoEditValByAppNum() {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            ComboEdit typeEdit = (ComboEdit)this.getControl(COLUMN_TYPE);
            ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
            this.getModel().beginInit();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue("1");
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u62df\u6210\u672c", (String)"CostTypeEditPlugin_1", (String)"bd-macc-formplugin", (Object[])new Object[0])));
            propertyItems.add(comboItem);
            comboItem = new ComboItem();
            comboItem.setValue("2");
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u6210\u672c", (String)"CostTypeEditPlugin_2", (String)"bd-macc-formplugin", (Object[])new Object[0])));
            propertyItems.add(comboItem);
            typeEdit.setComboItems(propertyItems);
            this.getModel().endInit();
        }
    }

    private void setEnableByUsed() {
        String status = (String)this.getModel().getValue("status");
        if ("A".equals(status) && this.isUsed()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_ISUPDATE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"isuseversion"});
        }
    }

    private boolean isUsed() {
        long costTypeId = (Long)this.getModel().getValue("id");
        if (costTypeId == 0L) {
            return false;
        }
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        if (QueryServiceHelper.exists((String)"cad_matcostinfo", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_subelement_material", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_outsourceprice", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_resourcerate", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        return QueryServiceHelper.exists((String)"cad_routersetting", (QFilter[])new QFilter[]{qfCostType});
    }

    private void setEnableBySysData() {
        Boolean issystem = (Boolean)this.getModel().getValue("issystem");
        if (issystem.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_ISUPDATE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    private void bindCostTypeEntryInfo() {
        if (!"aca".equals(this.getView().getFormShowParameter().getAppId())) {
            return;
        }
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("costtypeentry");
        for (int index = entrys.size() - 1; index >= 0; --index) {
            String costtypeattr = ((DynamicObject)entrys.get(index)).getString("costtypeattr");
            if ("0".equals(costtypeattr)) {
                entrys.remove(index);
                continue;
            }
            if (!"1".equals(costtypeattr) || ((DynamicObject)entrys.get(index)).getBoolean("default")) continue;
            entrys.remove(index);
        }
        this.getView().updateView("costtypeentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "createorg": {
                OperationStatus os = this.getView().getFormShowParameter().getStatus();
                if (!OperationStatus.ADDNEW.equals((Object)os)) break;
                Object currencyId = null;
                if (newValue != null) {
                    DynamicObject object = (DynamicObject)newValue;
                    QFilter filter = new QFilter("baseacctorg", "=", object.getPkValue());
                    DynamicObject acctBaseOrg = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{filter});
                    if (acctBaseOrg != null) {
                        currencyId = acctBaseOrg.get("basecurrrency");
                    }
                }
                this.getModel().setValue("currency", currencyId);
                break;
            }
            case "type": {
                Object typeValue = this.getModel().getValue(COLUMN_TYPE);
                if (typeValue.equals("0")) {
                    this.getModel().setValue(COLUMN_ISUPDATE, (Object)Boolean.TRUE);
                    break;
                }
                this.getModel().setValue(COLUMN_ISUPDATE, (Object)Boolean.FALSE);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_save": 
            case "bar_saveandnew": {
                this.initData();
                OperationStatus os = this.getView().getFormShowParameter().getStatus();
                if (!OperationStatus.ADDNEW.equals((Object)os)) break;
                this.getPageCache().put("isFirstSave", "1");
                break;
            }
            case "bar_submit": {
                this.setEnableByUsed();
                this.initData();
                break;
            }
            case "bar_unsubmit": {
                this.setEnableByUsed();
                break;
            }
            case "bar_unaudit": {
                this.setEnableByUsed();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_submit": 
            case "bar_save": 
            case "bar_saveandnew": {
                Boolean isupdate;
                Object typeId = this.getModel().getValue(COLUMN_TYPE);
                if (!"0".equals(typeId) || (isupdate = (Boolean)this.getModel().getValue(COLUMN_ISUPDATE)).booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u5c5e\u6027\u4e0b\u5fc5\u987b\u52fe\u9009\u201c\u5141\u8bb8\u66f4\u65b0\u201d\u3002", (String)"CostTypeEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("audit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (afterDoOperationEventArgs.getOperateKey().equals("save")) {
            String type = (String)this.getModel().getValue(COLUMN_TYPE);
            if (CadEmptyUtils.isEmpty((String)type) || "1".equals(type)) {
                return;
            }
            DynamicObjectCollection costtypeEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("costtypeentry");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costtypeEntrys)) {
                return;
            }
            this.showCostTypeSetting(this.getModel().getDataEntity().getLong("id"));
        }
    }

    private void showCostTypeSetting(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
        FormShowParameter parameter = new FormShowParameter();
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            parameter.setFormId("cad_costtypesettingforaca");
        } else {
            parameter.setFormId("cad_costtypesetting");
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("useorg", this.getPageCache().get("useorg"));
        map.put(COLUMN_TYPE, dynamicObject.getString(COLUMN_TYPE));
        map.put("id", dynamicObject.getLong("id"));
        map.put("currey", dynamicObject.getLong("currency.id"));
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("costtypeentry");
        ArrayList<Long> mulSimulationCostIds = new ArrayList<Long>(10);
        for (DynamicObject dyn : dynamicObjects) {
            String type = dyn.getString("costtypeattr");
            Long costId = dyn.getLong("costtype.id");
            Boolean defaultSimulationCost = dyn.getBoolean("default");
            if (CadEmptyUtils.isEmpty((Long)costId)) continue;
            if ("0".equals(type)) {
                map.put("accountcost", costId);
            }
            if ("1".equals(type)) {
                if (defaultSimulationCost.booleanValue()) {
                    map.put("simulationcost", costId);
                }
                mulSimulationCostIds.add(costId);
            }
            if (!"2".equals(type)) continue;
            map.put("plancost", costId);
        }
        map.put("mulsimulationcost", mulSimulationCostIds);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "costTypeRelationBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        super.closedCallBack(e);
        if ("costTypeRelationBack".equals(e.getActionId()) && (returnData = (Map)e.getReturnData()) != null) {
            Object defaultId = 0L;
            HashSet<Long> idSet = new HashSet<Long>(5);
            for (Map.Entry entry : returnData.entrySet()) {
                Object value;
                if ("mulsimulationCost".equals(entry.getKey())) {
                    value = (List)entry.getValue();
                    idSet.addAll((Collection<Long>)value);
                    continue;
                }
                value = Long.parseLong(String.valueOf(entry.getValue()));
                if ("simulationCost".equals(entry.getKey())) {
                    defaultId = value;
                }
                if (CadEmptyUtils.isEmpty((Long)value)) continue;
                idSet.add((Long)value);
            }
            HashSet<Long> simulationCostSet = new HashSet<Long>(2);
            this.clearRelationType(Long.parseLong(String.valueOf(returnData.get("id"))), simulationCostSet);
            Map<Long, String> attrMap = this.getAttrMap(idSet);
            for (Long id : idSet) {
                HashSet<Long> ids = new HashSet<Long>(5);
                for (Long relationId : idSet) {
                    if (id.longValue() == relationId.longValue()) continue;
                    ids.add(relationId);
                }
                if (ids.isEmpty()) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
                if ("1".equals(dynamicObject.getString(COLUMN_TYPE))) {
                    simulationCostSet.add(id);
                    continue;
                }
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("costtypeentry");
                for (Long reId : ids) {
                    DynamicObject reObj = entry.addNew();
                    reObj.set("costtype", (Object)reId);
                    reObj.set("costtypeattr", (Object)attrMap.get(reId));
                    if (!reId.equals(defaultId)) continue;
                    reObj.set("default", (Object)Boolean.TRUE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            this.dealSimulationCostType(simulationCostSet);
            this.getView().invokeOperation("refresh");
        }
    }

    protected void addListener() {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    private void initData() {
        QFilter elementTypeFilter = new QFilter(COLUMN_NUMBER, "=", (Object)"ET001");
        DynamicObject material = QueryServiceHelper.queryOne((String)TABLE_CAD_ELEMENTTYPE, (String)"id", (QFilter[])new QFilter[]{elementTypeFilter});
        long elementTypeId = material.getLong("id");
        this.getModel().setValue(COLUMN_ELEMENTTYPE, (Object)elementTypeId);
        QFilter elementFilter = new QFilter(COLUMN_ELEMENTTYPE, "=", (Object)elementTypeId);
        DynamicObjectCollection element = QueryServiceHelper.query((String)TABLE_CAD_ELEMENT, (String)"id", (QFilter[])new QFilter[]{elementFilter}, (String)COLUMN_NUMBER);
        Boolean isfrist = Boolean.TRUE;
        for (DynamicObject ele : element) {
            int index = this.getModel().createNewEntryRow("elemententry");
            if (index != 0 && isfrist.booleanValue()) {
                this.getModel().deleteEntryRow("elemententry", index);
                break;
            }
            isfrist = Boolean.FALSE;
            this.getModel().setValue("element", (Object)ele.getLong("id"), index);
        }
        this.getModel().setDataChanged(false);
    }

    private void defualtCurreny() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object corg = this.getModel().getValue("createorg");
            Object currencyId = null;
            if (corg != null) {
                DynamicObject object = (DynamicObject)corg;
                QFilter filter = new QFilter("baseacctorg", "=", object.getPkValue());
                DynamicObject acctBaseOrg = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{filter});
                if (acctBaseOrg != null) {
                    currencyId = acctBaseOrg.get("basecurrrency");
                }
            }
            this.getModel().setValue("currency", currencyId);
        }
    }

    private void dealSimulationCostType(Set<Long> simulationCostSet) {
        if (!CadEmptyUtils.isEmpty(simulationCostSet)) {
            for (Long simulationCostId : simulationCostSet) {
                QFilter qFilter = new QFilter("costtypeentry.costtype", "=", (Object)simulationCostId);
                DynamicObject simulationCostDy = BusinessDataServiceHelper.loadSingle((Object)simulationCostId, (String)"cad_costtype");
                DynamicObjectCollection entry = simulationCostDy.getDynamicObjectCollection("costtypeentry");
                entry.clear();
                DynamicObjectCollection costTypeDc = QueryServiceHelper.query((String)"cad_costtype", (String)"id,type", (QFilter[])qFilter.toArray());
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeDc)) {
                    for (DynamicObject reDy : costTypeDc) {
                        DynamicObject reObj = entry.addNew();
                        reObj.set("costtype", (Object)reDy.getLong("id"));
                        reObj.set("costtypeattr", (Object)reDy.getString(COLUMN_TYPE));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{simulationCostDy});
            }
        }
    }

    private Map<Long, String> getAttrMap(Set<Long> idSet) {
        HashMap<Long, String> map = new HashMap<Long, String>(5);
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,type", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getLong("id"), dynamicObject.getString(COLUMN_TYPE));
        }
        return map;
    }

    private void clearRelationType(Long id, Set<Long> simulationCostSet) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
        DynamicObjectCollection relationTypes = dynamicObject.getDynamicObjectCollection("costtypeentry");
        for (DynamicObject relationType : relationTypes) {
            long reId = relationType.getLong("costtype.id");
            if (CadEmptyUtils.isEmpty((Long)reId)) continue;
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)reId, (String)"cad_costtype");
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("costtypeentry");
            if ("1".equals(dyn.getString(COLUMN_TYPE))) {
                simulationCostSet.add(reId);
                continue;
            }
            entryCol.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
        relationTypes.clear();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

