/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.costtype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CostTypeSettingEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl("btnok");
        confirm.addClickListener((ClickListener)this);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            BasedataEdit accountCost = (BasedataEdit)this.getControl("accountcost");
            accountCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"0"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
            BasedataEdit planCost = (BasedataEdit)this.getControl("plancost");
            planCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"2"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
            BasedataEdit simulationCost = (BasedataEdit)this.getControl("simulationcost");
            simulationCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"1"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
            MulBasedataEdit mulsimulationcost = (MulBasedataEdit)this.getControl("mulsimulationcost");
            mulsimulationcost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"1"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
        }
    }

    private static QFilter getCtrlBaseDataFilter(Map<String, Object> params) {
        Object useOrg = params.get("useorg");
        Long currAcctOrg = useOrg != null ? Long.valueOf(Long.parseLong(String.valueOf(useOrg))) : Long.valueOf(RequestContext.getOrCreate().getOrgId());
        return BaseDataServiceHelper.getBaseDataFilter((String)"cad_costtype", (Long)currAcctOrg);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            Object mulsimulationcost;
            Object planCost;
            Object simulationCost;
            IDataModel model = this.getModel();
            String type = params.get("type").toString();
            Object id = params.get("id");
            Object accountCost = params.get("accountcost");
            if (accountCost != null) {
                model.setValue("accountcost", accountCost);
                this.getView().setEnable(Boolean.valueOf(!this.costTypeHasUsed(Long.parseLong(accountCost.toString()), "0")), new String[]{"accountcost"});
            }
            if ((simulationCost = params.get("simulationcost")) != null) {
                model.setValue("simulationcost", simulationCost);
            }
            if ((planCost = params.get("plancost")) != null) {
                model.setValue("plancost", planCost);
                this.getView().setEnable(Boolean.valueOf(!this.costTypeHasUsed(Long.parseLong(planCost.toString()), "1")), new String[]{"plancost"});
            }
            if ((mulsimulationcost = params.get("mulsimulationcost")) != null) {
                List mulSimulationCostIds = (List)mulsimulationcost;
                model.setValue("mulsimulationcost", (Object)mulSimulationCostIds.toArray());
            }
            if ("0".equals(type)) {
                model.setValue("accountcost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountcost"});
            } else if ("1".equals(type)) {
                model.setValue("simulationcost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"simulationcost"});
            } else {
                model.setValue("plancost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"plancost"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            IDataModel model = this.getModel();
            HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>(5);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Long id = (Long)params.get("id");
            returnMap.put("accountCost", Long.valueOf(model.getDataEntity().getLong("accountcost.id")));
            returnMap.put("planCost", Long.valueOf(model.getDataEntity().getLong("plancost.id")));
            returnMap.put("simulationCost", Long.valueOf(model.getDataEntity().getLong("simulationcost.id")));
            returnMap.put("id", id);
            DynamicObjectCollection mulSimulationCosts = model.getDataEntity().getDynamicObjectCollection("mulsimulationcost");
            ArrayList<Long> mulSimulationCostIds = new ArrayList<Long>(10);
            for (DynamicObject mulSimulationCost : mulSimulationCosts) {
                long simulationCostId = mulSimulationCost.getLong("fbasedataid_id");
                if (CadEmptyUtils.isEmpty((Long)simulationCostId)) continue;
                mulSimulationCostIds.add(simulationCostId);
            }
            if ("aca".equals(this.getView().getFormShowParameter().getAppId()) && CadEmptyUtils.isEmpty((Long)model.getDataEntity().getLong("simulationcost.id"))) {
                mulSimulationCostIds.clear();
            }
            returnMap.put("mulsimulationCost", mulSimulationCostIds);
            params.put("mulsimulationCost", mulSimulationCostIds);
            if (this.uniquenessCheck(params) && this.checkDefaultSimulationCost(mulSimulationCostIds, model.getDataEntity().getDynamicObject("simulationcost"), this.getView().getFormShowParameter().getAppId()) && this.uniqueMulCostTypeCheck(params, this.getView().getFormShowParameter().getAppId())) {
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        }
    }

    private boolean checkDefaultSimulationCost(List<Long> mulSimulationCostIds, DynamicObject defaultSimulationCost, String appId) {
        if ("aca".equals(appId)) {
            return Boolean.TRUE;
        }
        if (defaultSimulationCost != null && !CadEmptyUtils.isEmpty((DynamicObject)defaultSimulationCost) && !mulSimulationCostIds.contains(defaultSimulationCost.getLong("id"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u62df\u6210\u672c\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u9700\u5305\u542b\u5728\u6a21\u62df\u6210\u672c\u4e2d\u3002", (String)"CostTypeSettingEditPlugin_5", (String)"bd-macc-formplugin", (Object[])new Object[0]), defaultSimulationCost.getString("number"), defaultSimulationCost.getString("name")));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean uniquenessCheck(Map<String, Object> params) {
        IDataModel model = this.getModel();
        Long accountId = model.getDataEntity().getLong("accountcost.id");
        Long planId = model.getDataEntity().getLong("plancost.id");
        String type = params.get("type").toString();
        HashSet<Long> ids = new HashSet<Long>(5);
        ids.add(planId);
        ids.add(accountId);
        boolean checkPass = true;
        if (!CadEmptyUtils.isEmpty((Long)accountId) && !CadEmptyUtils.isEmpty((Long)planId)) {
            QFilter filter = null;
            filter = "0".equals(type) ? new QFilter("costtypeentry.costtype", "=", (Object)planId) : ("1".equals(type) ? new QFilter("costtypeentry.costtype", "in", ids) : new QFilter("costtypeentry.costtype", "=", (Object)accountId));
            filter.and("id", "not in", ids);
            filter.and("type", "!=", (Object)"1");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,number,name,type,costtypeentry.costtype.name costTypeName", (QFilter[])new QFilter[]{filter});
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                checkPass = false;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u88ab\u201c%2$s/%3$s\u201d\u6210\u672c\u7c7b\u578b\u7ed1\u5b9a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6210\u672c\u7c7b\u578b\u3002", (String)"CostTypeSettingEditPlugin_3", (String)"bd-macc-formplugin", (Object[])new Object[0]), dynamicObject.getString("costTypeName"), dynamicObject.getString("number"), dynamicObject.getString("name")));
                }
                this.getView().showTipNotification(sb.toString());
            }
        }
        return checkPass;
    }

    private boolean uniqueMulCostTypeCheck(Map<String, Object> params, String appId) {
        if ("aca".equals(appId)) {
            return Boolean.TRUE;
        }
        IDataModel model = this.getModel();
        Long accountId = model.getDataEntity().getLong("accountcost.id");
        String type = params.get("type").toString();
        List mulSimulationCostIds = (List)params.get("mulsimulationCost");
        if (CadEmptyUtils.isEmpty((Long)accountId) || CadEmptyUtils.isEmpty((List)mulSimulationCostIds)) {
            return Boolean.TRUE;
        }
        if (!"0".equals(type) && !"2".equals(type)) {
            return Boolean.TRUE;
        }
        QFilter filter = new QFilter("costtypeentry.costtype", "in", (Object)mulSimulationCostIds);
        filter.and("id", "!=", (Object)accountId);
        filter.and("type", "=", (Object)"0");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,number,name,type,costtypeentry.costtype.number costTypeNumber,costtypeentry.costtype.name costTypeName", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return Boolean.TRUE;
        }
        HashMap<String, Set> infoMap = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String key = number + "@" + name;
            String value = dynamicObject.getString("costTypeNumber") + "@" + dynamicObject.getString("costTypeName");
            infoMap.computeIfAbsent(key, p -> new HashSet()).add(value);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry info : infoMap.entrySet()) {
            String hsCostTypeStr = (String)info.getKey();
            String[] hsCostType = hsCostTypeStr.split("@");
            Set mnCostTypeStrs = (Set)info.getValue();
            for (String mnCostTypeStr : mnCostTypeStrs) {
                String[] mnCostType = mnCostTypeStr.split("@");
                sb.append(String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%1$s\u3001\u540d\u79f0\uff1a%2$s\u201d\u5728\u6838\u7b97\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%3$s\u3001\u540d\u79f0\uff1a%4$s\u201d\u4e0b\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u5bf9\u5e94\u6838\u7b97\u6210\u672c\u7c7b\u578b\u4e0b\u5220\u9664\u8be5\u6a21\u62df\u6210\u672c\u7c7b\u578b\u3002", (String)"CostTypeSettingEditPlugin_4", (String)"bd-macc-formplugin", (Object[])new Object[0]), mnCostType[0], mnCostType[1], hsCostType[0], hsCostType[1]));
            }
        }
        if (CadEmptyUtils.isEmpty((String)sb.toString())) {
            return Boolean.TRUE;
        }
        this.getView().showTipNotification(sb.toString());
        return Boolean.FALSE;
    }

    private boolean costTypeHasUsed(long costType, String type) {
        String entityNum = "";
        QFilter filter = null;
        if ("0".equals(type)) {
            entityNum = "cad_calceffectiveresult";
            filter = new QFilter("costtype", "=", (Object)costType);
        } else {
            entityNum = "sca_plancostcalclog";
            filter = new QFilter("plancosttype", "=", (Object)costType);
        }
        return QueryServiceHelper.exists((String)entityNum, (QFilter[])new QFilter[]{filter});
    }
}

