/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.element;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.macc.common.helper.FilterHelper;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SubElementAccountEdit
extends AbstractFormPlugin {
    public static final String ENTITY_ENTRY = "accountlist";
    public static final String COSTACCOUNT = "costaccount";
    public static final String ACCOUNT = "account";
    public static final String DIFACCOUNT = "difaccount";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit ele = (BasedataEdit)this.getControl("subelement");
        ele.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Object> list = this.getAllSubElementBy(this.getCostTypeId());
            if (list != null && !list.isEmpty()) {
                filters.add(new QFilter("id", "in", list));
                filters.add(new QFilter("enable", "=", (Object)true));
            } else {
                filters.add(new QFilter("id", "=", (Object)-1L));
            }
            filterParameter.setQFilters(filters);
        });
    }

    private List<Object> getAllSubElementBy(Long costTypeId) {
        if (costTypeId == null || costTypeId == 0L) {
            return null;
        }
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)costTypeId, (String)"cad_costtype");
        DynamicObjectCollection elements = null;
        if (costType != null && costType.getDynamicObject("elementtype") != null) {
            QFilter eleTypeFilter = new QFilter("elementtype", "=", costType.getDynamicObject("elementtype").getPkValue());
            elements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"id,subelement", (QFilter[])new QFilter[]{eleTypeFilter});
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(elements.size());
        elements.forEach(s -> list.add(s.get("subelement")));
        return list;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
        BasedataEdit costAccount = (BasedataEdit)this.getControl(COSTACCOUNT);
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)new /* Unavailable Anonymous Inner Class!! */);
        BasedataEdit account = (BasedataEdit)this.getControl(ACCOUNT);
        account.addBeforeF7SelectListener((BeforeF7SelectListener)new /* Unavailable Anonymous Inner Class!! */);
        BasedataEdit difAccount = (BasedataEdit)this.getControl(DIFACCOUNT);
        difAccount.addBeforeF7SelectListener((BeforeF7SelectListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private QFilter getCostAccountFilter() {
        DynamicObject[] costAccounts;
        HashSet<Long> costAccountIds = new HashSet<Long>(10);
        Set enabledCostAccount = FilterHelper.getEnabledCostAccount((String)"sca");
        for (DynamicObject costAccount : costAccounts = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{new QFilter("costtype", "=", (Object)this.getCostTypeId())})) {
            if (!enabledCostAccount.contains(costAccount.getLong("id"))) continue;
            costAccountIds.add(costAccount.getLong("id"));
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTITY_ENTRY);
        HashSet<Long> existCostAccount = new HashSet<Long>(10);
        for (DynamicObject row : rows) {
            existCostAccount.add(row.getLong("costaccount.id"));
        }
        costAccountIds.removeAll(existCostAccount);
        return new QFilter("id", "in", costAccountIds);
    }

    private Boolean notSetAccountOrDifAccount() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTITY_ENTRY);
        for (DynamicObject row : rows) {
            DynamicObject costAccount = row.getDynamicObject(COSTACCOUNT);
            DynamicObject account = row.getDynamicObject(ACCOUNT);
            DynamicObject difAccount = row.getDynamicObject(DIFACCOUNT);
            if (costAccount == null || account != null && difAccount != null) continue;
            return true;
        }
        return false;
    }

    private QFilter getAccountFilter(BeforeF7SelectEvent evt) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTITY_ENTRY).get(evt.getRow());
        Long costAccount = dynamicObject.getLong("costaccount.id");
        DynamicObject calpolicy = BusinessDataServiceHelper.loadSingle((String)"cal_bd_costaccount", (String)"calorg,calpolicy", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)});
        QFilter calpolicyFilter = new QFilter("id", "=", (Object)calpolicy.getLong("calpolicy.id"));
        Long org = calpolicy.getLong("calorg.id");
        DynamicObject accounttable = BusinessDataServiceHelper.loadSingle((String)"cal_bd_calpolicy", (String)"accounttable", (QFilter[])new QFilter[]{calpolicyFilter});
        QFilter filter = new QFilter("accounttable", "in", (Object)accounttable.getLong("accounttable.id"));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_accountview", (Long)org);
        DynamicObject[] accountViews = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{filter, orgFilter});
        HashSet<Long> ids = new HashSet<Long>(10);
        for (DynamicObject accountView : accountViews) {
            ids.add(accountView.getLong("id"));
        }
        return new QFilter("id", "in", ids);
    }

    private Map<Long, Map<Long, Long>> getAllAccountId() {
        HashMap<Long, Map<Long, Long>> map = new HashMap<Long, Map<Long, Long>>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTITY_ENTRY);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return map;
        }
        for (DynamicObject row : rows) {
            DynamicObject costAccount = row.getDynamicObject(COSTACCOUNT);
            DynamicObject account = row.getDynamicObject(ACCOUNT);
            DynamicObject difAccount = row.getDynamicObject(DIFACCOUNT);
            if (costAccount == null) continue;
            map.computeIfAbsent(costAccount.getLong("id"), k -> new HashMap(16)).put(account == null ? 0L : account.getLong("id"), difAccount == null ? 0L : difAccount.getLong("id"));
        }
        return map;
    }

    private Map<Long, Map<Long, Long>> getAllDbCccountBy(Long costTypeId, Long subElementId) {
        HashMap<Long, Map<Long, Long>> map = new HashMap<Long, Map<Long, Long>>(16);
        if (subElementId == null || costTypeId == null) {
            return map;
        }
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter subElementFilter = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"cad_subelement_account", (String)"id,account,difaccount,costaccount", (QFilter[])new QFilter[]{costTypeFilter, subElementFilter});
        if (accounts == null) {
            return map;
        }
        for (DynamicObject row : accounts) {
            map.computeIfAbsent(row.getLong(COSTACCOUNT), k -> new HashMap(16)).put(row.getLong(ACCOUNT), row.getLong(DIFACCOUNT));
        }
        return map;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_add": {
                Long costTypeId = this.getCostTypeId();
                if (costTypeId != null && costTypeId >= 1L) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"SubElementAccountEdit_0", (String)"bd-macc-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (COSTACCOUNT.equals(name)) {
            this.getModel().setValue(ACCOUNT, null, rowIndex);
            this.getModel().setValue(DIFACCOUNT, null, rowIndex);
        }
        if (!"subelement".equals(name)) {
            return;
        }
        if (newValue != null) {
            Map<Long, Map<Long, Long>> mids = this.getAllDbCccountBy(this.getCostTypeId(), ((DynamicObject)newValue).getLong("id"));
            this.fillExpenseItemInfo(mids);
        } else if (this.getModel().getEntryRowCount(ENTITY_ENTRY) > 0) {
            this.getModel().deleteEntryData(ENTITY_ENTRY);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long subElementId = (Long)fsp.getCustomParam("subelement");
        Map<Long, Map<Long, Long>> mids = this.getAllDbCccountBy(this.getCostTypeId(), subElementId);
        this.fillExpenseItemInfo(mids);
        this.getModel().setValue("subelement", (Object)subElementId);
        this.getModel().setValue("costtype", (Object)this.getCostTypeId());
    }

    private void fillExpenseItemInfo(Map<Long, Map<Long, Long>> mids) {
        if (mids == null) {
            return;
        }
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(ENTITY_ENTRY) > 0) {
            model.deleteEntryData(ENTITY_ENTRY);
        }
        for (Map.Entry<Long, Map<Long, Long>> mid : mids.entrySet()) {
            int orgListIndex = model.createNewEntryRow(ENTITY_ENTRY);
            model.setValue(COSTACCOUNT, (Object)mid.getKey(), orgListIndex);
            for (Map.Entry<Long, Long> account : mid.getValue().entrySet()) {
                model.setValue(ACCOUNT, (Object)account.getKey(), orgListIndex);
                model.setValue(DIFACCOUNT, (Object)account.getValue(), orgListIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("btn_save".equals(btn.getKey())) {
            this.save();
        }
    }

    private Long getCostTypeId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costTypeId = (String)fsp.getCustomParam("costtype");
        if (StringUtils.isEmpty((CharSequence)costTypeId)) {
            return 0L;
        }
        return Long.parseLong(costTypeId);
    }

    private Long getSubelementId() {
        DynamicObject subelement = (DynamicObject)this.getModel().getValue("subelement");
        if (subelement == null) {
            return 0L;
        }
        return subelement.getLong("id");
    }

    private void save() {
        if (this.notSetAccountOrDifAccount().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58\uff0c\u5b58\u5728\u672a\u8bbe\u7f6e\u7684\u79d1\u76ee\u6216\u5dee\u5f02\u79d1\u76ee\u3002", (String)"SubElementAccountEdit_4", (String)"bd-macc-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, Map<Long, Long>> Idsmap = this.getAllAccountId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (!CadEmptyUtils.isEmpty(Idsmap)) {
            for (Map.Entry<Long, Map<Long, Long>> map : Idsmap.entrySet()) {
                DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"cad_subelement_account");
                item.set("subelement", (Object)this.getSubelementId());
                item.set("costtype", (Object)this.getCostTypeId());
                item.set(COSTACCOUNT, (Object)map.getKey());
                item.set("creater", (Object)RequestContext.get().getUserId());
                item.set("modifier", (Object)RequestContext.get().getUserId());
                item.set("modifydate", (Object)new Date());
                item.set("createdate", (Object)new Date());
                Map<Long, Long> accounts = map.getValue();
                for (Map.Entry<Long, Long> account : accounts.entrySet()) {
                    item.set(ACCOUNT, (Object)account.getKey());
                    item.set(DIFACCOUNT, (Object)account.getValue());
                }
                list.add(item);
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cad_subelement_account", (QFilter[])QFilter.of((String)"subelement = ? and costtype = ?", (Object[])new Object[]{this.getSubelementId(), this.getCostTypeId()}).toArray());
                if (!CadEmptyUtils.isEmpty(list)) {
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_subelement_account");
                    SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SubElementAccountEdit_2", (String)"bd-macc-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SubElementAccountEdit_3", (String)"bd-macc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    static /* synthetic */ QFilter access$000(SubElementAccountEdit x0) {
        return x0.getCostAccountFilter();
    }

    static /* synthetic */ QFilter access$100(SubElementAccountEdit x0, BeforeF7SelectEvent x1) {
        return x0.getAccountFilter(x1);
    }
}

