/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class DefaultGroupStandardSettingImportPo
extends BatchImportPlugin {
    public ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"DefaultGroupStandardSettingImportPo", (String)"checkData");){
            if (rowdatas.isEmpty()) {
                ApiResult apiResult = null;
                return apiResult;
            }
            this.checkData(rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List itemList = super.getOverrideFieldsConfig();
        ArrayList<ComboItem> newItemList = new ArrayList<ComboItem>();
        for (ComboItem item : itemList) {
            if (!"mastertype".equals(item.getValue()) && !"object".equals(item.getValue())) continue;
            newItemList.add(item);
        }
        return newItemList;
    }

    public String getDefaultKeyFields() {
        return "mastertype".concat(",").concat("object");
    }

    private void checkData(List<ImportBillData> rowDatas, ImportLogger logger) {
        Iterator<ImportBillData> rowDataIterator = rowDatas.iterator();
        while (rowDataIterator.hasNext()) {
            ImportBillData billData = rowDataIterator.next();
            if (billData == null) continue;
            JSONObject jsonData = billData.getData();
            Boolean isPresetNew = jsonData.getBoolean("ispreset");
            String masterTypeNew = jsonData.getString("mastertype");
            JSONObject objectNew = jsonData.getJSONObject("object");
            int errMsgRowIndex = billData.getStartIndex();
            StringBuilder errMsgBuilder = new StringBuilder();
            this.checkMasterType(masterTypeNew, errMsgBuilder);
            this.checkObject(objectNew, errMsgBuilder);
            if (errMsgBuilder.length() == 0) {
                QFilter q = new QFilter("mastertype", "=", (Object)masterTypeNew);
                QFilter p = new QFilter("object", "=", (Object)objectNew.getString("number"));
                QFilter[] qs = new QFilter[]{q.and(p)};
                DynamicObject set = BusinessDataServiceHelper.loadSingle((String)"bd_groupstandardset", (String)"id,mastertype,object,matgroupstandardcode,cusgroupstandardcode,supgroupstandardcode,ispreset", (QFilter[])qs);
                if (set == null) {
                    if (isPresetNew.booleanValue()) {
                        errMsgBuilder.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u9884\u7f6e\u6570\u636e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    Boolean isPresetOld = set.getBoolean("ispreset");
                    if (isPresetNew.booleanValue()) {
                        String masterTypeOld;
                        if (!isPresetNew.equals(isPresetOld)) {
                            errMsgBuilder.append(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u975e\u9884\u7f6e\u6570\u636e\u3002", (String)"DefaultGroupStandardSettingImportPo_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                        }
                        if (!(masterTypeOld = set.getString("mastertype")).equals(masterTypeNew)) {
                            errMsgBuilder.append(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u4e3b\u6570\u636e\u7c7b\u578b\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
                        }
                        DynamicObject objectOld = set.getDynamicObject("object");
                        if (!objectNew.getString("number").equals(objectOld.getString("number"))) {
                            errMsgBuilder.append(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u4e1a\u52a1\u5bf9\u8c61\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_4", (String)"bd-master-opplugin", (Object[])new Object[0]));
                        }
                    } else if (!isPresetNew.equals(isPresetOld)) {
                        errMsgBuilder.append(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u9884\u7f6e\u6807\u8bc6\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_5", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            this.checkGroupStandard(masterTypeNew, jsonData, errMsgBuilder);
            if (errMsgBuilder.length() <= 0) continue;
            logger.log(Integer.valueOf(errMsgRowIndex), errMsgBuilder.toString()).fail();
            rowDataIterator.remove();
        }
    }

    private void checkObject(JSONObject object, StringBuilder errMsgBuilder) {
        QFilter q = new QFilter("number", "=", (Object)object.getString("number"));
        QFilter[] qs = new QFilter[]{q};
        DynamicObject objDym = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id", (QFilter[])qs);
        if (objDym == null) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_6", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkGroupStandard(String masterType, JSONObject jsonData, StringBuilder errMsgBuilder) {
        JSONObject jsonSub = null;
        if ("bd_material".equals(masterType)) {
            jsonSub = jsonData.getJSONObject("matgroupstandardcode");
        } else if ("bd_customer".equals(masterType)) {
            jsonSub = jsonData.getJSONObject("cusgroupstandardcode");
        } else if ("bd_supplier".equals(masterType)) {
            jsonSub = jsonData.getJSONObject("supgroupstandardcode");
        }
        if (jsonSub == null) {
            return;
        }
        String number = jsonSub.getString("number");
        QFilter q = new QFilter("number", "=", (Object)number);
        QFilter qEnable = new QFilter("enable", "=", (Object)"1");
        QFilter[] qs = new QFilter[]{q.and(qEnable)};
        DynamicObject supDym = BusinessDataServiceHelper.loadSingleFromCache((String)(masterType + "groupstandard"), (String)"id", (QFilter[])qs);
        if (supDym == null) {
            if ("bd_material".equals(masterType)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_7", (String)"bd-master-opplugin", (Object[])new Object[0]));
            } else if ("bd_customer".equals(masterType)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_9", (String)"bd-master-opplugin", (Object[])new Object[0]));
            } else if ("bd_supplier".equals(masterType)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_10", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkMasterType(String masterTypeNew, StringBuilder errMsgBuilder) {
        if (!("bd_material".equals(masterTypeNew) || "bd_customer".equals(masterTypeNew) || "bd_supplier".equals(masterTypeNew))) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DefaultGroupStandardSettingImportPo_8", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }
}

