/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.util.GroupStandardUtils;
import kd.bd.master.validator.GroupDataValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GroupDataSaveValidator
extends GroupDataValidator {
    private MasterDataHelper masterDataHelper = new MasterDataHelper();
    private Map<Long, Boolean> groupLastNews = new HashMap<Long, Boolean>();
    private Map<Long, Set<Long>> orgParents = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> orgStandards = new HashMap<Long, Set<Long>>();
    private Map<String, Set<Long>> orgStandardGroups = new HashMap<String, Set<Long>>();

    public GroupDataSaveValidator(String entityNumber) {
        super(entityNumber);
        this.setEntityKey(entityNumber);
    }

    public void validate() {
        this.checkStandardEffective(this.dataEntities);
        this.checkGroupNew(this.dataEntities);
        super.validate();
    }

    private void checkStandardEffective(ExtendedDataEntity[] dataEntities) {
        String masterDataNumber = GroupStandardUtils.getMasterDataNumber((String)this.entityKey);
        for (ExtendedDataEntity exData : dataEntities) {
            String key;
            Set<Long> groupIds;
            Long parentId;
            DynamicObject dataEntity = exData.getDataEntity();
            Long standardId = GroupStandardUtils.getDataByType((Object)dataEntity.get("standard"));
            Long creatorgId = GroupStandardUtils.getDataByType((Object)dataEntity.get("createorg"));
            if (creatorgId == 0L || standardId == 0L) continue;
            Set standardIds = this.orgStandards.get(creatorgId);
            if (standardIds == null) {
                standardIds = GroupStandardUtils.getGroupStandard((String)masterDataNumber, (Long)creatorgId, (boolean)true);
                this.orgStandards.put(creatorgId, standardIds);
            }
            if (standardIds != null && standardIds.size() > 0 && !standardIds.contains(standardId)) {
                this.addErrorMessage(exData, ResManager.loadKDString((String)"\u5206\u7c7b\u6807\u51c6\u4e0d\u5728\u5f53\u524d\u7ec4\u7ec7\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"GroupDataSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
            if ((parentId = GroupStandardUtils.getDataByType((Object)dataEntity.get("parent"))) == 0L) continue;
            Set orgs = this.orgParents.get(creatorgId);
            if (orgs == null) {
                HashSet<Long> orgIds = new HashSet<Long>(1);
                orgIds.add(creatorgId);
                orgs = GroupStandardUtils.getGroupOrgId((String)masterDataNumber, orgIds);
                this.orgParents.put(creatorgId, orgs);
            }
            if ((groupIds = this.orgStandardGroups.get(key = creatorgId + "_" + standardId)) == null) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
                qFilters.add(new QFilter("createorg", "in", (Object)orgs));
                qFilters.add(new QFilter("standard", "=", (Object)standardId));
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)this.entityKey, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
                groupIds = new HashSet<Long>(loadFromCache.size());
                for (Object pkid : loadFromCache.keySet()) {
                    groupIds.add(Long.valueOf(pkid.toString()));
                }
                this.orgStandardGroups.put(key, groupIds);
            }
            if (groupIds == null || groupIds.size() <= 0 || groupIds.contains(parentId)) continue;
            this.addErrorMessage(exData, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5728\u5f53\u524d\u7ec4\u7ec7\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"GroupDataSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    public void checkGroupNew(ExtendedDataEntity[] dataEntities) {
        boolean isGroupLastNew = this.masterDataHelper.getGroupNew();
        if (!isGroupLastNew) {
            return;
        }
        HashSet<Long> parentIds = new HashSet<Long>();
        for (ExtendedDataEntity exData : dataEntities) {
            Long parentId;
            DynamicObject data = exData.getDataEntity();
            DynamicObject parent = data.getDynamicObject("parent");
            if (parent == null || (parentId = Long.valueOf(parent.getLong("id"))) == 0L) continue;
            parentIds.add(parentId);
        }
        String entityNumber = this.getEntityKey();
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "detail"), (String)"group,id", (QFilter[])new QFilter[]{new QFilter("group", "in", parentIds)});
        if (loadFromCache == null || loadFromCache.size() == 0) {
            return;
        }
        for (DynamicObject detail : loadFromCache.values()) {
            DynamicObject group = detail.getDynamicObject("group");
            if (group == null) continue;
            Long groupId = group.getLong("id");
            this.groupLastNews.put(groupId, Boolean.TRUE);
        }
        for (ExtendedDataEntity exData : dataEntities) {
            boolean exists;
            Long parentId;
            DynamicObject data = exData.getDataEntity();
            DynamicObject parent = data.getDynamicObject("parent");
            if (parent == null || (parentId = Long.valueOf(parent.getLong("id"))) == 0L || !(exists = this.groupLastNews.get(parentId).booleanValue())) continue;
            this.addFatalErrorMessage(exData, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5206\u7c7b\u5df2\u5173\u8054\u5bf9\u5e94\u4e3b\u6570\u636e\uff0c\u7981\u6b62\u4fdd\u5b58\u3002", (String)"GroupDataSaveValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }
}

