/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GroupDisableValidator
extends AbstractValidator {
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_MATERIAL = "material";

    public void validate() {
        String entityKey = this.getEntityKey();
        if ("disable".equalsIgnoreCase(this.getOperateKey())) {
            this.checkDisable(entityKey);
        }
    }

    private void checkDisable(String entityKey) {
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            String detailEntityKey = "";
            if (entityKey.contains(PROP_SUPPLIER)) {
                detailEntityKey = "bd_suppliergroupdetail";
            } else if (entityKey.contains(PROP_CUSTOMER)) {
                detailEntityKey = "bd_customergroupdetail";
            } else if (entityKey.contains(PROP_MATERIAL)) {
                detailEntityKey = "bd_materialgroupdetail";
            }
            boolean exists = QueryServiceHelper.exists((String)detailEntityKey, (QFilter[])new QFilter("group", "in", dynamicObject.getValue("id")).toArray());
            if (!exists) continue;
            if (entityKey.contains(PROP_SUPPLIER)) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-756360", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
                continue;
            }
            if (entityKey.contains(PROP_CUSTOMER)) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u5ba2\u6237\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-561216", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
                continue;
            }
            if (!entityKey.contains(PROP_MATERIAL)) continue;
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-553258", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
        }
    }
}

