/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GroupStandardDisableValidator
extends AbstractValidator {
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_MATERIAL = "material";

    public void validate() {
        if ("disable".equalsIgnoreCase(this.getOperateKey())) {
            this.checkDisable();
        }
        String useOrgIDStr = null;
        try {
            useOrgIDStr = this.getOption().getVariableValue("createOrg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(useOrgIDStr)) {
            return;
        }
        Long useOrgID = Long.parseLong(useOrgIDStr);
        DynamicObject baseData = null;
        DynamicObject createorg = null;
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            baseData = dynamicObject.getDataEntity();
            String entity = baseData.getDataEntityType().getName();
            String value = "";
            if (entity.contains(PROP_SUPPLIER)) {
                value = "716529547008326656";
            } else if (entity.contains(PROP_CUSTOMER)) {
                value = "712984405228187648";
            } else if (entity.contains(PROP_MATERIAL)) {
                value = "730148448254487552";
            }
            if (value.equals(baseData.getPkValue().toString())) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"StandardSaveValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
            if ((createorg = baseData.getDynamicObject("createorg")) == null || useOrgID.equals(createorg.getPkValue())) continue;
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"GroupStandardValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("createOrg");
        return set;
    }

    private void checkDisable() {
        String entityKey = this.getEntityKey();
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            String detailEntityKey = "";
            if (entityKey.contains(PROP_SUPPLIER)) {
                detailEntityKey = "bd_suppliergroupdetail";
            } else if (entityKey.contains(PROP_CUSTOMER)) {
                detailEntityKey = "bd_customergroupdetail";
            } else if (entityKey.contains(PROP_MATERIAL)) {
                detailEntityKey = "bd_materialgroupdetail";
            }
            boolean exists = QueryServiceHelper.exists((String)detailEntityKey, (QFilter[])new QFilter("standard", "in", dynamicObject.getValue("id")).toArray());
            if (!exists) continue;
            if (entityKey.contains(PROP_SUPPLIER)) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-733220", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
                continue;
            }
            if (entityKey.contains(PROP_CUSTOMER)) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u5ba2\u6237\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-355072", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
                continue;
            }
            if (!entityKey.contains(PROP_MATERIAL)) continue;
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5b58\u5728\u5173\u8054\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BASEDATA-W-615486", (String)"bd-master-opplugin", (Object[])new Object[]{dynamicObject.getValue("name"), dynamicObject.getValue("number")}));
        }
    }
}

