/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.helper.MaterialServiceHelper;
import kd.bd.master.validator.MasterDataSaveValidator;
import kd.bd.master.vo.ErrorEntity;
import kd.bd.master.vo.MaterialReturnVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialSaveValidator
extends MasterDataSaveValidator {
    public static final String NEW_NULL_FID = "0";
    private MaterialServiceHelper materialServiceHelper = new MaterialServiceHelper();
    private Map<Long, String> auxPty = new HashMap<Long, String>();

    public MaterialSaveValidator() {
        this.setEntityKey("bd_material");
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("serviceattribute");
        propertys.add("serviceattribute.entity");
        return propertys;
    }

    @Override
    public void validate() {
        Throwable throwable;
        TraceSpan span;
        DynamicObject param = BusinessDataServiceHelper.loadSingle((String)"bd_materialbgparam", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)});
        if (param != null && !param.getBoolean("references")) {
            span = Tracer.create((String)"MaterialSaveValidator", (String)"checkUnitconvert");
            throwable = null;
            try {
                this.checkUnitconvert(this.dataEntities);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span != null) {
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        span = Tracer.create((String)"MaterialSaveValidator", (String)"checkGroupNew");
        throwable = null;
        try {
            Set<Long> groupIds = this.checkGroupEffective(this.dataEntities);
            this.checkGroupNew(this.dataEntities, groupIds);
        }
        catch (Throwable groupIds) {
            throwable = groupIds;
            throw groupIds;
        }
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable groupIds) {
                        throwable.addSuppressed(groupIds);
                    }
                } else {
                    span.close();
                }
            }
        }
        span = Tracer.create((String)"MaterialSaveValidator", (String)"checkAuxptyUnit");
        throwable = null;
        try {
            Map<Long, Set<Long>> matAuxListMap = this.cacheAuxPtyEntry(this.dataEntities);
            block27: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkAuxptyUnit(dataEntity);
                this.checkAuxPtyEntry(dataEntity, matAuxListMap);
                DynamicObjectCollection serviceattributes = dataEntity.getDataEntity().getDynamicObjectCollection("serviceattribute");
                if (serviceattributes == null || serviceattributes.size() <= 0) continue;
                for (DynamicObject dyn : serviceattributes) {
                    DynamicObject basedata = dyn.getDynamicObject("fbasedataid");
                    if (basedata == null || basedata.getDynamicObject("entity") == null || "bd_material".equals(basedata.getDynamicObject("entity").getString("number"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u4e1a\u52a1\u5c5e\u6027\u7684\u5173\u8054\u5b9e\u4f53\u4e0d\u662f\u7269\u6599\u3002", (String)"MaterialSaveValidator_9", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    continue block27;
                }
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private Map<Long, Set<Long>> cacheAuxPtyEntry(ExtendedDataEntity[] dataEntities) {
        ArrayList<Object> materialIdList = new ArrayList<Object>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isUseAuxpty;
            DynamicObject material = dataEntity.getDataEntity();
            Object pkValue = material.getPkValue();
            if (pkValue == null || !(isUseAuxpty = material.getBoolean("isuseauxpty"))) continue;
            materialIdList.add(pkValue);
        }
        if (materialIdList.isEmpty()) {
            return null;
        }
        QFilter materialQ = new QFilter("material", "in", materialIdList);
        DynamicObjectCollection auxPtyValueList = QueryServiceHelper.query((String)"bd_auxptyvalue", (String)"material.id, auxpty.id, auxpty.name", (QFilter[])new QFilter[]{materialQ});
        HashMap<Long, Set<Long>> matAuxListMap = new HashMap<Long, Set<Long>>(materialIdList.size());
        for (DynamicObject matAux : auxPtyValueList) {
            Long materialId = matAux.getLong("material.id");
            HashSet<Long> auxIdList = (HashSet<Long>)matAuxListMap.get(materialId);
            if (auxIdList == null) {
                auxIdList = new HashSet<Long>();
            }
            Long auxPtyId = matAux.getLong("auxpty.id");
            auxIdList.add(auxPtyId);
            matAuxListMap.put(materialId, auxIdList);
            this.auxPty.put(auxPtyId, matAux.getString("auxpty.name"));
        }
        return matAuxListMap;
    }

    private void checkAuxPtyEntry(ExtendedDataEntity dataEntity, Map<Long, Set<Long>> matAuxListMap) {
        DynamicObject material = dataEntity.getDataEntity();
        boolean isUseAuxPty = material.getBoolean("isuseauxpty");
        DynamicObjectCollection auxPtyEntry = material.getDynamicObjectCollection("auxptyentry");
        if (isUseAuxPty && auxPtyEntry.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"MaterialSaveValidator_8", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
        if (matAuxListMap == null || matAuxListMap.isEmpty()) {
            return;
        }
        Set<Long> auxPtyIdSet = matAuxListMap.get(material.getLong("id"));
        if (isUseAuxPty && auxPtyIdSet != null) {
            HashMap<Long, DynamicObject> auxptyMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject auxPtyRow : auxPtyEntry) {
                DynamicObject auxpty = auxPtyRow.getDynamicObject("auxpty");
                if (auxpty == null) continue;
                Long auxPtyId = auxpty.getLong("id");
                auxptyMap.put(auxPtyId, auxpty);
            }
            for (Long auxPtyId : auxPtyIdSet) {
                if (auxptyMap.containsKey(auxPtyId)) continue;
                String auxPtyName = this.auxPty.get(auxPtyId);
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8f85\u52a9\u5c5e\u6027\u503c\u8303\u56f4\u5f15\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\u201c{0}\u201d\u3002", (String)"BASEDATA-W-004237", (String)"bd-master-formplugin", (Object[])new Object[]{auxPtyName}));
            }
        }
    }

    private void checkAuxptyUnit(ExtendedDataEntity dataEntity) {
        Object auxptyunit = dataEntity.getDataEntity().get("auxptyunit");
        Long auxptyunitId = 0L;
        if (auxptyunit instanceof DynamicObject) {
            auxptyunitId = Long.parseLong(((DynamicObject)auxptyunit).getPkValue().toString());
        } else if (auxptyunit instanceof Long) {
            auxptyunitId = (Long)auxptyunit;
        }
        if (auxptyunitId == 0L) {
            return;
        }
        Long baseunitId = 0L;
        Object baseunit = dataEntity.getDataEntity().get("baseunit");
        if (baseunit instanceof DynamicObject) {
            baseunitId = Long.parseLong(((DynamicObject)baseunit).getPkValue().toString());
        } else if (baseunit instanceof Long) {
            baseunitId = (Long)baseunit;
        }
        Set desmulist = this.materialServiceHelper.getFixedonversionList(dataEntity.getDataEntity());
        desmulist.add(baseunitId);
        if (desmulist.contains(auxptyunitId)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5355\u4f4d\u548c\u57fa\u672c\u5355\u4f4d\u4e4b\u95f4\u53ea\u80fd\u4e3a\u6d6e\u52a8\u6362\u7b97\u7c7b\u578b\uff1b\u548c\u57fa\u672c\u5355\u4f4d\u6709\u9012\u5f52\u56fa\u5b9a\u6362\u7b97\u5173\u7cfb\u7684\u5176\u4ed6\u5355\u4f4d\uff0c\u4e0e\u8f85\u52a9\u5355\u4f4d\u4e5f\u53ea\u80fd\u6d6e\u52a8\u6362\u7b97\u3002", (String)"MaterialSaveValidator_6", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkUnitconvert(ExtendedDataEntity[] dataEntitys) {
        ArrayList<String> ignoreRefEntityIds = new ArrayList<String>();
        ignoreRefEntityIds.add("bd_multimeasureunit");
        ignoreRefEntityIds.add("bd_materialgroupdetail");
        ignoreRefEntityIds.add("im_mdc_mftproorder");
        ArrayList<String> checkRefEntityIds = new ArrayList<String>();
        checkRefEntityIds.add("bd_configuredcode");
        boolean isOpenPrecision = MaterialServiceHelper.getPrecisionProperty();
        String entityNumber = "";
        HashSet<Object> materialIds = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            Object materialId;
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                entityNumber = dataEntity.getDataEntity().getDataEntityType().getName();
            }
            if (!dataEntity.getDataEntity().getDataEntityState().getFromDatabase() || StringUtils.isBlank((Object)(materialId = dataEntity.getDataEntity().getPkValue())) || NEW_NULL_FID.equals(materialId.toString())) continue;
            materialIds.add(materialId);
            if (!isOpenPrecision) continue;
            List errormsgs = this.materialServiceHelper.checkUnitconvertPrecision(dataEntity);
            for (String errormsg : errormsgs) {
                this.addMessage(dataEntity, errormsg);
            }
        }
        MaterialReturnVo materialReturnVo = this.materialServiceHelper.dataModifyVerification(materialIds, dataEntitys);
        List errors = this.materialServiceHelper.checkReferences(materialReturnVo.getMaterialIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        List configuredcodeErrors = this.materialServiceHelper.checkConfiguredcodeReferences(materialReturnVo.getConfiguredcodeMaterialIds(), dataEntitys, entityNumber, checkRefEntityIds);
        List suiteErrors = this.materialServiceHelper.checkSuiteReferences(materialReturnVo.getSuitChangeMaterialIds(), materialReturnVo.getMaterialTypeIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        List IsuseauxptyErrors = this.materialServiceHelper.checkIsuseauxptyReferences(materialReturnVo.getIsuseauxptyChangeMaterialIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        if (configuredcodeErrors.size() > 0) {
            errors.addAll(configuredcodeErrors);
        }
        if (suiteErrors.size() > 0) {
            errors.addAll(suiteErrors);
        }
        if (IsuseauxptyErrors.size() > 0) {
            errors.addAll(IsuseauxptyErrors);
        }
        for (ErrorEntity error : errors) {
            List errmsgs = error.getErrmsgs();
            for (String errmsg : errmsgs) {
                this.addMessage(error.getExtendedDataEntity(), errmsg);
            }
        }
    }
}

